####################################
package RIB::Attribute;

use strict;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'NAME'        => undef,
    'STATUS'      => undef,
    'CARDINALITY' => undef,
    'DTYPE'       => undef,
    'ALT'         => undef,
    'DISPLAY'     => undef,
    'VOCABULARY'  => undef,
    'VALUES'      => []
  };
  bless ($self, $class);
  return $self;
}

sub name {
  my $self = shift;
  if (@_) { $self->{'NAME'} = shift }
  return $self->{'NAME'};
}

sub status {
  my $self = shift;
  if (@_) { $self->{'STATUS'} = shift }
  if (defined $self->{'STATUS'}) {
    return $self->{'STATUS'};
  } else {
    return 'opt';
  }
}

sub display {
  my $self = shift;
  if (@_) { $self->{'DISPLAY'} = shift }
  if (defined $self->{'DISPLAY'}) {
    return $self->{'DISPLAY'};
  } else {
    return 'show';
  }
}

sub cardinality {
  my $self = shift;
  if (@_) { $self->{'CARDINALITY'} = shift }
  if (defined $self->{'CARDINALITY'}) {
    return $self->{'CARDINALITY'};
  } else {
    return 'mult';
  }
}

sub dtype {
  my $self = shift;
  if (@_) { $self->{'DTYPE'} = shift }
  if (defined $self->{'DTYPE'}) {
    return $self->{'DTYPE'};
  } else {
    return 'text';
  }
}

sub alt {
  my $self = shift;
  if (@_) { $self->{'ALT'} = shift }
  if ($self->{'ALT'}) {
    return $self->{'ALT'};
  } else {
    return $self->{'NAME'};
  }
}

sub push_value {
  my ($self,$value) = @_;
  push (@{$self->{'VALUES'}},$value);
}

sub values {
  my $self = shift;
  return $self->{'VALUES'};
}

sub vocabulary {
  my $self = shift;
  if (@_) { $self->{'VOCABULARY'} = shift }
  return $self->{'VOCABULARY'};
}

1;
