#BANGLINE

##############################################
use strict;
use RIB::Util;
use Getopt::Std;

##############################################
my $util = new RIB::Util();
my $riburl = $util->RibUrl;
my $ribdir = $util->RibDir;

eval { $util->dbConnect(); };
if ($@) { die "Can't connect to database. $@"; }

my $sth = $util->dbh->prepare("SELECT handle FROM repositories");
eval { $sth->execute(); };
if ($@) { die "Can't start $0\n"; }

while (my $row = $sth->fetchrow_arrayref()) {
  my $rh = $row->[0];
  my $pid;
  if ($pid = fork()) {
    wait;  ## parent wait on first child (should happen quickly)
  } elsif (defined $pid) {
    # 2nd fork forces child into background
    unless (fork()) {   # child's child
      sleep 1 until getppid == 1;
      exec "$ribdir/bin/updateInterops.pl", "-r", $rh;
    }
    ## first child exits quickly
    exit (0);
  } else  { # this isn't supposed to happen
    die $!;
  }
}
