#!/bin/sh

RIBVERSION="2.1"
PATH=$PATH:/bin:/usr/bin:/usr/local/bin:/usr/ucb
export PATH

echo
echo "Repository in a Box (RIB), version 2.0 installation"
echo
echo "This script will guide you through the RIB installation process."
echo "Press Enter to accept default values which appear in []'s. If at"
echo "any time you need to stop this script then press CTRL-C."
echo

#############################################
# determine rib path
while true; do
  echo
  echo "Where would you like to install RIB? [/usr/local/rib/rib-$RIBVERSION]"
  read rib_path
  if test $rib_path"x" = "x"; then
    rib_path="/usr/local/rib/rib-$RIBVERSION"
  fi
  if test -x $rib_path; then
    echo
    echo "The directory $rib_path already exists. Install here anyway? [y]"
    read tmp
    if test $tmp"x" = "x" -o $tmp"x" = "xy"; then
      if test -w $rib_path; then
        break
      else
        echo
        echo "!!!!!! You don't have write permissions at $rib_path !!!!!!"
      fi
    fi
  else
    echo
    echo "Ok to create directory $rib_path? [y]"
    read tmp
    if test $tmp"x" = "x" -o $tmp"x" = "xy"; then
      if mkdir $rib_path; then
        break;
      else
        echo
        echo "!!!!!! Can't create directory $rib_path !!!!!!"
      fi
    fi
  fi
done

#############################################
# untar distribution file
echo
echo "Extracting the RIB distribution files...."
mydir=`pwd`
#if cp -r bin conf docRoot lib $rib_path; then
if tar cf - . | (cd $rib_path; tar xf -); then
  echo
else
  echo
  echo "!!!!!! Can't copy distribution files to $rib_path !!!!!!"
  echo "Quitting."
  echo
  exit
fi

cd $mydir

echo
echo "Testing your database...."
echo 

# Added for binary install
#
sql_path=$rib_path/lib/mysql
cd $sql_path
sql_pass=''
./configure > /dev/null
sleep 30

if $sql_path/bin/mysqladmin --user=root --password=$sql_pass version; then
  echo
else
  echo
  echo "Cannot connect to the MySQL database using the following command :"
  echo
  #echo "	$sql_path/bin/mysqladmin --socket=$sql_sock --user=root --password=$sql_pass version"
  echo "	$sql_path/bin/mysqladmin --user=root --password=$sql_pass version"
  echo
  echo "Please consult the MySQL documentation to determine the cause of "
  echo "this problem and rerun this installation script when you are finshed."
  echo
  exit
fi

echo
echo "Your database looks ok. Proceeding with RIB installation."

###################################################
# determine rib user
default_usr="nobody"
if grep '^rib:' /etc/passwd >/dev/null 2>&1; then
  default_usr="rib"
fi
user=`whoami`
if test $user = "root"; then
  while true; do
    echo
    echo "Which user would you like to run the RIB server as? [$default_usr]"
    read rib_usr
    if test $rib_usr"x" = "x"; then
      rib_usr=$default_usr
      break;
    elif test $rib_usr = "root"; then
      echo
      echo "Running RIB as the user \"root\" is not recommended."
      echo "Are you sure that you want to do this? [y]"
      read tmp
      if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
        break;
      fi
    else
      break;
    fi
  done
else
  echo
  echo "Since you are not currently logged in as root, you cannot"
  echo "configure the RIB server to run as any user other than who you"
  echo "are currently logged in as (\"$user\"). Is this ok? [y]"
  read tmp
  if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
    rib_usr=$user
    echo
  else
    echo
    echo "To enable RIB to run as another user, please log in as root"
    echo "and then run this installation program again."
    echo
    exit
  fi
fi

###################################################
# get the RIB password.
while true; do
  echo
  echo "Please specify a password for the RIB Management Page. The"
  echo "password should be at least 5 characters in length. Be sure"
  echo "to write the password down before proceeding. This password"
  echo "will be used to protect access to RIB's user interface."
  read rib_pass
  length=`echo $rib_pass | wc -c`
  if test $length -gt 5; then
    break
  fi
done

sql_pass=$rib_pass
$sql_path/bin/mysqladmin --user=root password $sql_pass 

#sql_cmd="$sql_path/bin/mysql --socket=$sql_sock --user=root --password=$sql_pass mysql"
sql_cmd="$sql_path/bin/mysql --user=root --password=$sql_pass mysql"
echo
echo "Creating database user $rib_usr for RIB..."

# this user created when rib binary was created
echo "DELETE FROM user WHERE User='mcmahan';" | $sql_cmd

create_cmd="INSERT INTO user (Host, User, Password, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Reload_priv, Shutdown_priv, Index_priv, Alter_priv) VALUES ('localhost','$rib_usr',password('$rib_pass'),'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"

tmp=`echo "select count(*) from user where User='$rib_usr'" | $sql_cmd`;
tmp=`echo $tmp | cut -d' ' -f2`
if test $tmp -gt 0; then
  echo
  echo "Database user \"$rib_usr\" already exists."
  echo "Ok to change the password for this user? [y]"
  read tmp
  if test ! $tmp"x" = "x" -a ! $tmp"x" = "yx"; then
    echo
    echo "Cannot proceed with installation unless the password can"
    echo "be changed for user \"$rib_usr\". After you have figured out a"
    echo "workaround run this installation script again to install rib."
    echo
    exit
  fi
  create_cmd="UPDATE user SET Host='localhost', Password=password('$rib_pass'), Select_priv='Y', Insert_priv='Y', Update_priv='Y', Delete_priv='Y', Create_priv='Y', Drop_priv='Y', Reload_priv='Y', Shutdown_priv='Y', Index_priv='Y', Alter_priv='Y' WHERE User='$rib_usr';"
fi

if echo $create_cmd | $sql_cmd; then
  echo "Database user \"$rib_usr\" successfully created."
else
  echo "Can't create database user \"$rib_usr\". Installation aborted."
  echo
  exit
fi

tmp=`echo "show databases like 'rib';" | $sql_cmd`
if test "$tmp x" = " x"; then
  echo "Creating database for RIB..."
  #if $sql_path/bin/mysqladmin --socket=$sql_sock --user=root --password=$sql_pass create rib; then
  if $sql_path/bin/mysqladmin --user=root --password=$sql_pass create rib; then
    echo
  else
    echo
    echo "!!!!!! Can't create database \"rib\" !!!!!!"
    echo "Quitting."
    echo
    exit
  fi
else
  echo
  echo "Database for RIB has already been created."
  echo "Skipping database creation step."
  echo
fi

##########################################################
## grant access to rib database
echo
echo "granting access to rib database"
echo
db_cmd="INSERT INTO db (Host, Db, User, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Index_priv, Alter_priv) VALUES ('localhost','rib','$rib_usr','Y','Y','Y','Y','Y','Y','Y','Y');"
tmp=`echo "select count(*) from db where Host='localhost' and Db='rib' and User='$rib_usr';" | $sql_cmd`
tmp=`echo $tmp | cut -d' ' -f2`
if test $tmp -gt 0; then
  db_cmd="UPDATE db SET Select_priv='Y', Insert_priv='Y', Update_priv='Y', Delete_priv='Y', Create_priv='Y', Drop_priv='Y', Index_priv='Y', Alter_priv='Y' WHERE Host='localhost' and Db='rib' and User='$rib_usr'";
fi

if echo $db_cmd | $sql_cmd; then
  echo
else
  echo
  echo "!!!!!! Can't grant access to the mysql.db table !!!!!!"
  echo "Quitting."
  echo
  exit
fi


##########################################################
## create rib's internal tables
echo
echo "Creating RIB's internal tables"
echo
sql_cmd2="$sql_path/bin/mysql --user=root --password=$sql_pass rib"

if echo "delete from admin;" | $sql_cmd2; then
  if echo "insert into admin (password,is_locked) values ('$rib_pass',0)" | $sql_cmd2; then
    echo
  else
    echo
    echo "!!!!!! Can't set RIB password in admin table !!!!!!"
    echo
    exit
  fi
else
  echo
  echo "!!!!!! Can't set RIB password in admin table !!!!!!"
  echo
  exit
fi

##########################################################
## create the database startup script
cat > $rib_path/bin/start-db <<EOF
#!/bin/sh
if cd $sql_path; then
  if test -x bin/safe_mysqld; then
    bin/safe_mysqld &
    echo "mysqld database started"
  else
    echo "ERROR: Cannot execute $sql_path/bin/safe_mysqld. Database not started."
    exit 1
  fi
else
  echo "ERROR: Can't cd to $sql_path. Database not started."
  exit 1
fi
EOF
if chmod +x $rib_path/bin/start-db; then
  echo
else
  echo
  echo "!!!!!! Can't set permissions on $rib_path/bin/start-db !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## create the database shutdown script
cat > $rib_path/bin/stop-db <<EOF
#!/bin/sh
if cd $sql_path; then
  if test -x bin/mysqladmin; then
    bin/mysqladmin --user=$rib_usr --password=$rib_pass shutdown
  else
    echo "ERROR: Cannot execute $sql_path/bin/mysqladmin. Database not shutdown."
    exit 1
  fi
else
  echo "ERROR: Can't cd to $sql_path. Database not shutdown."
  exit 1
fi
EOF
if chmod +x $rib_path/bin/stop-db; then
  echo
else
  echo
  echo "!!!!!! Can't set permissions on $rib_path/bin/start-db !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## force mysql to reload the privilege tables
if $sql_path/bin/mysqladmin --user=root --password=$sql_pass reload; then
  echo
else
  echo
  echo "!!!!!! Can't reload mysql privelege tables !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## http port number
while true; do
  echo
  echo "Which port do you want to run the RIB HTTP server on? [80]"
  echo "If you choose a port other than 80, that port number will"
  echo "appear in ther URLs used to access your RIB repository."
  echo "e.g. http://your.machine.org:port#/"
  read http_port
  if test $http_port"x" = "x"; then 
    http_port="80"
  fi
  if test $user"x" != "rootx"; then
    if test $http_port -lt 1025; then
      echo "Since the port number is less than 1025 you must start the"
      echo "RIB server as the user root (preferably from your machine's"
      echo "startup scripts). Is this ok? [y]"
      read tmp
      if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
        break
      fi
    else
      break
    fi
  else
    break
  fi
done


##########################################################
## host name
while true; do
  echo
  echo "What is the fully qualified hostname of your machine?"
  echo "e.g. www.cs.utk.edu"
  read rib_host
  if test $rib_host"x" = "x"; then
    echo
  else
    break
  fi
done

#####################################################################
## Modify apache configuration
cd $rib_path/lib/apache/conf
#mv httpd.conf httpd.conf.old

##########################################################################
#
#This line was removed from the following for portability reasons:
#
#   -e  "/Group n.*/s/n.*/$rib_grp/" \
#

#sed -e "/Port RIBPORT.*/s/RIBPORT.*/$http_port/" \
    #-e "/User RIBUSER.*/s/RIBUSER.*/$rib_usr/" \
    #-e "/DocumentRoot \"/s%.*%DocumentRoot \"$rib_path/docRoot/\"%" \
    #-e "/ServerRoot \"/s%.*%ServerRoot \"$rib_path/lib/apache\"%" \
    #-e "s%RIBPATH%$rib_path%g" \
    #httpd.conf.old > httpd.conf

sed -e "s%RIBPORT%$http_port%g" \
    -e "s%RIBUSER%$rib_usr%g" \
    -e "s%RIBPATH%$rib_path%g" \
    httpd.conf.old > httpd.conf

cd $rib_path/lib/apache/bin
sed -e "s%RIBPATH%$rib_path%g" apachectl.old > apachectl
chmod +x apachectl
cd $rib_path/bin
ln -s $rib_path/lib/apache/bin/apachectl ./apachectl
echo "Done."

ln -s $rib_path/lib/perl/bin/perl ./perl

if test $http_port -eq 80; then
  rib_url="http://"$rib_host
else
  rib_url="http://"$rib_host":"$http_port
fi

#####################################################################
# Modify Util.pm
rib_lib=$rib_path/lib/perl/lib/site_perl/5.005/RIB
#mkdir $rib_lib
#cd $mydir/src/RIB
#cp * $rib_lib
cd $rib_lib
sed -e "s%RIBDIR%$rib_path%" \
         -e "s%RIBURL%$rib_url%" \
         -e "s%RIBUSR%$rib_usr%" \
         -e "s%RIBPASS%$rib_pass%" \
         -e "s%RIBVERSION%$RIBVERSION%" \
         -e "s%SOCKET_PATH%$sql_sock%" \
         Util.pm.old > $rib_lib/Util.pm

####################################################################
# Modify RIB CGI scripts
echo
echo "Installing RIB CGI scripts...."
#cd $mydir/src/CGI
cd $rib_path/docRoot
#cat > bangtest.pl <<DONE
##!$rib_path/bin/perl
#print "good shell\n";
#DONE
#chmod +x bangtest.pl
#if ./bangtest.pl; then
#	goodbang=1
#else
#	goodbang=0
#fi
#
#for file in `ls *.pl`
#for file in `ls`
#do
#	if [ $goodbang -eq 1 ]; then
#		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
#		    -e "/#USELIB/i\\
#'use lib $rib_path/lib/perl/lib/5.00503'; \\
#'use lib $rib_path/lib/perl/lib/site_perl/5.005';" \
#	   	$file > $rib_path/docRoot/cgi-bin/$file.pl
#	else
#		sed -e "/#BANGLINE/i\\
##!/bin/sh -- # perl \\
#eval 'exec $rib_path/bin/perl -S \$0 \${1+\"\$@\"}' \\
#if 0;" \
#		    -e "/#USELIB/i\\
#'use lib $rib_path/lib/perl/lib/5.00503'; \\
#'use lib $rib_path/lib/perl/lib/site_perl/5.005';" \
#			$file > $rib_path/docRoot/cgi-bin/$file.pl
#	fi
#	chmod +x $rib_path/docRoot/cgi-bin/$file.pl
#done 

###################################################################
# For binary installs we wrap everything ina shell script
# (Except for linux, 'cause it hates that)
#
for file in `ls *.pl`
do
	sed -e "/#BANGLINE/i\\
#!$rib_path/bin/perl -I$rib_path/lib/perl/lib/5.00503 -I$rib_path/lib/perl/lib/site_perl/5.005" \
	$file > $file.new
	mv -f $file.new $file
	chmod +x $file
done

cd $rib_path/bin
for file in `ls *.pl`
do
#	if [ $goodbang -eq 1 ]; then
#		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
#	   	$file > $file.new
#	else
		sed -e "/#BANGLINE/i\\
#!$rib_path/bin/perl -I$rib_path/lib/perl/lib/5.00503 -I$rib_path/lib/perl/lib/site_perl/5.005" \
			$file > $file.new
#	fi
        if test -s $file.new; then
	  chmod +x $file.new
          rm $file
          mv -f $file.new $file
        else
          echo
          echo "!!!!!! Can't substitute bangline in $file !!!!!!"
          echo
          exit
        fi
done 
echo "Done."

echo
echo "Creating startup scripts...."
cat > $rib_path/bin/start-rib <<DONE
#!/bin/sh
if $rib_path/bin/start-db; then
	echo
else
	echo
	echo "!!!!!! Unable to start mysql database !!!!!!"
	echo 
	exit 1
fi
# set environment variable for apache perl
PERL5LIB=$rib_path/lib/perl/lib/5.00503:$rib_path/lib/perl/lib/site_perl/5.005
export PERL5LIB
if $rib_path/bin/apachectl start; then
	echo
else
	echo
	echo "!!!!!! Unable to start apache !!!!!!"
	echo
	exit 1
fi
DONE
chmod +x $rib_path/bin/start-rib

cat > $rib_path/bin/stop-rib <<DONE
#!/bin/sh
if $rib_path/bin/stop-db; then
	echo
else
	echo
	echo "!!!!!! Unable to stop mysql database !!!!!!"
	echo
	exit 1
fi
if $rib_path/bin/apachectl stop; then
	echo
else
	echo
	echo "!!!!!! Unable to stop apache !!!!!!"
	echo
	exit 1
fi
DONE
chmod +x $rib_path/bin/stop-rib

if test $user = "root"; then
  chown -R $rib_usr $rib_path
fi


# stop mysql if it's currently running
if $rib_path/bin/stop-db; then
  echo
fi


echo
echo "Starting RIB...."
cd $rib_path/bin
if ./start-rib; then
  echo
  echo "RIB was successfully installed. You can access the administration"
  echo "pages by pointing your web browser at :"
  echo
  echo "	$rib_url/top.pl"
  echo
  echo "and using the RIB password that you entered before."
  echo
  echo "If you want RIB to automatically start when the machine reboots"
  echo "then you need to make sure that the following script gets run"
  echo "at startup time :"
  echo
  echo "	$rib_path/bin/start-rib"
  echo
  echo "If you want RIB's interoperation scheduler to run automatically"
  echo "then you need to use cron to set up a job that runs at 15 minute"
  echo "intervals and executes the following script :"
  echo
  echo "	$rib_path/bin/updateAllInterops.pl"
  echo
  echo "This can probably be done by typing \"crontab -e\" and inserting the"
  echo "following line :"
  echo
  echo "0,15,30,45 * * * * $rib_path/bin/updateAllInterops.pl"
  echo
else
  echo
  echo "RIB was NOT successfully installed."
  echo
fi
