#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;
use RIB::VocabularyTerm;

##########################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();
my $MAXHITS = 50;

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }


##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "primary_class,primary_attribute FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $primary_class = $row->{'primary_class'};
my $primary_attribute = $row->{'primary_attribute'};

print header;
unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/advanced_search_template.html")) {
  $util->error("Can't open join template : $!");
}
while (<TEMPLATE>) {
  s/\bREPOSITORY_NAME\b/$repoName/g;
  s/\bREPOSITORY_CONTACT\b/$repoContact/g;
  s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
  s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
  s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
  s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
  s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
  s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
  s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
  s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
  s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;

  print;
  if (/<!-- RIB -->/i) {
    # parse repository configuration
    my $rp = new RIB::Parser;
    eval { $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml"); };
    if ($@) { $util->error("Can't parse repository configuration : " . $@); }
    my @classNames;
    foreach my $class (@{$rp->classes()}) {
      next if $class->name eq "RigObject";
      next if $class->name eq $primary_class;
      push (@classNames, $class->name);
    }
    @classNames = sort @classNames;
    unshift(@classNames,$primary_class);

    if (my $className = param('class')) {
      if (my $attribute = param('attribute')) {
        if (my $term = param('term')) {
          $util->error("Bad class name") unless my $class =$rp->getClass($className);
          $util->error("Bad attribute name")
            unless my $attr = $class->get_attribute($attribute);
          my $sth;
          if ($object_approval_required) {
            $sth = $util->dbh->prepare("SELECT Name_, IF(extends,extends,handle) "
                                     . "FROM $repoHandle\_$className WHERE "
                                     . "$attribute\_ = "
                                     . $util->dbh->quote($term)
                                     . "AND approved != 0");
          } else {
            $sth = $util->dbh->prepare("SELECT Name_, IF(extends,extends,handle) "
                                     . "FROM $repoHandle\_$className WHERE "
                                     . "$attribute\_ = "
                                     . $util->dbh->quote($term));
          }
          eval { $sth->execute(); };
          if ($@) { $util->error($@); }
          my @matches = ();

          if ($className eq $primary_class) {
            my $sth = $util->dbh->prepare("SELECT DISTINCT Name_, url FROM "
                                        . "$repoHandle\_interop_objects "
                                        . "WHERE $attribute\_= "
                                        . $util->dbh->quote($term));
            eval { $sth->execute(); };
            if ($@) { $util->error($@); }
            while (my $row = $sth->fetchrow_arrayref()) {
              my $url = $row->[1];
              if ($url =~ /object.pl\?/) {
                $url .= "&html=1";
              }
              push (@matches,[$row->[0],$url]);
            }
          }
          my $prefix = "object.pl?rh=$repoHandle&class=$className&html=1&oh=";
          while (my $row = $sth->fetchrow_arrayref) {
            push (@matches, [$row->[0], $prefix.$row->[1]]);
          }
          print "$className / $attribute / $term",
                p;
          if (@matches) {
            print "<UL>";
            foreach my $match (@matches) {
              print "<LI><A HREF=\"", $match->[1], "\">", $match->[0], "</A>";
            }
            print "</UL>";
          } else {
            print "No matches found.";
          }
        } else {
          $util->error("Bad class name") unless my $class =$rp->getClass($className);
          $util->error("Bad attribute name")
            unless my $attr = $class->get_attribute($attribute);
          $util->error("Bad class name") unless my $vocab = $attr->vocabulary;
          my @terms = ();
          foreach my $x ($vocab->getChildren) {
            push @terms, $x->term;
            foreach my $y ($x->getChildren) { # just go two deep
              push @terms, $x->term . "!" . $y->term;
            }
          }
          print "Please choose the term you wish to use for sorting the catalog :",
                p,
                start_form,
                "$className / $attribute / ",
                hidden(-name=>'rh'),
                hidden(-name=>'type'),
                hidden(-name=>'class'),
                hidden(-name=>'attribute'),
                popup_menu(-name=>'term', -values=>\@terms),
                submit(-value=>'Submit'),
                end_form;
        }
      } else {
        $util->error("Bad class name") unless my $class = $rp->getClass($className);
        my @attributeNames = ();
        foreach my $attribute (@{$class->attributes}) {
          if ($attribute->vocabulary) {
            push @attributeNames, $attribute->alt;
          }
        }
        @attributeNames = sort(@attributeNames);
        print "Please choose the attribute you wish to examine :",
              start_form,
              "$className / ",
              hidden(-name=>'rh'),
              hidden(-name=>'type'),
              hidden(-name=>'class'),
              popup_menu(-name=>'attribute', -values=>\@attributeNames),
              submit(-value=>'Submit'),
              end_form;
      }
    } else {
      print "This type of query allows you to query the repository collection ",
            "based on a field that has a controlled vocabulary. A field that ",
            "has a controlled vocabulary can only contain values from a ",
            "predetermined set. ";
      my @classNames = ();  # overwrite previous array
      foreach my $class (@{$rp->classes}) {
        foreach my $attribute (@{$class->attributes}) {
          if ($attribute->vocabulary) {
            push @classNames, $class->name;
            last;
          }
        }
      }
      if (@classNames) {
        print "To begin your query, please choose the class that you ",
              "wish to examine :",
              start_form,
              hidden(-name=>'rh'),
              hidden(-name=>'type'),
              popup_menu(-name=>'class', -values=>\@classNames),
              submit(-value=>'Submit'),
              end_form;
      } else {
        print "This repository does not contain any controlled vocabularies. ",
              "Therefore, a controlled vocabulary search is not available.";
      }
    }
  }
}

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
