#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;

##########################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();
my $MAXHITS = 50;

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }


##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "primary_class,primary_attribute FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $primary_class = $row->{'primary_class'};
my $primary_attribute = $row->{'primary_attribute'};

print header;
unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/advanced_search_template.html")) {
  $util->error("Can't open join template : $!");
}
while (<TEMPLATE>) {
  s/\bREPOSITORY_NAME\b/$repoName/g;
  s/\bREPOSITORY_CONTACT\b/$repoContact/g;
  s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
  s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
  s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
  s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
  s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
  s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
  s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;


  print;
  if (/<!-- RIB -->/i) {
    # parse repository configuration
    my $rp = new RIB::Parser;
    eval { $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml"); };
    if ($@) { $util->error("Can't parse repository configuration : " . $@); }
    my @classNames;
    foreach my $class (@{$rp->classes()}) {
      next if $class->name eq "RigObject";
      next if $class->name eq $primary_class;
      push (@classNames, $class->name);
    }
    @classNames = sort @classNames;
    unshift(@classNames,$primary_class);
 
    if (my $className = param('class')) {
      $util->error("Bad class name") unless my $class = $rp->getClass($className);
      if (my $field = param('field')) {
        $field =~ s/\./_/;
        $util->error("Bad input : $className") unless $className =~ /^\w+$/;
        $util->error("Bad input : $field") unless $field =~ /^\w+$/;
        my $class = $rp->getClass($className);
        foreach my $x (@{$class->attributes},@{$class->relationships}) {
          if ($x->alt eq $field) {
            $field = $x->name;
            last;
          }
        }
        my $sth;
        if ($object_approval_required) {
          $sth = $util->dbh->prepare("SELECT Name_, handle FROM "
                                   . "$repoHandle\_$className WHERE "
                                   . "handle IS NOT NULL "
                                   . "AND $field\_ IS NOT NULL "
                                   . "AND $field\_ != '' "
                                   . "AND approved != 0 "
                                   . "ORDER BY Name_");
        } else {
          $sth = $util->dbh->prepare("SELECT Name_, handle FROM "
                                   . "$repoHandle\_$className WHERE "
                                   . "handle IS NOT NULL "
                                   . "AND $field\_ IS NOT NULL "
                                   . "AND $field\_ != '' "
                                   . "ORDER BY Name_");
        }
        eval { $sth->execute(); };
        if ($@) { $util->error("Database error $@"); }
        my @matches = ();

        if ($className eq $primary_class) {
          my $sth = $util->dbh->prepare("SELECT DISTINCT Name_, url FROM "
                                      . "$repoHandle\_interop_objects "
                                      . "WHERE $field\_ IS NOT NULL "
                                      . "AND $field\_ != ''");
          eval { $sth->execute(); };
          if ($@) { $util->error($@); }
          while (my $row = $sth->fetchrow_arrayref()) {
            my $url = $row->[1];
            if ($url =~ /object.pl\?/) {
              $url .= "&html=1";
            }
            push (@matches,[$row->[0],$url]);
          }
        }
        my $prefix = "object.pl?rh=$repoHandle&class=$className&html=1&oh=";
        while (my $row = $sth->fetchrow_arrayref) {
          push @matches, [$row->[0],$prefix.$row->[1]];
        }
        if (@matches) {
          print "<UL>";
          foreach my $match (sort { lc($a->[0]) cmp lc($b->[0])} @matches) {
            print "<LI><A HREF=\"" . $match->[1],
                  "\">", $match->[0], "</A>\n";
          }
          print "</UL>";
        } else {
          print "No matches found.";
        }
      }
      else {
        my @fieldNames = ();
        foreach (@{$class->attributes},@{$class->relationships}) {
          push @fieldNames, $_->alt;
        }
        @fieldNames = sort(@fieldNames);
        print "Please choose the field you wish to examine :",
              start_form,
              hidden(-name=>'rh'),
              hidden(-name=>'class'),
              popup_menu(-name=>'field', -values=>\@fieldNames),
              submit(-value=>'Submit'),
              end_form;
      }
    } else {
      print "This type of query allows you to determine which records contain ",
            "a value for a certain field. The value itself is not checked, ",
            "only the existence of a value.",
            "To begin your query, please choose the class that you ",
            "wish to examine :",
            start_form,
            hidden(-name=>'rh'),
            popup_menu(-name=>'class', -values=>\@classNames),
            submit(-value=>'Submit'),
            end_form;
    }
  }
}

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
