#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use RIB::Parser;

##############################################

my $util = new RIB::Util();
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
my $repoHandle = param('rh');
unless (param('objectClass')) {
  $util->error("object class not specified in input");
}
my $class = param('objectClass');

# parse repository configuration
my $rp = new RIB::Parser;
eval { $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml"); };
if ($@) { $util->error("Can't parse repository configuration : " . $@); }

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $class_handle = param('rh') . "_" . param('objectClass');

foreach my $x (param()) {
  next unless $x =~ /^oh\d+$/;
  my $handle = param($x);
  next unless $handle =~ /^[0-9]+$/;

  #########
  # delete the object
  my $sth = $util->dbh->prepare("DELETE FROM $class_handle WHERE handle=$handle "
                              . "OR extends=$handle");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }

  #########
  # delete any pointers to the object in the same repository
  my $url = $riburl;
  # make the url safe for regexp
  $url =~ s/\\/\\\\/g;
  $url =~ s/([\$\^\.\*\+\?\|\(\)\{\}\[\]])/\\$1/g;
  my $regexp1 = "$url.*[[:<:]]rh=".$repoHandle."[[:>:]]";
  my $regexp2 = "$url.*[[:<:]]oh=".$handle."[[:>:]]";
  my $regexp3 = "$url.*[[:<:]]class=".$class."[[:>:]]";
  
  #########
  eval {
    $sth = $util->dbh->prepare("SHOW TABLES LIKE '$repoHandle\_%'");
    $sth->execute();
    my $tmpref = $sth->fetchall_arrayref;
    foreach my $table (@{$tmpref}) {
      my $tn = $table->[0];
      my @fieldnames = ();
      next if $tn =~ /^$repoHandle\_interop_registry/;
      next if $tn =~ /^$repoHandle\_interop_objects/;
      my $sth2 = $util->dbh->prepare("SHOW COLUMNS FROM $tn");
      $sth2->execute();
      my $tmpref2 = $sth2->fetchall_arrayref;
      my $made_change = 0;
      foreach my $column (@{$tmpref2}) {
        my $cn = $column->[0];
        next unless $cn =~ /\_$/;
        next unless $cn =~ /^[^_]+\_$class\_/;
        $made_change = 1;
        push(@fieldnames,$cn);
        $util->dbh->do("UPDATE $tn SET $cn=NULL WHERE "
                     . "$cn REGEXP \"$regexp1\" "
                     . "AND $cn REGEXP \"$regexp2\" "
                     . "AND $cn REGEXP \"$regexp3\"");
      }
      if ($made_change) {
        my $query = "DELETE FROM $tn WHERE extends IS NOT NULL ";
        foreach my $field (@fieldnames) {
          $query.="AND ($field IS NULL OR $field='')";
        }
        $util->dbh->do($query);
    }
    }
  };
}
print header(-type=>"text/plain"), "ok";

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
