#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

##############################################

my $util = new RIB::Util();
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("Repository handle not supplied in input.");
}
$util->dbConnect();
$util->authenticate(param('password'),undef);

my $passwd_form = 
      "Please enter the new repository password in the form below. "
      . "Click <A HREF=$riburl/doc/top_help.html#ac>here</A> for help."
      . start_form
      . "<TABLE><TR><TD>Password:</TD><TD>"
      . password_field(-name=>'newPasswd1', -size=>50, -maxlength=>80, -value=>'')
      . "</TD></TR><TR><TD>Retype Password:</TD><TD>"
      . password_field(-name=>'newPasswd2', -size=>50, -maxlength=>80, -value=>'')
      . "</TD></TR></TABLE>"
      . hidden(-name=>'password')
      . hidden(-name=>'rh')
      . submit(-value=>'Submit')
      . end_form
      . end_html;

if (!defined(param('newPasswd1'))) {
  print header,
        start_html('-title'=>'Change Repository Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Repository Password')),
        p,hr,p,
        $passwd_form;
  goto FALLOFF;
}

if (length(param('newPasswd1')) < 5) {
  print header,
        start_html('-title'=>'Change Repository Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Repository Password')),
        p,hr,p,
        "New Password should be at least 5 characters long.",
        $passwd_form;
  goto FALLOFF;
}

if (length(param('newPasswd1')) < 5) {
  print header,
        start_html('-title'=>'Change Repository Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Repository Password')),
        p,hr,p,
        "Passwords didn't match. Please retype the passwords.",
        $passwd_form;
  goto FALLOFF;
}

my $sth = $util->dbh->prepare("UPDATE repositories SET password="
                   . $util->dbh->quote(param('newPasswd1'))
                   . " WHERE handle="
                   . param('rh'));

unless ($sth->execute) {
  $util->error($util->dbh->errstr);
}

print header,
      start_html('-title'=>'Change Repository Password',-BGCOLOR=>'#FFFFFF'),
      center(h1('Change Repository Password')),
      p,hr,p,
      "The repository password was successfully changed.",
      p,
      start_form(-action=>'top.pl'),
      hidden(-name=>'password'),
      submit(-value=>'Return to the RIB management page'),
      end_form;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
