#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('objectClass') =~ /^\w+$/) {
  $util->error("object class not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $class_handle = param('rh') . "_" . param('objectClass');

foreach my $x (param()) {
  next unless $x =~ /^oh\d+$/;
  my $handle = param($x);
  next unless $handle =~ /^[0-9]+$/;
  my $sth = $util->dbh->prepare("UPDATE $class_handle SET approved=1, "
                              . "last_modified=last_modified WHERE "
                              . "handle=$handle OR extends=$handle");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
}
print header(-type=>"text/plain"), "ok";

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
