/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibObjectEditor;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;
import org.nhse.rib.RibVocabularyTerm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RibObjectEditor
extends JPanel {
    private RibConfig ribConfig;
    private RibComm ribComm;
    private JPanel addHere = new JPanel();
    private String cgiUrl;
    private String objectHandle;
    private RibInterface ribInterface;
    private Hashtable browsedObjects = new Hashtable();
    private Stack saveState = new Stack();
    private ImageIcon deleteButtonIcon;
    private ImageIcon createButtonIcon;
    private ImageIcon browseButtonIcon;
    private String startClass;
    Cursor waitCursor = Cursor.getPredefinedCursor(3);
    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    Cursor textCursor = Cursor.getPredefinedCursor(2);
    private Vector exportBag = new Vector(9);

    RibObjectEditor(RibInterface ri, RibConfig rc1, RibComm rc2) {
        this.ribInterface = ri;
        this.ribConfig = rc1;
        this.ribComm = rc2;
        this.setLayout(new CardLayout());
        this.deleteButtonIcon = this.ribInterface.deleteButtonIcon;
        this.createButtonIcon = this.ribInterface.createButtonIcon;
        this.browseButtonIcon = this.ribInterface.browseButtonIcon;
    }

    private void buildVocabularyTree(DefaultMutableTreeNode tn, RibVocabularyTerm rvt) {
        DefaultMutableTreeNode newTreeNode = new DefaultMutableTreeNode(rvt.getTerm());
        Vector children = rvt.getChildren();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            this.buildVocabularyTree(newTreeNode, (RibVocabularyTerm)e.nextElement());
        }
        tn.add(newTreeNode);
    }

    private void checkSaveButton(JButton saveButton, Color[] attrListColors, Color[] relListColors) {
        int i = 0;
        while (i < attrListColors.length) {
            if (attrListColors[i] == Color.red) {
                saveButton.setEnabled(false);
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < relListColors.length) {
            if (relListColors[i2] == Color.red) {
                saveButton.setEnabled(false);
                return;
            }
            ++i2;
        }
        saveButton.setEnabled(true);
    }

    private JPanel createClassPanel(RibClass rc) {
        RibClass ribClass = rc;
        String className = ribClass.getName();
        JList attributeList = new JList();
        JList relationshipList = new JList();
        JPanel editPanel = new JPanel(new BorderLayout());
        JPanel valuesPanel = new JPanel(new CardLayout());
        JButton addButton = new JButton("   Add Field  ");
        addButton.addMouseListener(new ButtonPushMouseListener(addButton));
        JButton saveButton = new JButton("   Save Object  ");
        saveButton.addMouseListener(new ButtonPushMouseListener(saveButton));
        saveButton.setToolTipText("Save this " + className);
        JButton cancelButton = new JButton("   Cancel   ");
        cancelButton.addMouseListener(new ButtonPushMouseListener(cancelButton));
        cancelButton.setToolTipText("Cancel creation of this " + className);
        JPanel classPanel = new JPanel(new BorderLayout());
        String[] chosenField = new String[]{""};
        JTextArea descArea = new JTextArea();
        descArea.setCursor(this.textCursor);
        JScrollPane descScrollPane = new JScrollPane();
        JPanel leftArea = new JPanel();
        leftArea.setLayout(new BoxLayout(leftArea, 1));
        Vector attributeNames = ribClass.getAttributeNames();
        Vector relationshipNames = ribClass.getRelationshipNames();
        Color[] attrListColors = new Color[attributeNames.size()];
        Color[] relListColors = new Color[relationshipNames.size()];
        JPanel[] attributePanels = new JPanel[attributeNames.size()];
        JPanel[] relationshipPanels = new JPanel[relationshipNames.size()];
        this.exportBag.addElement(ribClass);
        this.exportBag.addElement(attributeList);
        this.exportBag.addElement(relationshipList);
        this.exportBag.addElement(addButton);
        this.exportBag.addElement(saveButton);
        this.exportBag.addElement(attrListColors);
        this.exportBag.addElement(relListColors);
        this.exportBag.addElement(attributePanels);
        this.exportBag.addElement(relationshipPanels);
        JPanel attrPanel = new JPanel();
        attrPanel.setBorder(new EtchedBorder());
        attrPanel.setLayout(new BorderLayout());
        JPanel attrLabelPanel = new JPanel(new BorderLayout());
        JLabel label1 = new JLabel(className);
        label1.setForeground(Color.white);
        label1.setHorizontalAlignment(0);
        attrLabelPanel.add((Component)label1, "North");
        JLabel label2 = new JLabel("Attributes");
        label2.setForeground(Color.white);
        label2.setHorizontalAlignment(0);
        attrLabelPanel.add((Component)label2, "South");
        attrLabelPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        attrLabelPanel.setBackground(Color.black);
        attrPanel.add((Component)attrLabelPanel, "North");
        if (attributeNames.size() > 0) {
            int i = 0;
            while (i < attributeNames.size()) {
                RibAttribute tmp = ribClass.getAttribute((String)attributeNames.elementAt(i));
                attrListColors[i] = tmp.getStatus().equals("req") ? Color.red : Color.black;
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                JScrollPane jsp = new JScrollPane(panel);
                valuesPanel.add("a" + tmp.getName(), jsp);
                attributePanels[i] = panel;
                ++i;
            }
            attributeList.setCellRenderer(new attrListCellRenderer(attrListColors, ribClass));
            attributeList.setListData(attributeNames);
            if (attributeNames.size() >= 12) {
                attributeList.setVisibleRowCount(12);
            }
            attributeList.addListSelectionListener(new 1.attributeListListSelectionListener(addButton, attributeList, chosenField, descArea, relationshipList, ribClass, this, valuesPanel));
            attributeList.setSelectionMode(0);
            JScrollPane attrScrollPane = new JScrollPane(attributeList);
            attrScrollPane.setPreferredSize(attrScrollPane.getPreferredSize());
            attrPanel.add((Component)attrScrollPane, "Center");
        } else {
            JPanel tmp = new JPanel(new FlowLayout());
            tmp.setBackground(Color.white);
            tmp.setBorder(new LineBorder(Color.gray));
            JLabel label = new JLabel("(none)");
            label.setFont(new Font("Dialog", 2, 12));
            tmp.add(label);
            attrPanel.add((Component)tmp, "Center");
        }
        leftArea.add(attrPanel);
        JPanel relPanel = new JPanel();
        relPanel.setLayout(new BorderLayout());
        relPanel.setBorder(new EtchedBorder());
        JPanel relLabelPanel = new JPanel(new BorderLayout());
        JLabel label3 = new JLabel(className);
        label3.setForeground(Color.white);
        label3.setHorizontalAlignment(0);
        relLabelPanel.add((Component)label3, "North");
        JLabel label4 = new JLabel("Relationships");
        label4.setForeground(Color.white);
        label4.setHorizontalAlignment(0);
        relLabelPanel.add((Component)label4, "South");
        relLabelPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        relLabelPanel.setBackground(Color.black);
        relPanel.add((Component)relLabelPanel, "North");
        if (relationshipNames.size() > 0) {
            int i = 0;
            while (i < relationshipNames.size()) {
                RibRelationship tmp = ribClass.getRelationship((String)relationshipNames.elementAt(i));
                relListColors[i] = tmp.getStatus().equals("req") ? Color.red : Color.black;
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                JScrollPane jsp = new JScrollPane(panel);
                jsp.setPreferredSize(jsp.getPreferredSize());
                valuesPanel.add("r" + tmp.getName(), jsp);
                relationshipPanels[i] = panel;
                ++i;
            }
            relationshipList.setCellRenderer(new relListCellRenderer(relListColors, ribClass));
            relationshipList.setListData(relationshipNames);
            relationshipList.addListSelectionListener(new 1.relationshipListListSelectionListener(addButton, attributeList, chosenField, descArea, relationshipList, ribClass, this, valuesPanel));
            relationshipList.setSelectionMode(0);
            if (relationshipNames.size() < 10) {
                relationshipList.setVisibleRowCount(relationshipNames.size());
            }
            JScrollPane relScrollPane = new JScrollPane(relationshipList);
            relScrollPane.setPreferredSize(relScrollPane.getPreferredSize());
            relPanel.add((Component)relScrollPane, "Center");
        } else {
            JPanel tmp = new JPanel(new FlowLayout());
            tmp.setBackground(Color.white);
            tmp.setBorder(new LineBorder(Color.gray));
            JLabel label = new JLabel("(none)");
            label.setFont(new Font("Dialog", 2, 12));
            tmp.add(label);
            relPanel.add((Component)tmp, "Center");
        }
        leftArea.add(relPanel);
        classPanel.add((Component)leftArea, "West");
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setBorder(new BevelBorder(1));
        buttonPanel.setFloatable(false);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(addButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(saveButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(cancelButton);
        HelpButton helpButton = new HelpButton("object_editor.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, cancelButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, cancelButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on the object editor");
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(helpButton);
        editPanel.add((Component)buttonPanel, "North");
        descArea.setRows(2);
        descArea.setEditable(false);
        descArea.setLineWrap(true);
        descArea.setWrapStyleWord(true);
        descArea.setBackground(new Color(126, 129, 211));
        descArea.setForeground(Color.white);
        descScrollPane.getViewport().setView(descArea);
        descScrollPane.setPreferredSize(descScrollPane.getPreferredSize());
        editPanel.add((Component)descScrollPane, "South");
        saveButton.addActionListener(new 1.saveButtonActionListener(attributeList, attributePanels, className, classPanel, relationshipList, relationshipPanels, this, this));
        addButton.addActionListener(new 1.addButtonActionListener(addButton, attrListColors, attributeList, chosenField, relListColors, relationshipList, ribClass, saveButton, this));
        cancelButton.addActionListener(new 1.cancelButtonActionListener(classPanel, this, this));
        addButton.setToolTipText(null);
        addButton.setEnabled(false);
        saveButton.setEnabled(false);
        editPanel.add((Component)valuesPanel, "Center");
        classPanel.add((Component)editPanel, "Center");
        String ds = String.valueOf(new Date().getTime());
        this.add((Component)classPanel, ds);
        return classPanel;
    }

    public JPanel createObject(String className) {
        this.ribConfig.parse();
        JPanel jp = this.createClassPanel(this.ribConfig.getClass(className));
        Date date = new Date();
        String ds = String.valueOf(date.getTime());
        this.add((Component)jp, ds);
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, ds);
        if (this.saveState.empty()) {
            this.startClass = className;
        }
        return jp;
    }

    public void editObject(String className, String url, String handle) {
        JPanel jp = this.createObject(className);
        this.objectHandle = handle;
        jp.setEnabled(false);
        this.loadURL(url);
        this.exportBag.removeAllElements();
        jp.setEnabled(true);
    }

    public void importObject(String className, String url) {
        JPanel jp = this.createObject(className);
        jp.setEnabled(false);
        try {
            this.loadURL(url);
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
        }
        this.exportBag.removeAllElements();
        jp.setEnabled(true);
    }

    private void loadURL(String s) {
        RibClass ribClass = (RibClass)this.exportBag.elementAt(0);
        JList attributeList = (JList)this.exportBag.elementAt(1);
        JList relationshipList = (JList)this.exportBag.elementAt(2);
        JButton addButton = (JButton)this.exportBag.elementAt(3);
        JButton saveButton = (JButton)this.exportBag.elementAt(4);
        Color[] attrListColors = (Color[])this.exportBag.elementAt(5);
        Color[] relListColors = (Color[])this.exportBag.elementAt(6);
        JPanel[] attributePanels = (JPanel[])this.exportBag.elementAt(7);
        JPanel[] relationshipPanels = (JPanel[])this.exportBag.elementAt(8);
        Reader reader = null;
        try {
            reader = this.ribComm.getObject(s);
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
            return;
        }
        try {
            NodeList relationshipNodes;
            NodeList attributeNodes;
            String inputLine;
            Parser parser = new Parser(s);
            parser.setExpandEntityReferences(true);
            parser.setEndBy1stError(false);
            BufferedReader br = new BufferedReader(reader);
            String content = new String();
            while ((inputLine = br.readLine()) != null) {
                content = String.valueOf(content) + inputLine;
            }
            if ((content = content.replace('\n', ' ')).indexOf("<?xml ") == -1) {
                content.trim();
                int index = content.indexOf("<head>");
                if (index == -1 && (index = content.indexOf("<HEAD>")) == -1) {
                    this.ribInterface.showAlert("Object is not in RIB version 1.x or 2.0 format so it cannot be parsed.");
                    return;
                }
                if ((index = (content = content.substring(index)).indexOf("</head>")) == -1 && (index = content.indexOf("</HEAD>")) == -1) {
                    this.ribInterface.showAlert("Object is not in RIB version 1.x or 2.0 format so it cannot be parsed.");
                    return;
                }
                content = content.substring(0, index + 7);
                String buf = new String();
                StringTokenizer st = new StringTokenizer(content, "<");
                while (st.hasMoreTokens()) {
                    String s2 = st.nextToken();
                    buf = s2.indexOf("META ") == 0 ? String.valueOf(buf) + "<" + s2 + "</META>" : (s2.indexOf("LINK ") == 0 ? String.valueOf(buf) + "<" + s2 + "</LINK>" : String.valueOf(buf) + "<" + s2);
                }
                content = buf;
                content = "<?xml version=\"1.0\" ?>" + content;
                TXDocument doc = parser.readStream((Reader)new StringReader(content));
                Element rootNode = doc.getDocumentElement();
                attributeNodes = new RibNodeList();
                relationshipNodes = new RibNodeList();
                NodeList metaNodes = rootNode.getElementsByTagName("META");
                int i = 0;
                while (i < metaNodes.getLength()) {
                    Element metaElement = (Element)metaNodes.item(i);
                    String name = metaElement.getAttribute("name");
                    name = name.substring(name.lastIndexOf(".") + 1);
                    Element element = doc.createElement("attribute");
                    element.setAttribute("name", name);
                    element.appendChild(doc.createTextNode(metaElement.getAttribute("content")));
                    ((RibNodeList)attributeNodes).addElement(element);
                    ++i;
                }
                NodeList linkNodes = rootNode.getElementsByTagName("LINK");
                int i2 = 0;
                while (i2 < linkNodes.getLength()) {
                    Element linkElement = (Element)linkNodes.item(i2);
                    String name = linkElement.getAttribute("rel");
                    name = name.substring(name.indexOf(".") + 1);
                    name = name.substring(name.indexOf(".") + 1);
                    Element element = doc.createElement("relationship");
                    element.setAttribute("name", name);
                    element.appendChild(doc.createTextNode(linkElement.getAttribute("href")));
                    ((RibNodeList)relationshipNodes).addElement(element);
                    ++i2;
                }
            } else {
                TXDocument doc = parser.readStream((Reader)new StringReader(content));
                Element rootNode = doc.getDocumentElement();
                if (rootNode.getTagName().equals("rib")) {
                    attributeNodes = rootNode.getElementsByTagName("attribute");
                    relationshipNodes = rootNode.getElementsByTagName("relationship");
                } else {
                    this.ribInterface.showAlert("Object is not in RIB version 1.x or 2.0 format so it cannot be parsed.");
                    return;
                }
            }
            if (attributeNodes.getLength() == 0 && relationshipNodes.getLength() == 0) {
                throw new Exception("The object was either formatted incorrectly\nor contained no useful information.");
            }
            ListModel attributeNames = attributeList.getModel();
            int i = 0;
            while (i < attributeNames.getSize()) {
                String attributeName = (String)attributeNames.getElementAt(i);
                RibAttribute attr = ribClass.getAttribute(attributeName);
                String cardinality = attr.getCardinality();
                String dtype = attr.getDtype();
                attributeList.setSelectedIndex(i);
                int j = 0;
                while (j < attributeNodes.getLength()) {
                    Element attributeNode = (Element)attributeNodes.item(j);
                    if (attributeNode.getAttribute("name").equals(attributeName) && (cardinality.equals("mult") || this.addHere.getComponentCount() <= 0)) {
                        JTextComponent typeIn;
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.setBorder(new EtchedBorder(1));
                        JPanel buttonPanel2 = new JPanel();
                        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
                        buttonPanel2.setAlignmentX(0.0f);
                        buttonPanel2.setBorder(new BevelBorder(1));
                        panel.add(buttonPanel2);
                        JButton deleteButton = new JButton("  Delete  ");
                        if (this.deleteButtonIcon != null) {
                            deleteButton.setIcon(this.deleteButtonIcon);
                        }
                        deleteButton.setToolTipText("Delete this field");
                        deleteButton.addMouseListener(new ButtonPushMouseListener(deleteButton));
                        deleteButton.addActionListener(new DeleteButtonActionListener(attrListColors, relListColors, attributeList, relationshipList, saveButton, addButton, "a" + attributeName, ribClass));
                        buttonPanel2.add(deleteButton);
                        RibDocumentListener rdl = new RibDocumentListener(attrListColors, relListColors, attributeList, saveButton, "a" + attributeName, ribClass, true);
                        if (attr.hasVocabulary()) {
                            int bangIndex;
                            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                            this.buildVocabularyTree(root, attr.getVocabulary());
                            root = (DefaultMutableTreeNode)root.getChildAt(0);
                            root.removeFromParent();
                            JTree jtree = new JTree(root);
                            jtree.setRootVisible(false);
                            jtree.getSelectionModel().setSelectionMode(1);
                            jtree.setAlignmentX(0.0f);
                            jtree.setBorder(new LineBorder(Color.gray));
                            String theValue = String.valueOf(attributeNode.getFirstChild().getNodeValue()) + "!";
                            TreePath tp = new TreePath((TreeNode)jtree.getModel().getRoot());
                            while ((bangIndex = theValue.indexOf("!")) != -1) {
                                if (bangIndex == 0) break;
                                String nodeToFind = theValue.substring(0, bangIndex);
                                theValue = theValue.substring(bangIndex + 1);
                                boolean foundNode = false;
                                TreeNode tn = (TreeNode)tp.getLastPathComponent();
                                int k = 0;
                                while (k < tn.getChildCount()) {
                                    if (tn.getChildAt(k).toString().equals(nodeToFind)) {
                                        tp = new TreePath(((DefaultMutableTreeNode)tn.getChildAt(k)).getPath());
                                        foundNode = true;
                                    }
                                    ++k;
                                }
                                if (!foundNode) break;
                            }
                            if (tp.getPathCount() == 1) {
                                jtree.setSelectionRow(0);
                            } else {
                                jtree.setSelectionPath(tp);
                            }
                            panel.add(jtree);
                            attrListColors[i] = Color.blue;
                            attributeList.repaint();
                        } else if (dtype.equals("text")) {
                            typeIn = new JTextArea();
                            typeIn.getDocument().addDocumentListener(rdl);
                            typeIn.setCursor(this.textCursor);
                            ((JTextArea)typeIn).setLineWrap(true);
                            ((JTextArea)typeIn).setWrapStyleWord(true);
                            ((JTextArea)typeIn).setRows(5);
                            JScrollPane jsp = new JScrollPane(typeIn);
                            jsp.setPreferredSize(jsp.getPreferredSize());
                            jsp.setMaximumSize(new Dimension(9999, jsp.getPreferredSize().height));
                            jsp.setAlignmentX(0.0f);
                            panel.add(jsp);
                            jsp.revalidate();
                            if (attributeName.equals("DateOfInformation")) {
                                typeIn.setText(new Date().toString());
                            } else {
                                typeIn.setText(attributeNode.getFirstChild().getNodeValue());
                            }
                        } else if (dtype.equals("date")) {
                            typeIn = new JTextField();
                            typeIn.getDocument().addDocumentListener(rdl);
                            typeIn.setCursor(this.textCursor);
                            typeIn.setAlignmentX(0.0f);
                            panel.add(typeIn);
                            if (attributeName.equals("DateOfInformation")) {
                                typeIn.setText(new Date().toString());
                            } else {
                                typeIn.setText(attributeNode.getFirstChild().getNodeValue());
                            }
                            typeIn.setMaximumSize(new Dimension(9999, ((JTextField)typeIn).getPreferredSize().height));
                        } else {
                            typeIn = new JTextField(5);
                            typeIn.getDocument().addDocumentListener(rdl);
                            typeIn.setCursor(this.textCursor);
                            typeIn.setAlignmentX(0.0f);
                            panel.add(typeIn);
                            if (attributeName.equals("DateOfInformation")) {
                                typeIn.setText(new Date().toString());
                            } else {
                                typeIn.setText(attributeNode.getFirstChild().getNodeValue());
                            }
                            typeIn.setMaximumSize(new Dimension(9999, ((JTextField)typeIn).getPreferredSize().height));
                        }
                        this.addHere.add(panel);
                        attributePanels[i].add(panel);
                    }
                    ++j;
                }
                ++i;
            }
            ListModel relationshipNames = relationshipList.getModel();
            int i3 = 0;
            while (i3 < relationshipNames.getSize()) {
                String relationshipName = (String)relationshipNames.getElementAt(i3);
                RibRelationship rel = ribClass.getRelationship(relationshipName);
                String cardinality = rel.getCardinality();
                relationshipList.setSelectedIndex(i3);
                int j = 0;
                while (j < relationshipNodes.getLength()) {
                    Element relationshipNode = (Element)relationshipNodes.item(j);
                    if (relationshipNode.getAttribute("name").equals(relationshipName) && (cardinality.equals("mult") || this.addHere.getComponentCount() <= 0)) {
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.setBorder(new EtchedBorder(1));
                        JPanel buttonPanel2 = new JPanel();
                        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
                        buttonPanel2.setBorder(new BevelBorder(1));
                        buttonPanel2.setAlignmentX(0.0f);
                        JButton deleteButton = new JButton("  Delete  ");
                        if (this.deleteButtonIcon != null) {
                            deleteButton.setIcon(this.deleteButtonIcon);
                        }
                        deleteButton.setToolTipText("Delete this field");
                        deleteButton.addMouseListener(new ButtonPushMouseListener(deleteButton));
                        deleteButton.addActionListener(new DeleteButtonActionListener(attrListColors, relListColors, attributeList, relationshipList, saveButton, addButton, "r" + relationshipName, ribClass));
                        deleteButton.setAlignmentY(0.0f);
                        buttonPanel2.add(deleteButton);
                        panel.add(buttonPanel2);
                        RibDocumentListener rdl = new RibDocumentListener(attrListColors, relListColors, relationshipList, saveButton, "r" + relationshipName, ribClass, false);
                        JTextField typeIn = new JTextField(5);
                        typeIn.getDocument().addDocumentListener(rdl);
                        typeIn.setAlignmentX(0.0f);
                        panel.add(typeIn);
                        String urlStr = relationshipNode.getFirstChild().getNodeValue();
                        typeIn.setText(urlStr);
                        typeIn.setForeground(Color.blue);
                        typeIn.setBackground(Color.white);
                        typeIn.setCursor(Cursor.getPredefinedCursor(12));
                        typeIn.addMouseListener(new 8(urlStr));
                        typeIn.setEditable(false);
                        typeIn.setToolTipText("Click to view");
                        typeIn.setMaximumSize(new Dimension(9999, typeIn.getPreferredSize().height));
                        this.addHere.add((Component)panel, 0);
                        this.addHere.revalidate();
                        relationshipPanels[i3].add(panel);
                    }
                    ++j;
                }
                ++i3;
            }
            if (attributeList.getModel().getSize() > 0) {
                relationshipList.clearSelection();
                attributeList.clearSelection();
                attributeList.setSelectedIndex(0);
            } else if (relationshipList.getModel().getSize() > 0) {
                attributeList.clearSelection();
                relationshipList.clearSelection();
                relationshipList.setSelectedIndex(0);
            } else {
                attributeList.clearSelection();
                relationshipList.clearSelection();
            }
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
        }
    }

    private String saveObject(String className, ListModel attributes, ListModel relationships, JPanel[] attributePanels, JPanel[] relationshipPanels) {
        try {
            TXDocument doc = new TXDocument();
            doc.setVersion("1.0");
            doc.setStandalone("yes");
            Element rootElement = doc.createElement("rib");
            rootElement.setAttribute("version", RibUtil.getRibVersion());
            doc.appendChild((Node)rootElement);
            Element repoElement = doc.createElement("repository");
            repoElement.setAttribute("name", this.ribInterface.repoName);
            rootElement.appendChild(repoElement);
            Element classElement = doc.createElement("class");
            classElement.setAttribute("name", className);
            repoElement.appendChild(classElement);
            Element objectElement = doc.createElement("object");
            classElement.appendChild(objectElement);
            int i = 0;
            while (i < attributes.getSize()) {
                JPanel attributePanel = attributePanels[i];
                int j = 0;
                while (j < attributePanel.getComponentCount()) {
                    TXElement element = new TXElement("attribute");
                    String attrName = (String)attributes.getElementAt(i);
                    element.setAttribute("name", attrName);
                    JPanel panel = (JPanel)attributePanel.getComponent(j);
                    Component component = panel.getComponent(1);
                    String componentText = null;
                    if (component instanceof JTextField) {
                        componentText = ((JTextField)component).getText();
                        if (this.ribConfig.getClass(className).getAttribute(attrName).getDtype().equals("url")) {
                            if ((componentText = componentText.trim()).indexOf("://") < 0) {
                                componentText = "http://" + componentText;
                            }
                            try {
                                new URL(componentText);
                            }
                            catch (MalformedURLException malformedURLException) {
                                return "Value for " + attrName + " attribute should be a URL since its data type is URL.";
                            }
                        }
                    } else if (component instanceof JScrollPane) {
                        JTextArea ta = (JTextArea)((JScrollPane)component).getViewport().getView();
                        componentText = ta.getText();
                    } else if (component instanceof JTree) {
                        Object[] path = ((JTree)component).getSelectionPath().getPath();
                        int k = 1;
                        while (k < path.length) {
                            componentText = componentText != null ? String.valueOf(componentText) + "!" + path[k].toString() : path[k].toString();
                            ++k;
                        }
                    }
                    if (componentText != null && !componentText.equals("")) {
                        element.appendChild((Node)doc.createTextNode(componentText));
                        objectElement.appendChild((Node)element);
                    }
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < relationships.getSize()) {
                JPanel relationshipPanel = relationshipPanels[i2];
                int j = 0;
                while (j < relationshipPanel.getComponentCount()) {
                    TXElement element = new TXElement("relationship");
                    String relName = (String)relationships.getElementAt(i2);
                    element.setAttribute("name", relName);
                    JPanel panel = (JPanel)relationshipPanel.getComponent(j);
                    Component component = panel.getComponent(1);
                    String componentText = null;
                    if (component.getClass().getName().indexOf("JTextField") != -1) {
                        componentText = ((JTextField)component).getText();
                    } else if (component instanceof JComboBox) {
                        String dest = this.ribConfig.getClass(className).getRelationship(relName).getDest();
                        String selectedItem = (String)((JComboBox)component).getSelectedItem();
                        componentText = (String)this.browsedObjects.get(String.valueOf(dest) + "!" + selectedItem);
                    }
                    if (componentText != null && !componentText.equals("")) {
                        componentText = componentText.trim();
                        try {
                            new URL(componentText);
                        }
                        catch (MalformedURLException malformedURLException) {
                            return "Value for " + relName + " relationship should be a URL or should come from the Browse button.";
                        }
                        element.appendChild((Node)doc.createTextNode(componentText));
                        objectElement.appendChild((Node)element);
                    }
                    ++j;
                }
                ++i2;
            }
            if (this.saveState.empty() && this.objectHandle != null) {
                this.ribInterface.setCursor(this.waitCursor);
                this.ribInterface.showStatus("Accessing network...");
                String res = this.ribComm.editObject(this.objectHandle, doc);
                this.ribInterface.setCursor(this.defaultCursor);
                this.ribInterface.showStatus("");
                return res;
            }
            this.ribInterface.setCursor(this.waitCursor);
            this.ribInterface.showStatus("Accessing network...");
            String res = this.ribComm.createObject(doc);
            this.ribInterface.setCursor(this.defaultCursor);
            this.ribInterface.showStatus("");
            return res;
        }
        catch (Exception e) {
            return "Error: " + e.toString();
        }
    }

    public void showAlert(String message) {
        SwingUtilities.invokeLater(new 9(message, this));
    }

    static /* synthetic */ void access$1(RibObjectEditor $0, JPanel $1) {
        $0.addHere = $1;
    }

    static /* synthetic */ String access$2(RibObjectEditor $0, String $1, ListModel $2, ListModel $3, JPanel[] $4, JPanel[] $5) {
        return $0.saveObject($1, $2, $3, $4, $5);
    }

    static /* synthetic */ Hashtable access$3(RibObjectEditor $0) {
        return $0.browsedObjects;
    }

    static /* synthetic */ Stack access$4(RibObjectEditor $0) {
        return $0.saveState;
    }

    static /* synthetic */ String access$6(RibObjectEditor $0) {
        return $0.startClass;
    }

    static /* synthetic */ ImageIcon access$7(RibObjectEditor $0) {
        return $0.deleteButtonIcon;
    }

    static /* synthetic */ void access$8(RibObjectEditor $0, DefaultMutableTreeNode $1, RibVocabularyTerm $2) {
        $0.buildVocabularyTree($1, $2);
    }

    static /* synthetic */ ImageIcon access$9(RibObjectEditor $0) {
        return $0.createButtonIcon;
    }

    static /* synthetic */ ImageIcon access$10(RibObjectEditor $0) {
        return $0.browseButtonIcon;
    }

    static /* synthetic */ RibConfig access$11(RibObjectEditor $0) {
        return $0.ribConfig;
    }

    static /* synthetic */ RibComm access$12(RibObjectEditor $0) {
        return $0.ribComm;
    }

    class attrListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color[] attrListColors;
        private RibClass ribClass;

        attrListCellRenderer(Color[] alc, RibClass r) {
            RibObjectEditor.this = RibObjectEditor.this;
            this.attrListColors = alc;
            this.ribClass = r;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setFont((Font)UIManager.get("Font"));
            this.setOpaque(true);
            this.setForeground(this.attrListColors[index]);
            this.setBackground(isSelected ? Color.lightGray : Color.white);
            if (isSelected) {
                this.setBorder(new LineBorder(Color.gray, 1));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    class relListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color[] relListColors;
        private RibClass ribClass;

        relListCellRenderer(Color[] rlc, RibClass r) {
            RibObjectEditor.this = RibObjectEditor.this;
            this.relListColors = rlc;
            this.ribClass = r;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setFont((Font)UIManager.get("Font"));
            this.setOpaque(true);
            this.setForeground(this.relListColors[index]);
            this.setBackground(isSelected ? Color.lightGray : Color.white);
            if (isSelected) {
                this.setBorder(new LineBorder(Color.gray, 1));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    class RibDocumentListener
    implements DocumentListener {
        private Color[] attrListColors;
        private Color[] relListColors;
        private JList jlist;
        private JButton saveButton;
        private String chosenField;
        private RibClass ribClass;
        private boolean isAttribute;

        RibDocumentListener(Color[] alc, Color[] rlc, JList jl, JButton sb, String cf, RibClass rc, boolean ia) {
            RibObjectEditor.this = RibObjectEditor.this;
            this.attrListColors = alc;
            this.relListColors = rlc;
            this.jlist = jl;
            this.saveButton = sb;
            this.chosenField = cf;
            this.ribClass = rc;
            this.isAttribute = ia;
        }

        public void changedUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.getLength() == 0) {
                this.removeUpdate(e);
            } else {
                this.insertUpdate(e);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (this.isAttribute) {
                this.attrListColors[this.jlist.getSelectedIndex()] = Color.blue;
                this.jlist.repaint();
            } else {
                this.relListColors[this.jlist.getSelectedIndex()] = Color.blue;
                this.jlist.repaint();
            }
            RibObjectEditor.this.checkSaveButton(this.saveButton, this.attrListColors, this.relListColors);
        }

        public void removeUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.getLength() > 0) {
                return;
            }
            boolean checkOk = false;
            if (this.isAttribute) {
                int i = 0;
                while (i < RibObjectEditor.this.addHere.getComponentCount()) {
                    JTextComponent jtc;
                    JPanel jp = (JPanel)RibObjectEditor.this.addHere.getComponent(i);
                    Component comp = jp.getComponent(1);
                    if (comp instanceof JScrollPane) {
                        JScrollPane jsp = (JScrollPane)jp.getComponent(1);
                        jtc = (JTextComponent)jsp.getViewport().getView();
                    } else {
                        jtc = (JTextComponent)comp;
                    }
                    if (!jtc.getText().equals("")) {
                        checkOk = true;
                    }
                    ++i;
                }
                if (!checkOk) {
                    RibAttribute ra = this.ribClass.getAttribute(this.chosenField.substring(1));
                    this.attrListColors[this.jlist.getSelectedIndex()] = ra.getStatus().equals("req") ? Color.red : Color.black;
                    this.jlist.repaint();
                }
            } else {
                int i = 0;
                while (i < RibObjectEditor.this.addHere.getComponentCount()) {
                    JPanel jp = (JPanel)RibObjectEditor.this.addHere.getComponent(i);
                    Component comp = jp.getComponent(1);
                    if (comp instanceof JComboBox) {
                        checkOk = true;
                        break;
                    }
                    JTextComponent jtc = (JTextComponent)comp;
                    if (!jtc.getText().equals("")) {
                        checkOk = true;
                        break;
                    }
                    ++i;
                }
                if (!checkOk) {
                    RibRelationship rr = this.ribClass.getRelationship(this.chosenField.substring(1));
                    this.relListColors[this.jlist.getSelectedIndex()] = rr.getStatus().equals("req") ? Color.red : Color.black;
                    this.jlist.repaint();
                }
            }
            RibObjectEditor.this.checkSaveButton(this.saveButton, this.attrListColors, this.relListColors);
        }
    }

    class DeleteButtonActionListener
    implements ActionListener {
        private Color[] attrListColors;
        private Color[] relListColors;
        private JList attributeList;
        private JList relationshipList;
        private JButton saveButton;
        private JButton addButton;
        private String chosenField;
        private RibClass ribClass;

        DeleteButtonActionListener(Color[] alc, Color[] rlc, JList al, JList rl, JButton sb, JButton ab, String cf, RibClass rc) {
            RibObjectEditor.this = RibObjectEditor.this;
            this.attrListColors = alc;
            this.relListColors = rlc;
            this.attributeList = al;
            this.relationshipList = rl;
            this.saveButton = sb;
            this.addButton = ab;
            this.chosenField = cf;
            this.ribClass = rc;
        }

        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            int x = button.getLocationOnScreen().x - ((RibObjectEditor)RibObjectEditor.this).addHere.getLocationOnScreen().x;
            int y = button.getLocationOnScreen().y - ((RibObjectEditor)RibObjectEditor.this).addHere.getLocationOnScreen().y;
            Component toDelete = RibObjectEditor.this.addHere.getComponentAt(new Point(x, y));
            RibObjectEditor.this.addHere.remove(toDelete);
            if (RibObjectEditor.this.addHere.getComponentCount() == 0) {
                this.addButton.setEnabled(true);
            }
            if (this.chosenField.charAt(0) == 'a') {
                boolean checkOk = false;
                int i = 0;
                while (i < RibObjectEditor.this.addHere.getComponentCount()) {
                    JPanel jp = (JPanel)RibObjectEditor.this.addHere.getComponent(i);
                    Component comp = jp.getComponent(1);
                    if (comp instanceof JScrollPane) {
                        JScrollPane jsp = (JScrollPane)jp.getComponent(1);
                        JTextComponent jtc = (JTextComponent)jsp.getViewport().getView();
                        if (jtc.getCaretPosition() != 0) {
                            checkOk = true;
                            break;
                        }
                    } else {
                        if (comp instanceof JTree) {
                            checkOk = true;
                            break;
                        }
                        JTextComponent jtc = (JTextComponent)comp;
                        if (jtc.getCaretPosition() != 0) {
                            checkOk = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (!checkOk) {
                    RibAttribute ra = this.ribClass.getAttribute(this.chosenField.substring(1));
                    this.attrListColors[this.attributeList.getSelectedIndex()] = ra.getStatus().equals("req") ? Color.red : Color.black;
                    this.attributeList.repaint();
                }
            } else if (this.chosenField.charAt(0) == 'r') {
                boolean checkOk = false;
                int i = 0;
                while (i < RibObjectEditor.this.addHere.getComponentCount()) {
                    JPanel jp = (JPanel)RibObjectEditor.this.addHere.getComponent(i);
                    Component comp = jp.getComponent(1);
                    if (comp instanceof JComboBox) {
                        checkOk = true;
                        break;
                    }
                    if (!((JTextComponent)comp).isEditable()) {
                        checkOk = true;
                        break;
                    }
                    if (((JTextComponent)comp).getCaretPosition() != 0) {
                        checkOk = true;
                        break;
                    }
                    ++i;
                }
                if (!checkOk) {
                    RibRelationship rr = this.ribClass.getRelationship(this.chosenField.substring(1));
                    this.relListColors[this.relationshipList.getSelectedIndex()] = rr.getStatus().equals("req") ? Color.red : Color.black;
                    this.relationshipList.repaint();
                }
            }
            RibObjectEditor.this.checkSaveButton(this.saveButton, this.attrListColors, this.relListColors);
            RibObjectEditor.this.addHere.revalidate();
            RibObjectEditor.this.addHere.repaint();
        }
    }

    private final class 8
    extends MouseAdapter {
        private final /* synthetic */ String val$urlStr;

        /* synthetic */ 8(String val$urlStr) {
            this.val$urlStr = val$urlStr;
        }

        public void mouseClicked(MouseEvent e) {
            try {
                String tmp = new String(this.val$urlStr);
                if (tmp.indexOf("?") != -1 && tmp.indexOf("oh=") != -1) {
                    tmp = String.valueOf(tmp) + "&html=1";
                }
                URL myUrl = new URL(tmp);
                RibObjectEditor.this.ribInterface.getAppletContext().showDocument(myUrl, "_blank");
            }
            catch (Exception e2) {
                RibObjectEditor.this.ribInterface.showAlert(e2.toString());
            }
        }
    }

    private static final class 9
    extends Thread {
        private final /* synthetic */ String val$message;
        private final /* synthetic */ RibObjectEditor this$0;

        /* synthetic */ 9(String val$message, RibObjectEditor this$0) {
            this.val$message = val$message;
            this.this$0 = this$0;
        }

        public void run() {
            JOptionPane.showMessageDialog(this.this$0.ribInterface, this.val$message, "Alert", 0);
        }
    }

    public class RibNodeList
    extends Vector
    implements NodeList {
        public RibNodeList() {
            RibObjectEditor.this = RibObjectEditor.this;
        }

        public int getLength() {
            return this.size();
        }

        public Node item(int i) {
            return (Node)this.elementAt(i);
        }
    }
}

