/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibCatalogInfo;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibConfigEditor;
import org.nhse.rib.RibHelpPane;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibInteropShell;
import org.nhse.rib.RibObjectBrowser;
import org.nhse.rib.RibObjectEditor;
import org.nhse.rib.RibTemplateEditor;
import org.nhse.rib.RibUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RibInterface
extends JApplet {
    JTabbedPane mainPanel = new JTabbedPane();
    JPanel helpPanel = new JPanel();
    JPanel objectsPanel = new JPanel();
    JPanel catalogPanel = new JPanel();
    JPanel filesPanel = new JPanel();
    JPanel interopPanel = new JPanel();
    JPanel propertiesPanel = new JPanel();
    String repoHandle;
    String repoPasswd;
    String repoName;
    String ribUrl;
    String repoUrl;
    String configUrl;
    String cgiUrl;
    RibInterface ribInterface;
    RibComm ribComm;
    Cursor waitCursor = Cursor.getPredefinedCursor(3);
    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    ImageIcon deleteButtonIcon;
    ImageIcon createButtonIcon;
    ImageIcon browseButtonIcon;
    ImageIcon helpButtonIcon;

    public void createInterop(String[] handles) {
        this.interopPanel.removeAll();
        this.interopPanel.repaint();
        JPanel jp1 = new JPanel();
        jp1.setLayout(new BoxLayout(jp1, 1));
        JPanel jp2 = new JPanel(new FlowLayout(0));
        JLabel jl = new JLabel("Repository type:   ");
        jp2.add(jl);
        String[] choices = new String[]{"Local repository", "Remote repository"};
        JComboBox<String> jcb = new JComboBox<String>(choices);
        jcb.setSelectedIndex(-1);
        jcb.setBackground(Color.white);
        jp2.add(jcb);
        jcb.addActionListener(new 36(handles, jcb, jp1, this));
        JButton cancelButton = new JButton("  Cancel  ");
        cancelButton.addMouseListener(new ButtonPushMouseListener(cancelButton));
        cancelButton.addActionListener(new 39());
        jp2.add(cancelButton);
        HelpButton helpButton = new HelpButton("interop_create.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, cancelButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, cancelButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on creating interoperations");
        jp2.add(helpButton);
        jp2.setAlignmentX(0.0f);
        jp2.setMaximumSize(jp2.getPreferredSize());
        jp1.add(jp2);
        this.interopPanel.add((Component)jp1, "North");
        jp1.revalidate();
    }

    public void createObject(String selectedClass) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.showStatus("Accessing network...");
        this.setCursor(this.waitCursor);
        RibConfig rc = new RibConfig(this.configUrl);
        RibObjectEditor re = new RibObjectEditor(this.ribInterface, rc, this.ribComm);
        re.createObject(selectedClass);
        this.objectsPanel.add((Component)re, "Center");
        this.objectsPanel.revalidate();
        this.showStatus("");
        this.setCursor(this.defaultCursor);
    }

    public void editObject(String url, String objectHandle, String selectedClass) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibConfig rc = new RibConfig(this.configUrl);
        RibObjectEditor re = new RibObjectEditor(this.ribInterface, rc, this.ribComm);
        re.editObject(selectedClass, url, objectHandle);
        this.objectsPanel.add((Component)re, "Center");
        re.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void help(String url) {
        this.mainPanel.setSelectedComponent(this.helpPanel);
        RibHelpPane rhp = (RibHelpPane)this.helpPanel.getComponent(0);
        rhp.gotoURL(String.valueOf(this.ribUrl) + "/doc/" + url);
    }

    public void importObject(String url, String selectedClass) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibConfig rc = new RibConfig(this.configUrl);
        RibObjectEditor re = new RibObjectEditor(this.ribInterface, rc, this.ribComm);
        re.importObject(selectedClass, url);
        this.objectsPanel.add((Component)re, "Center");
        re.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void init() {
        URL url;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add(this.mainPanel);
        this.repoHandle = this.getParameter("repoHandle");
        this.repoPasswd = this.getParameter("repoPasswd");
        this.repoName = this.getParameter("repoName");
        this.ribUrl = this.getParameter("ribUrl");
        this.repoUrl = String.valueOf(this.ribUrl) + "/" + this.repoHandle;
        this.configUrl = String.valueOf(this.repoUrl) + "/config.xml";
        this.cgiUrl = new String(this.ribUrl);
        SymChange lSymChange = new SymChange();
        this.mainPanel.addChangeListener(lSymChange);
        this.mainPanel.addTab(" Help ", this.helpPanel);
        this.helpPanel.setLayout(new GridLayout(1, 1));
        this.helpPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.addTab(" Manage Objects ", this.objectsPanel);
        this.objectsPanel.setLayout(new BorderLayout());
        this.objectsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.addTab(" Manage Catalog ", this.catalogPanel);
        this.catalogPanel.setLayout(new BoxLayout(this.catalogPanel, 1));
        this.mainPanel.addTab(" Interoperation ", this.interopPanel);
        this.interopPanel.setLayout(new BoxLayout(this.interopPanel, 1));
        this.mainPanel.addTab(" Repository Properties ", this.propertiesPanel);
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 1));
        this.ribInterface = this;
        this.ribComm = new RibComm(this.cgiUrl, this.repoHandle, this.repoPasswd, this);
        this.getRootPane().setGlassPane(new MyGlassPane());
        try {
            url = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/delete.gif");
            this.deleteButtonIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            this.deleteButtonIcon = null;
        }
        try {
            url = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/browse.gif");
            this.browseButtonIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            this.browseButtonIcon = null;
        }
        try {
            url = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/create.gif");
            this.createButtonIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            this.createButtonIcon = null;
        }
        try {
            url = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/help.gif");
            this.helpButtonIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            this.helpButtonIcon = null;
        }
    }

    private void initCatalogPanel() {
        this.catalogPanel.removeAll();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibCatalogInfo tmp = null;
        try {
            tmp = this.ribComm.getCatalogInfo();
        }
        catch (Exception e) {
            this.showAlert(e.toString());
        }
        this.setCursor(this.defaultCursor);
        this.showStatus("");
        if (tmp == null) {
            return;
        }
        RibCatalogInfo rci = tmp;
        JToolBar jtb1 = new JToolBar();
        jtb1.setFloatable(false);
        JMenuItem viewCatalogMenuItem = new JMenuItem("  Catalog  ");
        viewCatalogMenuItem.addActionListener(new 3());
        JMenuItem viewJoinMenuItem = new JMenuItem("  Join  ");
        viewJoinMenuItem.addActionListener(new 4());
        JMenuItem viewSearchMenuItem = new JMenuItem("  Search  ");
        viewSearchMenuItem.addActionListener(new 5());
        JMenuItem viewAdvancedSearchMenuItem = new JMenuItem("  Advanced Search  ");
        viewAdvancedSearchMenuItem.addActionListener(new 6());
        JMenuItem viewWhatsNewMenuItem = new JMenuItem("  What's New  ");
        viewWhatsNewMenuItem.addActionListener(new 7());
        JPopupMenu jpm1 = new JPopupMenu();
        jpm1.add(viewCatalogMenuItem);
        jpm1.add(viewJoinMenuItem);
        jpm1.add(viewSearchMenuItem);
        jpm1.add(viewAdvancedSearchMenuItem);
        jpm1.add(viewWhatsNewMenuItem);
        jpm1.pack();
        JButton viewButton = new JButton("  View  ");
        viewButton.setPreferredSize(new Dimension(jpm1.getPreferredSize().width, viewButton.getPreferredSize().height));
        viewButton.addActionListener(new 8(jpm1, viewButton));
        viewButton.addMouseListener(new ButtonPushMouseListener(viewButton));
        Container parent = this.getParent();
        while (!(parent instanceof Frame)) {
            parent = ((Component)parent).getParent();
        }
        RibTemplateEditor templateEditor = new RibTemplateEditor(this.ribInterface, this.ribComm, (Frame)parent);
        JMenuItem editCatalogMenuItem = new JMenuItem("  Catalog  ");
        JMenuItem editJoinMenuItem = new JMenuItem("  Join  ");
        JMenuItem editSearchMenuItem = new JMenuItem("  Search  ");
        JMenuItem editAdvancedSearchMenuItem = new JMenuItem("  Advanced Search  ");
        JMenuItem editWhatsNewMenuItem = new JMenuItem("  What's New  ");
        editCatalogMenuItem.addActionListener(new 9(templateEditor, this));
        editJoinMenuItem.addActionListener(new 10(templateEditor, this));
        editSearchMenuItem.addActionListener(new 11(templateEditor, this));
        editAdvancedSearchMenuItem.addActionListener(new 12(templateEditor, this));
        editWhatsNewMenuItem.addActionListener(new 13(templateEditor, this));
        JPopupMenu jpm2 = new JPopupMenu();
        jpm2.add(editCatalogMenuItem);
        jpm2.add(editJoinMenuItem);
        jpm2.add(editSearchMenuItem);
        jpm2.add(editAdvancedSearchMenuItem);
        jpm2.add(editWhatsNewMenuItem);
        jpm2.pack();
        JButton templateButton = new JButton("  Edit Template  ");
        templateButton.setPreferredSize(new Dimension(jpm2.getPreferredSize().width, templateButton.getPreferredSize().height));
        templateButton.addActionListener(new 14(jpm2, templateButton));
        templateButton.addMouseListener(new ButtonPushMouseListener(templateButton));
        HelpButton helpButton = new HelpButton("manage_catalog.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, templateButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, templateButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on managing the catalog");
        jtb1.add(viewButton);
        jtb1.add(Box.createHorizontalStrut(10));
        jtb1.add(templateButton);
        jtb1.add(Box.createHorizontalStrut(10));
        jtb1.add(helpButton);
        jtb1.setAlignmentX(0.0f);
        jtb1.setMaximumSize(jtb1.getPreferredSize());
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.catalogPanel.add(jtb1);
        JPanel jp1 = new JPanel(new FlowLayout(0));
        JLabel jl1 = new JLabel("Primary class is " + rci.getPrimaryClass());
        JPanel jp2 = new JPanel(new FlowLayout(0));
        JLabel jl2 = new JLabel("Primary attribute is " + rci.getPrimaryAttribute());
        jp1.add(jl1);
        jp1.add(Box.createHorizontalStrut(5));
        JComboBox classChoice = new JComboBox();
        classChoice.setVisible(false);
        classChoice.setBackground(Color.white);
        JButton changePrimClass = new JButton("  Change  ");
        JButton classCancel = new JButton("  Cancel  ");
        jp2.add(jl2);
        jp2.add(Box.createHorizontalStrut(5));
        JComboBox attrChoice = new JComboBox();
        attrChoice.setVisible(false);
        attrChoice.setBackground(Color.white);
        JButton changePrimAttr = new JButton("  Change  ");
        JButton attrCancel = new JButton("  Cancel  ");
        changePrimClass.addActionListener(new 15(attrCancel, attrChoice, changePrimAttr, changePrimClass, classCancel, classChoice, jp1, rci, this));
        changePrimClass.addMouseListener(new ButtonPushMouseListener(changePrimClass));
        jp1.add(changePrimClass);
        jp1.add(Box.createHorizontalStrut(5));
        jp1.add(classChoice);
        jp1.add(Box.createHorizontalStrut(2));
        classCancel.addActionListener(new 17(changePrimAttr, changePrimClass, classCancel, classChoice));
        classCancel.addMouseListener(new ButtonPushMouseListener(classCancel));
        jp1.add(classCancel);
        classCancel.setVisible(false);
        classChoice.addActionListener(new 18(changePrimAttr, changePrimClass, classCancel, jl1, jl2, jp1, jp2, rci, this));
        jp1.setAlignmentX(0.0f);
        changePrimAttr.addActionListener(new 19(attrCancel, attrChoice, changePrimAttr, jp2, rci, this));
        changePrimAttr.addMouseListener(new ButtonPushMouseListener(changePrimAttr));
        jp2.add(changePrimAttr);
        jp2.add(Box.createHorizontalStrut(5));
        jp2.add(attrChoice);
        jp2.add(Box.createHorizontalStrut(2));
        attrCancel.addActionListener(new 21(attrCancel, attrChoice, changePrimAttr));
        attrCancel.addMouseListener(new ButtonPushMouseListener(attrCancel));
        jp2.add(attrCancel);
        attrCancel.setVisible(false);
        attrChoice.addActionListener(new 22(attrCancel, changePrimAttr, jl2, jp2, rci, this));
        jp2.setAlignmentX(0.0f);
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jp1.setMaximumSize(jp1.getMinimumSize());
        this.catalogPanel.add(jp1);
        jp1.revalidate();
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jp2.setMaximumSize(jp2.getPreferredSize());
        this.catalogPanel.add(jp2);
        jp2.revalidate();
        ButtonGroup bg1 = new ButtonGroup();
        JRadioButton yes1 = new JRadioButton("Yes");
        JRadioButton no1 = new JRadioButton("No");
        if (rci.isObjectApprovalRequired()) {
            yes1.setSelected(true);
            no1.setSelected(false);
        } else {
            yes1.setSelected(false);
            no1.setSelected(true);
        }
        yes1.addActionListener(new 23(no1, rci, this));
        no1.addActionListener(new 24(rci, this, yes1));
        bg1.add(yes1);
        bg1.add(no1);
        JPanel jp3 = new JPanel();
        JLabel jl3 = new JLabel("Require object approval?     ");
        jp3.add(jl3);
        jp3.add(yes1);
        jp3.add(no1);
        jp3.setAlignmentX(0.0f);
        jp3.setMaximumSize(jp3.getPreferredSize());
        this.catalogPanel.add(jp3);
        jp3.revalidate();
        ButtonGroup bg2 = new ButtonGroup();
        JRadioButton yes2 = new JRadioButton("Yes");
        JRadioButton no2 = new JRadioButton("No");
        if (rci.isJoinEnabled()) {
            yes2.setSelected(true);
            no2.setSelected(false);
        } else {
            yes2.setSelected(false);
            no2.setSelected(true);
        }
        yes2.addActionListener(new 25(no2, rci, this));
        no2.addActionListener(new 26(rci, this, yes2));
        bg2.add(yes2);
        bg2.add(no2);
        JPanel jp4 = new JPanel();
        JLabel jl4 = new JLabel("Enable joins?");
        jl4.setPreferredSize(jl3.getPreferredSize());
        jp4.add(jl4);
        jp4.add(yes2);
        jp4.add(no2);
        jp4.setAlignmentX(0.0f);
        jp4.setMaximumSize(jp4.getPreferredSize());
        this.catalogPanel.add(jp4);
        jp4.revalidate();
        ButtonGroup bg3 = new ButtonGroup();
        JRadioButton yes3 = new JRadioButton("Yes");
        JRadioButton no3 = new JRadioButton("No");
        if (rci.isWhatsNewEnabled()) {
            yes3.setSelected(true);
            no3.setSelected(false);
        } else {
            yes3.setSelected(false);
            no3.setSelected(true);
        }
        yes3.addActionListener(new 27(no3, rci, this));
        no3.addActionListener(new 28(rci, this, yes3));
        bg3.add(yes3);
        bg3.add(no3);
        JPanel jp5 = new JPanel();
        JLabel jl5 = new JLabel("Enable \"What's New\"?");
        jl5.setPreferredSize(jl3.getPreferredSize());
        jp5.add(jl5);
        jp5.add(yes3);
        jp5.add(no3);
        jp5.setAlignmentX(0.0f);
        jp5.setMaximumSize(jp5.getPreferredSize());
        this.catalogPanel.add(jp5);
        jp5.revalidate();
    }

    public void initHelpPanel() {
        this.helpPanel.setLayout(new GridLayout(1, 1));
        RibHelpPane rhp = new RibHelpPane(this);
        this.helpPanel.add(rhp);
        rhp.revalidate();
    }

    private void initInteropPanel() {
        this.showInteropList();
    }

    public void initObjectsPanel() {
        this.showStatus("Accessing network ...");
        this.setCursor(this.waitCursor);
        this.objectsPanel.removeAll();
        this.objectsPanel.repaint();
        RibConfig config = new RibConfig(this.configUrl);
        config.parse();
        if (config.getClassNames(false).size() == 0) {
            this.showAlert("Error : Cannot parse repository data model");
        } else {
            JPanel jp = new JPanel(new FlowLayout(0));
            JLabel myLabel = new JLabel("Class :");
            jp.add(myLabel);
            Vector v = config.getClassNames(false);
            JComboBox classCombo = new JComboBox(v);
            classCombo.setSelectedIndex(-1);
            classCombo.addActionListener(new 2());
            classCombo.setBackground(Color.white);
            classCombo.setMaximumRowCount(classCombo.getItemCount());
            jp.add(classCombo);
            HelpButton helpButton = new HelpButton("manage_objects.html", this.ribInterface);
            helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, classCombo.getPreferredSize().height));
            helpButton.setToolTipText("Display help on managing objects");
            jp.add(helpButton);
            this.objectsPanel.add((Component)jp, "North");
            jp.revalidate();
        }
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void initPropertiesPanel() {
        this.propertiesPanel.removeAll();
        this.propertiesPanel.repaint();
        JPanel jp = new JPanel(new FlowLayout(0));
        JLabel l = new JLabel("Action :");
        jp.add(l);
        String[] choices = new String[]{"Data Model Editor", "Change Name", "Change Contact", "Change Password"};
        JComboBox<String> jcb = new JComboBox<String>(choices);
        jcb.setSelectedIndex(-1);
        jcb.addActionListener(new PropertiesActionChosen());
        jcb.setBackground(Color.white);
        jp.add(jcb);
        HelpButton helpButton = new HelpButton("repo_properties.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jcb.getPreferredSize().height));
        helpButton.setToolTipText("Display help on repository properties");
        jp.add(helpButton);
        jp.setMaximumSize(jp.getPreferredSize());
        jp.setAlignmentX(0.0f);
        this.propertiesPanel.add(jp);
        jp.revalidate();
    }

    void mainPanel_stateChanged(ChangeEvent event) {
        JTabbedPane pane = (JTabbedPane)event.getSource();
        JPanel panel = (JPanel)pane.getSelectedComponent();
        if (panel != this.propertiesPanel && this.propertiesPanel.getComponentCount() == 2 && this.propertiesPanel.getComponent(1) instanceof RibConfigEditor) {
            RibConfigEditor rce = (RibConfigEditor)this.propertiesPanel.getComponent(1);
            String message = "The data model being edited in the Properties panel has not been saved.\nWould you like to save the data model at this time?";
            Object[] options = new String[]{"Yes", "No"};
            int i = JOptionPane.showOptionDialog(this.ribInterface, message, "Confirm", -1, 3, null, options, options[0]);
            if (i == 0) {
                pane.setSelectedComponent(this.propertiesPanel);
                rce.saveButton.doClick();
            }
        }
        if (panel == this.helpPanel) {
            if (this.helpPanel.getComponentCount() == 0) {
                this.initHelpPanel();
            }
        } else if (panel == this.objectsPanel) {
            if (this.objectsPanel.getComponentCount() == 0) {
                this.initObjectsPanel();
            }
        } else if (panel == this.catalogPanel) {
            this.initCatalogPanel();
        } else if (panel == this.interopPanel) {
            if (this.interopPanel.getComponentCount() == 0) {
                this.initInteropPanel();
            }
        } else if (panel == this.propertiesPanel && this.propertiesPanel.getComponentCount() == 0) {
            this.initPropertiesPanel();
        }
    }

    public void showAlert(String message) {
        SwingUtilities.invokeLater(new 35(message, this));
    }

    public void showInteropList() {
        this.interopPanel.removeAll();
        this.interopPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibInteropShell ris = new RibInteropShell(this.ribInterface, this.ribComm);
        this.interopPanel.add((Component)ris, "Center");
        ris.revalidate();
        this.interopPanel.revalidate();
        this.interopPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void showObjectsList() {
        this.objectsPanel.repaint();
        JPanel jp = (JPanel)this.objectsPanel.getComponent(0);
        JComboBox classBox = (JComboBox)jp.getComponent(1);
        String chosenClass = (String)classBox.getSelectedItem();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibObjectBrowser rob = new RibObjectBrowser(this.ribInterface, this.ribComm, chosenClass);
        this.objectsPanel.add((Component)rob, "Center");
        rob.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
    }

    public void showObjectsList(String chosenClass) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibObjectBrowser rob = new RibObjectBrowser(this.ribInterface, this.ribComm, chosenClass);
        this.objectsPanel.add((Component)rob, "Center");
        rob.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    class MyGlassPane
    extends JComponent {
        public MyGlassPane() {
            RibInterface.this = RibInterface.this;
            this.addMouseListener(new 1());
        }
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
            RibInterface.this = RibInterface.this;
        }

        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == RibInterface.this.mainPanel) {
                RibInterface.this.mainPanel_stateChanged(event);
            }
        }
    }

    private final class 2
    implements ActionListener {
        /* synthetic */ 2() {
        }

        public void actionPerformed(ActionEvent ae) {
            RibInterface.this.showObjectsList();
        }
    }

    private final class 3
    implements ActionListener {
        /* synthetic */ 3() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                URL url = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/catalog.pl?rh=" + RibInterface.this.repoHandle);
                RibInterface.this.getAppletContext().showDocument(url, "_blank");
            }
            catch (Exception e2) {
                RibInterface.this.showAlert(e2.toString());
            }
        }
    }

    private final class 4
    implements ActionListener {
        /* synthetic */ 4() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                URL url = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/join.pl?rh=" + RibInterface.this.repoHandle);
                RibInterface.this.getAppletContext().showDocument(url, "_blank");
            }
            catch (Exception e2) {
                RibInterface.this.showAlert(e2.toString());
            }
        }
    }

    private final class 5
    implements ActionListener {
        /* synthetic */ 5() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                URL url = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/search.pl?rh=" + RibInterface.this.repoHandle);
                RibInterface.this.getAppletContext().showDocument(url, "_blank");
            }
            catch (Exception e2) {
                RibInterface.this.showAlert(e2.toString());
            }
        }
    }

    private final class 6
    implements ActionListener {
        /* synthetic */ 6() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                URL url = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/advancedSearch.pl?rh=" + RibInterface.this.repoHandle);
                RibInterface.this.getAppletContext().showDocument(url, "_blank");
            }
            catch (Exception e2) {
                RibInterface.this.showAlert(e2.toString());
            }
        }
    }

    private final class 7
    implements ActionListener {
        /* synthetic */ 7() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                URL url = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/whatsNew.pl?rh=" + RibInterface.this.repoHandle);
                RibInterface.this.getAppletContext().showDocument(url, "_blank");
            }
            catch (Exception e2) {
                RibInterface.this.showAlert(e2.toString());
            }
        }
    }

    private static final class 8
    implements ActionListener {
        private final /* synthetic */ JButton val$viewButton;
        private final /* synthetic */ JPopupMenu val$jpm1;

        /* synthetic */ 8(JPopupMenu val$jpm1, JButton val$viewButton) {
            this.val$jpm1 = val$jpm1;
            this.val$viewButton = val$viewButton;
        }

        public void actionPerformed(ActionEvent ae) {
            this.val$jpm1.show(this.val$viewButton, 0, this.val$viewButton.getHeight());
        }
    }

    private static final class 9
    implements ActionListener {
        private final /* synthetic */ RibTemplateEditor val$templateEditor;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 9(RibTemplateEditor val$templateEditor, RibInterface this$0) {
            this.val$templateEditor = val$templateEditor;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.showStatus("Accessing network...");
            this.this$0.setCursor(this.this$0.waitCursor);
            this.val$templateEditor.loadURL(String.valueOf(this.this$0.repoUrl) + "/catalog_template.html");
            this.val$templateEditor.setLocationRelativeTo(this.this$0.ribInterface);
            this.val$templateEditor.show();
            this.this$0.showStatus("");
            this.this$0.setCursor(this.this$0.defaultCursor);
        }
    }

    private static final class 10
    implements ActionListener {
        private final /* synthetic */ RibTemplateEditor val$templateEditor;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 10(RibTemplateEditor val$templateEditor, RibInterface this$0) {
            this.val$templateEditor = val$templateEditor;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.showStatus("Accessing network...");
            this.this$0.setCursor(this.this$0.waitCursor);
            this.val$templateEditor.loadURL(String.valueOf(this.this$0.repoUrl) + "/join_template.html");
            this.val$templateEditor.show();
            this.this$0.showStatus("");
            this.this$0.setCursor(this.this$0.defaultCursor);
        }
    }

    private static final class 11
    implements ActionListener {
        private final /* synthetic */ RibTemplateEditor val$templateEditor;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 11(RibTemplateEditor val$templateEditor, RibInterface this$0) {
            this.val$templateEditor = val$templateEditor;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.showStatus("Accessing network...");
            this.this$0.setCursor(this.this$0.waitCursor);
            this.val$templateEditor.loadURL(String.valueOf(this.this$0.repoUrl) + "/search_template.html");
            this.val$templateEditor.show();
            this.this$0.showStatus("");
            this.this$0.setCursor(this.this$0.defaultCursor);
        }
    }

    private static final class 12
    implements ActionListener {
        private final /* synthetic */ RibTemplateEditor val$templateEditor;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 12(RibTemplateEditor val$templateEditor, RibInterface this$0) {
            this.val$templateEditor = val$templateEditor;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.showStatus("Accessing network...");
            this.this$0.setCursor(this.this$0.waitCursor);
            this.val$templateEditor.loadURL(String.valueOf(this.this$0.repoUrl) + "/advanced_search_template.html");
            this.val$templateEditor.show();
            this.this$0.showStatus("");
            this.this$0.setCursor(this.this$0.defaultCursor);
        }
    }

    private static final class 13
    implements ActionListener {
        private final /* synthetic */ RibTemplateEditor val$templateEditor;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 13(RibTemplateEditor val$templateEditor, RibInterface this$0) {
            this.val$templateEditor = val$templateEditor;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.showStatus("Accessing network...");
            this.this$0.setCursor(this.this$0.waitCursor);
            this.val$templateEditor.loadURL(String.valueOf(this.this$0.repoUrl) + "/whats_new_template.html");
            this.val$templateEditor.show();
            this.this$0.showStatus("");
            this.this$0.setCursor(this.this$0.defaultCursor);
        }
    }

    private static final class 14
    implements ActionListener {
        private final /* synthetic */ JButton val$templateButton;
        private final /* synthetic */ JPopupMenu val$jpm2;

        /* synthetic */ 14(JPopupMenu val$jpm2, JButton val$templateButton) {
            this.val$jpm2 = val$jpm2;
            this.val$templateButton = val$templateButton;
        }

        public void actionPerformed(ActionEvent ae) {
            this.val$jpm2.show(this.val$templateButton, 0, this.val$templateButton.getHeight());
        }
    }

    private static final class 15
    implements ActionListener {
        private final /* synthetic */ JPanel val$jp1;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JComboBox val$classChoice;
        private final /* synthetic */ JComboBox val$attrChoice;
        private final /* synthetic */ JButton val$attrCancel;
        private final /* synthetic */ JButton val$classCancel;
        private final /* synthetic */ JButton val$changePrimAttr;
        private final /* synthetic */ JButton val$changePrimClass;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 15(JButton val$attrCancel, JComboBox val$attrChoice, JButton val$changePrimAttr, JButton val$changePrimClass, JButton val$classCancel, JComboBox val$classChoice, JPanel val$jp1, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$attrCancel = val$attrCancel;
            this.val$attrChoice = val$attrChoice;
            this.val$changePrimAttr = val$changePrimAttr;
            this.val$changePrimClass = val$changePrimClass;
            this.val$classCancel = val$classCancel;
            this.val$classChoice = val$classChoice;
            this.val$jp1 = val$jp1;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            this.this$0.setCursor(this.this$0.waitCursor);
            this.this$0.showStatus("Accessing network...");
            SwingUtilities.invokeLater(new 16(this.val$changePrimClass));
            this.val$changePrimAttr.setEnabled(false);
            this.val$classCancel.setVisible(true);
            this.val$attrCancel.setVisible(false);
            this.val$attrChoice.setVisible(false);
            RibConfig rc = new RibConfig(this.this$0.configUrl);
            rc.parse();
            if (this.val$classChoice.getItemCount() > 0) {
                this.val$classChoice.removeAllItems();
            }
            Enumeration en = rc.getClassNames(false).elements();
            while (en.hasMoreElements()) {
                String tmp2 = (String)en.nextElement();
                if (tmp2.equals(this.val$rci.getPrimaryClass())) continue;
                this.val$classChoice.addItem(tmp2);
            }
            if (this.val$classChoice.getItemCount() == 0) {
                this.this$0.showAlert(String.valueOf(this.val$rci.getPrimaryClass()) + " is the only class in this repository's data model");
            } else {
                this.val$classChoice.insertItemAt("--Choose a new primary class--", 0);
                this.val$classChoice.setSelectedIndex(0);
                this.val$classChoice.setVisible(true);
                this.val$classChoice.revalidate();
            }
            this.val$jp1.setMaximumSize(this.val$jp1.getPreferredSize());
            this.this$0.setCursor(this.this$0.defaultCursor);
            this.this$0.showStatus("");
        }
    }

    private static final class 17
    implements ActionListener {
        private final /* synthetic */ JComboBox val$classChoice;
        private final /* synthetic */ JButton val$changePrimAttr;
        private final /* synthetic */ JButton val$changePrimClass;
        private final /* synthetic */ JButton val$classCancel;

        /* synthetic */ 17(JButton val$changePrimAttr, JButton val$changePrimClass, JButton val$classCancel, JComboBox val$classChoice) {
            this.val$changePrimAttr = val$changePrimAttr;
            this.val$changePrimClass = val$changePrimClass;
            this.val$classCancel = val$classCancel;
            this.val$classChoice = val$classChoice;
        }

        public void actionPerformed(ActionEvent ae) {
            this.val$classCancel.setVisible(false);
            this.val$changePrimClass.setEnabled(true);
            this.val$changePrimAttr.setEnabled(true);
            this.val$classChoice.setVisible(false);
        }
    }

    private static final class 18
    implements ActionListener {
        private final /* synthetic */ JPanel val$jp2;
        private final /* synthetic */ JLabel val$jl2;
        private final /* synthetic */ JPanel val$jp1;
        private final /* synthetic */ JLabel val$jl1;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JButton val$classCancel;
        private final /* synthetic */ JButton val$changePrimAttr;
        private final /* synthetic */ JButton val$changePrimClass;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 18(JButton val$changePrimAttr, JButton val$changePrimClass, JButton val$classCancel, JLabel val$jl1, JLabel val$jl2, JPanel val$jp1, JPanel val$jp2, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$changePrimAttr = val$changePrimAttr;
            this.val$changePrimClass = val$changePrimClass;
            this.val$classCancel = val$classCancel;
            this.val$jl1 = val$jl1;
            this.val$jl2 = val$jl2;
            this.val$jp1 = val$jp1;
            this.val$jp2 = val$jp2;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            JComboBox jcb = (JComboBox)ae.getSource();
            if (jcb.getSelectedIndex() == 0) {
                return;
            }
            if (jcb.getItemCount() == 0) {
                return;
            }
            String message = "Making this change will cause the catalog to show objects of\nthe chosen class. Side effects of this change are that the primary\nattribute is set to null and any objects currently appearing in the\ncatalog as a result of interoperation will be removed. If the\nrepositories being interoperated with contain objects of the chosen\nclass then those objects will appear in the catalog on the next\ninteroperation update. Proceed with this change?";
            Object[] options = new Object[]{"Yes", "No"};
            int i = JOptionPane.showOptionDialog(this.this$0.ribInterface, message, "Confirm new primary class", -1, 3, null, options, options[0]);
            if (i == 0) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network...");
                this.val$changePrimClass.setEnabled(true);
                this.val$changePrimAttr.setEnabled(true);
                this.val$classCancel.setVisible(false);
                jcb.setVisible(false);
                String newClass = (String)jcb.getSelectedItem();
                String response = this.this$0.ribComm.changePrimClass(newClass, "");
                if (response.equals("ok")) {
                    this.val$rci.setPrimaryClass(newClass);
                    JPanel tmpPanel = (JPanel)this.this$0.catalogPanel.getComponent(7);
                    tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
                    this.val$jl1.setText("Primary class is " + this.val$rci.getPrimaryClass());
                    this.val$jp1.setMaximumSize(this.val$jp1.getPreferredSize());
                    this.val$jl1.revalidate();
                    this.val$rci.setPrimaryAttribute(null);
                    this.val$jl2.setText("Primary attribute is null");
                    this.val$jp2.setMaximumSize(this.val$jp2.getPreferredSize());
                    this.val$jl2.revalidate();
                } else {
                    this.this$0.showAlert(response);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            } else if (i == 1) {
                this.val$changePrimClass.setEnabled(true);
                this.val$changePrimAttr.setEnabled(true);
                this.val$classCancel.setVisible(false);
                jcb.setVisible(false);
            }
        }
    }

    private static final class 19
    implements ActionListener {
        private final /* synthetic */ JPanel val$jp2;
        private final /* synthetic */ JButton val$attrCancel;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JComboBox val$attrChoice;
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ JButton val$changePrimAttr;

        /* synthetic */ 19(JButton val$attrCancel, JComboBox val$attrChoice, JButton val$changePrimAttr, JPanel val$jp2, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$attrCancel = val$attrCancel;
            this.val$attrChoice = val$attrChoice;
            this.val$changePrimAttr = val$changePrimAttr;
            this.val$jp2 = val$jp2;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            SwingUtilities.invokeLater(new 20(this.val$changePrimAttr));
            this.this$0.setCursor(this.this$0.waitCursor);
            this.this$0.showStatus("Accessing network...");
            RibConfig rc = new RibConfig(this.this$0.configUrl);
            rc.parse();
            if (this.val$attrChoice.getItemCount() > 0) {
                this.val$attrChoice.removeAllItems();
            }
            RibClass ribClass = rc.getClass(this.val$rci.getPrimaryClass());
            Enumeration en = ribClass.getAttributes().elements();
            while (en.hasMoreElements()) {
                RibAttribute ra = (RibAttribute)en.nextElement();
                String name = ra.getName();
                if (name.equals(this.val$rci.getPrimaryAttribute()) || !ra.hasVocabulary()) continue;
                this.val$attrChoice.addItem(name);
            }
            if (this.val$attrChoice.getItemCount() == 0) {
                if (this.val$rci.getPrimaryAttribute() == null) {
                    this.this$0.showAlert(String.valueOf(this.val$rci.getPrimaryClass()) + " does not contain an attribute with a vocabulary");
                } else {
                    this.this$0.showAlert("The primary attribute must contain a vocabulary. " + this.val$rci.getPrimaryClass() + " does\nnot contain an attribute with a vocabulary other than " + this.val$rci.getPrimaryAttribute());
                }
            } else {
                this.val$attrChoice.insertItemAt("--Choose a new primary attribute--", 0);
                this.val$attrChoice.setSelectedIndex(0);
                this.val$attrCancel.setVisible(true);
                this.val$attrChoice.setVisible(true);
                this.val$attrChoice.revalidate();
            }
            this.val$jp2.setMaximumSize(this.val$jp2.getPreferredSize());
            this.this$0.setCursor(this.this$0.defaultCursor);
            this.this$0.showStatus("");
        }
    }

    private static final class 21
    implements ActionListener {
        private final /* synthetic */ JComboBox val$attrChoice;
        private final /* synthetic */ JButton val$changePrimAttr;
        private final /* synthetic */ JButton val$attrCancel;

        /* synthetic */ 21(JButton val$attrCancel, JComboBox val$attrChoice, JButton val$changePrimAttr) {
            this.val$attrCancel = val$attrCancel;
            this.val$attrChoice = val$attrChoice;
            this.val$changePrimAttr = val$changePrimAttr;
        }

        public void actionPerformed(ActionEvent ae) {
            this.val$attrCancel.setVisible(false);
            this.val$changePrimAttr.setEnabled(true);
            this.val$attrChoice.setVisible(false);
        }
    }

    private static final class 22
    implements ActionListener {
        private final /* synthetic */ JPanel val$jp2;
        private final /* synthetic */ JLabel val$jl2;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JButton val$changePrimAttr;
        private final /* synthetic */ JButton val$attrCancel;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 22(JButton val$attrCancel, JButton val$changePrimAttr, JLabel val$jl2, JPanel val$jp2, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$attrCancel = val$attrCancel;
            this.val$changePrimAttr = val$changePrimAttr;
            this.val$jl2 = val$jl2;
            this.val$jp2 = val$jp2;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            JComboBox jcb = (JComboBox)ae.getSource();
            if (jcb.getSelectedIndex() == 0) {
                return;
            }
            if (jcb.getItemCount() == 0) {
                return;
            }
            String message = "Making this change will cause the catalog to be sorted by\nthe chosen attribute. A side effect of making this change is\nthat any objects currently appearing in the catalog as a result\nof interoperation will be temporarily removed until the next\ninteroperation update. Proceed with this change?";
            Object[] options = new Object[]{"Yes", "No"};
            int i = JOptionPane.showOptionDialog(this.this$0.ribInterface, message, "Confirm new primary attribute", -1, 3, null, options, options[0]);
            if (i == 0) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network...");
                this.val$attrCancel.setVisible(false);
                this.val$changePrimAttr.setEnabled(true);
                jcb.setVisible(false);
                String newAttr = (String)jcb.getSelectedItem();
                String response = this.this$0.ribComm.changePrimClass(this.val$rci.getPrimaryClass(), newAttr);
                if (response.equals("ok")) {
                    this.val$rci.setPrimaryAttribute(newAttr);
                    this.val$jl2.setText("Primary attribute is " + this.val$rci.getPrimaryAttribute());
                    this.val$jp2.setMaximumSize(this.val$jp2.getPreferredSize());
                    this.val$jp2.revalidate();
                } else {
                    this.this$0.showAlert(response);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            } else if (i == 1) {
                this.val$changePrimAttr.setEnabled(true);
                this.val$attrCancel.setVisible(false);
                jcb.setVisible(false);
            }
        }
    }

    private static final class 23
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$no1;

        /* synthetic */ 23(JRadioButton val$no1, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$no1 = val$no1;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$no1.isSelected() && !this.val$rci.isObjectApprovalRequired()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network...");
                String response = this.this$0.ribComm.objectApprovalRequired(true);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$no1.setSelected(true);
                } else {
                    this.val$rci.setObjectApprovalRequired(true);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            }
        }
    }

    private static final class 24
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$yes1;

        /* synthetic */ 24(RibCatalogInfo val$rci, RibInterface this$0, JRadioButton val$yes1) {
            this.val$rci = val$rci;
            this.this$0 = this$0;
            this.val$yes1 = val$yes1;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$yes1.isSelected() && this.val$rci.isObjectApprovalRequired()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network");
                String response = this.this$0.ribComm.objectApprovalRequired(false);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$yes1.setSelected(true);
                } else {
                    this.val$rci.setObjectApprovalRequired(false);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            }
        }
    }

    private static final class 25
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$no2;

        /* synthetic */ 25(JRadioButton val$no2, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$no2 = val$no2;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$no2.isSelected() && !this.val$rci.isJoinEnabled()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network");
                String response = this.this$0.ribComm.enableJoin(true);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$no2.setSelected(true);
                } else {
                    this.val$rci.setJoinEnabled(true);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            }
        }
    }

    private static final class 26
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$yes2;

        /* synthetic */ 26(RibCatalogInfo val$rci, RibInterface this$0, JRadioButton val$yes2) {
            this.val$rci = val$rci;
            this.this$0 = this$0;
            this.val$yes2 = val$yes2;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$yes2.isSelected() && this.val$rci.isJoinEnabled()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network");
                String response = this.this$0.ribComm.enableJoin(false);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$yes2.setSelected(true);
                } else {
                    this.val$rci.setJoinEnabled(false);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            }
        }
    }

    private static final class 27
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$no3;

        /* synthetic */ 27(JRadioButton val$no3, RibCatalogInfo val$rci, RibInterface this$0) {
            this.val$no3 = val$no3;
            this.val$rci = val$rci;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$no3.isSelected() && !this.val$rci.isWhatsNewEnabled()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network");
                String response = this.this$0.ribComm.enableWhatsNew(true);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$no3.setSelected(true);
                } else {
                    this.val$rci.setWhatsNewEnabled(true);
                }
                this.this$0.showStatus("");
                this.this$0.setCursor(this.this$0.defaultCursor);
            }
        }
    }

    private static final class 28
    implements ActionListener {
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ RibCatalogInfo val$rci;
        private final /* synthetic */ JRadioButton val$yes3;

        /* synthetic */ 28(RibCatalogInfo val$rci, RibInterface this$0, JRadioButton val$yes3) {
            this.val$rci = val$rci;
            this.this$0 = this$0;
            this.val$yes3 = val$yes3;
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.val$yes3.isSelected() && this.val$rci.isWhatsNewEnabled()) {
                this.this$0.setCursor(this.this$0.waitCursor);
                this.this$0.showStatus("Accessing network");
                String response = this.this$0.ribComm.enableWhatsNew(false);
                if (!response.equals("ok")) {
                    this.this$0.showAlert(response);
                    this.val$yes3.setSelected(true);
                } else {
                    this.val$rci.setWhatsNewEnabled(false);
                }
                this.this$0.setCursor(this.this$0.defaultCursor);
                this.this$0.showStatus("");
            }
        }
    }

    class PropertiesActionChosen
    implements ActionListener {
        PropertiesActionChosen() {
            RibInterface.this = RibInterface.this;
        }

        public void actionPerformed(ActionEvent e) {
            int i = RibInterface.this.propertiesPanel.getComponentCount() - 1;
            while (i > 0) {
                RibInterface.this.propertiesPanel.remove(i);
                --i;
            }
            RibInterface.this.propertiesPanel.repaint();
            JComboBox jcb = (JComboBox)e.getSource();
            String action = (String)jcb.getSelectedItem();
            if (action.equals("Data Model Editor")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network");
                RibConfig config = new RibConfig(RibInterface.this.configUrl);
                config.parse();
                if (config.getClassNames(false).size() == 0) {
                    JPanel jp = new JPanel(new GridLayout());
                    JLabel label = new JLabel("Error: Cannot parse data model. " + config.errorMsg);
                    jp.add(label);
                    RibInterface.this.propertiesPanel.add(jp);
                    label.revalidate();
                } else {
                    RibConfigEditor rce = new RibConfigEditor(config, RibInterface.this.ribComm, RibInterface.this.ribInterface);
                    rce.setAlignmentX(0.0f);
                    RibInterface.this.propertiesPanel.add(rce);
                    rce.revalidate();
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
            } else if (action.equals("Change Name")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network...");
                RibCatalogInfo tmp2 = null;
                try {
                    tmp2 = RibInterface.this.ribComm.getCatalogInfo();
                }
                catch (Exception e2) {
                    RibInterface.this.showAlert(e2.toString());
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
                if (tmp2 == null) {
                    return;
                }
                RibCatalogInfo rci = tmp2;
                JPanel p = new JPanel(new FlowLayout(0));
                JLabel l = new JLabel("New Name :");
                p.add(l);
                p.add(Box.createHorizontalStrut(5));
                JTextField jtf = new JTextField(rci.getName(), 30);
                jtf.setBorder(new BevelBorder(1));
                p.add(jtf);
                p.setAlignmentX(0.0f);
                p.setMaximumSize(p.getPreferredSize());
                RibInterface.this.propertiesPanel.add(p);
                p.revalidate();
                JPanel p2 = new JPanel(new FlowLayout(0, 3, 3));
                JButton jb = new JButton("  Submit  ");
                jb.addActionListener(new 29(jtf, this));
                jb.setEnabled(false);
                jb.addMouseListener(new ButtonPushMouseListener(jb));
                p2.add(jb);
                JButton jb2 = new JButton("  Cancel  ");
                jb2.addActionListener(new 30(this));
                jb2.addMouseListener(new ButtonPushMouseListener(jb2));
                p2.add(jb2);
                p2.setMaximumSize(p2.getPreferredSize());
                p2.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(p2);
                jtf.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jb));
                jtf.requestFocus();
            } else if (action.equals("Change Contact")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network...");
                RibCatalogInfo tmp2 = null;
                try {
                    tmp2 = RibInterface.this.ribComm.getCatalogInfo();
                }
                catch (Exception e2) {
                    RibInterface.this.showAlert(e2.toString());
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
                if (tmp2 == null) {
                    return;
                }
                RibCatalogInfo rci = tmp2;
                JPanel p = new JPanel(new FlowLayout(0));
                JLabel l = new JLabel("New Contact Address :");
                p.add(l);
                p.add(Box.createHorizontalStrut(5));
                JTextField jtf = new JTextField(rci.getContact(), 30);
                JButton jb = new JButton("  Submit  ");
                jtf.setBorder(new BevelBorder(1));
                p.add(jtf);
                p.setAlignmentX(0.0f);
                p.setMaximumSize(p.getPreferredSize());
                RibInterface.this.propertiesPanel.add(p);
                p.revalidate();
                JPanel p2 = new JPanel(new FlowLayout(0, 5, 5));
                jb.addActionListener(new 31(jtf, this));
                jb.setEnabled(false);
                jb.addMouseListener(new ButtonPushMouseListener(jb));
                p2.add(jb);
                JButton jb2 = new JButton("  Cancel  ");
                jb2.addActionListener(new 32(this));
                jb2.addMouseListener(new ButtonPushMouseListener(jb2));
                p2.add(jb2);
                p2.setMaximumSize(p2.getPreferredSize());
                p2.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(p2);
                jtf.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jb));
                jtf.requestFocus();
            } else if (action.equals("Change Password")) {
                JPanel p = new JPanel(new FlowLayout(0));
                JLabel l = new JLabel("New Password :");
                p.add(l);
                p.add(Box.createHorizontalStrut(5));
                JTextField jtf = new JTextField(30);
                jtf.setBorder(new BevelBorder(1));
                p.add(jtf);
                p.setAlignmentX(0.0f);
                p.setMaximumSize(p.getPreferredSize());
                RibInterface.this.propertiesPanel.add(p);
                p.revalidate();
                JPanel p2 = new JPanel(new FlowLayout(0, 5, 5));
                JButton jb = new JButton("  Submit  ");
                jb.addActionListener(new 33(jtf, this));
                jb.setEnabled(false);
                jb.addMouseListener(new ButtonPushMouseListener(jb));
                p2.add(jb);
                JButton jb2 = new JButton("  Cancel  ");
                jb2.addActionListener(new 34(this));
                jb2.addMouseListener(new ButtonPushMouseListener(jb2));
                p2.add(jb2);
                p2.setMaximumSize(p2.getPreferredSize());
                p2.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(p2);
                jtf.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jb));
                jtf.requestFocus();
            }
        }

        static /* synthetic */ RibInterface access$0(PropertiesActionChosen $0) {
            return $0.RibInterface.this;
        }
    }

    class EnsureNonemptyDocumentListener
    implements DocumentListener {
        JButton button;

        EnsureNonemptyDocumentListener(JButton b) {
            RibInterface.this = RibInterface.this;
            this.button = b;
        }

        public void changedUpdate(DocumentEvent de) {
            if (de.getDocument().getLength() == 0) {
                this.button.setEnabled(false);
            } else if (de.getDocument().getLength() > 0) {
                this.button.setEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent de) {
            this.changedUpdate(de);
        }

        public void removeUpdate(DocumentEvent de) {
            this.changedUpdate(de);
        }
    }

    private static final class 35
    extends Thread {
        private final /* synthetic */ String val$message;
        private final /* synthetic */ RibInterface this$0;

        /* synthetic */ 35(String val$message, RibInterface this$0) {
            this.val$message = val$message;
            this.this$0 = this$0;
        }

        public void run() {
            JOptionPane.showMessageDialog(this.this$0.ribInterface, this.val$message, "Alert", 0);
        }
    }

    private static final class 36
    implements ActionListener {
        private final /* synthetic */ String[] val$handles;
        private final /* synthetic */ RibInterface this$0;
        private final /* synthetic */ JComboBox val$jcb;
        private final /* synthetic */ JPanel val$jp1;

        /* synthetic */ 36(String[] val$handles, JComboBox val$jcb, JPanel val$jp1, RibInterface this$0) {
            this.val$handles = val$handles;
            this.val$jcb = val$jcb;
            this.val$jp1 = val$jp1;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            JLabel jl2;
            JPanel jp4;
            int i = this.val$jp1.getComponentCount() - 1;
            while (i > 0) {
                this.val$jp1.remove(i);
                --i;
            }
            String selection = (String)this.val$jcb.getSelectedItem();
            JPanel jp3 = new JPanel();
            jp3.setLayout(new BoxLayout(jp3, 1));
            JTextField urlTextField = new JTextField(40);
            JTextField nameTextField = new JTextField(40);
            JButton submitButton = new JButton("  Submit  ");
            submitButton.setEnabled(false);
            urlTextField.getDocument().addDocumentListener(this.this$0.new EnsureNonemptyDocumentListener(submitButton));
            if (selection.equals("Local repository")) {
                this.this$0.showStatus("Accessing network...");
                this.this$0.setCursor(this.this$0.waitCursor);
                NodeList nl = null;
                try {
                    nl = this.this$0.ribComm.listRepositories();
                }
                catch (Exception e) {
                    this.this$0.showAlert(e.toString());
                }
                RibCatalogInfo rci = null;
                try {
                    rci = this.this$0.ribComm.getCatalogInfo();
                }
                catch (Exception e) {
                    this.this$0.showAlert(e.toString());
                }
                this.this$0.showStatus("");
                this.this$0.setCursor(this.this$0.defaultCursor);
                if (rci == null) {
                    return;
                }
                if (nl == null) {
                    return;
                }
                Vector<String> repoNameList = new Vector<String>(nl.getLength());
                Hashtable<String, String> repoHandles = new Hashtable<String, String>();
                int i2 = 0;
                while (i2 < nl.getLength()) {
                    String interopHandle;
                    Element element = (Element)nl.item(i2);
                    String name = element.getAttribute("name");
                    if (name != null && (interopHandle = element.getAttribute("interop_handle")) != null && !name.equals(rci.getName())) {
                        repoNameList.addElement(name);
                        repoHandles.put(name, interopHandle);
                    }
                    ++i2;
                }
                if (repoNameList.size() == 0) {
                    this.this$0.showAlert("There are no local repositories available for interoperation.");
                    this.this$0.createInterop(this.val$handles);
                    return;
                }
                JPanel jp42 = new JPanel(new FlowLayout(0));
                JLabel jl22 = new JLabel("Repository name :   ");
                jp42.add(jl22);
                JComboBox jcb2 = new JComboBox(repoNameList);
                jcb2.setSelectedIndex(-1);
                jcb2.setBackground(Color.white);
                jcb2.addActionListener(new 37(jcb2, nameTextField, repoHandles, urlTextField));
                jp42.add(jcb2);
                jp42.setMaximumSize(jp42.getPreferredSize());
                jp42.setAlignmentX(0.0f);
                jp3.add(jp42);
            } else if (selection.equals("Remote repository")) {
                jp4 = new JPanel(new FlowLayout(0));
                jl2 = new JLabel("Interoperation handle :   ");
                jp4.add(jl2);
                urlTextField.setCursor(Cursor.getPredefinedCursor(2));
                jp4.add(urlTextField);
                jp4.setAlignmentX(0.0f);
                jp4.setMaximumSize(jp4.getPreferredSize());
                jp3.add(jp4);
                JPanel jp5 = new JPanel(new FlowLayout(0));
                JLabel jl3 = new JLabel("Repository name :   ");
                jp5.add(jl3);
                nameTextField.setCursor(Cursor.getPredefinedCursor(2));
                jp5.add(nameTextField);
                jp5.setAlignmentX(0.0f);
                jp5.setMaximumSize(jp5.getPreferredSize());
                jp3.add(jp5);
            }
            jp4 = new JPanel(new FlowLayout(0));
            jl2 = new JLabel("Update interval :   ");
            jp4.add(jl2);
            JComboBox<String> jcb2 = new JComboBox<String>(RibUtil.getSortedInteropIntervals());
            jcb2.setSelectedIndex(5);
            jcb2.setBackground(Color.white);
            jp4.add(jcb2);
            submitButton.addMouseListener(new ButtonPushMouseListener(submitButton));
            jp4.add(submitButton);
            submitButton.addActionListener(new 38(this.val$handles, jcb2, nameTextField, this.this$0, urlTextField));
            jp4.setMaximumSize(jp4.getPreferredSize());
            jp4.setAlignmentX(0.0f);
            jp3.add(jp4);
            jp3.setMaximumSize(jp3.getPreferredSize());
            jp3.setAlignmentX(0.0f);
            this.val$jp1.add(jp3);
            jp3.revalidate();
            urlTextField.requestFocus();
        }
    }

    private final class 39
    implements ActionListener {
        /* synthetic */ 39() {
        }

        public void actionPerformed(ActionEvent ae) {
            RibInterface.this.showInteropList();
        }
    }
}

