/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nhse.rib.RibInterface;

public class RibHelpPane
extends JPanel {
    DefaultMutableTreeNode top;
    JTree docTree;
    JEditorPane htmlDisplay = new JEditorPane();
    RibInterface ribInterface;
    String separator = "^";

    RibHelpPane(RibInterface ri) {
        this.ribInterface = ri;
        this.top = new DefaultMutableTreeNode(new helpInfo("Welcome!", "welcome.html"));
        this.docTree = new JTree(this.top);
        this.setLayout(new BorderLayout());
        this.htmlDisplay.setEditable(false);
        this.htmlDisplay.setCursor(Cursor.getPredefinedCursor(2));
        this.addHelpNode("Manage Objects", "manage_objects.html");
        this.addHelpNode("Manage Catalog", "manage_catalog.html");
        this.addHelpNode("Interoperation", "interoperation.html");
        this.addHelpNode("Repository Properties", "repo_properties.html");
        this.addHelpNode("Errata", "errata.html");
        String s = "Manage Objects" + this.separator;
        this.addHelpNode(String.valueOf(s) + "Object Browser", "object_browser.html");
        this.addHelpNode(String.valueOf(s) + "Object Editor", "object_editor.html");
        s = String.valueOf(s) + "Object Browser" + this.separator;
        this.addHelpNode(String.valueOf(s) + "Creating Objects", "object_browser_create.html");
        this.addHelpNode(String.valueOf(s) + "Importing Objects", "object_browser_import.html");
        this.addHelpNode(String.valueOf(s) + "Editing Objects", "object_browser_edit.html");
        this.addHelpNode(String.valueOf(s) + "Deleting Objects", "object_browser_delete.html");
        this.addHelpNode(String.valueOf(s) + "Viewing Objects", "object_browser_view.html");
        this.addHelpNode(String.valueOf(s) + "Object Status", "object_browser_status.html");
        s = "Manage Catalog" + this.separator;
        this.addHelpNode(String.valueOf(s) + "View", "catalog_view.html");
        this.addHelpNode(String.valueOf(s) + "Templates", "catalog_templates.html");
        this.addHelpNode(String.valueOf(s) + "Primary Class", "catalog_primary_class.html");
        this.addHelpNode(String.valueOf(s) + "Primary Attribute", "catalog_primary_attribute.html");
        this.addHelpNode(String.valueOf(s) + "Object Approval", "catalog_object_approval.html");
        this.addHelpNode(String.valueOf(s) + "Joins", "catalog_joins.html");
        this.addHelpNode(String.valueOf(s) + "\"What's New?\"", "catalog_whats_new.html");
        s = "Interoperation" + this.separator;
        this.addHelpNode(String.valueOf(s) + "Creating Interoperations", "interop_create.html");
        this.addHelpNode(String.valueOf(s) + "Listing Objects", "interop_list.html");
        this.addHelpNode(String.valueOf(s) + "Interoperation Logs", "interop_log.html");
        this.addHelpNode(String.valueOf(s) + "Starting Updates", "interop_update.html");
        this.addHelpNode(String.valueOf(s) + "Deleting Interoperations", "interop_delete.html");
        this.addHelpNode(String.valueOf(s) + "Setting Update Intervals", "interop_intervals.html");
        s = "Repository Properties" + this.separator;
        this.addHelpNode(String.valueOf(s) + "Data Model Editor", "properties_data_model_editor.html");
        this.addHelpNode(String.valueOf(s) + "Repository Name", "properties_name.html");
        this.addHelpNode(String.valueOf(s) + "Repository Contact", "properties_contact.html");
        this.addHelpNode(String.valueOf(s) + "Repository Password", "properties_password.html");
        this.docTree.addTreeSelectionListener(new 1());
        this.docTree.setShowsRootHandles(false);
        this.docTree.expandRow(0);
        JScrollPane treeScrollPane = new JScrollPane(this.docTree);
        treeScrollPane.setViewportBorder(new EtchedBorder());
        this.setBorder(new EtchedBorder());
        this.add((Component)treeScrollPane, "West");
        JScrollPane htmlScrollPane = new JScrollPane(this.htmlDisplay);
        this.add((Component)htmlScrollPane, "Center");
        SwingUtilities.invokeLater(new 2());
    }

    public void addHelpNode(String name, String url) {
        if (name.indexOf(this.separator) == -1) {
            this.top.add(new DefaultMutableTreeNode(new helpInfo(name, url)));
        } else {
            String prefix = name.substring(0, name.lastIndexOf(this.separator));
            Enumeration<TreeNode> e = this.top.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)e.nextElement();
                helpInfo h = (helpInfo)tn.getUserObject();
                if (!h.name.equals(prefix)) continue;
                tn.add(new DefaultMutableTreeNode(new helpInfo(name, url)));
                break;
            }
        }
    }

    private void displayURL(String loc) {
        try {
            this.htmlDisplay.setPage(loc);
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
        }
    }

    public void gotoURL(String url) {
        boolean found = false;
        Enumeration<TreeNode> sibling = this.top.breadthFirstEnumeration();
        while (sibling.hasMoreElements() && !found) {
            DefaultMutableTreeNode t = (DefaultMutableTreeNode)sibling.nextElement();
            helpInfo h = (helpInfo)t.getUserObject();
            if (!url.equalsIgnoreCase(h.helpURL.toString())) continue;
            Object[] pathToHere = t.getPath();
            TreePath path = new TreePath(pathToHere);
            this.docTree.setSelectionPath(path);
            this.displayURL(h.helpURL);
            found = true;
        }
    }

    private final class 1
    implements TreeSelectionListener {
        /* synthetic */ 1() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            RibHelpPane.this.ribInterface.showStatus("Accessing network...");
            RibHelpPane.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)RibHelpPane.this.docTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            helpInfo help = (helpInfo)nodeInfo;
            try {
                RibHelpPane.this.displayURL(help.helpURL);
            }
            catch (Exception exception) {}
            RibHelpPane.this.ribInterface.showStatus("");
            RibHelpPane.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private final class 2
    extends Thread {
        /* synthetic */ 2() {
        }

        public void run() {
            RibHelpPane.this.docTree.addSelectionRow(0);
        }
    }

    private class helpInfo {
        public String name;
        public String helpURL;

        public helpInfo(String hName, String filename) {
            RibHelpPane.this = RibHelpPane.this;
            this.name = hName;
            this.helpURL = String.valueOf(RibHelpPane.this.ribInterface.ribUrl) + "/doc/" + filename;
        }

        public String toString() {
            return this.name.substring(this.name.lastIndexOf(RibHelpPane.this.separator) + 1);
        }
    }
}

