#include <stdio.h>
#include <string.h>
#include "ab-post.h"
#include <sys/time.h>

#define MAXEVENTS 2000
#define MAXWORDSIZE 35
#define MAXSUCC 25
#define MAXPRED 25
#define MAXPROC 50
#define MAXPEND 50
#define NONE (-1)


/* The routines in this file should construct the dag, given
*  an array of event structures that has been read in.
*/

/* The structure that will hold an event.  
   Assumptions:
   * Component & machine names are of size <= MAXWORDSIZE
   * Depending on the event type, some fields may be missing. 
*/

/* Revision 1.0: 1993/07/24 swee
 * Added stuff needed by barrier call
*/
typedef int bool;

struct event {
  long event_sec;
  long event_usec;
  int event_type;
  char event_comp[MAXWORDSIZE];  
  int event_pid;
  int event_rc;
  char dest_comp[MAXWORDSIZE];
  char dest_mach[MAXWORDSIZE];
  int dest_pid;
  int msg_type;
  int msg_length;
  int msg_serial;
  int msg_count;
  long abmon_sec;
  long abmon_usec;
  int numsucc;
  int succ[MAXSUCC];
  int numpred;
  int pred[MAXPRED];
  int data; /* used by xab-post routines */
  char name[MAXWORDSIZE];  /* used by barrier */
  int number;
};

extern struct event *read_trf();
extern int make_dag();
extern void dag_test();





/* In any PVM program, there must be a "first" event, the master
*  program's enrolling.  This routine finds it.
*/

int find_first_event(ev)
struct event *ev;
{
  int i=0;

  while ((ev[i].event_type != XAB_enroll) || (ev[i].numpred != 1) ||
	 (ev[i].pred[0] != NONE))
    i++;

  return(i);
}


/* pop an element from a stack.  position is assumed to point to the
*  highest valid value in the stack; if position=size it is an error.
*/

int pop(stack,position,size)
int *stack;
int *position;
int size;
{
  if ((*position)==size) 
    printf("Stack pop error. \n");
  else
    return(stack[(*position)++]);
}


/* push an element onto a stack.
*/

push(stack,position,element)
int *stack;
int *position;
int element;
{
  if ((*position)==0)
    printf("Stack push error. \n");
  else
    stack[--(*position)]=element;
}

print_stack(stack,position,size)
int *stack;
int position;
int size;
{
  int i;
  printf("------------------\n");
  for (i=position;i<size;i++) {
    printf("%d.",stack[i]);
    if (((i-position) % 15)==14) printf("\n");
  }
}




/* Find the next dag child of an event record whose "data"
*  field is NONE.
*/

int next_none_child(ev,index)
struct event *ev;
int index;
{
  int nnc;

  nnc=0;

  while ((nnc<ev[index].numsucc) && ((ev[index].succ[nnc] == NONE) ||
	 (ev[ev[index].succ[nnc]].data != NONE)))
    nnc++;
  
  if (nnc==ev[index].numsucc)
    return(NONE);
  else
    return(ev[index].succ[nnc]);
}


/* Create an array which stores a topological ordering of the
*  events in the event array ev.
*/

top_order(ev,order,size)
struct event *ev;
int *order;
int size;
{
  int current,first,i,s;
  int orderpos,stackpos,stack[MAXEVENTS];

  for (i=0;i<size;i++)
    ev[i].data=NONE;
  first=find_first_event(ev);
  orderpos=size;
  stackpos=(size-1);
  stack[stackpos]=first;
  ev[first].data=1;

  /* do a DFS of the event dag.  As each node is finished,
  *  add it to the head of the ordering.  (As per CLR 
  *  topological sort algorithm, p.486.)
  */ 

  while (stackpos<size) {
    current=pop(stack,&stackpos,size);
    s=next_none_child(ev,current);
    if (s==NONE)
      push(order,&orderpos,current);
    else {
      push(stack,&stackpos,current);
      push(stack,&stackpos,s);
      ev[s].data=1;
    }
  }
}



/* Correct_time makes sure a node's time is greater than the
*  maximum time of its predecessors.
*/

correct_time(ev,index)
struct event *ev;
int index;
{
  struct timeval m;
  int i,c;

  m.tv_sec=ev[index].event_sec;
  m.tv_usec=ev[index].event_usec;

  for (i=0;i<ev[index].numpred;i++) {
    c=ev[index].pred[i];
    if ((c!=NONE) && ((ev[c].event_sec > m.tv_sec) ||
	((ev[c].event_sec == m.tv_sec) && (ev[c].event_usec > m.tv_usec)))) {
      m.tv_sec=ev[c].event_sec;
      m.tv_usec=ev[c].event_usec;
    }
  }

  if ((m.tv_sec != ev[index].event_sec) || 
      (m.tv_usec != ev[index].event_usec)) {
    ev[index].event_sec=m.tv_sec;
    ev[index].event_usec=m.tv_usec+1;
    if (ev[index].event_usec == 1000000) {
      ev[index].event_sec++;
      ev[index].event_usec=0;
    }
  }
}





/* This routine corrects the times to follow an ordering consistent
*  with Lamport's logical time:
*/

correct_time_list(ev,order,size)
struct event *ev;
int *order;
int size;
{
  int i,j;

  for (i=0;i<size;i++) 
    correct_time(ev,order[i]);
}



/* Comparison routine for use by qsort function:  
*/

int compare_for_qsort(p,q)
struct event *p;
struct event *q;
{
  if (((p->event_sec) > (q->event_sec)) ||
      (((p->event_sec)==(q->event_sec)) && ((p->event_usec)>(q->event_usec))))
    return(1);
  else return(-1);
}



main(argc,argv)
int argc;
char **argv;
{
  struct event *event_list;
  int i,s;
  int order[MAXEVENTS];

  if (argc>0)
    event_list=read_trf(argv[1]);
  else
    event_list=read_trf((char *) 0);


  s=make_dag(event_list);

  top_order(event_list,order,s);

  correct_time_list(event_list,order,s);

  qsort(event_list,s,sizeof(struct event),compare_for_qsort);

  if (argc>1)
    write_trf(argv[2],event_list); 
  else
    write_trf((char *) 0,event_list);

}


















