/* tick2: Check Absolute Value of Clock */

#include <stdio.h>

#define STRMAX  10

extern double  dwalltime00();

char name[] = "TICK2";

main()
{
    int  flag = 1, fval;
    float timwal;
    double  dt[2], tk[2], pcterr;
    char chr[STRMAX];
    FILE  *ofp;

    ofp = fopen("tick2.res", "w");
    header(ofp, name);

/*    printf("\nThe calculation is in progress.  Please wait...\n\n");*/

	/* Initialise timer */
    tk[0] = dwalltime00();

    printf("\tMEASURING THE CLOCK MULTIPLIER\n\t------------------------------\n\n");
    printf("\nMost computers measure time by counting the number\n");
    printf("of clock ticks, then use a multiplier to convert this\n");
    printf("number to seconds. This benchmark tests the validity\n");
    printf("of this multiplier, by measuring the same time interval\n");
    printf("with both the computer TIMER subroutine, and an external\n");
    printf("wall-clock, which can be your own wrist-watch.\n\n");

    while( flag > 0 ){

	printf("The time interval is started and ended by a keyboard\n");
	printf("input. We suggest you time in interval of 2 minutes,\n");
	printf("which is timeable to about 0.1% with a wrist-watch.\n\n");
	printf("Hit q[uit] <CR> to finish\n");
	printf("Hit s[tart] <CR> to start timing interval\n");

	scanf("%s", chr);

	tk[0] = dwalltime00();

	if ( strncasecmp(chr, "q", 1) == 0 )
	    break;

	fprintf(ofp, "\tMEASURING THE CLOCK MULTIPLIER\n\t------------------------------\n\n");
	printf("\tMEASURING THE CLOCK MULTIPLIER\n\t------------------------------\n\n");

	/* WE WAIT SAY approx 5 minutes */
	printf("Hit s[top] <CR> to end timing interval\n");
	scanf("%s", chr);

	tk[1] = dwalltime00();

	fval = 1;
	while( fval > 0 ){
	    printf("Type number of **minutes** which elapsed by your\n");
	    printf("external wall clock or wrist watch\n");
	    printf("ENTER AS REAL NUMBER WITH DECIMAL POINT\n");

	    scanf("%f", &timwal);

	    if ( timwal < 0.0 ){
		printf(" *******  WALL-CLOCK TIME <= 0 : INVALID  *******\n");
		printf("\t\tInput Again\n");
	    }
	    else
		fval = 0;
	}

	dt[0] = tk[1] - tk[0];
	dt[1] = 60.0 * timwal;
	pcterr = 100.0 * abs( dt[1] - dt[0] );

	if ( dt[0] == 0.0 ){
	    printf(" *******  TIME INTERVAL TOO SHORT TO MEASURE  *******\n");
	    printf("\t\tStart Again\n");
	    continue;
	}

	printf("Your computer TIMER routine measured %g second\n", dt[0]);
	printf("Your wall clock  measured            %g second\n", dt[1]);
	printf("\nPercentage error = %g\n\n", pcterr);
	printf("Multiply value from TIMER by %g\n", dt[1]/dt[0]);
	printf("  to make TIMER correct\n\n");
	fprintf(ofp, "Your computer TIMER routine measured %g second\n", dt[0]);
	fprintf(ofp, "Your wall clock  measured            %g second\n", dt[1]);
	fprintf(ofp, "\nPercentage error = %g\n", pcterr);
	fprintf(ofp, "Multiply value from TIMER by %g\n", dt[1]/dt[0]);
	fprintf(ofp, "  to make TIMER correct\n\n");

	printf("If this multiplier is very variable or badly in error,\n");
	printf("it probably means that you are using a\n");
	printf("CPU-for-this-job-only timer\n");
	printf("not a wall-clock timer. You must use a\n");
	printf("wall-clock timer for parallel benchmarking.\n\n");
	printf("*** BEWARE *** : The returned value of the popular\n");
	printf(" Sun Unix timer ETIME is not a wall-clock timer,\n");
	printf(" even though it is called the elapsed time.\n\n");

	if ( pcterr > 10.0 ){
	    printf(" ***************************************************\n");
	    printf("\tTIMER GROSSLY IN ERROR\n\t----------------------\n");
	    printf(" Change Multiplier and/or change to wall-clock timer\n");
	    printf(" ***************************************************\n\n");
	    fprintf(ofp, " ***************************************************\n");
	    fprintf(ofp, "\tTIMER GROSSLY IN ERROR\n\t----------------------\n");
	    fprintf(ofp, " Change Multiplier and/or\n change to wall-clock timer\n");
	    fprintf(ofp, " ***************************************************\n\n");
	}

	if ( pcterr < 0.5 ){
	    printf(" ***************************************************\n");
	    printf("\t\tTIMER ERROR < 0.5 %%\n\t\t-------------------\n");
	    printf("\tYour timer is good enough to use\n");
	    printf(" ***************************************************\n\n");
	    fprintf(ofp, " ***************************************************\n");
	    fprintf(ofp, "\t\tTIMER ERROR < 0.5 %%\n\t\t-------------------\n");
	    fprintf(ofp, "\tYour timer is good enough to use\n");
	    fprintf(ofp, " ***************************************************\n\n");
	}

	printf("Repeat test at least four times, using a busy system in\n");
	printf("order to distinguish between CPU and wall-clock timers\n\n");
    }

    fclose(ofp);

    printf("Benchmark complete.\n");
}
