/* tick1: Measure clock tick interval */

#include <stdio.h>

#define NSAMPL  7
#define min(x,y) ((x)>(y)?(y):(x))

extern double  dwalltime00();

char name[] = "TICK1";

/* There are two cases.  Either the tick is shorter than the time    */
/* between successive calls to TIMER, in which case all of the DT    */
/* values will be multiples of it, or it is longer, in which case    */
/* the loop may have to execute a number of times before successive  */
/* calls register different times, but this should happen eventually */
main()
{
    int  i, j, k;
    double  dt[NSAMPL], tk[NSAMPL], tick, tstart;
    FILE  *ofp;

    ofp = fopen("tick1.res", "w");
    header(ofp, name);

    printf("\nThe calculation is in progress.  Please wait...\n\n");

	/* Initialise timer */
    tstart = dwalltime00();

    fprintf(ofp, "  TIME CHANGES BETWEEN SUCCESSIVE SAMPLES OF TIME BY SUBROUTINE TIMER\n");
	/* Initialise TICK to a large value */

    tick = 1.0e6;
	/* Measure the time between clock ticks */
    for( i = 0 ; i < 10000 ; i++ ){
	for( k = 0 ; k < 7 ; k++ )
	    tk[k] = dwalltime00();

	for( j = 1 ; j < NSAMPL ; j++ ){
	    dt[j] = tk[j] - tk[j-1];
	    if ( dt[j] != 0 )
		tick = min(tick, dt[j]);
	}

	if ( i < 50 ){
	    fprintf(ofp, "  TIME CHANGE=");
	    for( j = 1 ; j < NSAMPL ; j++ )
		fprintf(ofp, " %14.6E", dt[j]);
	    fprintf(ofp, "\n");
	}

    }

    fprintf(ofp, "\n    CLOCK TICK is less than or equal to %15.6G sec\n", tick);

    fclose(ofp);

    printf("Benchmark complete.\n");
}
