      PROGRAM SYNCH1

      INCLUDE 'synch1.inc'
      INCLUDE 'fpvm3.h'
      INCLUDE 'dattyp.inc'

C     =================================================
C     ===                                           ===
C     ===   Program:  Barrier Syncronisation Rate   ===
C     ===   Version:  PVM3 + Fortran 77             ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME
      DATA NAME /'synch1_pvm'/


C     /* Timer and result file placement routines */
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
C     PVM Variables:
C
      CHARACTER*6 GROUP
      DATA GROUP /'synch1'/
      INTEGER I, INFO, ME, MYTID, TIDS(0:MAXNOD)
C
C     /* Variable Declarations */
C
      INTEGER K, NBARR, NNODE
      REAL*8 RMBARS,T0,T1,T2,TN
C
C     /* the unit number of output files */
C
      INTEGER IOUNIT, NW1
      PARAMETER(IOUNIT=10)
      PARAMETER(NW1=11)


c     This call launches all processes (if necessary)
c     and distributes the variables NNODES, ME, MYTID, TIDS

      call launch(NAME, GROUP, IOUNIT, 'synch1.dat', MAXNOD,
     &                  NNODE, ME, MYTID, TIDS)


C     Read in data and Broadcast them

      IF( ME .EQ. 0 ) THEN  

C        Get parameters from input file
C
         PRINT *
         PRINT *,'     SYNCH1:  Barrier Test'
         PRINT *,'     ---------------------'
         PRINT *
         OPEN( UNIT=IOUNIT, FILE='synch1.dat', STATUS='OLD' )
         READ( IOUNIT,FMT = * ) NNODE
         PRINT *,'Number of nodes =',NNODE
         PRINT *
         CLOSE(IOUNIT)

      ENDIF

C     ======================
C
C     /* measure timing overhead, t0 */
C
      T1 = DWALLTIME00()
      DO 10 I = 1, NREPT
        CALL DUMMY(I)
10    CONTINUE
      T2 = DWALLTIME00()
      T0 = T2-T1
C
      T1 = DWALLTIME00()
      DO 20 I = 1,NREPT
        CALL DUMMY(I)
        DO 15 K = 1, 10
          CALL PVMFBARRIER(GROUP,NNODE,INFO)
15      CONTINUE
20    CONTINUE
      T2 = DWALLTIME00()
C
      IF( ME.EQ.0 ) THEN
C
C       /* number of barriers in loop */
C
        NBARR=10
C
C       /* time per barrier, tn: */
C
        TN = (T2-T1-T0)/(NBARR*NREPT)
        TN=1.0E+06*TN
C
C        /* megabarrier/s */
C
         RMBARS=1.0/TN
C
         OPEN(NW1,FILE='synch1.res')
C
         CALL HEADER(NW1,NAME)
C
         WRITE(NW1,997) NNODE,TN,RMBARS
C
  997    FORMAT(/,
     2  1X,'       -----------------------------------',/,
     1  1X,'       SYNCH1: Global Synch - Barrier Rate',/,
     2  1X,'       -----------------------------------',/,
     2  1X,'                 Result Summary          ',/,
     2  1X,'                 --------------         ',//,
     4  1X,'    Number of processors (nodes) = ',I6,//,
     4  1X,'    Time per barrier = ',1PE12.3,' us',/,
     5  1X,'    Barrier Rate     = ',1PE12.3,' Mbarr/s',//,
     2  1X,'       -----------------------------------',/)
C
         CLOSE(NW1)
C
         PRINT *,'Benchmark completed.'
C
      ENDIF
C
C     Program finished. Leave group and PVM before exiting
C
      CALL PVMFLVGROUP(GROUP,INFO)
      CALL PVMFEXIT(INFO)
      STOP
C
      END
