      PROGRAM SYNCH1
C
      INCLUDE 'synch1.inc'
      INCLUDE 'mpif.h'

C     =================================================
C     ===                                           ===
C     ===   Program:  Barrier Syncronisation Rate   ===
C     ===   Version:  MPI  + Fortran 77             ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME
      DATA NAME /'synch1_mpi'/
C
C     /* Timer routine */
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
C     Variables:
C
      INTEGER I, ierr, my_rank
C
C     /* Variable Declarations */
C
      CHARACTER*6 GROUP
      DATA GROUP /'synch1'/
      INTEGER K, NBARR, NP
      REAL*8 RMBARS,T0,T1,T2,TN
C
C     /* the unit number of output files */
C
      INTEGER IOUNIT, NW1
      PARAMETER(IOUNIT=10)
      PARAMETER(NW1=11)


C     Initialize MPI.
C
      CALL MPI_INIT( ierr )
C
      IF( ierr.NE.MPI_SUCCESS )
     &    PRINT *,'ERROR: MPI_INIT returned ', ierr
C	 
      CALL MPI_COMM_RANK( MPI_COMM_WORLD, my_rank, ierr)
      CALL MPI_COMM_SIZE( MPI_COMM_WORLD, NP, ierr)

      IF ( my_rank.EQ.0 )THEN
C
C        Get parameters from input file
C
         PRINT *
         PRINT *,'     SYNCH1:  Barrier Test'
         PRINT *,'     ---------------------'
         PRINT *
         PRINT *,'Number of processes =',NP
         PRINT *
C
      ENDIF
C
C     /* measure timing overhead, t0 */
C
      T1 = DWALLTIME00()
      DO 10 I = 1, NREPT
        CALL DUMMY(I)
 10   CONTINUE
      T2 = DWALLTIME00()
      T0 = T2-T1
C
      T1 = DWALLTIME00()

      DO 20 I = 1,NREPT
        CALL DUMMY(I)
        DO 15 K = 1, 10
          CALL MPI_BARRIER( MPI_COMM_WORLD, ierr )
C          IF( ierr.NE.MPI_SUCCESS )
C     &    PRINT *,'ERROR: MPI_BARRIER returned ', ierr
C
 15     CONTINUE
 20   CONTINUE
C
      T2 = DWALLTIME00()
C
      IF( my_rank .EQ. 0 ) THEN
C
C       /* number of barriers in loop */
C
        NBARR=10
C
C       /* time per barrier, tn: */
C
        TN = (T2-T1-T0)/(NBARR*NREPT)
        TN=1.0E+06*TN
C
C        /* megabarrier/s */
C
         RMBARS=1.0/TN
C
         OPEN(NW1,FILE='synch1.res')
C
         CALL HEADER(NW1,NAME)
C
         WRITE(NW1,997) NP,TN,RMBARS
C
  997    FORMAT(/,
     2  1X,'       -----------------------------------',/,
     1  1X,'       SYNCH1: Global Synch - Barrier Rate',/,
     2  1X,'       -----------------------------------',/,
     2  1X,'                 Result Summary          ',/,
     2  1X,'                 --------------         ',//,
     4  1X,'    Number of processes = ',I6,//,
     4  1X,'    Time per barrier = ',1PE12.3,' us',/,
     5  1X,'    Barrier Rate     = ',1PE12.3,' Mbarr/s',//,
     2  1X,'       -----------------------------------',/)
C
         CLOSE(NW1)
C
         PRINT *,'Benchmark completed.'
C
      ENDIF
C
C     Program finished. Leave MPI before exiting
C        
      CALL MPI_BARRIER( MPI_COMM_WORLD, ierr )
         IF( ierr.NE.MPI_SUCCESS )
     &     PRINT *,'ERROR: MPI_BARRIER returned ', ierr
      CALL MPI_FINALIZE(ierr)  
C      
      STOP
      END
