      SUBROUTINE DOALL(ICASE,N,TN)
C
      INCLUDE 'rinf1.inc'
C
C     ICASE - CASE NUMBER, INPUT PARAM
C     N     - VECTOR LENGTH
C     TN    - TIME PER VECTOR OPERATION, OUTPUT PARAM
C
      INTEGER ICASE,N
      REAL*8 TN
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
      COMMON /DATA/ A(NNMAX),B(NNMAX),C(NNMAX),D(NNMAX),E(NNMAX),    
     1  F(NNMAX),MATA(NNMAX1,NNMAX1),MATB(NNMAX1,NNMAX1),
     2  MATC(NNMAX1,NNMAX1),IA(NNMAX),IB(NNMAX),IC(NNMAX)
      INTEGER IA,IB,IC
      REAL*8 A,B,C,D,E,F,MATA,MATB,MATC
C
      COMMON /PARM/ TOTIM,IOUT,NMAX,NMAX1,NTIMES,NTIM
      INTEGER IOUT,NMAX,NMAX1,NTIMES,NTIM
      REAL*8 TOTIM
C
      COMMON /CHARS/ LABEL(20)
      CHARACTER*80 LABEL
C
      INTEGER FLOP,I,J,JT,K,N2,NL
      REAL*8 CH,FNTIM,S,SUM,T0,T1,T2
C
C    /* SELECT REPEAT */
C
      NTIM=1
      IF (N .EQ. 0) GO TO 50
      IF (N .NE. 0) NTIM=NTIMES/N
      IF(ICASE .EQ. 10) NTIM=NTIM/N
      IF(ICASE .GE. 11 .AND. ICASE .LE. 13) NTIM=NTIM/(N*N)
      IF(NTIM .EQ. 0) NTIM=1
      FNTIM=NTIM
C
C     /* TIME OVERHEAD OF CALLING TIMER, IN T0 */
C
      T1 = DWALLTIME00()
C
      DO 669 JT=1,NTIM
        CALL DUMMY(JT)
669   CONTINUE
      T2 = DWALLTIME00()
      T0=T2-T1
C
50      CONTINUE
C
      IF (ICASE .NE. 1) GOTO 200
C     /* CONTIGUOUS DYADS */
      LABEL(1)='(1) CONTIGUOUS DYADS:  A(I)=B(I)*C(I)'
      IF(N.GT.NMAX) N=0
      IF (N .EQ. 0) RETURN
C
      FLOP=1.0
      T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
      DO 111 JT=1,NTIM
        CALL DUMMY(JT)
C        /* THE VECTOR OPERATION */
C$OMP do
         DO 110 I=1,N
           A(I)=B(I)*C(I)
110      CONTINUE
C$OMP end do
111   CONTINUE
C$OMP end parallel
C
      T2 = DWALLTIME00()
C
C     /* GO TO FINAL SEQUENCE */
C
      GOTO 10
C
200   IF (ICASE .NE. 2) GOTO 300
C     /* NONCONTIGUOUS DYAD */
      LABEL(2)='(2) DYADS,  STRIDE=8:  A(I)=B(I)*C(I)'
      IF(N.GT.NMAX) N=0
      IF (N .EQ. 0) RETURN
C
      FLOP=1.0
      NL=1+8*(N-1)
      IF (NL .GT. NMAX) N=0
C     /*  N=0 IS SIGNAL VECTOR TOO LONG TO OUTSIDE */
      IF (N .EQ. 0) RETURN
C
      T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
      DO 211 JT=1,NTIM
        CALL DUMMY(JT)
C$OMP do
        DO 210 I=1,NL,8
           A(I)=B(I)*C(I)
210     CONTINUE
C$OMP end do
211   CONTINUE
C$OMP end parallel
C
      T2 = DWALLTIME00()
C
C     /* GO TO FINAL SEQUENCE */
        GOTO 10
C
C
300   IF (ICASE .NE. 3) GOTO 400
C     /* CONTIGUOUS TRIAD */
      LABEL(3)='(3) CONTIGUOUS TRIADS:  A(I)=B(I)*C(I)+D(I)'
      IF(N.GT.NMAX) N=0
      IF (N .EQ. 0) RETURN
C
      FLOP=2.0
C
      T1 = DWALLTIME00()
C$OMP parallel private(jt)
      DO 311 JT=1, NTIM
        CALL DUMMY(JT)
C$OMP do
        DO 310 I=1,N
           A(I)=B(I)*C(I)+D(I)
310     CONTINUE
C$OMP end do
311   CONTINUE
C$OMP end parallel
C
      T2 = DWALLTIME00()
C
C     /* GO TO FINAL SEQUENCE */
C
      GOTO 10
C
400   IF (ICASE .NE. 4) GOTO 500
C     /* NONCONTIGUOUS TRIADS */
      LABEL(4)='(4) TRIADS,  STRIDE=8:  A(I)=B(I)*C(I)+D(I)'
C
      FLOP=2.0
      NL=1+8*(N-1)
      IF (NL .GT. NMAX) N=0
      IF (N .EQ. 0) RETURN
C
      T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
      DO 411 JT=1,NTIM
        CALL DUMMY(JT)
C$OMP do
        DO 410 I=1,NL,8
           A(I)=B(I)*C(I)+D(I)
410     CONTINUE
C$OMP end do
411   CONTINUE
C$OMP end parallel
C
      T2 = DWALLTIME00()
C
C     /* GO TO FINAL SEQUENCE */
C
      GOTO 10
C
C
C
C ----------------------------------------------------------------------
C
 500   IF (ICASE .NE. 5) GOTO 600
C RANDOM SCATTER/GATHER
        LABEL(5)='(5) RANDOM SCATTER/GATHER:'
        IF(N .GT. NMAX) N=0        	
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
C
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 511 JT=1,NTIM
        CALL DUMMY(JT)
C
C RANDOM GATHER
C$OMP do
        DO 510 I=1,N
           A(I)=C(IB(I))
 510    CONTINUE
C$OMP end do
C
C RANDOM SCATTER
C$OMP do
        DO 520 I=1,N
           A(IB(I))=C(I)
 520    CONTINUE
C$OMP end do
C
 511   CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C RECORD AVERAGE SCATTER/GATHER, DIVIDE BY 2
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
C
C
C ----------------------------------------------------------------------
C
 600   IF (ICASE .NE. 6) GOTO 700
C CONTIGUOUS 4-OPS
        LABEL(6)='(6) CONTIGUOUS 4-OP:  A(I)=B(I)*C(I)+D(I)*E(I)+F(I)'
        IF(N .GT. NMAX) N=0        	
        IF (N .EQ. 0) RETURN
        FLOP=4.0
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 611 JT=1,NTIM
        CALL DUMMY(JT)
C THE VECTOR OPERATION
C$OMP do
        DO 610 I=1,N
           A(I)=B(I)*C(I)+D(I)*E(I)+F(I)
 610    CONTINUE
C$OMP end do
C
 611    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
C
 700    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 7) GOTO 800
        LABEL(7)='(7) INNER PRODUCT:  S=S+B(I)*C(I)'
        IF(N .GT. NMAX) N=0        	
        IF (N .EQ. 0) RETURN
        FLOP=2.0
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 711 JT=1,NTIM
            CALL DUMMY(JT)
C THE VECTOR OPERATION
C$OMP single
            SUM=0.0
C$OMP end single
C$OMP do reduction(+:SUM)
        DO 710 I=1,N
           SUM=SUM+B(I)*C(I)
 710    CONTINUE
C$OMP end do
C
 711    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C ASSIGN SUM TO A(1) TO PRVENT OPTIMIZING THE 710 LOOP
        A(1)=SUM
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 800    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 8) GOTO 900
        LABEL(8)='(8) FIRST ORDER RECURRENCE:  A(I)=B(I)*A(I-1)+D(I)'
        IF(N .GT. NMAX) N=0        	
        IF (N .EQ. 0) RETURN
        FLOP=2.0
        T1 = DWALLTIME00()
C
        DO 811 JT=1,NTIM
        CALL DUMMY(JT)
C THE VECTOR OPERATION
           A(1)=D(1)
        DO 810 I=2,N
           A(I)=F(I)*A(I-1)+D(I)
 810    CONTINUE
C
 811    CONTINUE
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 900    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 9) GOTO 1000
        LABEL(9)='(9) CHARGE ASSIGNMENT:  A(J(I))=A(J(I))+S'
        IF(N .GT. NMAX) N=0        	
        IF (N .EQ. 0) RETURN
        FLOP=1.0
        T1 = DWALLTIME00()
C
          CH=1.7349
C$OMP parallel private(jt)
        DO 911 JT=1,NTIM
        CALL DUMMY(JT)
C THE VECTOR OPERATION
C$OMP do
        DO 910 I=1,N
C$OMP  atomic
          C(IA(I))=C(IA(I))+CH
 910    CONTINUE
C$OMP end do
C
 911    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1000    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 10) GOTO 1100
       LABEL(10)='(10) TRANSPOSITION:  B(I,J)=A(J,I)'
C
C  ESCAPE IF N TOO BIG
        IF (N .GT. NMAX1) N=0
        IF (N .EQ. 0) RETURN
C
C
        FLOP=N
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 1010 JT=1,NTIM
        CALL DUMMY(JT)
C THE VECTOR OPERATION
C$OMP do private(j)
        DO 1011 I=1,N
        DO 1012 J=1,N
           MATB(I,J)=MATA(J,I)
 1012   CONTINUE
 1011   CONTINUE
C$OMP end do
C
 1010    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1100    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 11) GOTO 1200
       LABEL(11)='(11) MATRIX MULT BY INNER PRODUCT'
C    EACH INNER PRODUCT ACCUMULATED IN SEQUENCE
C
C  ESCAPE IF N TOO BIG
        IF (N .GT. NMAX1) N=0
        IF (N .EQ. 0) RETURN
C
C  CLEAR ARRAY BEFORE ACCUMULATING SUMS
C$OMP parallel do private(j)
        DO 1120 I=1,N
        DO 1121 J=1,N
            MATA(I,J)=0.0
 1121   CONTINUE
 1120   CONTINUE
C$OMP end parallel do
C
        FLOP=2*N*N
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 1110 JT=1,NTIM
        CALL DUMMY(JT)
C$OMP do private(i,k)
        DO 1111 J=1,N
        DO 1112 I=1,N
C   ACCUMULATE INNER PRODUCT
        DO 1113 K=1,N
           MATA(I,J)=MATA(I,J)+MATB(I,K)*MATC(K,J)
 1113   CONTINUE
 1112   CONTINUE
 1111   CONTINUE
C$OMP end do
C
 1110    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1200    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 12) GOTO 1300
       LABEL(12)='(12) MATRIX MULT BY MIDDLE PRODUCT'
C    A COLUMN OF INNER PRODUCTS ARE ACCUMULATED IN PARALLEL
C    2 N**2 VECTOR OPS OF LENGTH N
C
C  ESCAPE IF N TOO BIG
        IF (N .GT. NMAX1) N=0
        IF (N .EQ. 0) RETURN
C
C  CLEAR ARRAY BEFORE ACCUMULATING SUMS
C$OMP parallel do private(j)
        DO 1220 I=1,N
        DO 1221 J=1,N
            MATA(I,J)=0.0
 1221   CONTINUE
 1220   CONTINUE
C$OMP end parallel do
C
        FLOP=2*N*N
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 1210 JT=1,NTIM
        CALL DUMMY(JT)
C$OMP do private(k,i)
        DO 1211 J=1,N
        DO 1212 K=1,N
C
C THE VECTOR OPERATION OF LENGTH N
        DO 1213 I=1,N
         MATA(I,J)=MATA(I,J)+MATB(I,K)*MATC(K,J)
 1213   CONTINUE
 1212   CONTINUE
 1211   CONTINUE
C$OMP end do
C
 1210    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1300    CONTINUE
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 13) GOTO 1400
       LABEL(13)='(13) MATRIX MULT BY OUTER PRODUCT'
C   ACCUMULATE ALL N**2 INNER PRODUCTS IN PARALLEL
C   USES 2*N VECTOR OPS OF LENGTH N**2
C
C  ESCAPE IF N TOO BIG
        IF (N .GT. NMAX1) N=0
        IF (N .EQ. 0) RETURN
C
        N2=N*N
C  CLEAR ARRAY BEFORE ACCUMULATING SUMS
C$OMP parallel do
        DO 1320 I=1,N2
            A(I)=0.0
 1320   CONTINUE
C$OMP end parallel do
C
        FLOP=2*N
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt,k)
        DO 1311 JT=1,NTIM
        CALL DUMMY(JT)
C
        DO 1314 K=1,N
C    LOAD 1D ARRAYS IN PREPARATION FOR VECTOR OP OF LENGTH N**2
C$OMP do
        DO 1312 J=1,N
        DO 1313 I=1,N
          B(I+N*(J-1))=MATB(I,K)
          C(I+N*(J-1))=MATC(K,J)
 1313   CONTINUE
 1312   CONTINUE
C$OMP end do
C
C   THE VECTOR OPERATION OF LENGTH N**2
C$OMP do
        DO 1310 I=1,N2
          A(I)=A(I)+B(I)*C(I)
 1310   CONTINUE
C$OMP end do
C
 1314   CONTINUE
C
 1311    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
         N=N2
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1400  CONTINUE
C
C
C ----------------------------------------------------------------------
C
C
       IF (ICASE .NE. 14) GOTO 1500
C DYAD, STRIDE=128
        LABEL(14)='(14) DYADS,  STRIDE=128:  A(I)=B(I)*C(I)'
C
        FLOP=1.0
        NL=1+128*(N-1)
        IF (NL .GT. NMAX) N=0
C N=0 IS SIGNAL VECTOR TOO LONG TO OUTSIDE
        IF (N .EQ. 0) RETURN
C
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 1411 JT=1,NTIM
        CALL DUMMY(JT)
C
C$OMP do
        DO 1410 I=1,NL,128
            A(I)=B(I)*C(I)
 1410   CONTINUE
C$OMP end do
C
 1411    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1500   CONTINUE
C
C ----------------------------------------------------------------------
C
C
       IF (ICASE .NE. 15) GOTO 1600
C NONCONTIGUOUS DYAD, STRIDE=1024
        LABEL(15)='(15) DYADS,  STRIDE=1024:  A(I)=B(I)*C(I)'
C
        FLOP=1.0
        NL=1+1024*(N-1)
        IF (NL .GT. NMAX) N=0
C N=0 IS SIGNAL VECTOR TOO LONG TO OUTSIDE
        IF (N .EQ. 0) RETURN
C
        T1 = DWALLTIME00()
C
C$OMP parallel private(jt)
        DO 1511 JT=1,NTIM
        CALL DUMMY(JT)
C
C$OMP do
        DO 1510 I=1,NL,1024
            A(I)=B(I)*C(I)
 1510   CONTINUE
C$OMP end do
C
 1511    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1600   CONTINUE
C
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 16) GOTO 1700
C CONTIGUOUS TRIAD
        LABEL(16)='(16) CONTIGUOUS DAXPY:  A(I)=S*B(I)+C(I)'
        IF (N .GT. NMAX) N=0
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
        S=1.2345
C
         T1 = DWALLTIME00()
C$OMP parallel private(jt)
        DO 1611 JT=1, NTIM
        CALL DUMMY(JT)
C
C$OMP do
        DO 1610 I=1,N
            A(I)=S*B(I)+C(I)
 1610   CONTINUE
C$OMP end do
C
 1611    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1700   CONTINUE
C
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 17) GOTO 1800
C CONTIGUOUS TRIAD
        LABEL(17)='(17) INDIRECT DAXPY:  A(J(I))=S*B(K(I))+C(L(I))'
        IF (N .GT. NMAX) N=0
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
        S=1.2345
C
         T1 = DWALLTIME00()
C$OMP parallel private(jt)
        DO 1711 JT=1, NTIM
        CALL DUMMY(JT)
C
C$OMP do
        DO 1710 I=1,N
            A(IC(I))=S*B(IB(I))+C(IC(I))
 1710   CONTINUE
C$OMP end do
C
 1711    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1800   CONTINUE
C
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 18) GOTO 1900
C CONTIGUOUS TRIAD
        LABEL(18)='(18) CONTIGUOUS DAXPY[parallel do]:A(I)=S*B(I)+C(I)'
        IF (N .GT. NMAX) N=0
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
        S=1.2345
C
         T1 = DWALLTIME00()
        DO 1811 JT=1, NTIM
        CALL DUMMY(JT)
C
C$OMP parallel do
        DO 1810 I=1,N
            A(I)=S*B(I)+C(I)
 1810   CONTINUE
C$OMP end parallel do
C
 1811    CONTINUE
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 1900   CONTINUE
C
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 19) GOTO 2000
C CONTIGUOUS TRIAD
        LABEL(19)='(19) CONTIGUOUS DAXPY[static(10)]: A(I)=S*B(I)+C(I)'
        IF (N .GT. NMAX) N=0
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
        S=1.2345
C
         T1 = DWALLTIME00()
C$OMP parallel private(jt)
        DO 1911 JT=1, NTIM
           CALL DUMMY(JT)
C
C$OMP do schedule(static,10)
        DO 1910 I=1,N
            A(I)=S*B(I)+C(I)
 1910   CONTINUE
C$OMP end do
C
 1911    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 2000   CONTINUE
C
C
C ----------------------------------------------------------------------
C
       IF (ICASE .NE. 20) GOTO 2100
C CONTIGUOUS TRIAD
        LABEL(20)='(20) CONTIGUOUS DAXPY[dynamic(10)]:A(I)=S*B(I)+C(I)'
        IF (N .GT. NMAX) N=0
        IF (N .EQ. 0) RETURN
C
        FLOP=2.0
        S=1.2345
C
         T1 = DWALLTIME00()
C$OMP parallel private(jt)
        DO 2011 JT=1, NTIM
        CALL DUMMY(JT)
C
C$OMP do schedule(dynamic,10)
        DO 2010 I=1,N
            A(I)=S*B(I)+C(I)
 2010   CONTINUE
C$OMP end do
C
 2011    CONTINUE
C$OMP end parallel
C
        T2 = DWALLTIME00()
C
C
C   GO TO FINAL SEQUENCE
        GOTO 10
C
 2100   CONTINUE
C
C ----------------------------------------------------------------------
C
C               ADD NEW CASES HERE FOLLOWING ABOVE PATTERN
C
C ----------------------------------------------------------------------
C
        TOTIM=0.0
        TN=0.0
        RETURN
C
 10     TOTIM=T2-T1-T0
        TN=TOTIM/(FLOP*FNTIM)
C
        RETURN
        END






