/* rinf1.h: rinf1.inc and common;
C===RINF1 parameter file
C===   NNMAX - 1D arrays dimensioned. e.g. A(NNMAX)
C===   NNMAX1- 2D arrays dimensioned. e.g. A(NNMAX1,NNMAX1)
C===   NITER  = number of iterations (repeats) to aid timing
C===          = 1.0E8*(CLOCK TICK)*(Mflop/s)
C===          e.g if the expected performance is 1 Mflop/s
C===          = 1000   IF TICK IS 1.0E-5 SEC
C===          = 100000 IF TICK IS 1.0E-3 SEC
 */

#ifdef RINF1
#define EX
#else
#define EX extern
#endif

#define NNMAX	100000	/* 1D maximum array dimension */
#define NNMAX1	300	/* 2D array dimension */
#define NITER	1000000	/* the number of iterations */
			/* 1000 to 10000 for testing execution,
			 * 10000 to 100000 for measurements */

EX double a[NNMAX], b[NNMAX], c[NNMAX], d[NNMAX], e[NNMAX], f[NNMAX];
EX double mata[NNMAX1][NNMAX1], matb[NNMAX1][NNMAX1], matc[NNMAX1][NNMAX1];
EX double totim;
EX int ia[NNMAX], ib[NNMAX], ic[NNMAX];
EX int nmax, nmax1, ntimes, ntim;
EX char *label[21];

extern double dwalltime();
