/* rinf1.c: translate from RINF1.f(Parkbench/Low_Level/rinf1)
 *=== Program:  R-infinity and N-half
 *=== Org Version:  Standard Fortran 77
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define RINF1
#include "rinf1.h"

char name[] = "RINF1";	/* program name */

#define NDIM1	50
#define NDIM2	2

#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))

extern int doall();
extern int casemax;

void usage()
{
    printf("Usage: rinf1 [option]\n");
    printf("options are:\n\t -s <start num>: start test case\n");
    printf("\t -e <end num>: end test case\n");
    printf("\t -n <number of case>: number of test executed[Max 17]\n");
    printf("\t -h: show this message\n");
}

main(int argc, char **argv)
{
    int  lnlast[NDIM1][NDIM2];
    int  i, j, i1, iback, icase, iodet, isw, n, ncase, nsel, nsel1, nsend;
    int  ntrip, lnsave[NDIM1];
    int  ist, totn;
    double pctmax[NDIM1][NDIM2], ravg[NDIM1][NDIM2];
    double rlast[NDIM1][NDIM2], xnlast[NDIM1][NDIM2];
    double dum1, dum2, dum3, per, raver, rinf, t10, t11, tn, xn, xn12;
    double ersave[NDIM1], xnsave[NDIM1], xrsave[NDIM1];
    double dbli;
    FILE  * outf;/** inf,*/

	/* set (default) Parameters  here */
    nmax = NNMAX;	/* set the maximum vector length */
    nmax1 = NNMAX1;
    iodet = 0;	/* set for detailed output as default */
    ist = 0;	/* icase start test number: 0 origin */
    ncase = casemax;	/* set the end number of test(20) */
    ntimes = NITER;	/* set repeat for timing */
    totn = 0;	/* the number of tests(for option) */

    for( i = 1 ; i < argc ; i++ ){
	if ( !strcmp(argv[i], "-s") ){
	    if ( argc <= (i+1) ){
		printf("-s requires number; ignored\n");
	    }
	    else{
		ist = atoi(argv[++i]) - 1;
/*		printf("start at test[%d]\n", ist+1);*/
	    }
	}
	else if ( !strcmp(argv[i], "-e") ){
	    if ( argc <= i+1 ){
		printf("-e requires number; ignored\n");
	    }
	    else{
		ncase = atoi(argv[++i]);
/*		printf("end at test[%d]\n", ncase);*/
	    }
	}
	else if ( !strcmp(argv[i], "-n") ){
	    if ( argc <= i+1 ){
		printf("-n requires number; ignored\n");
	    }
	    else{
		totn = atoi(argv[++i]);
/*		printf("[%d] test will be executed\n", totn);*/
	    }
	}
	else if ( !strncmp(argv[i], "-h", 2) ){
	    usage();
	    exit(0);
	}
	else{
	    printf("%s: unknown flag, ignored\n", argv[i]);
	    usage();
	    exit(1);
	}
    }

    if ( totn > 0 ){
	ncase = ist + totn;
	if ( ncase > casemax )
	    ncase = casemax;
    }

    outf = fopen("rinf1.res", "w");	/* output file open */
    rewind(outf);

    header(outf, name);		/* print ParkBench header */
    printf("\n      RINF1:  R-infinity and N-half\n");
    printf("      -----------------------------\n");
    printf("\nThe calculation is in progress.  Please, wait...\n\n");

	/* INITIALISE TIMER */
    satime();
    t10 = dwalltime();
    tn = 0.0;

	/* INITIALIZE ARRAYS : */
    for( i = 0 ; i < nmax ; i++ ){
	dbli = i + 1;	/* F-index = C-index + 1 */
	a[i] = 5.842 * dbli;
	b[i] = 0.39675 * dbli;
	c[i] = 4.5693 / dbli;
	d[i] = 9.8124 * sqrt(dbli);
	e[i] = -4.815 * dbli;
	f[i] = -1.0067 * sin((double)dbli);
	i1 = (int)b[i];
	    /* NON REPEATING INDICES */
	ib[i] = i1 % nmax + 1;
	i1 = a[i];
	/* NON REPEATING INDICES */
	ic[i] = i1 % nmax + 1;
	/* REPEATING INDICES */
	ia[i] = ((ib[i] % 60) * nmax) / 60 + 1;
    }

    for( i = 0 ; i < nmax1 ; i++ ){
	for( j = 0 ; j < nmax1 ; j++ ){
	    mata[i][j] = 6.3487;
	    matb[i][j] = 9.765342;
	    matc[i][j] = 1.653982;
	}
    }

/*    printf("Benchmark loop for [%d]-[%d] case...\n", ist+1, ncase);*/
    for( icase = ist ; icase < ncase && icase < casemax; icase++ ){

	/* RESET SWITCH FOR CHOOSING SUMMARY OUTPUT VALUES */
	isw = 0;
	for( i = 0 ; i < NDIM1 ; i++ ){	/*C index*/
	    xrsave[i] = 0.0;
	    xnsave[i] = 0.0;
	    lnsave[i] = 0;
	    ersave[i] = 0.0;
	}
	for( j = 0 ; j < NDIM2 ; j++ ){
	    rlast[icase][j] = 0.0;
	    xnlast[icase][j] = 0.0;
	    lnlast[icase][j] = 0.0;
	    pctmax[icase][j] = 0.0;
	}

	/* stores minimum RAVERAGE */
	ravg[icase][0] = 1.0e10;
	/* stores maximum RAVERAGE */
	ravg[icase][1] = 0.0;

	/* INITIALIZE LABELS */

	n = doall(icase, 0, &tn);

	if ( iodet == 0 ){
	    fprintf(outf, "\n%s\n", label[icase]);
	    fprintf(outf, " icase=%4d  ncase=%4d  nmax=%6d  ntimes=%10d\n", icase, ncase, nmax, ntimes);
	}

	/* INITIALIZE LEAST SQUARES */
	lstsq(0, xn, tn, &rinf, &xn12, &per);
	rinf = rinf * 1.0e-6;

	if ( iodet == 0 ){
	    fprintf(outf, " SI      NI\t     TI\t\t\tRINF         N1/2\tPCT ERROR   REPEAT\tTOTAL TIME\t   R[N]\n");
	    fprintf(outf, "\tvlen\t    sec\t\t     Mflop/s         vlen \t    \t\t\t  sec \t\tMflop/s\n");
	}

	lnlast[icase][1] = 1;
	nsel1 = 0;
	per = 0.0;
	nsend = 46;

	for( nsel = 1 ; nsel <= nsend ; nsel++ ){	/*nsel = si*/
/*	    printf(" -> loop nsel[%d]\n", nsel);*/
	    /* SELECT VECTOR LENGTH */
	    if ( nsel <= 10 ) n = nsel;
	    if ( 10 < nsel && nsel <= 19 ) n = 10 * (nsel - 9);
	    if ( 19 < nsel && nsel <= 28 ) n = 100 * (nsel - 18);
	    if ( 28 < nsel && nsel <= 37 ) n = 1000 * (nsel - 27);
	    if ( 37 < nsel && nsel <= 46 ) n = 10000 * (nsel - 36);
	    if ( 46 < nsel ) n = 100000 * (nsel - 45);

	    /*  skip cases after out-of-cache discovery */
/*	    if ( nsel < nsel1 ){
		printf(" -> skip nsel[%d] at 1\n", nsel);
		  continue;*break?
	    }*/

	    if ( n > nmax )
		n = nmax;

	    if ( per == 222.2 ){
		lnlast[icase][1] = n;
		per = 0.0;
/*		printf(" ->[%2d]lnlast[%d][0] = %d\n", nsel, icase, lnlast[icase][0]);*/
	    }

	    /* TIME VECTOR OPERATION */
	    n = doall(icase, n, &tn);

	    /*  ESCAPE IF VECTOR TOO LONG */
	    if ( n == 0 ){
/*		printf("skip nsel[%d] at 2\n", nsel);*/
		continue;
	    }
	    /* UPDATE LEAST SQUARES */
	    xn = n;
	    lstsq(1, xn, tn, &rinf, &xn12, &per);
	    rinf = rinf * 1.0e-6;

	    /* SELECT AND SAVE SUMMARY VALUES */
	    if ( xn12 < 0 ){
/*		printf(" -> n[%d] nsel[%d]\n", n, nsel);*/
		if ( rinf < 0.0 || tn < 0.0 ){
		    /* Negative time or larger problem takes less time */
		    /* Value rejected and least squares restarted */
		    /* PER is used to hold marker value for this action */
		    per = 111.1;

		    /* re-initialise least-squares fit */
		    xn = n;
		    lstsq(0, xn, tn, &dum1, &dum2, &dum3);
		}

		/* any lengths < NTRIP are assumed in-cache */
		/* suppress out-of-cache trip */
		ntrip = n;
		if ( icase == 1 || icase == 3 ) ntrip = 8 * n;
		if ( 8 < icase && icase < 13 ) ntrip = n * n;
		if ( icase == 13 ) ntrip = 128 * n;
		if ( icase == 14 ) ntrip = 1024 * n;

		if ( rinf > 0.0 && isw == 0 && ntrip > 100 ){
		/* Going out-of-cache detected (1st time N12<0 and RINF>0) */
		/* Record in-cache values (take those from two cases before) */
		/* PER is used to hold marker value for this action */
		    per = 222.2;
		    isw = 1;
		    iback = 3;
		    rlast[icase][0] = xrsave[nsel-iback];
		    xnlast[icase][0] = xnsave[nsel-iback];
		    lnlast[icase][0] = lnsave[nsel-iback];
		    pctmax[icase][0] = ersave[nsel-iback];
/*	    printf(" ->lnlast[%d][0] = %d\n", icase, lnlast[icase][0]);*/
		}
	    }

	    /* Save values for future recording */
	    /* make near zero values zero */
/* if ( -1.0 < xn12 && xn12 < 1.0 ) xn12 = 0.0*/
	    xrsave[nsel] = rinf;
	    xnsave[nsel] = xn12;
	    lnsave[nsel] = n;
	    ersave[nsel] = per;

	    /* average Mflop/s, minimum and maximum */
	    raver = (n / tn) * 1.0e-06;
	    if ( tn > 0.0 ){
		ravg[icase][0] = MIN(ravg[icase][0], raver);
		ravg[icase][1] = MAX(ravg[icase][1], raver);
	    }

	    if ( iodet == 0 ){
		fprintf(outf, "%3d %8d %15.6e %15.6f %12.3f %12.3f %10d %15.6e %15.6f\n",
			nsel, n, tn, rinf, xn12, per, ntim, totim, raver);
		fflush(outf);
	    }

	    if ( per == 222.2 ){
		/* If out-of-cache detected */
		/* Restart least squares fit 4 cases further on */
		/* advance case counter, skip two cases to bypass transition */
		nsel1 = nsel + 4;
		if ( nsel1 > nsend )
		    nsel1 = nsend;

		/* re-initialise least-squares fit */
		xn = n;
		lstsq(0, xn, tn, &dum1, &dum2, &dum3);
	    }
	}/*nsel*/

	/* record last values */
	rlast[icase][1] = rinf;
	xnlast[icase][1] = xn12;
	pctmax[icase][1] = per;
/*	printf(" ->pctmax[%d,1] = %g\n", icase, pctmax[icase][1]);*/
    }/*icase*/

    /* PRINT SELECTED VALUES */
    fprintf(outf, "\n\tSUMMARY OF SELECTED VALUES\n");
    fprintf(outf, "\t--------------------------\n");
    fprintf(outf, "   LENGTHS  RMSERR/VALUE  R-INFINITY \tN-HALF  \t  R(N)\n");
    fprintf(outf, "      vlen \t  \t   Mflop/s      vlen\t\tMflop/s\n");

    for( icase = ist ; icase < ncase && icase < casemax ; icase++ ){
	fprintf(outf, "%s\n", label[icase]);
	fprintf(outf, "  <=%6d %10.3g %10.3g  %10.3g  | Min =%10.3g\n",
		lnlast[icase][0], pctmax[icase][0], rlast[icase][0], xnlast[icase][0], ravg[icase][0]);
	fprintf(outf, "  >=%6d %10.3g %10.3g  %10.3g  | Max =%10.3g\n",
		lnlast[icase][1], pctmax[icase][1], rlast[icase][1], xnlast[icase][1], ravg[icase][1]);
    }

    t11 = dwalltime();
    fprintf(outf, "\nTOTAL EXECUTION TIME IS %20.10g SECONDS.\n", t11 - t10);

    fclose(outf);

    printf("Benchmark completed.\n");
}
