      SUBROUTINE DOALL(ICASE,N,TN,NFLOP)
C
C **********************************************************************
C
C     ICASE - CASE NUMBER, INPUT PARAM
C     N     - VECTOR LENGTH
C     TN    - TIME PER VECTOR OPERATION, OUTPUT PARAM
C     NFLOP  - NUMBER OF VECTOR OPS TIMED
C
C ----------------------------------------------------------------------
C
      INTEGER ICASE,N,NFLOP
      REAL*8 TN
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
      INTEGER NNMAX
      PARAMETER(NNMAX=100000)
C
      COMMON /SHDATA/ A(NNMAX),B(NNMAX),C(NNMAX),D(NNMAX)
      REAL*8 A,B,C,D
C
      COMMON /PARM/ IOUT,NMAX,T0,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      INTEGER IOUT,NMAX,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      REAL*8 T0
C
      INTEGER I
      REAL*8 S,S0,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,
     &                 T1,T2,T10,T11,TS
C
C  inserted to avoid compiler warning of 'not used'
C
        T10=0.0
        T11=0.0
C
        IF (N .EQ. 0) RETURN
C
        NTIM=1
C
C  Measure overhead
          T1 = DWALLTIME00()
          T2 = DWALLTIME00()
          T0=T2-T1
C
C  Time loop for one  CPU only
C
         S0=3.12
         S1=2.13
         S2=1.65
         S3=8.32
         S4=1.76
         S5=3.09
         S6=1.82
         S7=2.41
         S8=3.69
         S9=4.11
         S10=8.51
         S11=1.66
C
C  Flush cache with other stuff
C
         DO 1000 I=1,NMAX
           C(I)=3.14*D(I)
 1000    CONTINUE
C
         IF (NFLOP .EQ. 2) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1)
C$OMP DO
         DO 110 I=1,N
           A(I)=S0+B(I)*S1
  110    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 4) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2)
C$OMP DO
         DO 210 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*S2)
  210    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 6) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3)
C$OMP DO
         DO 310 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*S3))
  310    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 8) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4)
C$OMP DO
         DO 410 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)*S4)))
  410    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 10) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5)
C$OMP DO
         DO 510 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*S5
     2                             ))))
  510    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 12) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5, S6)
C$OMP DO
         DO 610 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*S6
     2                             )))))
  610    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 14) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5, S6, S7)
C$OMP DO
         DO 1210 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *S7
     2                             ))))))
 1210    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 16) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5, S6, S7, S8)
C$OMP DO
         DO 1810 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*S8
     2                             )))))))
 1810    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 18) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5, S6, S7, S8, S9)
C$OMP DO
         DO 2410 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*(S8+B(I)*S9
     2                             ))))))))
 2410    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
         ELSEIF (NFLOP .EQ. 20) THEN
C
         T1 = DWALLTIME00()
C
C$OMP PARALLEL FIRSTPRIVATE(S0, S1, S2, S3, S4, S5, S6, S7, S8, S9, S10)
C$OMP DO
         DO 3010 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*(S8+B(I)*(S9+B(I)
     1                 *S10
     2                             )))))))))
 3010    CONTINUE
C$OMP END PARALLEL
C
         T2 = DWALLTIME00()
C
C   end if NFLOP alternatives
        ENDIF
C
C  Total flops in loop, S
        S=N*NFLOP
C  Average loop time, TS 
        TS=T2-T1-T0
C  Convert to time per vector operation
        TN=TS/FLOAT(NFLOP)
C
        RETURN
        END
