/* C version 'poly1' in Parkbench */

#include <stdio.h>


#define NITER 100000	/* number of iterations(repeats) to aid timing */
#define NNMAX 10000	/* maximum length of arrays */

extern double dwalltime00();

double a[NNMAX], b[NNMAX], c[NNMAX], d[NNMAX];
int  ntim, ntimes;

char name[] = "POLY1";

main()
{
    int  nmax, kfsel, np, nrept, nsel;
    int  i, icase, mref, n, ncase, nflop;
    double  fhalf, frat[50], per, rhat, rinf, rlast[50], rmflps;
    double  s12, st0, stime, t0, t1, t2, t10, t11, tn, totime;
    double  xn, xn12, xnlast[50], x, y;
    FILE  *ofp;

    ntimes = 1000000;
    ncase = 1;
    nmax = 10000;
    nrept = NITER;

    ofp = fopen("poly1.res", "w");
    rewind(ofp);

    header(ofp, name);

    printf("\n\tPOLY1:  In-cache Test\n\t---------------------\n\n");
    printf(" This benchmark tests severity of memory bottlenecks\n");
    printf(" by varying the amount of arithmetic per memory reference\n");
    printf(" which is called the computational intensity of the loop.\n\n");
    printf(" The performance for long loop (vector) lengths, RINF, is\n");
    printf(" represented as :\n\n");
    printf("\t\tRINF = RHAT/(1 + FHALF/F)\n\n");
    printf(" where   RHAT = peak Mflop/s rate of arithmetic pipeline\n");
    printf("\t\tapproached as F goes to infinity\n");
    printf("   and\t    F = computational intensity\n");
    printf("\t      = ratio floating operations/memory references\n");
    printf("\tFHALF = F required to obtain RINF=RHAT/2\n\n");
    printf(" The loop executed is polynomial evaluation by Horners rule,\n");
    printf(" F varies as the order increases from 1 to 10.\n");
    printf("\t---------------------\n\n\n");
    printf("The calculation is in progress.  Please, wait...\n\n");

	/* initialize timer */
    t0 = 0.0;
    t1 = 0.0;
    t2 = 0.0;

    satime();
    t10 = dwalltime00();

	/* initialize arrays: */
    for( i = 0 ; i < nmax ; i++ ){
	a[i] = 5.842 * i;
	b[i] = 3.9675 * i;
	c[i] = 4.5693 / i;
	d[i] = 3.3671 / i;
    }

    icase = 1;
    np = 1;

    fprintf(ofp, "\n\t-------------------------------\n");
    fprintf(ofp, "\tPOLY1: FHALF and RHAT In-cache\n");
    fprintf(ofp, "\t-------------------------------\n");
    fprintf(ofp, "\t\tResult Summary\n\t\t--------------\n\n");
    fprintf(ofp, "\tNumber of processes = %6d\n", np);
    fprintf(ofp, "\t-------------------------------\n");

	/* Polynomial Evaluation by Horners Rule */

    fprintf(ofp, "   POLYNOMIALS :  A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*S3))\n");
    fprintf(ofp, "   ICASE=%4d   NCASE=%4d   NMAX=%6d   ", icase, ncase, nmax);
    fprintf(ofp, "NTIMES=%8d      NP=%4d\n", ntimes, np);

    for( kfsel = 1 ; kfsel < 11 ; kfsel++ ){
	nflop = kfsel*2;

	mref = 2;
	frat[kfsel] = nflop / mref;

	fprintf(ofp, "\n\n COMPUTATIONAL INTENSITY = flop per mem ref  %g.\n", frat[kfsel]);
	fprintf(ofp, " ------------------------------------------\n\n");
	fprintf(ofp, "Floating operations per iteration =%4d\n\n", nflop);
	fprintf(ofp, "Memory references   per iteration =%4d\n\n\n", mref);

	/* initialize least squares */
	lstsq(0, xn, tn, &rinf, &xn12, &per);

	fprintf(ofp, "  LOOP       LOOP        RINF        N1/2       S1/2     ERROR    R-AVERAGE      T0      NTIM\n");
	fprintf(ofp, " LENGTH      SECS       MFLOP/S    VEC.LEN      FLOP       %%\t   MFLOP/S      SECS    repeat\n");

	for( nsel = 1 ; nsel < 13 ; nsel++ ){
	    /* select vector length */
	    switch(nsel){
	    case 1: n = 1; break;
	    case 2: n = 5; break;
	    case 3: n = 10; break;
	    case 4: n = 20; break;
	    case 5: n = 50; break;
	    case 6: n = 100; break;
	    case 7: n = 200; break;
	    case 8: n = 300; break;
	    case 9: n = 400; break;
	    case 10: n = 600; break;
	    case 11: n = 800; break;
	    case 12: n = 1000; break;
	    default:
		n = nmax + 1; printf("illegal nsel.\n");
		break;
	    }
	    if ( n > nmax )
		continue;
		/* time vector operation */
	    doall(icase, n, &tn, nflop);

	    /* escape if vector too long */
	    if ( n == 0 )
		continue;

	    /* update least squares */
	    xn = n;
	    lstsq(1, xn, tn, &rinf, &xn12, &per);

	    /* convert to Mflop/s */
	    rinf = rinf*1.0e-6;

	    /* average Mflop/s */
	    rmflps = n / tn * 1.0e-6;
	    /* sflop = nflop * n; */
	    s12 = nflop * xn12;
	    stime = nflop * tn;
	    st0 = 0.0;
	    if ( rinf != 0.0 )
		st0 = (s12 / rinf)*1.0e-6;
	    if ( nsel == 1 )
		st0 = stime;

	    fprintf(ofp, " %6d %11.3E %11.6f %10.3f %12.3E %6.2f %11.6f %11.3E %7d\n",
			n, stime, rinf, xn12, s12, per, rmflps, st0, ntim);
	}

	rlast[kfsel] = rinf;
	xnlast[kfsel] = xn12;
    }/*kfsel*/

	/* Work out f-half *//* initialize least squares - first */
    lstsq(0, x, y, &rhat, &fhalf, &per);

    fprintf(ofp, "\n\tCALCULATION OF FHALF\n\t--------------------\n\n");
    fprintf(ofp, "   F         RINF         RHAT      FHALF    ERROR\n");
    fprintf(ofp, "  f/m      Fflop/s      Fflop/s   flop/mref    %%\n");

    for( kfsel = 1 ; kfsel < 11 ; kfsel++ ){
	y = frat[kfsel] / rlast[kfsel];
	x = frat[kfsel];
	/* update least squares*/
	lstsq(1, x, y, &rhat, &fhalf, &per);

	fprintf(ofp, " %4.1f %12.6f %12.6f %9.4f %7.2f\n", frat[kfsel], rlast[kfsel], rhat, fhalf, per);
    }

    fprintf(ofp, "\n\n\n\t   LAST VALUES :    RHAT = %12.6f Mflop/s\n\n", rhat);
    fprintf(ofp, "\t\t\t   FHALF = %12.4f flop/mref\n\n", fhalf);

    t11 = dwalltime00();

    totime = t11 - t10;
    fprintf(ofp, "\tTOTAL EXECUTION TIME IS %20.10E SECONDS.\n", totime);

    fclose(ofp);

    printf("Benchmark completed.\n");
}
