/* doall(): poly1 function in Parkbench */

#define NNMAX 10000

extern double dwalltime00();
extern double a[NNMAX], b[NNMAX];
extern int  ntim, ntimes;

/*
 * icase: case number, Input param,
 * n: vector length
 * tn: time per vector operation, Output param,
 * nflop: number of vector ops timed
 */
doall(icase, n, tn, nflop)
    int icase, n, nflop;
    double *tn;
{
    int  i, j, jt;
    double  s, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;
    double  t0, t1, t2, t10, t11, ts;

	/* select repeat */
    ntim = ntimes / (nflop*n);
    if ( ntim < 1 )
	ntim = 1;

	/* inserted to avoid compiler warning of 'not used' */
    t10 = 0.0; t11 = 0.0;

    if ( n == 0 )
	return;

	/* Measure overhead */
    t1 = dwalltime00();
    for( jt = 0 ; jt < ntim ; jt++ ){
	dummy(jt);
    }
    t2 = dwalltime00();
    t0 = t2 - t1;

	/* Time loop for one  CPU only */
    s0 = 3.12;
    s1 = 2.13;
    s2 = 1.65;
    s3 = 8.32;
    s4 = 1.76;
    s5 = 3.09;
    s6 = 1.82;
    s7 = 2.41;
    s8 = 3.69;
    s9 = 4.11;
    s10 = 8.51;
    s11 = 1.66;

    switch(nflop){
    case 2:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*s1;
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 4:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*s2);
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 6:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*s3));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 8:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*s4)));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 10:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*s5))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 12:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5, s6)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*(s5 + b[i]*s6)))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 14:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5, s6, s7)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*(s5 + b[i]*(s6 + b[i]*s7))))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 16:
	t1 = dwalltime00();
	{
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5, s6, s7, s8)
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*(s5 + b[i]*(s6 + b[i]*(s7 + b[i]*s8)))))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 18:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5, s6, s7, s8, s9)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*(s5 + b[i]*(s6 + b[i]*(s7 + b[i]*(s8 + b[i]*s9))))))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    case 20:
	t1 = dwalltime00();
#pragma omp parallel private(jt) firstprivate(s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10)
	{
	for( jt = 0 ; jt < ntim ; jt++ ){
	    dummy(jt);
#pragma omp for
	    for( i = 0 ; i < n ; i++ ){
		a[i] = s0 + b[i]*(s1 + b[i]*(s2 + b[i]*(s3 + b[i]*(s4 + b[i]*(s5 + b[i]*(s6 + b[i]*(s7 + b[i]*(s8 + b[i]*(s9 + b[i]*s10)))))))));
	    }
	}
	}
	t2 = dwalltime00();
	break;
    default:
	printf("illegal arg\n");
	break;
    }

	/* Total flops in loop, S */
    s = n * nflop;
	/* Average loop time, TS */
    ts = ((t2 - t1) - t0) / ntim;
	/* Convert to time per vector operation */
    *tn = ts / nflop;
}
