      SUBROUTINE launch(NAME, GROUP, iounit, infile, MAXNOD,
     &                  NNODES, ME, MYTID, TIDS)

c     ==================== 
c     This subroutine launches all precesses (if necessary)
c     and distributes the variables NNODES, ME, MYTID, TIDS
c     ==================== 

      INCLUDE  'fpvm3.h'
      INCLUDE  'dattyp.inc'

C     /* Program name */
      CHARACTER*10  NAME 

C     /* Timer  routines */
      EXTERNAL  DWALLTIME00
      REAL*8  DWALLTIME00


      CHARACTER*6  GROUP   
      INTEGER  GID, GSIZE

      CHARACTER*20  infile
      INTEGER  iounit

      INTEGER  MAXNOD, NNODES, ME, MYTID, TIDS(0:MAXNOD)

C     Timeout in sec for establishing the group (if spawnit=0)
      REAL*8  LIMIT
      DATA LIMIT /10.0/
      INTEGER  INFO, INUM, MASTID

      REAL*8  T0, T1


C     ======================
C     Register process to PVM.

      CALL PVMFMYTID( MYTID )
      IF( MYTID .LT. 0 ) Then
         PRINT *,' MYTID failed, MYTID <0, MYTID=',MYTID
         PRINT *,' Please check if pvmd is running!'
         stop
      endif
      CALL PVMFJOINGROUP(GROUP,INUM)
      IF( INUM .LT. 0 ) PRINT *,' joingroup error, INUM <0, INUM=',INUM


C     ======================
C     "Spawning section"

      IF( INUM .EQ. 0 ) THEN  

         OPEN( UNIT=iounit, FILE=infile, STATUS='OLD' )
         READ( iounit,FMT = * ) NNODES
         PRINT *,'Number of nodes =',NNODES
         CLOSE( iounit )

	 TIDS(0) = MYTID
	 TIDS(NNODES) = MYTID

         Write(6,*) 'Front End System (1=yes, 0=no) =',MASTER
         Write(6,*) 'Spawning done by process (1=yes, 0=no) =',SPAWNIT

         if ( SPAWNIT .eq. 1 ) then

C     Collect the output from children (if spawnit =1! only)
c            CALL PVMFCATCHOUT( 1, INFO )
C            IF ( INFO .lt. 0 ) write (6,*) ' Catchout failed '

C     Spawn PVM node processes

            CALL PVMFSPAWN(NAME, PVMDEFAULT,'*',NNODES-1+MASTER,
     &                     TIDS(1-MASTER),INFO)            
            IF (INFO .LT. 0) THEN
               PRINT *,' pvmspawn error, INFO < 0, INFO = ',INFO
               STOP
            ENDIF
C
            PRINT *, 'Spawned ', INFO,  ' processes OK...'

         else

C        Collect TIDS from other processes assuming they are spawned!
C        The problem behind this is, that the value of nnodes 
C        is unknown for processes with (inum .ne. 0)
C        So we just try LIMIT sec and quit then

            T0 = DWALLTIME00()
 10         CONTINUE      
            CALL PVMFGSIZE(GROUP,GSIZE)
            IF (INFO .LT. 0) THEN
               PRINT *,' PVM_GSIZE error, INFO < 0, INFO = ',INFO
               CALL PVMFLVGROUP(GROUP,INFO)
               CALL PVMFEXIT(INFO)
               STOP
            ENDIF
            if ( GSIZE .ne. NNODES+MASTER ) THEN
               T1 = DWALLTIME00()
               if ( T1-T0 .gt. LIMIT) Then
                  WRITE (6,*) 'Not all processes spawned yet '
     &                   ,GSIZE,' instead of ', NNODES+Master
                  CALL PVMFLVGROUP(GROUP,INFO)
                  CALL PVMFEXIT(INFO)
                  STOP
               endif
               GOTO 10
            endif

            DO 100 GID=MASTER,NNODES-1+MASTER   
               CALL PVMFGETTID(GROUP, GID, TIDS(GID-MASTER))
               IF (INFO .LT. 0) THEN
                  PRINT *,' pvmgettid error, INFO < 0, INFO = ',INFO
                  CALL PVMFLVGROUP(GROUP,INFO)
                  CALL PVMFEXIT(INFO)
                  STOP
               ENDIF
 100        CONTINUE
            PRINT *, 'Spawned ', GSIZE,  ' processes OK...'

         ENDIF
      ENDIF

C     ======================
C     We now send the  TIDS out and calculate ME

      IF( INUM .EQ. 0 ) THEN  

C     /* Send number of nodes to each node */
C     /* Send all processor ids to each node */

         CALL PVMFINITSEND(PVMDEFAULT,INFO )
         CALL PVMFPACK(ITYPE,NNODES,1,1,INFO)
         CALL PVMFPACK(ITYPE,TIDS,NNODES,1,INFO)
         CALL PVMFMCAST(NNODES,TIDS,0,INFO)

         if ( master .eq. 0 ) then
           ME = 0
         else
           ME = NNODES
         endif

         PRINT *,'TIDs sent...benchmark progressing...'

      ELSE

         CALL PVMFGETTID(GROUP, 0, MASTID)
         IF (MASTID .LT. 0) THEN
            PRINT *,' pvmgettid error, MASTID < 0, MASTID = ',MASTID
            CALL PVMFLVGROUP(GROUP,INFO)
            CALL PVMFEXIT(INFO)
            STOP
         ENDIF

         CALL PVMFRECV(MASTID,0,INFO)
         CALL PVMFUNPACK(ITYPE,NNODES,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,TIDS,NNODES,1,INFO)
C
C        /* Define who I am */
C
         ME = NNODES
         DO 200 GID=0,NNODES-1
            IF( MYTID.EQ.TIDS(GID) ) ME = GID
 200     CONTINUE

      ENDIF


C     ======================
C     Now the group should be established
C     /* Global synchronisation as final check */

      CALL PVMFBARRIER(GROUP,NNODES+MASTER,INFO)
      IF( INFO.LT.0 ) PRINT *,'ERROR: pvmfbarrier returned ',INFO  

C     /* "front end" process can quit now  */

      IF( ME .EQ. NNODES ) THEN
         CALL PVMFLVGROUP(GROUP,INFO)
         CALL PVMFEXIT(INFO)
         STOP
      ENDIF

      RETURN
      END
