      PROGRAM COMMS2
C
      INCLUDE 'mpif.h'
      INCLUDE 'dattyp.inc.MPI'
      INCLUDE 'comms2.inc'

C     =================================================
C     ===                                           ===
C     ===   Program:  Message Pingpong              ===
C     ===   Version:  MPI  + Fortran 77             ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME
      DATA NAME /'comms2_mpi'/


C     /* Timer routine */
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
C     Variables:
C
      CHARACTER*6 GROUP
      DATA GROUP /'comms2'/
      INTEGER I, ierr, my_rank, status(MPI_STATUS_SIZE)
C     /* Maximum message length and unit number of output file */
      INTEGER NMAX, NW1
      PARAMETER(NMAX=MAXLEN/IDPLEN, NW1=11)
C     /* Logical unit number for message length defining file */
      INTEGER IOLDEF
      PARAMETER(IOLDEF=10)
      CHARACTER*20  INFILE
      DATA INFILE /'comms2.dat'/
C     /* Number of processes, slave process, max length of short messages */
      INTEGER NP,NSLAVE,NSBYTE
C     /* Number of test cases, their lengths, and current case */
      INTEGER NTESTS, LEN(MAXTST), ILEN
      INTEGER NCASE, NREPT
C     /* Ignore zero length messages in least squares fitting? */
      LOGICAL USE0
C     /* Measurement time for each test case and estimated loop overhead */
      REAL*8 MTIME, EOVER
C     /* Estimated R-infinity and startup time */
      REAL*8 ERINF, ESTART
C     /* TN is measured average time to send message of length XN */
      REAL*8 XN, TN, RINF, XN12, PER
C     /* Timer overhead, start time and stop time */
      REAL*8 T0, T1, T2, T3, T4, T5, T6
C     /* Array to send to the slave + checker value*/
      REAL*8 A(NMAX), B(NMAX), DVAL
      REAL*8 RMBPS(2),XNHALF(2),TSTART(2)


C     Initialize MPI.
C
      CALL MPI_INIT( ierr )
      IF( ierr.NE.MPI_SUCCESS )
     &   PRINT *,'ERROR: MPI_INIT returned ', ierr
C
      CALL MPI_COMM_RANK(MPI_COMM_WORLD, my_rank, ierr)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, NP, ierr)
C
      IF( my_rank.EQ.0 )THEN

         CALL GETOPT(IOLDEF,INFILE,NP,NSLAVE,NSBYTE,USE0,MTIME,
     &        MAXLEN,ierr)
         IF( ierr.LT.0 )THEN
            CALL MPI_FINALIZE(ierr)
            STOP
         ENDIF

         CALL GETLEN(IOLDEF, INFILE, LEN, NTESTS, MAXLEN, MAXTST)
         IF (NSBYTE .NE. 0) CALL ADDLEN(LEN, NTESTS, NSBYTE, MAXTST)


C       /* Broadcast NSLAVE to each process */
        CALL MPI_BCAST(NSLAVE,1,MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
C       /* Send remaining parameters to the slave process */
        CALL MPI_SEND(NSBYTE,1,MPI_INTEGER,NSLAVE,1,MPI_COMM_WORLD,ierr)
        CALL MPI_SEND(NTESTS,1,MPI_INTEGER,NSLAVE,2,MPI_COMM_WORLD,ierr)
        CALL MPI_SEND(USE0,1,MPI_LOGICAL,NSLAVE,3,MPI_COMM_WORLD,ierr)
        CALL MPI_SEND(LEN,NTESTS,MPI_INTEGER,NSLAVE,4,MPI_COMM_WORLD,
     &                ierr)
        CALL MPI_SEND(MTIME,1,MPI_DOUBLE_PRECISION,NSLAVE,5,
     &                MPI_COMM_WORLD,ierr)
C
        PRINT *,'Parameters sent to slave. Benchmark progressing...'
C
      ELSE
C       /* All slaves receive NSLAVE from master */
        CALL MPI_BCAST(NSLAVE,1,MPI_INTEGER,0,MPI_COMM_WORLD,ierr)
C			              
        IF( my_rank.EQ.NSLAVE )THEN
C
C         /* Receive remaining parameters from master */
C
          CALL MPI_RECV(NSBYTE,1,MPI_INTEGER,0,1,MPI_COMM_WORLD,
     &                  status,ierr)
          CALL MPI_RECV(NTESTS,1,MPI_INTEGER,0,2,MPI_COMM_WORLD,
     &                  status,ierr)
          CALL MPI_RECV(USE0,1,MPI_LOGICAL,0,3,MPI_COMM_WORLD,
     &                  status,ierr)
          CALL MPI_RECV(LEN,NTESTS,MPI_INTEGER,0,4,MPI_COMM_WORLD,
     &                  status,ierr)
          CALL MPI_RECV(MTIME,1,MPI_DOUBLE_PRECISION,0,5,MPI_COMM_WORLD,
     &                  status,ierr)
        ENDIF
C
      ENDIF
C
      IF( my_rank.EQ.0 )THEN
C
C        /* Initialize least squares fit */
C
         CALL LSTSQ(0,XN,TN,RINF,XN12,PER)
C
C        /* Call the timer routine to make sure it's initialised */
C
         T1 = DWALLTIME00()
         PRINT *,'Estimating loop overhead...'
         CALL ESTOV(EOVER,MTIME)
         PRINT *,'Estimated loop overhead = ',EOVER,' seconds'
         PRINT *
         PRINT *,'Estimating communication parameters...'
      ENDIF
C
        CALL ESTCOM(ERINF,ESTART,EOVER,MTIME,my_rank,0,NSLAVE,A)
C
      IF( my_rank.EQ.0 )THEN
         PRINT *,'Estimated R-infinity    = ',ERINF/1.0E6,' Mbyte/s'
         PRINT *,'Estimated start up time = ',ESTART,' seconds'
         PRINT *
      ENDIF
C
C     /* Global synchronisation */
C
      CALL MPI_BARRIER( MPI_COMM_WORLD, ierr )
      IF( ierr.NE.MPI_SUCCESS )
     &    PRINT *,'ERROR: MPI_BARRIER returned ', ierr
C
      IF( my_rank.EQ.0 )THEN
         OPEN(NW1,FILE='comms2.res')
C
C        /* Print header */
C
         CALL HEADER(NW1,NAME)
         WRITE(NW1,981) MTIME
  981    FORMAT(' The measurement time requested for each test',
     &         ' case was ',1P,E9.2,' seconds.')
         IF( NSBYTE.NE.0 )THEN
            WRITE(NW1,995) NSBYTE
  995       FORMAT(/,' SHORT MESSAGES  <= ',I6,'B (B=Byte)')
         ELSE
            WRITE(NW1,980)
  980       FORMAT(/,' No distinction was made between ',
     &             'long and short messages.')
         ENDIF
         IF( USE0 )THEN
            WRITE(NW1,982)
  982       FORMAT(/,' Zero length messages were used in',
     &             ' least squares fitting.')
         ELSE
            WRITE(NW1,983)
  983       FORMAT(/,' Zero length messages were not used in',
     &             ' least squares fitting.')
         ENDIF
         WRITE(NW1,998)
  998    FORMAT(/,2X,'  Case  LENGTH(B)   TIME(sec)   RINF(B/s)',
     &         '    N1/2(B)    %error fit  ')
      ENDIF
C
C     /* Copy DVAL into send/recv buffer  A */
C
      DVAL = 2.0D0
      CALL DCOPY(NMAX, DVAL, A, 1)
      CALL DCOPY(NMAX, DVAL, B, 1)
C
      DO 50 NCASE = 1,NTESTS
C
         ILEN = LEN(NCASE)
C
C        /* Decide how many iterations - at least one! */
C
         NREPT = MAX(INT(MTIME/(ESTART + ILEN/ERINF)/2), 1)
C
C        Master code...
C
         IF( my_rank.EQ.0 )THEN
C
C           /* I'm the master */
C
            WRITE(*,100) NCASE,ILEN
  100       FORMAT ('Case ',I3,', length ',I7,' bytes')
C
C           /* Measure timing overhead, T0 */
C
            CALL TOVER(T0,EOVER,MTIME)
            T1 = DWALLTIME00()
C
            DO 20 I = 1,NREPT
               CALL DUMMY(I)
C
C              /* SEND buffer A and RECV buffer B */
C
               CALL MPI_SENDRECV(A,ILEN,MPI_BYTE,NSLAVE,10,
     &              B,ILEN,MPI_BYTE,NSLAVE,20,
     &              MPI_COMM_WORLD,status,ierr)
C
C              /* Check that buffer B contains DVAL */
C              /* no data to check in zero length message */
C
               T2 = DWALLTIME00()
               IF( ILEN.NE.0 )
     &            CALL CHECK(B, ILEN/IDPLEN, DVAL)
               T3 = DWALLTIME00()
C
C              /* SEND buffer A and RECV buffer B */
C
               CALL MPI_SENDRECV(A,ILEN,MPI_BYTE,NSLAVE,10,
     &              B,ILEN,MPI_BYTE,NSLAVE,20,
     &              MPI_COMM_WORLD,status,ierr)
C
C              /* Check that buffer B contains DVAL */
C              /* no data to check in zero length message */
C
               T4 = DWALLTIME00()
               IF( ILEN.NE.0 )
     &            CALL CHECK(B, ILEN/IDPLEN, DVAL)
               T5 = DWALLTIME00()
C
   20       CONTINUE
            T6 = DWALLTIME00()
C
C           T0 = loop overhead time
C           T1 = start time
C           T3 - T2 = CHECK time
C           T5 - T4 = CHECK time
C           T6 = finish time, 
C
C           /* Divide by 2 because a message goes there and back */
C	
            TN =(T6 - T1 - (((T5-T4)+(T3-T2) + T0) * NREPT))/(NREPT*2)   
            WRITE(*,101) TN, FLOAT(NREPT),(2*ILEN/(TN*1000000.0))
  101       FORMAT(1P,E9.3,' sec/message, in ',E8.2,' iterations (',
     &             E8.2,' Mbytes/s)'/)
C
C           /* Update least squares fit */
C
C           /* Use twice the message length because two messages */
C           /* are sent, one in each direction */
C
            XN = 2*ILEN
            IF( ILEN.GT.0 .OR. USE0 )
     &         CALL LSTSQ(1,XN,TN,RINF,XN12,PER)
C
C           /* Write latest values */
C
            WRITE(NW1,999) NCASE,ILEN,TN,RINF,XN12,PER
  999       FORMAT(1X,I6,I9,3X,4(1PE12.3))
            IF( ILEN.EQ.NSBYTE .AND. NSBYTE.NE.0 )THEN
C
C              /* store short message result */
C
               RMBPS(1)=RINF*1.0E-06
               XNHALF(1)=XN12
               TSTART(1)=XNHALF(1)/RMBPS(1)
C
C              /* reset when changing to long messages */
C
               CALL LSTSQ(0,XN,TN,RINF,XN12,PER)
               WRITE(NW1,994) NSBYTE
  994          FORMAT(/,' LONG MESSAGES  > ',I6,'B (B=Byte)')
               WRITE(NW1,998)
            ENDIF
C
C        Slave code... Take a message of ILEN bytes and reflect it to master.
C                      Twice!
C
         ELSEIF( my_rank.EQ.NSLAVE )THEN
            DO 30 I = 1,NREPT
               CALL MPI_SENDRECV(A,ILEN,MPI_BYTE,0,20,
     &              B,ILEN,MPI_BYTE,0,10,
     &              MPI_COMM_WORLD,status,ierr)
C
               CALL MPI_SENDRECV(A,ILEN,MPI_BYTE,0,20,
     &              B,ILEN,MPI_BYTE,0,10,
     &              MPI_COMM_WORLD,status,ierr)
   30       CONTINUE
         ENDIF
 50   CONTINUE
C
C     /* Print result summary */
C
      IF( my_rank.EQ.0 )THEN
C
C        /* Store long message result */
C
         RMBPS(2)=RINF*1.0E-06
         XNHALF(2)=XN12
         TSTART(2)=XNHALF(2)/RMBPS(2)
C
C
C
         WRITE(NW1,990)
  990    FORMAT(/,22X,'------------------------',/,
     &           22X,'COMMS2: Message Exchange',/,
     &           22X,'------------------------',/,
     &           22X,'     Result Summmary    ',/,
     &           22X,'     ---------------    ',/)
         IF( NSBYTE.EQ.0 )THEN
            WRITE(NW1,996) RMBPS(2),XNHALF(2),TSTART(2)
  996       FORMAT(' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',/)
         ELSE
            WRITE(NW1,997) NSBYTE,RMBPS(1),XNHALF(1),TSTART(1),
     &                 NSBYTE,RMBPS(2),XNHALF(2),TSTART(2)
  997       FORMAT(' Short Messages, <= ',I4,' Byte',/,
     &           ' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',//,
     &           ' Long Messages, > ',I4,' Byte',/,
     &           ' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',/)
         ENDIF
C
         CLOSE(NW1)
C
         PRINT *,'Benchmark completed.'
C
      ENDIF
C
C     Program finished. Leave MPI before exiting
C
      CALL MPI_FINALIZE(ierr)
      STOP
      END
