/* getopt(): */

#include <stdio.h>

#define MAXLINE  1024

/* 1st arg('int iounit') is deleted, and function name is changed */
pbgetopt(char *infile, int np, int *nslave, int nsbyte, int use0, double mtime, int maxlen, int *info)
{
    FILE  *fp;
    char  line[MAXLINE];

    printf("\n\tGeneral Pingpong Test\n");
    printf("\t---------------------\n\n");
    printf("Number of processes = %d\n", np);
    *info = 0;

    fp = fopen(infile, "rw");
    getline(fp, line);
    getline(fp, line);
    sscanf(line, "%d", nslave);

    if ( np == 2 )
	*nslave = 1;
    else{
	printf("\nThe master process, number 0, communicates with a\n");
	printf("slave with a number in the range 1 to %d.\n", np-1);
	printf("Number 1 is the nearest neighbour.\n");
	if ( *nslave < 1 || *nslave > np-1 ){
	    printf("The slave process value is invalid.\n");
	    printf("Try again:  1 <= slave number <= %d\n", np-1);
	    *info = -1;
	    return;
	}
    }

    printf("Slave number = %d\n\n", nslave);
    printf("On some systems short and long messages are treated differently.\n");

    sscanf(line, "%d", &nsbyte);
    if ( nsbyte < 0 || nsbyte > maxlen ){
	printf("The number of bytes value %d is invalid.\n", nsbyte);
	printf("Try again: 0 <= short message length <= %d\n", maxlen);
	*info = -1;
    }
    if ( nsbyte != 0 )
	printf("The longest short message is %d bytes.\n", nsbyte);
    else
	printf("No distinction will be made between long and short messages.\n");

    sscanf(line, "%d", &use0);
    if ( use0 > 0 )
	printf("Zero length messages will be used in least squares fitting.\n");
    else
	printf("Zero length messages will be ignored in least squares fitting.\n");

    sscanf(line, "%f", &mtime);
    printf("Loop overhead and communication time are both measured\n");
    printf("per test case, so run time is twice the measured time.\n\n");
    printf("Run time per test case is approx %E seconds.\n\n", mtime*2);

    fclose(fp);
}
