/* getlen(): */

#include <stdio.h>

#define MAXLINE 1024

int getline(FILE *fp, char *line)
{
/* read line */
}

/* 1st arg[int iounit] is deleted in C */
getlen(char * infile, int *len, int ntests, int maxlen, int maxtst)
{
    FILE *fp;
    char  line[MAXLINE];
    int  i, length;

    fp = fopen(infile, "rw");
    rewind(fp);

    length = fgetline(fp, line);
    for( ntests = 0, i = 0 ; length > 0 ; i++, length = fgetline(fp, line) ){
	/* Skip over first five lines of input file. */
	if ( i < 5 )
	    continue;

	if ( ntests < maxtst ){
	    if ( length <= maxlen ){
		len[ntests] = length;
		ntests += 1;
	    }
	    else{
		printf("              ** WARNING **\n");
		printf("Message length of ',LENGTH,' specified in file\n");
		printf("%s is longer than the allowed maximum of\n", infile);
		printf("%d and will be ignored.  Edit value of\n", maxlen);
		printf("MAXLEN and recompile to allow longer messages.\n\n");
	    }
	    continue;
	}
	else{
	    printf("              ** WARNING **\n");
	    printf("More than %d test cases in %s\n", maxtst, infile);
	    printf("Extra cases ignored. Edit value of MAXTST and\n");
	    printf("recompile to allow more cases.\n\n");
	    continue;
	}
    }

    fclose(fp);
}
