      SUBROUTINE PDELSET2( ALPHA, A, IA, JA, DESCA, BETA )
*
*  -- ScaLAPACK tools routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IA, JA
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose
*  =======
*
*  PDELSET2 sets alpha to the distributed matrix entry A(IA,JA)
*  and A(IA,JA) to beta.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  ALPHA   (local output) DOUBLE PRECISION
*          The scalar alpha.
*
*  A       (local input/local ouput) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A,*) containing
*          the local pieces of the distributed matrix A.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  BETA    (local input) DOUBLE PRECISION
*          The scalar beta.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            IACOL, IAROW, IIA, IOFFA, JJA, MYCOL, MYROW,
     $                   NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      CALL BLACS_GRIDINFO( DESCA( 7 ), NPROW, NPCOL, MYROW, MYCOL )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
*
      IF( MYROW.EQ.IAROW .AND. MYCOL.EQ.IACOL ) THEN
         IOFFA = IIA+(JJA-1)*DESCA( 8 )
         ALPHA = A( IOFFA )
         A( IOFFA ) = BETA
      END IF
*
      RETURN
*
*     End of PDELSET2
*
      END
