      INTEGER FUNCTION ILCM( I1, I2 )
*
*  -- ScaLAPACK tools routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            I1, I2
*     ..
*
*  Purpose
*  =======
*
*  ILCM returns the Least Common Multiple of the integers I1 and I2.
*
*  Arguments
*  =========
*
*  I1      (local input) INTEGER
*
*  I2      (local input) INTEGER
*          I1 and I2 specify the integers whose the least common
*          multiple is to be returned.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IMAX, IMIN, KLCM
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
      IF( I1.GE.I2 ) THEN
         IMAX = I1
         IMIN = I2
      ELSE
         IMAX = I2
         IMIN = I1
      ENDIF
*
      KLCM = 0
      DO 10 I = 1, IMIN
         KLCM = KLCM + IMAX
         IF( MOD( KLCM, IMIN ).EQ.0 )
     $      GO TO 20
   10 CONTINUE
*
   20 CONTINUE
*
      ILCM = KLCM
*
      RETURN
*
*     End of ILCM
*
      END
