      SUBROUTINE PDLARFT( DIRECT, STOREV, N, K, V, IV, JV, DESCV, TAU,
     $                    T, WORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          DIRECT, STOREV
      INTEGER            IV, JV, K, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCV( * )
      DOUBLE PRECISION   TAU( * ), T( * ), V( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLARFT forms the triangular factor T of a real block reflector H
*  of order n, which is defined as a product of k elementary reflectors.
*
*  If DIRECT = 'F', H = H(1) H(2) . . . H(k) and T is upper triangular;
*
*  If DIRECT = 'B', H = H(k) . . . H(2) H(1) and T is lower triangular.
*
*  If STOREV = 'C', the vector which defines the elementary reflector
*  H(i) is stored in the i-th column of the distributed matrix V, and
*
*     H  =  I - V * T * V'
*
*  If STOREV = 'R', the vector which defines the elementary reflector
*  H(i) is stored in the i-th row of the distributed matrix V, and
*
*     H  =  I - V' * T * V
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  DIRECT  (global input) CHARACTER*1
*          Specifies the order in which the elementary reflectors are
*          multiplied to form the block reflector:
*          = 'F': H = H(1) H(2) . . . H(k) (Forward)
*          = 'B': H = H(k) . . . H(2) H(1) (Backward)
*
*  STOREV  (global input) CHARACTER*1
*          Specifies how the vectors which define the elementary
*          reflectors are stored (see also Further Details):
*          = 'C': columnwise
*          = 'R': rowwise
*
*  N       (global input) INTEGER
*          The order of the block reflector H. N >= 0.
*
*  K       (global input) INTEGER
*          The order of the triangular factor T (= the number of
*          elementary reflectors). 1 <= K <= MB_V (= NB_V).
*
*  V       (input/output) DOUBLE PRECISION pointer into the local memory
*          to an array of local dimension (LOCp(IV+N-1),LOCq(JV+K-1))
*          if STOREV = 'C', and (LOCp(IV+K-1),LOCq(JV+N-1)) if
*          STOREV = 'R'. The distributed matrix V contains the
*          Householder vectors. See further details.
*
*  IV      (global input) INTEGER
*          V's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JV      (global input) INTEGER
*          V's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCV   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix V.
*
*  TAU     (local input) DOUBLE PRECISION, array, dimension  LOCq(JV) if
*          INCV = 1, and LOCq(JV) otherwise. This array contains the
*          Householder scalars related to the Householder vectors.
*          TAU is tied to the distributed matrix V.
*
*  T       (local output) DOUBLE PRECISION array, dimension (NB_V,NB_V)
*          if STOREV = 'Col', and (MB_V,MB_V) otherwise. It contains
*          the k-by-k triangular factor of the block reflector asso-
*          ciated with V. If DIRECT = 'F', T is upper triangular;
*          if DIRECT = 'B', T is lower triangular.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension K*(K-1)/2.
*
*  Further Details
*  ===============
*
*  The shape of the matrix V and the storage of the vectors which define
*  the H(i) is best illustrated by the following example with n = 5 and
*  k = 3. The elements equal to 1 are not stored; the corresponding
*  array elements are modified but restored on exit. The rest of the
*  array is not used.
*
*  DIRECT = 'F' and STOREV = 'C':   DIRECT = 'F' and STOREV = 'R':
*
*  V( IV:IV+N-1,    (  1       )    V( IV:IV+K-1,    (  1 v1 v1 v1 v1 )
*     JV:JV+K-1 ) = ( v1  1    )       JV:JV+K-1 ) = (     1 v2 v2 v2 )
*                   ( v1 v2  1 )                     (        1 v3 v3 )
*                   ( v1 v2 v3 )
*                   ( v1 v2 v3 )
*
*  DIRECT = 'B' and STOREV = 'C':   DIRECT = 'B' and STOREV = 'R':
*
*  V( IV:IV+N-1,    ( v1 v2 v3 )    V( IV:IV+K-1,    ( v1 v1  1       )
*     JV:JV+K-1 ) = ( v1 v2 v3 )       JV:JV+K-1 ) = ( v2 v2 v2  1    )
*                   (  1 v2 v3 )                     ( v3 v3 v3 v3  1 )
*                   (     1 v3 )
*                   (        1 )
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            FORWARD
      INTEGER            ICOFF, ICTXT, II, IIV, IROFF, IVCOL, IVROW,
     $                   ITMP0, ITMP1, IW, JJ, JJV, LDV, MICOL, MIROW,
     $                   MYCOL, MYROW, NP, NPCOL, NPROW, NQ
      DOUBLE PRECISION   VII
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DCOPY, DGEMV, DGSUM2D,
     $                   DLASET, DTRMV, INFOG2L
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2P, NUMROC
      EXTERNAL           INDXG2P, LSAME, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 .OR. K.LE.0 )
     $   RETURN
*
      ICTXT = DESCV( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      FORWARD = LSAME( DIRECT, 'F' )
      CALL INFOG2L( IV, JV, DESCV, NPROW, NPCOL, MYROW, MYCOL,
     $              IIV, JJV, IVROW, IVCOL )
*
      IF( LSAME( STOREV, 'C' ) .AND. MYCOL.EQ.IVCOL ) THEN
*
         IW = 1
         LDV = DESCV( 8 )
         IROFF = MOD( IV-1, DESCV( 3 ) )
*
         IF( FORWARD ) THEN
*
*           DIRECT = 'Forward', STOREV = 'Columnwise'
*
            NP = NUMROC( N+IROFF, DESCV( 3 ), MYROW, IVROW, NPROW )
            IF( MYROW.EQ.IVROW ) THEN
               NP = NP - IROFF
               II = IIV  + 1
            ELSE
               II = IIV
            END IF
            IF( IROFF+1.EQ.DESCV( 3 ) ) THEN
               MIROW = MOD( IVROW+1, NPROW )
            ELSE
               MIROW = IVROW
            END IF
            ITMP0 = 0
*
            DO 10 JJ = JJV+1, JJV+K-1
*
               IF( MYROW.EQ.MIROW ) THEN
                  VII = V( II+(JJ-1)*LDV )
                  V( II+(JJ-1)*LDV ) = ONE
               END IF
*
*              T(1:i-1,i) := V(i:n,1:i-1)' * V(i:n,i)
*
               ITMP0 = ITMP0 + 1
               IF( NP-II+IIV.GT.0 ) THEN
                  CALL DGEMV( 'Transpose', NP-II+IIV, ITMP0,
     $                        -TAU( JJ ), V( II+(JJV-1)*LDV ), LDV,
     $                        V( II+(JJ-1)*LDV ), 1, ZERO,
     $                        WORK( IW ), 1 )
               ELSE
                  CALL DLASET( 'All', ITMP0, 1, ZERO, ZERO, WORK( IW ),
     $                         ITMP0 )
               END IF
*
               IW = IW + ITMP0
               IF( MYROW.EQ.MIROW ) THEN
                  V( II+(JJ-1)*LDV ) = VII
                  II = II + 1
               END IF
*
               IF( MOD( IV+ITMP0, DESCV( 3 ) ).EQ.0 )
     $            MIROW = MOD( MIROW+1, NPROW )
*
   10       CONTINUE
*
            CALL DGSUM2D( ICTXT, 'Columnwise', ' ', IW-1, 1, WORK, IW-1,
     $                    IVROW, MYCOL )
*
            IF( MYROW.EQ.IVROW ) THEN
*
               IW = 1
               ITMP0 = 0
               ITMP1 = 1
*
               T( ITMP1 ) = TAU( JJV )
*
               DO 20 JJ = JJV+1, JJV+K-1
*
*                 T(1:j-1,j) := T(1:j-1,1:j-1) * T(1:j-1,j)
*
                  ITMP0 = ITMP0 + 1
                  ITMP1 = ITMP1 + DESCV( 4 )
                  CALL DCOPY( ITMP0, WORK( IW ), 1, T( ITMP1 ), 1 )
                  IW = IW + ITMP0
*
                  CALL DTRMV( 'Upper', 'No transpose', 'Non-unit',
     $                        ITMP0, T, DESCV( 4 ), T( ITMP1 ), 1 )
                  T(ITMP1+ITMP0) = TAU( JJ )
*
   20          CONTINUE
*
            END IF
*
         ELSE
*
*           DIRECT = 'Backward', STOREV = 'Columnwise'
*
            NP = NUMROC( N+IROFF-1, DESCV( 3 ), MYROW, IVROW, NPROW )
            IF( MYROW.EQ.IVROW )
     $         NP = NP - IROFF
            MIROW = INDXG2P( IV+N-2, DESCV( 3 ), MYROW, DESCV( 5 ),
     $                       NPROW )
            II = IIV + NP - 1
            ITMP0 = 0
*
            DO 30 JJ = JJV+K-2, JJV, -1
*
               IF( MYROW.EQ.MIROW ) THEN
                  VII = V( II+(JJ-1)*LDV )
                  V( II+(JJ-1)*LDV ) = ONE
               END IF
*
*              T(i+1:k,i) := -tau(i) * V(1:n-k+i,i+1:k)' * V(1:n-k+i,i)
*
               ITMP0 = ITMP0 + 1
               IF( II-IIV+1.GT.0 ) THEN
                  CALL DGEMV( 'Transpose', II-IIV+1, ITMP0, -TAU( JJ ),
     $                        V( IIV+JJ*LDV ), LDV,
     $                        V( IIV+(JJ-1)*LDV ), 1, ZERO,
     $                        WORK( IW ), 1 )
               ELSE
                  CALL DLASET( 'All', ITMP0, 1, ZERO, ZERO, WORK( IW ),
     $                         ITMP0 )
               END IF
*
               IW = IW + ITMP0
               IF( MYROW.EQ.MIROW ) THEN
                  V( II+(JJ-1)*LDV ) = VII
                  II = II - 1
               END IF
*
               IF( MOD( IV+N-ITMP0-2, DESCV(3) ).EQ.0 )
     $            MIROW = MOD( MIROW+NPROW-1, NPROW )
*
   30       CONTINUE
*
            CALL DGSUM2D( ICTXT, 'Columnwise', ' ', IW-1, 1, WORK, IW-1,
     $                    IVROW, MYCOL )
*
            IF( MYROW.EQ.IVROW ) THEN
*
               IW = 1
               ITMP0 = 0
               ITMP1 = K + 1 + (K-1) * DESCV( 4 )
*
               T( ITMP1-1 ) = TAU( JJV+K-1 )
*
               DO 40 JJ = JJV+K-2, JJV, -1
*
*                 T(j+1:k,j) := T(j+1:k,j+1:k) * T(j+1:k,j)
*
                  ITMP0 = ITMP0 + 1
                  ITMP1 = ITMP1 - DESCV( 4 ) - 1
                  CALL DCOPY( ITMP0, WORK( IW ), 1, T( ITMP1 ), 1 )
                  IW = IW + ITMP0
*
                  CALL DTRMV( 'Lower', 'No transpose', 'Non-unit',
     $                        ITMP0, T( ITMP1+DESCV( 4 ) ), DESCV( 4 ),
     $                        T( ITMP1 ), 1 )
                  T( ITMP1-1 ) = TAU( JJ )
*
   40          CONTINUE
*
            END IF
*
         END IF
*
      ELSE IF( LSAME( STOREV, 'R' ) .AND. MYROW.EQ.IVROW ) THEN
*
         IW = 1
         LDV = DESCV( 8 )
         ICOFF = MOD( JV-1, DESCV( 4 ) )
*
         IF( FORWARD ) THEN
*
*           DIRECT = 'Forward', STOREV = 'Rowwise'
*
            NQ = NUMROC( N+ICOFF, DESCV( 4 ), MYCOL, IVCOL, NPCOL )
            IF( MYCOL.EQ.IVCOL ) THEN
               NQ = NQ - ICOFF
               JJ = JJV  + 1
            ELSE
               JJ = JJV
            END IF
            IF( ICOFF+1.EQ.DESCV( 4 ) ) THEN
               MICOL = MOD( IVCOL+1, NPCOL )
            ELSE
               MICOL = IVCOL
            END IF
            ITMP0 = 0
*
            DO 50 II = IIV+1, IIV+K-1
*
               IF( MYCOL.EQ.MICOL ) THEN
                  VII = V( II+(JJ-1)*LDV )
                  V( II+(JJ-1)*LDV ) = ONE
               END IF
*
*              T(1:i-1,i) := V(1:i-1,i:n) * V(i,i:n)
*
               ITMP0 = ITMP0 + 1
               IF( NQ-JJ+JJV.GT.0 ) THEN
                  CALL DGEMV( 'No transpose', ITMP0, NQ-JJ+JJV,
     $                        -TAU(II), V( IIV+(JJ-1)*LDV ), LDV,
     $                        V( II+(JJ-1)*LDV ), LDV, ZERO,
     $                        WORK( IW ), 1 )
               ELSE
                  CALL DLASET( 'All', ITMP0, 1, ZERO, ZERO,
     $                         WORK( IW ), ITMP0 )
               END IF
*
               IW = IW + ITMP0
               IF( MYCOL.EQ.MICOL ) THEN
                  V( II+(JJ-1)*LDV ) = VII
                  JJ = JJ + 1
               END IF
*
               IF( MOD( JV+ITMP0, DESCV( 4 ) ).EQ.0 )
     $            MICOL = MOD( MICOL+1, NPCOL )
*
   50       CONTINUE
*
            CALL DGSUM2D( ICTXT, 'Rowwise', ' ', IW-1, 1, WORK, IW-1,
     $                    MYROW, IVCOL )
*
            IF( MYCOL.EQ.IVCOL ) THEN
*
               IW = 1
               ITMP0 = 0
               ITMP1 = 1
*
               T( ITMP1 ) = TAU( IIV )
*
               DO 60 II = IIV+1, IIV+K-1
*
*                 T(1:i-1,i) := T(1:i-1,1:i-1) * T(1:i-1,i)
*
                  ITMP0 = ITMP0 + 1
                  ITMP1 = ITMP1 + DESCV( 3 )
                  CALL DCOPY( ITMP0, WORK( IW ), 1, T( ITMP1 ), 1 )
                  IW = IW + ITMP0
*
                  CALL DTRMV( 'Upper', 'No transpose', 'Non-unit',
     $                        ITMP0, T, DESCV( 3 ), T( ITMP1 ), 1 )
                  T( ITMP1+ITMP0 ) = TAU( II )
*
   60          CONTINUE
*
            END IF
*
         ELSE
*
*           DIRECT = 'Backward', STOREV = 'Rowwise'
*
            NQ = NUMROC( N+ICOFF-1, DESCV( 4 ), MYCOL, IVCOL, NPCOL )
            IF( MYCOL.EQ.IVCOL )
     $         NQ = NQ - ICOFF
            MICOL = INDXG2P( JV+N-2, DESCV( 4 ), MYCOL, DESCV( 6 ),
     $                       NPCOL )
            JJ = JJV + NQ - 1
            ITMP0 = 0
*
            DO 70 II = IIV+K-2, IIV, -1
*
               IF( MYCOL.EQ.MICOL ) THEN
                  VII = V( II+(JJ-1)*LDV )
                  V( II+(JJ-1)*LDV ) = ONE
               END IF
*
*              T(i+1:k,i) := -tau(i) * V(i+1:k,1:n-k+i) * V(i,1:n-k+i)
*
               ITMP0 = ITMP0 + 1
               IF( JJ-JJV+1.GT.0 ) THEN
                  CALL DGEMV( 'No transpose', ITMP0, JJ-JJV+1,
     $                        -TAU( II ), V( II+1+(JJV-1)*LDV ), LDV,
     $                        V( II+(JJV-1)*LDV ), LDV, ZERO,
     $                        WORK( IW ), 1 )
               ELSE
                  CALL DLASET( 'All', ITMP0, 1, ZERO, ZERO,
     $                         WORK( IW ), ITMP0 )
               END IF
*
               IW = IW + ITMP0
               IF( MYCOL.EQ.MICOL ) THEN
                  V( II+(JJ-1)*LDV ) = VII
                  JJ = JJ - 1
               END IF
*
               IF( MOD( JV+N-ITMP0-2, DESCV( 4 ) ).EQ.0 )
     $            MICOL = MOD( MICOL+NPCOL-1, NPCOL )
*
   70       CONTINUE
*
            CALL DGSUM2D( ICTXT, 'Rowwise', ' ', IW-1, 1, WORK, IW-1,
     $                    MYROW, IVCOL )
*
            IF( MYCOL.EQ.IVCOL ) THEN
*
               IW = 1
               ITMP0 = 0
               ITMP1 = K + 1 + (K-1) * DESCV( 3 )
*
               T( ITMP1-1 ) = TAU( IIV+K-1 )
*
               DO 80 II = IIV+K-2, IIV, -1
*
*                 T(i+1:k,i) := T(i+1:k,i+1:k) * T(i+1:k,i)
*
                  ITMP0 = ITMP0 + 1
                  ITMP1 = ITMP1 - DESCV( 3 ) - 1
                  CALL DCOPY( ITMP0, WORK( IW ), 1, T( ITMP1 ), 1 )
                  IW = IW + ITMP0
*
                  CALL DTRMV( 'Lower', 'No transpose', 'Non-unit',
     $                        ITMP0, T( ITMP1+DESCV( 3 ) ), DESCV( 3 ),
     $                        T( ITMP1 ), 1 )
                  T( ITMP1-1 ) = TAU( II )
*
   80          CONTINUE
*
            END IF
*
         END IF
*
      END IF
*
      RETURN
*
*     End of PDLARFT
*
      END
