      SUBROUTINE PDLARFG( N, ALPHA, IAX, JAX, X, IX, JX, DESCX, INCX,
     $                    TAU )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IAX, INCX, IX, JAX, JX, N
      DOUBLE PRECISION   ALPHA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCX( * )
      DOUBLE PRECISION   TAU( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLARFG generates a real elementary reflector H of order n, such
*  that
*
*     H * sub( X ) = H * ( x(iax,jax) ) = ( alpha ),   H' * H = I.
*                        (      x     )   (   0   )
*
*  where alpha is a scalar, and sub( X ) is an (N-1)-element real
*  distributed vector X(IX:IX+N-2,JX) if INCX = 1 and X(IX,JX:JX+N-2) if
*  INCX = DESCX(1).  H is represented in the form
*
*        H = I - tau * ( 1 ) * ( 1 v' ) ,
*                      ( v )
*
*  where tau is a real scalar and v is a real (N-1)-element
*  vector.
*
*  If the elements of sub( X ) are all zero, then tau = 0 and H is
*  taken to be the unit matrix.
*
*  Otherwise  1 <= tau <= 2.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Because vectors may be viewed as a subclass of matrices, a
*  distributed vector is considered to be a distributed matrix.
*
*  Arguments
*  =========
*
*  N       (global input) INTEGER
*          The global order of the elementary reflector. N >= 0.
*
*  ALPHA   (local output) DOUBLE PRECISION
*          On exit, alpha is computed in the process scope having the
*          vector sub( X ).
*
*  IAX     (global input) INTEGER
*          The global row index in X of X(IAX,JAX).
*
*  JAX     (global input) INTEGER
*          The global column index in X of X(IAX,JAX).
*
*  X       (local input/local output) DOUBLE PRECISION, pointer into the
*          local memory to an array of dimension (LLD_X,*). This array
*          contains the local pieces of the distributed vector sub( X ).
*          Before entry, the incremented array sub( X ) must contain
*          the vector x. On exit, it is overwritten with the vector v.
*
*  IX      (global input) INTEGER
*          X's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JX      (global input) INTEGER
*          X's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCX   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  TAU     (local output) DOUBLE PRECISION, array, dimension  LOCq(JX) if
*          INCX = 1, and LOCq(JX) otherwise. This array contains the
*          Householder scalars related to the Householder vectors.
*          TAU is tied to the distributed matrix X.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            ICTXT, IIAX, INDXTAU, IXCOL, IXROW, J, JJAX,
     $                   KNT, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   BETA, RSAFMN, SAFMIN, XNORM
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DGEBR2D, DGEBS2D, DSCAL,
     $                   INFOG2L, PDNRM2
*     ..
*     .. External Functions ..
      INTEGER            NUMROC
      DOUBLE PRECISION   DLAMCH, DLAPY2
      EXTERNAL           NUMROC, DLAMCH, DLAPY2
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MIN, SIGN
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      ICTXT = DESCX( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IF( INCX.EQ.DESCX( 1 ) ) THEN
*
*        sub( X ) is distributed across a process row.
*
         CALL INFOG2L( IX, JAX, DESCX, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIAX, JJAX, IXROW, IXCOL )
*
         IF( MYROW.NE.IXROW )
     $      RETURN
*
*        Broadcast X(IAX,JAX) across the process row.
*
         IF( MYCOL.EQ.IXCOL ) THEN
            J = IIAX+(JJAX-1)*DESCX( 8 )
            CALL DGEBS2D( ICTXT, 'Rowwise', ' ', 1, 1, X( J ), 1 )
            ALPHA = X( J )
         ELSE
            CALL DGEBR2D( ICTXT, 'Rowwise', ' ', 1, 1, ALPHA, 1,
     $                    MYROW, IXCOL )
         END IF
*
         INDXTAU = IIAX
*
      ELSE
*
*        sub( X ) is distributed across a process column.
*
         CALL INFOG2L( IAX, JX, DESCX, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIAX, JJAX, IXROW, IXCOL )
*
         IF( MYCOL.NE.IXCOL )
     $      RETURN
*
*        Broadcast X(IAX,JAX) across the process column.
*
         IF( MYROW.EQ.IXROW ) THEN
            J = IIAX+(JJAX-1)*DESCX( 8 )
            CALL DGEBS2D( ICTXT, 'Columnwise', ' ', 1, 1, X( J ), 1 )
            ALPHA = X( J )
         ELSE
            CALL DGEBR2D( ICTXT, 'Columnwise', ' ', 1, 1, ALPHA, 1,
     $                    IXROW, MYCOL )
         END IF
*
         INDXTAU = JJAX
*
      END IF
*
      IF( N.LE.0 ) THEN
         TAU( INDXTAU ) = ZERO
         RETURN
      END IF
*
      CALL PDNRM2( N-1, XNORM, X, IX, JX, DESCX, INCX )
*
      IF( XNORM.EQ.ZERO ) THEN
*
*        H = I
*
         TAU( INDXTAU ) = ZERO
*
      ELSE
*
*        General case
*
         BETA = -SIGN( DLAPY2( ALPHA, XNORM ), ALPHA )
         SAFMIN = DLAMCH( 'S' )
         RSAFMN = ONE / SAFMIN
         IF( ABS( BETA ).LT.SAFMIN ) THEN
*
*           XNORM, BETA may be inaccurate; scale X and recompute them
*
            KNT = 0
   10       CONTINUE
            KNT = KNT + 1
            CALL PDSCAL( N-1, RSAFMN, X, IX, JX, DESCX, INCX )
            BETA = BETA*RSAFMN
            ALPHA = ALPHA*RSAFMN
            IF( ABS( BETA ).LT.SAFMIN )
     $         GO TO 10
*
*           New BETA is at most 1, at least SAFMIN
*
            CALL PDNRM2( N-1, XNORM, X, IX, JX, DESCX, INCX )
            BETA = -SIGN( DLAPY2( ALPHA, XNORM ), ALPHA )
            TAU( INDXTAU ) = ( BETA-ALPHA ) / BETA
            CALL PDSCAL( N-1, ONE/(ALPHA-BETA), X, IX, JX, DESCX, INCX )
*
*           If ALPHA is subnormal, it may lose relative accuracy
*
            ALPHA = BETA
            DO 20 J = 1, KNT
               ALPHA = ALPHA*SAFMIN
   20       CONTINUE
         ELSE
            TAU( INDXTAU ) = ( BETA-ALPHA ) / BETA
            CALL PDSCAL( N-1, ONE/(ALPHA-BETA), X, IX, JX, DESCX, INCX )
            ALPHA = BETA
         END IF
      END IF
*
      RETURN
*
*     End of PDLARFG
*
      END
