      SUBROUTINE PDLARFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, V, IV,
     $                    JV, DESCV, T, C, IC, JC, DESCC, WORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          SIDE, TRANS, DIRECT, STOREV
      INTEGER            IC, IV, JC, JV, M, N, K
*     ..
*     .. Array Arguments ..
      INTEGER            DESCC( * ), DESCV( * )
      DOUBLE PRECISION   C( * ), T( * ), V( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLARFB applies a real block reflector Q or its transpose Q**T to a
*  real distributed M-by-N matrix sub( C ) = C(IC:IC+M-1,JC:JC+N-1)
*  from the left or the right.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  SIDE    (global input) CHARACTER
*          = 'L': apply Q or Q**T from the Left;
*          = 'R': apply Q or Q**T from the Right.
*
*  TRANS   (global input) CHARACTER
*          = 'N':  No transpose, apply Q;
*          = 'T':  Transpose, apply Q**T.
*
*  DIRECT  (global input) CHARACTER
*          Indicates how Q is formed from a product of elementary
*          reflectors
*          = 'F': Q = H(1) H(2) . . . H(k) (Forward)
*          = 'B': Q = H(k) . . . H(2) H(1) (Backward)
*
*  STOREV  (global input) CHARACTER
*          Indicates how the vectors which define the elementary
*          reflectors are stored:
*          = 'C': Columnwise
*          = 'R': Rowwise
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( C ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( C ). N >= 0.
*
*  K       (global input) INTEGER
*          The order of the matrix T (= the number of elementary
*          reflectors whose product defines the block reflector).
*
*  V       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension ( LLD_V, LOCq(JV+K-1) ) if
*          STOREV = 'C', ( LLD_V, LOCq(JV+M-1)) if STOREV = 'R' and
*          SIDE = 'L', ( LLD_V, LOCq(JV+N-1) ) if STOREV = 'R' and
*          SIDE = 'R'. It contains the local pieces of the distributed
*          vectors V representing the Householder transformation.
*          See further details.
*          If STOREV = 'C' and SIDE = 'L', LLD_V >= MAX(1,LOCp(IV+M-1));
*          if STOREV = 'C' and SIDE = 'R', LLD_V >= MAX(1,LOCp(IV+N-1));
*          if STOREV = 'R', LLD_V >= LOCp(IV+K-1).
*
*  IV      (global input) INTEGER
*          V's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JV      (global input) INTEGER
*          V's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCV   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix V.
*
*  T       (local input) DOUBLE PRECISION array, dimension MB_V by MB_V
*          if STOREV = 'R' and NB_V by NB_V if STOREV = 'C'. The trian-
*          gular matrix T in the representation of the block reflector.
*
*  C       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_C,LOCq(JC+N-1)).
*          On entry, the M-by-N distributed matrix sub( C ). On exit,
*          sub( C ) is overwritten by Q*sub( C ) or Q'*sub( C ) or
*          sub( C )*Q or sub( C )*Q'.
*
*  IC      (global input) INTEGER
*          C's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JC      (global input) INTEGER
*          C's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCC   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix C.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (LWORK)
*          If STOREV = 'C',
*            if SIDE = 'L',
*              LWORK >= ( NqC0 + MpC0 ) * K
*            else if SIDE = 'R',
*              LWORK >= ( NqC0 + MAX( NpV0 + NUMROC( NUMROC( N+ICOFFC,
*                         NB_V, 0, 0, NPCOL ), NB_V, 0, 0, LCMQ ),
*                         MpC0 ) ) * K
*            end if
*          else if STOREV = 'R',
*            if SIDE = 'L',
*              LWORK >= ( MpC0 + MAX( MqV0 + NUMROC( NUMROC( M+IROFFC,
*                         MB_V, 0, 0, NPROW ), MB_V, 0, 0, LCMP ),
*                         NqC0 ) ) * K
*            else if SIDE = 'R',
*              LWORK >= ( MpC0 + NqC0 ) * K
*            end if
*          end if
*
*          where LCMQ = LCM / NPCOL with LCM = ICLM( NPROW, NPCOL ),
*
*          IROFFV = MOD( IV-1, MB_V ), ICOFFV = MOD( JV-1, NB_V ),
*          IVROW = INDXG2P( IV, MB_V, MYROW, RSRC_V, NPROW ),
*          IVCOL = INDXG2P( JV, NB_V, MYCOL, CSRC_V, NPCOL ),
*          MqV0 = NUMROC( M+ICOFFV, NB_V, MYCOL, IVCOL, NPCOL ),
*          NpV0 = NUMROC( N+IROFFV, MB_V, MYROW, IVROW, NPROW ),
*
*          IROFFC = MOD( IC-1, MB_C ), ICOFFC = MOD( JC-1, NB_C ),
*          ICROW = INDXG2P( IC, MB_C, MYROW, RSRC_C, NPROW ),
*          ICCOL = INDXG2P( JC, NB_C, MYCOL, CSRC_C, NPCOL ),
*          MpC0 = NUMROC( M+IROFFC, MB_C, MYROW, ICROW, NPROW ),
*          NpC0 = NUMROC( N+ICOFFC, MB_C, MYROW, ICROW, NPROW ),
*          NqC0 = NUMROC( N+ICOFFC, NB_C, MYCOL, ICCOL, NPCOL ),
*
*          ILCM, INDXG2P and NUMROC are ScaLAPACK tool functions;
*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling
*          the subroutine BLACS_GRIDINFO.
*
*  =====================================================================
*
*  Alignment requirements
*  ======================
*
*  The distributed submatrices V(IV:*, JV:*) and C(IC:IC+M-1,JC:JC+N-1)
*  must verify some alignment properties, namely the following
*  expressions should be true:
*
*  MB_V = NB_V,
*
*  If STOREV = 'Columnwise'
*    If SIDE = 'Left',
*      ( MB_V.EQ.MB_C .AND. IROFFV.EQ.IROFFC .AND. IVROW.EQ.ICROW )
*    If SIDE = 'Right',
*      ( MB_V.EQ.NB_A .AND. MB_V.EQ.NB_C .AND. IROFFV.EQ.ICOFFC )
*  else if STOREV = 'Rowwise'
*    If SIDE = 'Left',
*      ( MB_V.EQ.NB_V .AND. MB_V.EQ.MB_C .AND. ICOFFV.EQ.IROFFC )
*    If SIDE = 'Right',
*      ( NB_V.EQ.NB_C .AND. ICOFFV.EQ.ICOFFC .AND. IVCOL.EQ.ICCOL )
*  end if
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            FORWARD
      CHARACTER          COLBTOP, ROWBTOP, TRANST, UPLO
      INTEGER            IBLCK, ICCOL, ICOFF, ICROW, ICTXT, IIC, IIV,
     $                   ILASTCOL, ILASTROW, IOFF, IOFFC, IOFFV, IPT,
     $                   IPV, IPW, IROFF, ITMP, IVCOL, IVROW, JBLCK,
     $                   JJC, JJV, LDC, LDV, LV, LW, MP, MP0, MQ, MQ0,
     $                   MYCOL, MYROW, NP, NP0, NPCOL, NPROW, NQ, NQ0
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DGEBR2D, DGEBS2D,DGEMM,
     $                   DGSUM2D, DLACPY, DLASET, DTRBR2D,
     $                   DTRBS2D, DTRMM, INFOG2L, PTOPGET,
     $                   PBDTRAN
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, LSAME, NUMROC
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( M.LE.0 .OR. N.LE.0 .OR. K.LE.0 )
     $   RETURN
*
*     Get grid parameters
*
      ICTXT = DESCC( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IF( LSAME( TRANS, 'N' ) ) THEN
          TRANST = 'T'
      ELSE
          TRANST = 'N'
      END IF
      FORWARD = LSAME( DIRECT, 'F' )
      IF( FORWARD ) THEN
         UPLO = 'U'
      ELSE
         UPLO = 'L'
      END IF
*
      CALL INFOG2L( IV, JV, DESCV, NPROW, NPCOL, MYROW, MYCOL, IIV, JJV,
     $              IVROW, IVCOL )
      CALL INFOG2L( IC, JC, DESCC, NPROW, NPCOL, MYROW, MYCOL, IIC, JJC,
     $              ICROW, ICCOL )
      LDC = DESCC( 8 )
      LDV = DESCV( 8 )
      IIC = MIN( IIC, LDC )
      IIV = MIN( IIV, LDV )
      IROFF = MOD( IC-1, DESCC( 3 ) )
      ICOFF = MOD( JC-1, DESCC( 4 ) )
      MP = NUMROC( M+IROFF, DESCC( 3 ), MYROW, ICROW, NPROW )
      NQ = NUMROC( N+ICOFF, DESCC( 4 ), MYCOL, ICCOL, NPCOL )
      IF( MYCOL.EQ.ICCOL )
     $   NQ = NQ - ICOFF
      IF( MYROW.EQ.ICROW )
     $   MP = MP - IROFF
      JJC = MIN( JJC, MAX( 1, JJC+NQ-1 ) )
      JJV = MIN( JJV, MAX( 1, NUMROC( DESCV( 2 ), DESCV( 4 ), MYCOL,
     $                                DESCV( 6 ), NPCOL ) ) )
      IOFFC = IIC + ( JJC-1 ) * LDC
      IOFFV = IIV + ( JJV-1 ) * LDV
*
      IF( LSAME( STOREV, 'C' ) ) THEN
*
*        V is stored columnwise
*
         IF( LSAME( SIDE, 'L' ) ) THEN
*
*           Form  H*sub( C )  or  H'*sub( C  ) where sub( C ) = ( C1 )
*                                                               ( C2 )
*           W := sub( C )' * V  (stored in WORK(IPW))
*
            IPV = 1
            IPW = IPV + MP * K
            LV = MAX( 1, MP )
            LW = MAX( 1, NQ )
*
*           Broadcast V to the other process columns.
*
            CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
            IF( MYCOL.EQ.IVCOL ) THEN
*
               CALL DGEBS2D( ICTXT, 'Rowwise', ROWBTOP, MP, K,
     $                       V( IOFFV ), LDV )
               IF( MYROW.EQ.IVROW )
     $            CALL DTRBS2D( ICTXT, 'Rowwise', ROWBTOP, UPLO,
     $                          'Non unit', K, K, T, DESCV( 4 ) )
               CALL DLACPY( 'All', MP, K, V( IOFFV ), LDV, WORK( IPV ),
     $                      LV )
*
            ELSE
*
               CALL DGEBR2D( ICTXT, 'Rowwise', ROWBTOP, MP, K,
     $                       WORK( IPV ), LV, MYROW, IVCOL )
               IF( MYROW.EQ.IVROW )
     $            CALL DTRBR2D( ICTXT, 'Rowwise', ROWBTOP, UPLO,
     $                          'Non unit', K, K, T, DESCV( 4 ), MYROW,
     $                          IVCOL )
*
            END IF
*
            IF( FORWARD ) THEN
*
*              Let  WORK(IPV) = ( V1 )    (first K rows)
*                               ( V2 )
*              where  V1  is unit lower triangular, zeroes upper
*              triangular part of WORK(IPV).
*
               IF( MP.GT.0 ) THEN
                  ITMP = MIN( DESCV( 3 )-IROFF, K )
                  IF( MYROW.EQ.IVROW ) THEN
                     IF( NPROW.GT.1 ) THEN
                        IBLCK = MIN( ITMP, MP )
                        CALL DLASET( 'Upper', IBLCK, K, ZERO, ONE,
     $                               WORK( IPV ), LV )
                     ELSE
                        CALL DLASET( 'Upper', MP, K, ZERO, ONE,
     $                               WORK( IPV ), LV )
                     END IF
                  ELSE IF( ( MYROW.EQ.MOD( IVROW+1, NPROW ) ).AND.
     $                     ( NPROW.GT.1 ).AND.( ITMP.LE.K ) ) THEN
                     CALL DLASET( 'Upper', MP, K-ITMP, ZERO, ONE,
     $                            WORK( IPV+ITMP*LV ), LV )
                  END IF
               END IF
*
            ELSE
*
*              Let  WORK(IPV) = ( V1 )
*                               ( V2 )    (last K rows)
*              where  V2  is unit upper triangular, zeroes lower
*              triangular part of WORK(IPV).
*
               IF( MP.GT.0 ) THEN
                  IOFF = ICEIL( IV+M-1, DESCV( 3 ) )*DESCV( 3 ) -
     $                   IV - M + 1
                  ITMP = MIN( DESCV( 3 )-IOFF, K )
                  ILASTROW = INDXG2P( IV+M-1, DESCV( 3 ), MYROW,
     $                                DESCV( 5 ), NPROW )
                  IF( MYROW.EQ.ILASTROW ) THEN
                     IF( NPROW.GT.1 ) THEN
                        IBLCK = MIN( ITMP, MP )
                        CALL DLASET( 'All', IBLCK, K-ITMP, ZERO, ZERO,
     $                               WORK( IPV+MP-IBLCK ), LV )
                        CALL DLASET( 'Lower', IBLCK, ITMP, ZERO, ONE,
     $                               WORK( IPV+MP-IBLCK+(K-ITMP)*LV ),
     $                               LV )
                     ELSE
                        CALL DLASET( 'Lower', K, K, ZERO, ONE,
     $                               WORK( IPV+MP-K ), LV )
                     END IF
                  ELSE IF( ( MYROW.EQ.MOD( ILASTROW+NPROW-1, NPROW ) )
     $                .AND.( NPROW.GT.1 ).AND.( K.GT.ITMP ) ) THEN
                     CALL DLASET( 'Lower', K-ITMP, K, ZERO, ONE,
     $                            WORK( IPV+MP-K+ITMP ), LV )
                  END IF
               END IF
*
            END IF
*
*           W := sub( C )' * V
*
            IF( MP.GT.0 ) THEN
               CALL DGEMM( 'Transpose', 'No transpose', NQ, K, MP, ONE,
     $                    C( IOFFC ), LDC, WORK( IPV ), LV, ZERO,
     $                    WORK( IPW ), LW )
            ELSE
               CALL DLASET( 'All', NQ, K, ZERO, ZERO, WORK( IPW ), LW )
            END IF
*
            CALL DGSUM2D( ICTXT, 'Columnwise', ' ', NQ, K, WORK( IPW ),
     $                    LW, IVROW, MYCOL )
*
            IF( MYROW.EQ.IVROW ) THEN
*
*              W := W * T'  or  W * T
*
               CALL DTRMM( 'Right', UPLO, TRANST, 'Non unit', NQ, K,
     $                     ONE, T, DESCV( 4 ), WORK( IPW ), LW )
               CALL DGEBS2D( ICTXT, 'Columnwise', ' ', NQ, K,
     $                       WORK( IPW ), LW )
*
            ELSE
               CALL DGEBR2D( ICTXT, 'Columnwise', ' ', NQ, K,
     $                       WORK( IPW ), LW, IVROW, MYCOL )
            END IF
*
*           sub( C ) := sub( C ) - V * W'
*
            CALL DGEMM( 'No transpose', 'Transpose', MP, NQ, K, -ONE,
     $                  WORK( IPV ), LV, WORK( IPW ), LW, ONE,
     $                  C(IOFFC), LDC )
*
         ELSE
*
*           SIDE = 'Right'
*
            NP0 = NUMROC( N+ICOFF, DESCV( 3 ), MYROW, IVROW, NPROW )
            IF( MYROW.EQ.ICROW ) THEN
               MP0 = MP + IROFF
            ELSE
               MP0 = MP
            END IF
            IF( MYROW.EQ.IVROW ) THEN
               NP = NP0 - ICOFF
            ELSE
               NP = NP0
            END IF
            IF( MYCOL.EQ.ICCOL ) THEN
               NQ0 = NQ + ICOFF
            ELSE
               NQ0 = NQ
            END IF
            IPV = 1
            IPW = IPV + K * NQ0
            IPT = IPW + K * NP0
            LV = MAX( 1, K )
            LW = MAX( 1, NP0 )
*
            IF( MYCOL.EQ.IVCOL ) THEN
               IF( MYROW.EQ.IVROW ) THEN
                  CALL DLACPY( 'All', NP, K, V( IOFFV ), LDV,
     $                         WORK( IPW+ICOFF ), LW )
               ELSE
                  CALL DLACPY( 'All', NP, K, V( IOFFV ), LDV,
     $                         WORK( IPW ), LW )
               END IF
*
               IF( FORWARD ) THEN
*
*                 Let  WORK(IPW) = ( V1 )    (first K rows)
*                                  ( V2 )
*                 where  V1  is unit lower triangular, zeroes upper
*                 triangular part of WORK(IPW).
*
                  IF( NP0.GT.0 ) THEN
                     ITMP = MIN( DESCV( 3 )-ICOFF, K )
                     IF( MYROW.EQ.IVROW ) THEN
                        CALL DLASET( 'All', ICOFF, K, ZERO, ZERO,
     $                               WORK( IPW ), LW )
                        IF( NPROW.GT.1 ) THEN
                           IBLCK = MIN( ITMP, NP )
                           CALL DLASET( 'Upper', IBLCK, K, ZERO, ONE,
     $                                  WORK( IPW+ICOFF ), LW )
                        ELSE
                           CALL DLASET( 'Upper', NP, K, ZERO, ONE,
     $                                  WORK( IPW+ICOFF ), LW )
                        END IF
                     ELSE IF( ( MYROW.EQ.MOD( IVROW+1, NPROW ) ).AND.
     $                        ( NPROW.GT.1 ).AND.( ITMP.LE.K ) ) THEN
                        CALL DLASET( 'Upper', NP, K-ITMP, ZERO, ONE,
     $                               WORK( IPW+ITMP*LW ), LW )
                     END IF
                  END IF
*
               ELSE
*
*                 Let  WORK(IPW) = ( V1 )
*                                  ( V2 )    (last K rows)
*                 where  V2  is unit upper triangular, zeroes lower
*                 triangular part of WORK(IPW).
*
                  IF( NP0.GT.0 ) THEN
                     ITMP = MIN( DESCV( 3 )-ICOFF, K )
                     IF( MYROW.EQ.IVROW ) THEN
                        CALL DLASET( 'All', ICOFF, K, ZERO, ZERO,
     $                               WORK( IPW ), LW )
                     END IF
                     IOFF = ICEIL( IV+N-1, DESCV( 3 ) )*DESCV(3)-IV-N+1
                     ITMP = MIN( DESCV( 3 )-IOFF, N )
                     ILASTROW = INDXG2P( IV+N-1, DESCV( 3 ), MYROW,
     $                                   DESCV( 5 ), NPROW )
                     IF( MYROW.EQ.ILASTROW ) THEN
                        IF( NPROW.GT.1 ) THEN
                           IBLCK = MIN( ITMP, NP0 )
                           CALL DLASET( 'All', IBLCK, K-ITMP, ZERO,
     $                                  ZERO, WORK( IPW+NP0-IBLCK ),
     $                                  LW )
                           CALL DLASET( 'Lower', IBLCK, ITMP, ZERO, ONE,
     $                                  WORK( IPW+NP0-IBLCK+
     $                                  (K-ITMP)*LW ), LW )
                        ELSE
                           CALL DLASET( 'Lower', K, K, ZERO, ONE,
     $                                  WORK( IPW+NP0-K ), LW )
                        END IF
                     ELSE IF( ( MYROW.EQ.MOD(ILASTROW+NPROW-1,NPROW) )
     $                   .AND.( NPROW.GT.1 ).AND.( K.GT.ITMP ) ) THEN
                        CALL DLASET( 'Lower', K-ITMP, K, ZERO, ONE,
     $                               WORK( IPW+NP0-K+ITMP ), LW )
                     END IF
                  END IF
               END IF
            END IF
*
            CALL PBDTRAN( ICTXT, 'Columnwise', 'Transpose', N+ICOFF, K,
     $                    DESCV( 3 ), WORK( IPW ), LW, ZERO,
     $                    WORK( IPV ), LV, IVROW, IVCOL, -1, ICCOL,
     $                    WORK( IPT ) )
            IF( MYCOL.EQ.ICCOL )
     $         IPV = IPV + ICOFF*LV
            LW = MAX( 1, MP0 )
*
*           W := sub( C ) * V
*
            IF( NQ.GT.0 ) THEN
               CALL DGEMM( 'No transpose', 'Transpose', MP, K, NQ, ONE,
     $                     C( IOFFC ), LDC, WORK( IPV ), LV, ZERO,
     $                     WORK( IPW ), LW )
            ELSE
               CALL DLASET( 'All', MP, K, ZERO, ZERO, WORK( IPW ), LW )
            END IF
*
            CALL DGSUM2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ), LW,
     $                    MYROW, IVCOL )
*
*           W := W * T'  or  W * T
*
            IF( MYCOL.EQ.IVCOL ) THEN
*
               IF( MYROW.EQ.IVROW ) THEN
*
*                 Broadcast the block reflector to the other rows.
*
                  CALL DTRBS2D( ICTXT, 'Columnwise', ' ', UPLO,
     $                          'Non unit', K, K, T, DESCV( 4 ) )
               ELSE
                  CALL DTRBR2D( ICTXT, 'Columnwise', ' ', UPLO,
     $                          'Non unit', K, K, T, DESCV( 4 ), IVROW,
     $                          MYCOL )
               END IF
               CALL DTRMM( 'Right', UPLO, TRANS, 'Non unit', MP, K,
     $                     ONE, T, DESCV( 4 ), WORK( IPW ), LW )
*
               CALL DGEBS2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ),
     $                       LW )
*
            ELSE
*
               CALL DGEBR2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ),
     $                       LW, MYROW, IVCOL )
            END IF
*
*           sub( C ) := sub( C ) - W * V'
*
            CALL DGEMM( 'No transpose', 'No transpose', MP, NQ, K, -ONE,
     $                  WORK( IPW ), LW, WORK( IPV ), LV, ONE,
     $                  C( IOFFC ), LDC )
         END IF
*
      ELSE
*
*        STOREV = 'Rowwise'
*
         IF( LSAME( SIDE, 'L' ) ) THEN
*
            MQ0 = NUMROC( M+IROFF, DESCV( 4 ), MYCOL, IVCOL, NPCOL )
            IF( MYCOL.EQ.IVCOL ) THEN
               MQ = MQ0 - IROFF
            ELSE
               MQ = MQ0
            END IF
            IF( MYCOL.EQ.ICCOL ) THEN
               NQ0 = NQ + ICOFF
            ELSE
               NQ0 = NQ
            END IF
            IF( MYROW.EQ.ICROW ) THEN
               MP0 = MP + IROFF
            ELSE
               MP0 = MP
            END IF
            IPV = 1
            IPW = IPV + K * MP0
            IPT = IPW + K * MQ0
            LV = MP0
            LW = MAX( 1, K )
*
            IF( MYROW.EQ.IVROW ) THEN
               IF( MYCOL.EQ.IVCOL ) THEN
                  CALL DLACPY( 'All', K, MQ, V( IOFFV ), LDV,
     $                         WORK( IPW+IROFF ), LW )
               ELSE
                  CALL DLACPY( 'All', K, MQ, V( IOFFV ), LDV,
     $                         WORK(IPW), LW )
               END IF
*
               IF( FORWARD ) THEN
*
*                 Let  WORK(IPW) = ( V1 V2 )
*                 where  V1  is unit upper triangular, zeroes lower
*                 triangular part of WORK(IPW).
*
                  IF( MQ0.GT.0 ) THEN
                     ITMP = MIN( DESCV( 4 )-IROFF, K )
                     IF( MYCOL.EQ.IVCOL ) THEN
                        CALL DLASET( 'All', K, IROFF, ZERO, ZERO,
     $                               WORK( IPW ), LW )
                        IF( NPCOL.GT.1 ) THEN
                           JBLCK = MIN( ITMP, MQ )
                           CALL DLASET( 'Lower', K, JBLCK, ZERO, ONE,
     $                                  WORK( IPW+IROFF*LW ), LW )
                        ELSE
                           CALL DLASET( 'Lower', K, MQ, ZERO, ONE,
     $                                  WORK( IPW+IROFF*LW ), LW )
                        END IF
                     ELSE IF( ( MYCOL.EQ.MOD( IVCOL+1, NPCOL ) ).AND.
     $                        ( NPCOL.GT.1 ).AND.( ITMP.LE.K   ) ) THEN
                        CALL DLASET( 'Lower', K-ITMP, MQ, ZERO, ONE,
     $                               WORK( IPW+ITMP ), LW )
                     END IF
                  END IF
*
               ELSE
*
*                 Let  WORK(IPW) = ( V1 V2 )
*                 where  V2  is unit lower triangular, zeroes upper
*                 triangular part of WORK(IPW).
*
                  IF( MQ0.GT.0 ) THEN
                     ITMP = MIN( DESCV( 4 )-IROFF, K )
                     IF( MYCOL.EQ.IVCOL ) THEN
                        CALL DLASET( 'All', K, IROFF, ZERO, ZERO,
     $                               WORK( IPW ), LW )
                     END IF
                     IOFF = ICEIL( JV+M-1, DESCV( 4 ) ) * DESCV( 4 ) -
     $                      JV - M + 1
                     ITMP = MIN( DESCV( 4 )-IOFF, M )
                     ILASTCOL = INDXG2P( JV+M-1, DESCV( 4 ), MYCOL,
     $                                   DESCV( 6 ), NPCOL )
                     IF( MYCOL.EQ.ILASTCOL ) THEN
                        IF( NPCOL.GT.1 ) THEN
                           JBLCK = MIN( ITMP, MQ0 )
                           CALL DLASET( 'All', K-ITMP, JBLCK, ZERO,
     $                                  ZERO, WORK( IPW+
     $                                  (MQ0-JBLCK)*LW ), LW )
                           CALL DLASET( 'Upper', ITMP, JBLCK, ZERO, ONE,
     $                                  WORK( IPW+(MQ0-JBLCK)*LW+
     $                                  K-ITMP), LW )
                        ELSE
                           CALL DLASET( 'Upper', K, K, ZERO, ONE,
     $                                  WORK( IPW+(MQ0-K)*LW ), LW )
                        END IF
                     ELSE IF( ( MYCOL.EQ.MOD(ILASTCOL+NPCOL-1,NPCOL) )
     $                   .AND.( NPCOL.GT.1 ).AND.( K.GT.ITMP ) ) THEN
                        CALL DLASET( 'Upper', K, K-ITMP, ZERO, ONE,
     $                               WORK( IPW+(MQ0-K+ITMP)*LW ), LW )
                     END IF
                  END IF
               END IF
            END IF
*
            CALL PBDTRAN( ICTXT, 'Rowwise', 'Transpose', K, M+IROFF,
     $                    DESCV( 4 ), WORK( IPW ), LW, ZERO,
     $                    WORK( IPV ), LV, IVROW, IVCOL, -1, ICCOL,
     $                    WORK( IPT ) )
            IF( MYROW.EQ.ICROW )
     $         IPV = IPV + IROFF
*
*           W := sub( C )' * V'
*
            IF( MP.GT.0 ) THEN
               CALL DGEMM( 'Transpose', 'No transpose', K, NQ, MP, ONE,
     $                     C( IOFFC ), LDC, WORK( IPV ), LV, ZERO,
     $                     WORK( IPW ), LW )
            ELSE
               CALL DLASET( 'All', K, NQ, ZERO, ZERO, WORK( IPW ), LW )
            END IF
*
            CALL DGSUM2D( ICTXT, 'Columnwise', ' ', K, NQ, WORK( IPW ),
     $                    LW, IVROW, MYCOL )
*
*           W := W * T'  or  W * T
*
            IF( MYROW.EQ.IVROW ) THEN
*
               IF( MYCOL.EQ.IVCOL ) THEN
*
*                 Broadcast the block reflector to the other columns.
*
                  CALL DTRBS2D( ICTXT, 'Rowwise', ' ', UPLO, 'Non unit',
     $                          K, K, T, DESCV( 3 ) )
               ELSE
                  CALL DTRBR2D( ICTXT, 'Rowwise', ' ', UPLO, 'Non unit',
     $                          K, K, T, DESCV( 3 ), MYROW, IVCOL )
               END IF
               CALL DTRMM( 'Right', UPLO, TRANST, 'Non unit', K, NQ,
     $                     ONE, T, DESCV( 3 ), WORK( IPW ), LW )
*
               CALL DGEBS2D( ICTXT, 'Columnwise', ' ', K, NQ,
     $                       WORK( IPW ), LW )
*
            ELSE
*
               CALL DGEBR2D( ICTXT, 'Columnwise', ' ', K, NQ,
     $                       WORK( IPW ), LW, IVROW, MYCOL )
*
            END IF
*
*           sub( C ) := sub( C ) - V * W'
*
            CALL DGEMM( 'No transpose', 'No transpose', MP, NQ, K, -ONE,
     $                  WORK( IPV ), LV, WORK( IPW ), LW, ONE,
     $                  C( IOFFC ), LDC )
*
         ELSE
*
*           Form sub( C )*Q or sub( C )*Q' where sub( C ) = ( C1  C2 )
*
            IPV = 1
            IPW = IPV + K * NQ
            LV = MAX( 1, K )
            LW = MAX( 1, MP )
*
*           Broadcast V to the other process rows.
*
            CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
            IF( MYROW.EQ.IVROW ) THEN
*
               CALL DGEBS2D( ICTXT, 'Columnwise', COLBTOP, K, NQ,
     $                       V( IOFFV ), LDV )
               IF( MYCOL.EQ.IVCOL )
     $            CALL DTRBS2D( ICTXT, 'Columnwise', COLBTOP, UPLO,
     $                          'Non unit', K, K, T, DESCV( 3 ) )
               CALL DLACPY( 'All', K, NQ, V( IOFFV ), LDV, WORK( IPV ),
     $                      LV )
*
            ELSE
*
               CALL DGEBR2D( ICTXT, 'Columnwise', COLBTOP, K, NQ,
     $                       WORK( IPV ), LV, IVROW, MYCOL )
               IF( MYCOL.EQ.IVCOL )
     $            CALL DTRBR2D( ICTXT, 'Columnwise', COLBTOP, UPLO,
     $                          'Non unit', K, K, T, DESCV( 3 ), IVROW,
     $                          MYCOL )
*
            END IF
*
            IF( FORWARD ) THEN
*
*              Let  WORK(IPV) = ( V1 V2 )
*              where  V1  is unit upper triangular, zeroes lower
*              triangular part of WORK(IPV).
*
               IF( NQ.GT.0 ) THEN
                  ITMP = MIN( DESCV( 4 )-ICOFF, K )
                  IF( MYCOL.EQ.IVCOL ) THEN
                     IF( NPCOL.GT.1 ) THEN
                        JBLCK = MIN( ITMP, NQ )
                        CALL DLASET( 'Lower', K, JBLCK, ZERO, ONE,
     $                               WORK( IPV ), LV )
                     ELSE
                        CALL DLASET( 'Lower', K, NQ, ZERO, ONE,
     $                               WORK( IPV ), LV )
                     END IF
                  ELSE IF( ( MYCOL.EQ.MOD( IVCOL+1, NPCOL ) ).AND.
     $                     ( NPCOL.GT.1 ).AND.( ITMP.LE.K ) ) THEN
                     CALL DLASET( 'Lower', K-ITMP, NQ, ZERO, ONE,
     $                            WORK( IPV+ITMP ), LV )
                  END IF
               END IF
*
            ELSE
*
*              Let  WORK(IPV) = ( V1 V2 )
*              where  V2  is unit lower triangular, zeroes upper
*              triangular part of WORK(IPV).
*
               IF( NQ.GT.0 ) THEN
                  IOFF = ICEIL( JV+N-1, DESCV( 4 ) )*DESCV( 4 ) -
     $                   JV - N + 1
                  ITMP = MIN( DESCV( 4 )-IOFF, K )
                  ILASTCOL = INDXG2P( JV+N-1, DESCV( 4 ), MYCOL,
     $                                DESCV( 6 ), NPCOL )
                  IF( MYCOL.EQ.ILASTCOL ) THEN
                     IF( NPCOL.GT.1 ) THEN
                        JBLCK = MIN( ITMP, NQ )
                        CALL DLASET( 'All', K-ITMP, JBLCK, ZERO, ZERO,
     $                               WORK( IPV+(NQ-JBLCK)*LV ), LV )
                        CALL DLASET( 'Upper', ITMP, JBLCK, ZERO, ONE,
     $                               WORK( IPV+(NQ-JBLCK)*LV+K-ITMP ),
     $                               LV )
                     ELSE
                        CALL DLASET( 'Upper', K, K, ZERO, ONE,
     $                               WORK( IPV+(NQ-K)*LV ), LV )
                     END IF
                  ELSE IF( ( MYCOL.EQ.MOD(ILASTCOL+NPCOL-1,NPCOL) )
     $                .AND.( NPCOL.GT.1 ).AND.( K.GT.ITMP ) ) THEN
                     CALL DLASET( 'Upper', K, K-ITMP, ZERO, ONE,
     $                            WORK( IPV+(NQ-K+ITMP)*LV ), LV )
                  END IF
               END IF
*
            END IF
*
*           W := sub( C ) * V (stored in WORK(IPW))
*
            IF( NQ.GT.0 ) THEN
               CALL DGEMM( 'No Transpose', 'Transpose', MP, K, NQ, ONE,
     $                    C( IOFFC ), LDC, WORK( IPV ), LV, ZERO,
     $                    WORK( IPW ), LW )
            ELSE
               CALL DLASET( 'All', MP, K, ZERO, ZERO, WORK( IPW ), LW )
            END IF
*
            CALL DGSUM2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ), LW,
     $                    MYROW, IVCOL )
*
            IF( MYCOL.EQ.IVCOL ) THEN
*
*              W := W * T'  or  W * T
*
               CALL DTRMM( 'Right', UPLO, TRANS, 'Non unit', MP, K, ONE,
     $                     T, DESCV( 3 ), WORK( IPW ), LW )
               CALL DGEBS2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ),
     $                       LW )
*
            ELSE
*
               CALL DGEBR2D( ICTXT, 'Rowwise', ' ', MP, K, WORK( IPW ),
     $                       LW, MYROW, IVCOL )
            END IF
*
*           sub( C ) := sub( C ) - W * V
*
            CALL DGEMM( 'No transpose', 'No transpose', MP, NQ, K, -ONE,
     $                  WORK( IPW ), LW, WORK( IPV ), LV, ONE,
     $                  C( IOFFC ), LDC )
*
         END IF
*
      END IF
*
      RETURN
*
*     End of PDLARFB
*
      END
