      SUBROUTINE PDLACPY( UPLO, M, N, A, IA, JA, DESCA, B, IB, JB,
     $                    DESCB )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IB, JA, JB, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      DOUBLE PRECISION   A( * ), B( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLACPY copies all or part of a distributed matrix A to another
*  distributed matrix B.  No communication is performed, PDLACPY
*  performs a local copy sub( A ) := sub( B ), where sub( A ) denotes
*  A(IA:IA+M-1,JA:JA+N-1) and sub( B ) denotes B(IB:IB+M-1,JB:JB+N-1).
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies the part of the distributed matrix sub( A ) to be
*          copied:
*          = 'U':   Upper triangular part is copied; the strictly
*                   lower triangular part of sub( A ) is not referenced;
*          = 'L':   Lower triangular part is copied; the strictly
*                   upper triangular part of sub( A ) is not referenced;
*          Otherwise:  All of the matrix sub( A ) is copied.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A, LOCq(JA+N-1) ). This array
*          contains the local pieces of the distributed matrix sub( A )
*          to be copied from.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  B       (local output) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_B, LOCq(JB+N-1) ). This array
*          contains on exit the local pieces of the distributed matrix
*          sub( B ) set as follows:
*
*          if UPLO = 'U', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         1<=i<=j, 1<=j<=N;
*          if UPLO = 'L', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         j<=i<=M, 1<=j<=N;
*          otherwise,     B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         1<=i<=M, 1<=j<=N.
*
*  IB      (global input) INTEGER
*          B's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JB      (global input) INTEGER
*          B's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCB   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix B.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IAA, IBB, IBLK, IN, ITMP, J, JAA, JBB,
     $                   JBLK, JN, JTMP
*     ..
*     .. External Subroutines ..
      EXTERNAL           PDLACP2
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      IN = MIN( ICEIL( IA, DESCA( 3 ) ) * DESCA( 3 ), IA+M-1 )
      JN = MIN( ICEIL( JA, DESCA( 4 ) ) * DESCA( 4 ), JA+N-1 )
*
      IF( M.LE.( DESCA( 3 ) - MOD( IA-1, DESCA( 3 ) ) ) .OR.
     $    N.LE.( DESCA( 4 ) - MOD( JA-1, DESCA( 4 ) ) ) ) THEN
         CALL PDLACP2( UPLO, M, N, A, IA, JA, DESCA,
     $                 B, IB, JB, DESCB )
      ELSE
*
         IF( LSAME( UPLO, 'U' ) ) THEN
            CALL PDLACP2( UPLO, IN-IA+1, N, A, IA, JA, DESCA,
     $                    B, IB, JB, DESCB )
            DO 10 I = IN+1, IA+M-1, DESCA( 3 )
               ITMP = I-IA
               IBLK = MIN( DESCA( 3 ), M-ITMP )
               IBB = IB + ITMP
               JBB = JB + ITMP
               JAA = JA + ITMP
               CALL PDLACP2( UPLO, IBLK, N-ITMP, A, I, JAA, DESCA,
     $                       B, IBB, JBB, DESCB )
   10       CONTINUE
         ELSE IF( LSAME( UPLO, 'L' ) ) THEN
            CALL PDLACP2( UPLO, M, JN-JA+1, A, IA, JA, DESCA,
     $                    B, IB, JB, DESCB )
            DO 20 J = JN+1, JA+N-1, DESCA( 4 )
               JTMP = J-JA
               JBLK = MIN( DESCA( 4 ), N-JTMP )
               IBB = IB + JTMP
               JBB = JB + JTMP
               IAA = IA + JTMP
               CALL PDLACP2( UPLO, M-JTMP, JBLK, A, IAA, J, DESCA,
     $                       B, IBB, JBB, DESCB )
   20       CONTINUE
         ELSE
            IF( M.LE.N ) THEN
               CALL PDLACP2( UPLO, IN-IA+1, N, A, IA, JA, DESCA,
     $                       B, IB, JB, DESCB )
               DO 30 I = IN+1, IA+M-1, DESCA( 3 )
                  ITMP = I-IA
                  IBLK = MIN( DESCA( 3 ), M-ITMP )
                  IBB = IB+ITMP
                  CALL PDLACP2( UPLO, IBLK, N, A, I, JA, DESCA,
     $                          B, IBB, JB, DESCB )
   30          CONTINUE
            ELSE
               CALL PDLACP2( UPLO, M, JN-JA+1, A, IA, JA, DESCA,
     $                       B, IB, JB, DESCB )
               DO 40 J = JN+1, JA+N-1, DESCA( 4 )
                  JTMP = J-JA
                  JBLK = MIN( DESCA( 4 ), N-JTMP )
                  JBB = JB+JTMP
                  CALL PDLACP2( UPLO, M, JBLK, A, IA, J, DESCA,
     $                          B, IB, JBB, DESCB )
   40          CONTINUE
            END IF
         END IF
*
      END IF
*
      RETURN
*
*     End of PDLACPY
*
      END
