      SUBROUTINE PDGERQF( M, N, A, IA, JA, DESCA, TAU, WORK, LWORK,
     $                    INFO )
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IA, INFO, JA, LWORK, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDGERQF computes a RQ factorization of a real distributed M-by-N
*  matrix sub( A ) = A(IA:IA+M-1,JA:JA+N-1) = R * Q.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  This routine requires square block decomposition ( MB_A = NB_A ).
*
*  Arguments
*  =========
*
*  M       (global input) INTEGER
*          The number of rows to be operated on, i.e. the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on, i.e. the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A, LOCq(JA+N-1)).
*          On entry, the local pieces of the M-by-N distributed matrix
*          sub( A ) which is to be factored. On exit, if M <= N, the
*          upper triangle of sub( A ) contains the M by M upper trian-
*          gular matrix R; if M >= N, the elements on and above the
*          (M-N)-th subdiagonal contain the M by N upper trapezoidal
*          matrix R; the remaining elements, with the array TAU,
*          represent the orthogonal matrix Q as a product of elementary
*          reflectors (see Further Details).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  TAU     (local output) DOUBLE PRECISION, array, dimension LOCp(M_A).
*          This array contains the scalar factors of the elementary
*          reflectors. TAU is tied to the distributed matrix A.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (LWORK)
*          On exit, WORK(1) returns the minimal and optimal LWORK.
*
*  LWORK   (local input) INTEGER
*          The dimension of the array WORK.
*          LWORK >= MB_A * ( Mp0 + Nq0 + MB_A ), where
*
*          IROFF = MOD( IA-1, MB_A ), ICOFF = MOD( JA-1, NB_A ),
*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ),
*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ),
*          Mp0   = NUMROC( M+IROFF, MB_A, MYROW, IAROW, NPROW ),
*          Nq0   = NUMROC( N+ICOFF, NB_A, MYCOL, IACOL, NPCOL ),
*
*          and NUMROC, INDXG2P are ScaLAPACK tool functions;
*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling
*          the subroutine BLACS_GRIDINFO.
*
*  INFO    (global output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*  =====================================================================
*
*  Further Details
*  ===============
*
*  The matrix Q is represented as a product of elementary reflectors
*
*     Q = H(ia) H(ia+1) . . . H(ia+k-1), where k = min(m,n).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
*  A(ia+m-k+i-1,ja:ja+n-k+i-2), and tau in TAU(ia+m-k+i-1).
*
*  =====================================================================
*
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            I, IACOL, IAROW, IB, ICTXT, IINFO, IL, IN, IPW,
     $                   K, LWMIN, MP0, MU, MYCOL, MYROW, NPCOL, NPROW,
     $                   NQ0, NU
*     ..
*     .. Local Arrays ..
      INTEGER            IDUM1( 1 ), IDUM2( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, PCHK1MAT, PDGERQ2,
     $                   PDLARFB, PDLARFT, PTOPGET, PTOPSET, PXERBLA
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -607
      ELSE
         CALL CHK1MAT( M, 1, N, 2, IA, JA, DESCA, 6, INFO )
         IF( INFO.EQ.0 ) THEN
            IAROW = INDXG2P( IA, DESCA( 3 ), MYROW, DESCA( 5 ), NPROW )
            IACOL = INDXG2P( JA, DESCA( 4 ), MYCOL, DESCA( 6 ), NPCOL )
            MP0 = NUMROC( M+MOD( IA-1, DESCA( 3 ) ), DESCA( 3 ), MYROW,
     $                    IAROW, NPROW )
            NQ0 = NUMROC( N+MOD( JA-1, DESCA( 4 ) ), DESCA( 4 ), MYCOL,
     $                    IACOL, NPCOL )
            LWMIN = DESCA( 3 ) * ( MP0 + NQ0 + DESCA( 3 ) )
*
            WORK( 1 ) = DBLE( LWMIN )
            IF( DESCA( 3 ).NE.DESCA( 4 ) ) THEN
               INFO = -604
            ELSE IF( LWORK.LT.LWMIN ) THEN
               INFO = -9
            END IF
         END IF
         CALL PCHK1MAT( M, 1, N, 2, IA, JA, DESCA, 6, 0, IDUM1, IDUM2,
     $                  INFO )
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDGERQF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      K = MIN( M, N )
      IPW = DESCA( 3 ) * DESCA( 3 ) + 1
      IN = MIN( ICEIL( IA+M-K, DESCA( 3 ) ) * DESCA( 3 ), IA+M-1 )
      IL = MAX( ( (IA+M-2) / DESCA( 3 ) ) * DESCA( 3 ) + 1, IA )
      CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( 'Broadcast', 'Rowwise', ' ' )
      CALL PTOPSET( 'Broadcast', 'Columnwise', 'D-ring' )
*
      IF( IL.GE.IN+1 ) THEN
*
*        Use blocked code initially
*
         DO 10 I = IL, IN+1, -DESCA( 3 )
            IB = MIN( IA+M-I, DESCA( 3 ) )
*
*           Compute the RQ factorization of the current block
*           A(i:i+ib-1,ja:ja+n-m+i+ib-ia-1)
*
            CALL PDGERQ2( IB, N-M+I+IB-IA, A, I, JA, DESCA, TAU, WORK,
     $                    LWORK, IINFO )
*
            IF( I.GT.IA ) THEN
*
*              Form the triangular factor of the block reflector
*              H = H(i+ib-1) . . . H(i+1) H(i)
*
               CALL PDLARFT( 'Backward', 'Rowwise', N-M+I+IB-IA, IB, A,
     $                       I, JA, DESCA, TAU, WORK, WORK( IPW ) )
*
*              Apply H to A(ia:i-1,ja:ja+n-m+i+ib-ia-1) from the
*              right
*
               CALL PDLARFB( 'Right', 'No transpose', 'Backward',
     $                       'Rowwise', I-IA, N-M+I+IB-IA, IB, A, I, JA,
     $                       DESCA, WORK, A, IA, JA, DESCA,
     $                       WORK( IPW ) )
            END IF
*
   10    CONTINUE
*
         MU = IN - IA + 1
         NU = N - M + IN - IA + 1
*
      ELSE
*
         MU = M
         NU = N
*
      END IF
*
*     Use unblocked code to factor the last or only block
*
      IF( MU.GT.0 .AND. NU.GT.0 )
     $   CALL PDGERQ2( MU, NU, A, IA, JA, DESCA, TAU, WORK, LWORK,
     $                 IINFO )
*
      CALL PTOPSET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( 'Broadcast', 'Columnwise', COLBTOP )
*
      WORK( 1 ) = DBLE( LWMIN )
*
      RETURN
*
*     End of PDGERQF
*
      END
