#include "Bdef.h"
#if (INTFACE == C_CALL)
void Cblacs_get(ConTxt, what, val)
int  ConTxt;
int  what;
int  *val;
#else
void blacs_get_(ConTxt, what, val)
int  *ConTxt;
int  *what;
int  *val;
#endif
{
   BLACSCONTEXT *ctxt;
   extern int minID00, maxID00;

   switch( Mpval(what) )
   {
   case SGET_SYSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_MSGIDS:
      val[0] = minID00;
      val[1] = maxID00;
      break;
   case SGET_DEBUGLVL:
      *val = BlacsDebugLvl;
      break;
   case SGET_BLACSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_NRING:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->nrings;
      break;
   case SGET_NBRANCHES:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->nbranches - 1;
      break;
   default:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__, "Unknown WHAT (%d)",
                Mpval(what));
   }
}
