      PROGRAM RINF1
C
      INCLUDE 'rinf1.inc'
C
C     =================================================
C     ===                                           ===
C     ===   Program:  R-infinity and N-half         ===
C     ===   Version:  Standard Fortran 77           ===
C     ===                                           ===
C     =================================================
C
C     /* Program name */
      CHARACTER*10  NAME /'RINF1'/
C
C     /* Timer routine */
C
      EXTERNAL DWALLTIME00
      DOUBLE PRECISION DWALLTIME00
C
      COMMON /DATA/ A(NNMAX),B(NNMAX),C(NNMAX),D(NNMAX),E(NNMAX),    
     1  F(NNMAX),MATA(NNMAX1,NNMAX1),MATB(NNMAX1,NNMAX1),
     2  MATC(NNMAX1,NNMAX1),IA(NNMAX),IB(NNMAX),IC(NNMAX)
      INTEGER IA,IB,IC
      DOUBLE PRECISION A,B,C,D,E,F,MATA,MATB,MATC
C
      COMMON /PARM/ TOTIM,IOUT,NMAX,NMAX1,NTIMES,NTIM
      INTEGER IOUT,NMAX,NMAX1,NTIMES,NTIM
      DOUBLE PRECISION TOTIM
C
      COMMON /CHARS/ LABEL(17)
      CHARACTER*80 LABEL
C
      INTEGER NDIM1,NDIM2
      PARAMETER(NDIM1=50,NDIM2=2)
      INTEGER LNLAST(NDIM1,NDIM2)
      DOUBLE PRECISION PCTMAX(NDIM1,NDIM2),RAVG(NDIM1,NDIM2),
     &                 RLAST(NDIM1,NDIM2),XNLAST(NDIM1,NDIM2)
      INTEGER I,I1,IBACK,ICASE,IODET,ISW,J,LNSAVE(NDIM1),N,NCASE,NSEL,
     &        NSEL1,NSEND,NTRIP
      DOUBLE PRECISION DUM1,DUM2,DUM3,ERSAVE(NDIM1),PER,RAVER,RINF,
     &                 T10,T11,TN,TOTIME,XN,XN12,XNSAVE(NDIM1),
     &                 XRSAVE(NDIM1),DBLI
C
C     /* SET  PARAMETERS  HERE */
C
C     /* set the maximum vector length */
      NMAX=NNMAX
      NMAX1=NNMAX1
C     /* set for detailed output as default */
      IODET=0
C     /* set the output unit number */
      IOUT=11
C     /* set the number of tests */
      NCASE=17
C     /* set repeat for timing */
      NTIMES=NITER
C
      OPEN(IOUT, FILE = 'rinf1.res')
      REWIND(IOUT)
C
      CALL HEADER(IOUT,NAME)
C
      PRINT *
      PRINT *,'      RINF1:  R-infinity and N-half'
      PRINT *,'      -----------------------------'
      PRINT *
      WRITE(6,*)
      WRITE(6,*)'The calculation is in progress.  Please, wait...'
      WRITE(6,*)
C
C     /* INITIALISE TIMER */
C
      CALL SATIME
      T10 = DWALLTIME00()
      TN = 0.0
C
C     /* INITIALIZE ARRAYS : */
C
      DO 30 I=1,NMAX
        DBLI=I
        A(I)=5.842*DBLI
        B(I)=0.39675*DBLI
        C(I)=4.5693/DBLI
        D(I)=9.8124*SQRT(DBLI)
        E(I)=-4.815*DBLI
        F(I)=-1.0067*SIN(DBLI)
        I1=B(I)
C       /* NON REPEATING INDICES */
        IB(I)=MOD(I1,NMAX)+1
        I1=A(I)
C       /* NON REPEATING INDICES */
        IC(I)=MOD(I1,NMAX)+1
C       /* REPEATING INDICES */
        IA(I)=(MOD(IB(I),60)*NMAX)/60+1
30    CONTINUE
C
      DO 32 I=1,NMAX1
      DO 31 J=1,NMAX1
        MATA(I,J)=6.3487
        MATB(I,J)=9.765342
        MATC(I,J)=1.653982
31    CONTINUE
32    CONTINUE
C 
      DO 200 ICASE=1,NCASE
C        /* RESET SWITCH FOR CHOOSING SUMMARY OUTPUT VALUES */
         ISW=0
         DO 555 I=1,NDIM1
            XRSAVE(I)=0.0
            XNSAVE(I)=0.0
            LNSAVE(I)=0
            ERSAVE(I)=0.0
555      CONTINUE
         DO 556 J=1,NDIM2
           RLAST(ICASE,J)=0.0
           XNLAST(ICASE,J)=0.0
           LNLAST(ICASE,J)=0.0
           PCTMAX(ICASE,J)=0.0
556     CONTINUE
C       /* stores minimum RAVERAGE */
        RAVG(ICASE,1)=1.0E10
C       /* stores maximum RAVERAGE */
        RAVG(ICASE,2)=0.0
C
C       /* INITIALIZE LABELS */
C
        CALL DOALL(ICASE,0,TN)
C
        IF (IODET .EQ. 0) THEN
          WRITE(IOUT,667) LABEL(ICASE),ICASE,NCASE,NMAX,NTIMES
        ENDIF
667     FORMAT(//,3X,A80,//,3X,'ICASE=',I4,3X,'NCASE=',I4,3X,
     1         'NMAX=',I6,3X,'NTIMES=',I10)
C
C       /* INITIALIZE LEAST SQUARES */
C
        CALL LSTSQ(0,XN,TN,RINF,XN12,PER)
        RINF = RINF*1.0E-6 
C
        IF (IODET .EQ. 0) THEN
            WRITE(IOUT,668)
        ENDIF
668     FORMAT(//,4X,'SI',6X,'NI',10X,'TI',13X,'RINF',10X,
     1      'N1/2',5X,'PCT ERROR',4X,'REPEAT',6X,'TOTAL TIME',
     1      9X,'  R(N)  ',
     2     /,11X,'vlen',8X,'sec',12X,'Mflop/s',8X,'vlen',8X,
     3      ' % ',23X,'sec',13X,'Mflop/s')
C
        LNLAST(ICASE,2)=1
        NSEL1=0
        PER=0.0
        NSEND=46
C
        DO 20 NSEL=1,NSEND
C
C         /* SELECT VECTOR LENGTH */
C
          IF (NSEL .LE. 10) N=NSEL
          IF (NSEL .GT. 10 .AND. NSEL .LE. 19) N=10*(NSEL-9)
          IF (NSEL .GT. 19 .AND. NSEL .LE. 28) N=100*(NSEL-18)
          IF (NSEL .GT. 28 .AND. NSEL .LE. 37) N=1000*(NSEL-27)
          IF (NSEL .GT. 37 .AND. NSEL .LE. 46) N=10000*(NSEL-36)
          IF (NSEL .GT. 46) N=100000*(NSEL-45)
C         /*  skip cases after out-of-cache discovery */
          IF (NSEL .LT. NSEL1) GOTO 20
C
          IF (N .GT. NMAX) N=NMAX
C
          IF(PER .EQ. 222.2) THEN
            LNLAST(ICASE,2)=N
            PER=0.0
          ENDIF
C
C         /* TIME VECTOR OPERATION */
C
          CALL DOALL(ICASE,N,TN)
C
C         /*  ESCAPE IF VECTOR TOO LONG */
          IF (N .EQ.0) GOTO 20
C
C         /* UPDATE LEAST SQUARES */
C
          XN=N
          CALL LSTSQ(1,XN,TN,RINF,XN12,PER)
          RINF = RINF*1.0E-6 
C
C         /* SELECT AND SAVE SUMMARY VALUES */
C
          IF(XN12 .LT. 0) THEN
             IF(RINF.LT.0.0 .OR. TN.LT.0.0) THEN
C
C            /* Negative time or larger problem takes less time */
C            /* Value rejected and least squares restarted */
C            /* PER is used to hold marker value for this action */
C
             PER=111.1
C
C            /* re-initialise least-squares fit */
C
             XN=N
             CALL LSTSQ(0,XN,TN,DUM1,DUM2,DUM3)
          ENDIF
C
C        /* any lengths < NTRIP are assumed in-cache */
C        /* suppress out-of-cache trip */
C
         NTRIP=N
         IF(ICASE.EQ.2 .OR. ICASE.EQ.4) NTRIP=8*N
         IF(ICASE.GE.10 .AND. ICASE.LE.13) NTRIP=N*N
         IF(ICASE.EQ.14) NTRIP=128*N
         IF(ICASE.EQ.15) NTRIP=1024*N
C
         IF(RINF.GT.0.0 .AND. ISW.EQ.0 .AND. NTRIP.GT.100) THEN
C
C          /* Going out-of-cache detected (1st time N12<0 and RINF>0) */
C          /* Record in-cache values (take those from two cases before) */
C          /* PER is used to hold marker value for this action */
C
           PER=222.2
           ISW=1
           IBACK=3
           RLAST(ICASE,1)=XRSAVE(NSEL-IBACK)
           XNLAST(ICASE,1)=XNSAVE(NSEL-IBACK)
           LNLAST(ICASE,1)=LNSAVE(NSEL-IBACK)
           PCTMAX(ICASE,1)=ERSAVE(NSEL-IBACK)
         ENDIF
       ENDIF
C
C      /* Save values for future recording */
C      /* make near zero values zero */
C      IF(XN12 .GT. -1.0 .AND. XN12 .LT. 1.0) XN12=0.0
       XRSAVE(NSEL)=RINF
       XNSAVE(NSEL)=XN12
       LNSAVE(NSEL)=N
       ERSAVE(NSEL)=PER
C
C      /* average Mflop/s, minimum and maximum */
C
       RAVER=(N/TN)*1.0E-06
       IF(TN.GT.0.0) THEN
         RAVG(ICASE,1)=MIN(RAVG(ICASE,1),RAVER)
         RAVG(ICASE,2)=MAX(RAVG(ICASE,2),RAVER)
       ENDIF
C
       IF (IODET .EQ. 0) THEN
         WRITE(IOUT,100) NSEL,N,TN,RINF,XN12,PER,NTIM,TOTIM,RAVER
       ENDIF
100    FORMAT(1X,I5,I10,1PE15.6,0PF15.6,F12.3,0PF12.3,I10,3X,
     1       0PE15.6,1X,0PF15.6)
C
       IF(PER .EQ. 222.2) THEN
C
C         /* If out-of-cache detected */
C         /* Restart least squares fit 4 cases further on */
C         /* advance case counter, skip two cases to bypass transition */
C
          NSEL1=NSEL+4
          IF(NSEL1 .GT. NSEND) NSEL1=NSEND
C
C         /* re-initialise least-squares fit */
C
          XN=N
          CALL LSTSQ(0,XN,TN,DUM1,DUM2,DUM3)
        ENDIF
C
C       /* End of NSEL loop /
C
20      CONTINUE
C
C       /* record last values */
        RLAST(ICASE,2)=RINF
        XNLAST(ICASE,2)=XN12
        PCTMAX(ICASE,2)=PER
C
C       /* End of ICASE loop*/
C
200     CONTINUE
C
C       /* PRINT SELECTED VALUES */
C
        WRITE(IOUT,301)
 301    FORMAT(/,/,24X,'SUMMARY OF SELECTED VALUES',/,
     1             24X,'--------------------------',//,
     2  11X,'LENGTHS',7X,'RMSERR/VALUE',
     2  7X,'R-INFINITY',9X,'N-HALF',9X,'   R(N)   ',/,11X,
     3  'vlen',13X,'  %',14X,'Mflop/s',11X,'vlen',12X,'Mflop/s',/)
C
        DO 300 ICASE=1,NCASE
        WRITE(IOUT,310) LABEL(ICASE),LNLAST(ICASE,1),
     1  PCTMAX(ICASE,1),RLAST(ICASE,1),XNLAST(ICASE,1),
     1  RAVG(ICASE,1),LNLAST(ICASE,2),
     1  PCTMAX(ICASE,2),RLAST(ICASE,2),XNLAST(ICASE,2),
     1  RAVG(ICASE,2)
 300    CONTINUE
 310  FORMAT(4X,A80,/,8X,'<=',I6,8X,F10.3,9X,F10.3,6X,F10.3,4X,
     1 '| Min =',F10.3,/,
     1 8X,'>=',I6,8X,F10.3,9X,F10.3,6X,F10.3,4X,'| Max =',F10.3,/)
C
      T11 = DWALLTIME00()
C
      TOTIME=T11-T10
      WRITE(IOUT,25) TOTIME
25    FORMAT(//,5X,'TOTAL EXECUTION TIME IS ',1PE20.10,' SECONDS.')
C
      CLOSE(IOUT)
C
C
      PRINT *,'Benchmark completed.'
C
      STOP
      END
