      SUBROUTINE ESTCOM(ERINF,ESTART,EOVER,MTIME,
     &                  MY_ID,MASTER_ID,SLAVE_ID,A)
C
      EXTERNAL DWALLTIME00
C
      INCLUDE 'fpvm3.h'
      INCLUDE 'dattyp.inc'
      INCLUDE 'comms2.inc'
C
c     /* PVM Variables - INFO - stores result of various PVM calls */
C
      INTEGER INFO, NMAX
      PARAMETER(NMAX=MAXLEN/IDPLEN)
C
C     /* Estimated R-infinity, startup time and loop overhead */
C
      DOUBLE PRECISION ERINF, ESTART, EOVER
C
C     /* Desired measurement time for each test case */
C
      DOUBLE PRECISION MTIME
C
C     /* Process IDs */
C
      INTEGER MY_ID, MASTER_ID, SLAVE_ID
C
C     /* The array to send/receive */
C
      DOUBLE PRECISION A(NMAX)
      INTEGER CASE, NREPT, MSGNUM, LENGTH
      DOUBLE PRECISION TIME(4),T1,T2, ELAPSED
      DOUBLE PRECISION DWALLTIME00
c
c     Master code.
c
      IF (MY_ID .EQ. MASTER_ID) THEN
        DO 50, CASE=1, 4
        LENGTH = MAXLEN/CASE
C      
C         /* Note there will be 2 repeats on first iteration */
C
          NREPT = 1
          ELAPSED = 0
 10       IF (ELAPSED .LT. MTIME) THEN
            NREPT = NREPT * 2
            call pvmfinitsend( PVMDEFAULT, info )
            call pvmfpack( ITYPE, NREPT, 1, 1, info )
            call pvmfsend( SLAVE_ID, 30, info )
C
C           /* Synchronize to make sure the slave is ready */
C
            call pvmfinitsend( PVMDEFAULT, info )
            call pvmfpack( ITYPE, LENGTH, 1, 1, info )
            call pvmfsend( SLAVE_ID, 31, info )
            T1 = DWALLTIME00()
            DO 20 MSGNUM = 1,NREPT
              CALL DUMMY(MSGNUM)
              call pvmfinitsend( PVMDEFAULT, info )
              call pvmfpack( BYTE1, A, LENGTH, 1, info )
              call pvmfsend( SLAVE_ID, 10, info )
              call pvmfrecv( -1, 20, info )
              call pvmfunpack( BYTE1, A, LENGTH, 1, info )
 20         CONTINUE
            T2 = DWALLTIME00()
            ELAPSED = T2-T1
            TIME(CASE) = (ELAPSED-EOVER*NREPT)/(NREPT*2)
            GOTO 10
          ENDIF
 50     CONTINUE
C
C       /* Inform the slave we've finished making timings for estimates */
C
        NREPT = 0
        call pvmfinitsend( PVMDEFAULT, info )
        call pvmfpack( ITYPE, NREPT, 1, 1, info )
        call pvmfsend( SLAVE_ID, 30, info )
C
C       /* Calculate the actual estimates from the timings */
C       /* Note that the calculation of ESTART relies on the fact that */
C       /* the first set of messages are twice the length of the second */
C
        ERINF = MAXLEN/(TIME(1)-TIME(4))
        ESTART = (4*TIME(4))-TIME(1)
C
C       /* Send the estimates to the slave */
C
        call pvmfinitsend( PVMDEFAULT, info )
        call pvmfpack( DTYPE, ERINF, 1, 1, info )
        call pvmfsend( SLAVE_ID, 32, info )
        call pvmfinitsend( PVMDEFAULT, info )              
        call pvmfpack( DTYPE, ESTART, 1, 1, info )              
        call pvmfsend( SLAVE_ID, 33, info )              
c
c	Slave code...
c
      ELSEIF (MY_ID .EQ. SLAVE_ID) THEN
        call pvmfrecv(-1 , 30, info )
        call pvmfunpack( ITYPE, NREPT, 1, 1, info )
 30     IF (NREPT .NE. 0) THEN
          call pvmfrecv(-1 , 31, info )
          call pvmfunpack( ITYPE, LENGTH, 1, 1, info )          
          DO 40 MSGNUM = 1,NREPT
            call pvmfrecv(-1 , 10, info )
            call pvmfunpack( BYTE1, A, LENGTH, 1, info )
            call pvmfinitsend( PVMDEFAULT, info )              
            call pvmfpack( BYTE1, A, LENGTH, 1, info )              
            call pvmfsend( MASTER_ID, 20, info )              
 40       CONTINUE
          call pvmfrecv(-1 , 30, info )
          call pvmfunpack( ITYPE, NREPT, 1, 1, info )
        GOTO 30
        ENDIF
C
C       /* Receive the estimates from the master */
C
        call pvmfrecv(-1 , 32, info )
        call pvmfunpack( DTYPE, ERINF, 1, 1, info )
        call pvmfrecv(-1 , 33, info )
        call pvmfunpack( DTYPE, ESTART, 1, 1, info )
      ENDIF
      RETURN
      END
