      SUBROUTINE PDTRANSINFO( SUMMRY, NOUT, NMAT, MVAL, NVAL, LDVAL,
     $                      NBMAT, MBVAL, NBVAL, LDNBVAL, NGRIDS,
     $                      NPVAL, NQVAL, LDPQVAL, IASEED, IMROW,
     $                      IMCOL, THRESH, WORK, IAM, NPROCS )
*
*  -- PUMMA Package routine (version 2.1) --
*     Jaeyoung Choi, Oak Ridge National Laboratory.
*     Jack Dongarra, Univ. of Tennessee, Oak Ridge National Laboratory.
*     David Walker,  Oak Ridge National Laboratory.
*     March 26, 1995.
*
*     .. Scalar Arguments ..
      CHARACTER*( * )    SUMMRY
      INTEGER            IAM, IASEED, IMCOL, IMROW, LDNBVAL, LDPQVAL
      INTEGER            LDVAL, NBMAT, NGRIDS, NMAT, NOUT, NPROCS
      REAL               THRESH
*     ..
*     .. Array Arguments ..
      INTEGER            MBVAL( LDNBVAL ), MVAL( LDVAL )
      INTEGER            NBVAL( LDNBVAL ), NPVAL( LDPQVAL )
      INTEGER            NQVAL( LDPQVAL ), NVAL( LDVAL )
      INTEGER            WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDTRANSINFO gets needed startup info and transmits it to all processes.
*
*  Arguments
*  =========
*
*  SUMMRY  (output) CHARACTER*( * )
*          Name of output (summary) file (if any). Only defined for process 0.
*
*  NOUT    (output) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr.  Only defined for process 0.
*
*  NMAT    (output) INTEGER
*          The number of different values that can be used for M and N.
*
*  MVAL    (output) INTEGER
*          Array, dimension(LDVAL), the values of M to run code with.
*
*  NVAL    (output) INTEGER
*          Array, dimension(LDVAL), the values of N to run code with.
*
*  LDVAL   (input) INTEGER
*          Leading dimension of the arrays MVAL and NVAL, LDVAL >= NMAT.
*
*  NBMAT   (output) INTEGER
*          The number of different values that can be used for MB and NB.
*
*  MBVAL   (output) INTEGER
*          Array, dimension(LDVAL), the values of MB to run code with.
*
*  NBVAL   (output) INTEGER
*          Array, dimension(LDVAL), the values of NB to run code with.
*
*  LDNBVAL (input) INTEGER
*          Leading dimension of the arrays MBVAL and NBVAL,
*          LDNBVAL >= NMAT.
*
*  NGRIDS  (output) INTEGER
*          The number of different values that can be used for P & Q.
*
*  NPVAL   (output) INTEGER
*          Array, dimension(LDPQVAL), the values of P (number of process
*          rows) to run code with.
*
*  NQVAL   (output) INTEGER
*          Array, dimension(LDPQVAL), the values of Q (number of process
*          columns) to run code with.
*
*  LDPQVAL (input) INTEGER
*          The maximum number of different values that can be used for P & Q,
*          LDPQVAL >= NGRIDS.
*
*  IASEED  (output) INTEGER
*          Seed number to generate A.
*
*  IMROW   (output) INTEGER
*          Starting row position of matrix A.
*
*  IMCOL   (output) INTEGER
*          Starting column position of matrix A.
*
*  THRESH  (output) DOUBLE PRECISION
*          Allowed threshold for the check.
*
*  WORK    (workspace) INTEGER
*          Array used to pack all input arrays.
*
*  IAM     (input) INTEGER
*          My process number.
*
*  NNODES  (input/output) INTEGER
*          The total number of processes.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            NIN
      PARAMETER        ( NIN = 11 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, ICTXT, IPWRK
      DOUBLE PRECISION   EPS
*     ..
*     .. Local Arrays ..
      CHARACTER*79       USRINFO
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINIT, BLACS_SETUP,
     $                   IGEBR2D, IGEBS2D, SGEBR2D, SGEBS2D
      EXTERNAL           ICOPY
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MAX
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           PDLAMCH
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Executable Statements ..
*
*     Process 0 reads the input data, broadcasts to other nodes and
*     writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
*
*         Open file and skip data file header
*
          OPEN(UNIT=NIN, FILE='TRANS.dat', STATUS='Old')
          READ(NIN, *) SUMMRY
          SUMMRY = ' '
*
*         Read in user-supplied info about machine type, compiler, etc.
*
          READ(NIN,10000) USRINFO
*
*         Read name and unit number for summary output file
*
          READ(NIN,*) SUMMRY
          READ(NIN,*) NOUT
          IF( NOUT.NE.0 .AND. NOUT.NE.6 )
     $        OPEN(UNIT=NOUT, FILE=SUMMRY, STATUS='UNKNOWN')
*
*         Get values of M and N
*
          READ(NIN,*) NMAT
          IF( NMAT.LT.1 .OR. NMAT.GT.LDVAL ) THEN
              WRITE(NOUT,2000) 'M', LDVAL
              GOTO 30
          END IF
          READ(NIN,*) ( MVAL(I), I = 1, NMAT )
          READ(NIN,*) ( NVAL(I), I = 1, NMAT )
*
*         Get values of MB and NB
*
          READ(NIN,*) NBMAT
          IF( (NBMAT.LT.1).OR.(NBMAT.GT.LDNBVAL) )THEN
              WRITE(NOUT,2000) 'NB', LDNBVAL
              GOTO 30
          END IF
          READ(NIN,*) ( MBVAL(I), I = 1, NBMAT )
          READ(NIN,*) ( NBVAL(I), I = 1, NBMAT )
*
*         Get IASEED
*
          READ(NIN,*) IASEED
*
*         Get IMROW and IMCOL >= (0,0)
*
          READ(NIN,*) IMROW, IMCOL
          IF( IMROW.LT.0 ) IMROW = 0
          IF( IMCOL.LT.0 ) IMCOL = 0
*
*         Get values of P, Q
*
          READ(NIN,*) NGRIDS
          IF( (NGRIDS.LT.1).OR.(NGRIDS.GT.LDPQVAL) )THEN
             WRITE(NOUT,2000) 'Grids', LDPQVAL
             GOTO 30
          END IF
          READ(NIN,*) ( NPVAL(I), I = 1, NGRIDS )
          READ(NIN,*) ( NQVAL(I), I = 1, NGRIDS )
*
*         Make sure (IMROW, IMCOL) <= (NPVAL(*), NQVAL(*))
*
          DO 10 I = 1, NGRIDS
             IMROW = MIN( IMROW, NPVAL(I)-1 )
             IMCOL = MIN( IMCOL, NQVAL(I)-1 )
   10     CONTINUE
*
*         Get level of checking
*
          READ(NIN,*) THRESH
*
          CLOSE( NIN )
*
*         Create "blacs_setup.dat" file for this executable
*
          OPEN(UNIT=NIN, FILE='blacs_setup.dat', STATUS='UNKNOWN')
          WRITE(NIN,*)'TRANS_pvm'
          CLOSE( NIN )
*
*         For pvm only: if virtual machine not set up, allocate it and
*         spawn the correct number of processes.
*
          IF( NPROCS.LT.1 ) THEN
              NPROCS = 0
              DO 20 I = 1, NGRIDS
                 NPROCS = MAX( NPROCS, NPVAL(I)*NQVAL(I) )
   20         CONTINUE
              CALL BLACS_SETUP( IAM, NPROCS )
          END IF
*
*         Temporarily define blacs grid to include all processes so
*         information can be broadcast to all processes
*
          CALL BLACS_GET( -1, 0, ICTXT )
          CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*         Compute machine epsilon
*
	  EPS = PDLAMCH( ICTXT, 'eps' )
*
*         Pack information arrays and broadcast
*
          IPWRK = 1
          WORK(IPWRK) = NMAT
          IPWRK = IPWRK + 1
          WORK(IPWRK) = NBMAT
          IPWRK = IPWRK + 1
          WORK(IPWRK) = NGRIDS
          IPWRK = IPWRK + 1
          CALL SGEBS2D( ICTXT, 'All', '1-Tree', 1, 1, THRESH, 1 )
          CALL ICOPY( NMAT, MVAL, 1, WORK(IPWRK), 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, NVAL, 1, WORK(IPWRK), 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NBMAT, MBVAL, 1, WORK(IPWRK), 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, NBVAL, 1, WORK(IPWRK), 1 )
          IPWRK = IPWRK + NBMAT
          WORK(IPWRK) = IASEED
          IPWRK = IPWRK + 1
          WORK(IPWRK) = IMROW
          IPWRK = IPWRK + 1
          WORK(IPWRK) = IMCOL
          IPWRK = IPWRK + 1
          CALL ICOPY( NGRIDS, NPVAL, 1, WORK(IPWRK), 1 )
          IPWRK = IPWRK + NGRIDS
          CALL ICOPY( NGRIDS, NQVAL, 1, WORK(IPWRK), 1)
          IPWRK = IPWRK + NGRIDS-1
          WORK(IPWRK+1) = IPWRK
          CALL IGEBS2D( ICTXT, 'All', '1-Tree', 1, 1, WORK(IPWRK+1), 1 )
          CALL IGEBS2D( ICTXT, 'All', '1-Tree', IPWRK, 1, WORK, IPWRK )
*
*         regurgitate input
*
          WRITE(NOUT,500) 'ScaLAPACK driver for full matrix transpose.'
          WRITE(NOUT,500) USRINFO
          WRITE(NOUT,500) '     '
          WRITE(NOUT,500) 'Running tests for C := A^T'
          WRITE(NOUT,500) 'The following scaled residual check will'//
     $                    ' be computed:'
          WRITE(NOUT,500) '  MAX( ABS( C( I, J ) - A^T( I, J ) ) )'//
     $                    ' for all I and J.'
          WRITE(NOUT,500) 'The matrix A is randomly '//
     $                    'generated for each test.'
          WRITE(NOUT,500) '    '
          WRITE(NOUT,500) 'An explanation of the input/output '//
     $                    'parameters follows:'
          WRITE(NOUT,500) 'M      : The number of rows in matrix A'//
     $                    ' and the number of columns in matrix C.'
          WRITE(NOUT,500) 'N      : The number of columns in matrix A'//
     $                    ' and the number of rows in matrix C.'
          WRITE(NOUT,500) 'MB     : The size of the row-blocks of A '//
     $                    'and the col-blocks of C.'
          WRITE(NOUT,500) 'NB     : The size of the col-blocks of A '//
     $                    'and the row-blocks of C.'
          WRITE(NOUT,500) 'P      : The number of process rows.'
          WRITE(NOUT,500) 'Q      : The number of process columns.'
          WRITE(NOUT,500) 'THRESH : If residual value is less than'//
     $                    ' THRESH, CHECK is flagged as PASSED.'
          WRITE(NOUT,500) 'TIME   : Time in seconds to perform the '//
     $                    'matrix transpose.'
          WRITE(NOUT,500) 'RESID  : value of the scaled residual'
          WRITE(NOUT,500) '   '
          WRITE(NOUT,500) 'The following parameter values will be used:'
          WRITE(NOUT,5000) 'M    ',( MVAL(I), I = 1, MIN(NMAT, 10) )
          IF( NMAT.GT.10 ) WRITE(NOUT,5000) ( MVAL(I), I = 11, NMAT )
          WRITE(NOUT,5000) 'N    ',( NVAL(I), I = 1, MIN(NMAT, 10) )
          IF( NMAT.GT.10 ) WRITE(NOUT,5000) ( NVAL(I), I = 11, NMAT )
          WRITE(NOUT,5000) 'MB   ',( MBVAL(I), I = 1, MIN(NBMAT, 10) )
          IF( NBMAT.GT.10 ) WRITE(NOUT,5000) ( NBVAL(I), I = 11, NBMAT )
          WRITE(NOUT,5000) 'NB   ',( NBVAL(I), I = 1, MIN(NBMAT, 10) )
          IF( NBMAT.GT.10 ) WRITE(NOUT,5000) ( NBVAL(I), I = 11, NBMAT )
          WRITE(NOUT,5000) 'P    ',( NPVAL(I), I = 1, MIN(NGRIDS, 10) )
          IF( NGRIDS.GT.10 )
     $        WRITE(NOUT,5000) ( NPVAL(I), I = 11, NGRIDS )
          WRITE(NOUT,5000) 'Q    ',( NQVAL(I), I = 1, MIN(NGRIDS, 10) )
          IF( NGRIDS.GT.10 )
     $        WRITE(NOUT,5000) ( NQVAL(I), I = 11, NGRIDS )
          WRITE(NOUT,500) '    '
          WRITE(NOUT,8000) IMROW, IMCOL
          WRITE(NOUT,4000) EPS
          WRITE(NOUT,9000) THRESH
*
      ELSE
*
*         If in pvm, must participate setting up virtual machine
*
          IF( NPROCS.LT.1 ) CALL BLACS_SETUP( IAM, NPROCS )
*
*         Temporarily define blacs grid to include all processes so
*         all processes have needed startup information
*
          CALL BLACS_GET( -1, 0, ICTXT )
          CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*         Compute machine epsilon
*
	  EPS = PDLAMCH( ICTXT, 'eps' )
*
          CALL SGEBR2D( ICTXT, 'All', '1-Tree', 1, 1, THRESH, 1, 0, 0 )
          CALL IGEBR2D( ICTXT, 'All', '1-Tree', 1, 1, WORK, 1, 0, 0 )
          IPWRK = WORK(1)
          CALL IGEBR2D( ICTXT, 'All', '1-Tree', IPWRK, 1, WORK, IPWRK,
     $                  0, 0 )
*
*         Unpack received information
*
          IPWRK = 1
          NMAT = WORK(IPWRK)
          IPWRK = IPWRK + 1
          NBMAT = WORK(IPWRK)
          IPWRK = IPWRK + 1
          NGRIDS = WORK(IPWRK)
          IPWRK = IPWRK + 1
          CALL ICOPY( NMAT, WORK(IPWRK), 1, MVAL, 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, WORK(IPWRK), 1, NVAL, 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NBMAT, WORK(IPWRK), 1, MBVAL, 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, WORK(IPWRK), 1, NBVAL, 1 )
          IPWRK = IPWRK + NBMAT
          IASEED = WORK(IPWRK)
          IPWRK = IPWRK + 1
          IMROW = WORK(IPWRK)
          IPWRK = IPWRK + 1
          IMCOL = WORK(IPWRK)
          IPWRK = IPWRK + 1
          CALL ICOPY( NGRIDS, WORK(IPWRK), 1, NPVAL, 1 )
          IPWRK = IPWRK + NGRIDS
          CALL ICOPY( NGRIDS, WORK(IPWRK), 1, NQVAL, 1 )
      END IF
*
      CALL BLACS_GRIDEXIT( ICTXT )
*
      RETURN
*
*     Prints error message if illegal input file
*
   30 WRITE(NOUT,1000)
      CLOSE( NIN )
      IF ( IAM.EQ.0 .AND. NOUT.NE.6 .AND. NOUT.NE.0 ) CLOSE( NOUT )
*
      CALL BLACS_ABORT( ICTXT, 1 )
      STOP
*
  500 FORMAT(A)
 1000 FORMAT(' ILLEGAL INPUT IN FILE ',40A,'.  ABORTING RUN.')
 2000 FORMAT(' NUMBER OF VALUES OF ',5A, ' IS LESS THAN 1 OR GREATER ',
     $       'THAN ', I2 )
 4000 FORMAT('Relative machine precision (eps) is taken to be ',E18.6)
 5000 FORMAT(2X,A5,':        ',10I6)
 8000 FORMAT('The matrices start in processor (',I4,',',I4,').')
 9000 FORMAT('Routines pass computational tests if scaled residual is',
     $       ' less than ',G14.7)
10000 FORMAT(A79)
*
*     End of PDTRANSINFO
*
      END
