      PROGRAM PDTRANSDRIVER
*
*  -- PUMMA Package routine (version 2.1) --
*     Jaeyoung Choi, Oak Ridge National Laboratory.
*     Jack Dongarra, Univ. of Tennessee, Oak Ridge National Laboratory.
*     David Walker,  Oak Ridge National Laboratory.
*     March 26, 1995.
*
*  Purpose: Driver routine for testing the full matrix transpose.
*  =======
*
*    The user should modify TOTMEM to indicate the maximum amount of memory
*  in bytes his system has.  Remember to leave room in memory for operating
*  system, the buffer of the communication package, etc ...
*
*    The constants INTGSZ and DBLESZ indicate the length in bytes on the
*  given platform for an integer and a double precision real. For example,
*  on a system with 8 MB of memory, the parameters we use are
*  TOTMEM=6200000 (leaving 1.8 MB for OS, code, communication buffer, etc).
*  However, for PVM, we usually set TOTMEM = 2000000.
*  The length of a double precision real is 8, and an integer takes up 4 bytes.
*
*    Some playing around to discover what the maximum value you can set
*  TOTMEM to may be required. All arrays used by the factorization and
*  check are allocated out of the array called MEM. The integer IPA,
*  for example, indicates the element of MEM that the answer vector(s)
*  A begin(s) on.
*
*  Global variables
*  ================
*
*     .. Parameters ..
      INTEGER            TOTMEM, MEMSIZ, INTGSZ, DBLESZ
      INCLUDE 'TOTMEM.inc'
      PARAMETER        ( INTGSZ = 4, DBLESZ = 8 )
      PARAMETER        ( MEMSIZ = TOTMEM / DBLESZ )
*
*     Maximum number of tests to be performed.
*
      INTEGER            NTESTS
      PARAMETER        ( NTESTS = 20 )
      DOUBLE PRECISION   ZERO
      PARAMETER        ( ZERO = 0.0D+0 )
*     ..
*     .. Scalars ..
      INTEGER            I, IAM, IASEED, ICTXT, II, IMCOL, IMROW, IPA
      INTEGER            IPC, IPIW, IPW, ISW, J, KFAIL, KPASS, KSKIP
      INTEGER            KTESTS, LCM, LDA, LDC, M, MB, MG, MP, MP0, MQ
      INTEGER            MQ0, MYCOL, MYROW, N, NB, NBMAT, NG, NGRIDS
      INTEGER            NMAT, NOUT, NP, NP0, NPCOL, NPROCS, NPROW
      INTEGER            NQ, NQ0
      REAL               THRESH
      DOUBLE PRECISION   EPS, RESID
*     ..
*     .. Arrays ..
      CHARACTER*6        PASSED
      CHARACTER*80       OUTFILE
      INTEGER            IERR(1)
      INTEGER            MBVAL( NTESTS ), MVAL( NTESTS )
      INTEGER            NBVAL( NTESTS ), NPVAL( NTESTS )
      INTEGER            NQVAL( NTESTS ), NVAL( NTESTS )
      DOUBLE PRECISION   MEM( MEMSIZ )
      DOUBLE PRECISION   CTIME(2), WTIME(2)
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_BARRIER, BLACS_EXIT, BLACS_GET,
     $                   BLACS_GRIDEXIT, BLACS_GRIDINFO, BLACS_GRIDINIT,
     $                   BLACS_PINFO, IGSUM2D, SLBOOT, SLCOMBINE,
     $                   SLTIMER
      EXTERNAL           PDMATCMP, PDMATGEN, PDTRANS, PDTRANSINFO
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX
*     ..
*     .. External Functions ..
      INTEGER            ILCM, ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ILCM, ICEIL, NUMROC, PDLAMCH
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Data Statements ..
      DATA               KTESTS, KPASS, KFAIL, KSKIP /4*0/
*
* ======================================================================
*
*     Get starting information
*
      CALL BLACS_PINFO( IAM, NPROCS )
*
      CALL PDTRANSINFO( OUTFILE, NOUT, NMAT, MVAL, NVAL, NTESTS,
     $                NBMAT, MBVAL, NBVAL, NTESTS, NGRIDS, NPVAL,
     $                NQVAL, NTESTS, IASEED, IMROW, IMCOL, THRESH,
     $                MEM, IAM, NPROCS )
*
*     Print headings
*
      IF( IAM.EQ.0 ) THEN
          WRITE(NOUT,14000) '   '
          WRITE(NOUT,5000)
          WRITE(NOUT,6000)
          WRITE(NOUT,14000) '   '
      END IF
*
*     Loop over different process grids
*
      DO 30 J = 1, NGRIDS
*
         NPROW = NPVAL( J )
         NPCOL = NQVAL( J )
*
*        Make sure grid information is correct
*
         IERR(1) = 0
         IF( NPROW.LT.1 ) THEN
             IF( IAM.EQ.0 ) WRITE(NOUT,1000) 'GRID', 'nprow', NPROW
             IERR(1) = 1
         ELSE IF( NPCOL.LT.1 ) THEN
             IF( IAM.EQ.0 ) WRITE(NOUT,1000) 'GRID', 'npcol', NPCOL
             IERR(1) = 1
         ELSE IF( NPROW*NPCOL.GT.NPROCS ) THEN
             IF( IAM.EQ.0 ) WRITE(NOUT,2000)  NPROW*NPCOL, NPROCS
             IERR(1) = 1
         END IF
*
         IF( IERR(1).GT.0 ) THEN
             IF( IAM .EQ. 0 ) WRITE(NOUT,3000) 'grid'
             KSKIP = KSKIP + 1
             GOTO 30
         END IF
*
*        Define process grid
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*        Go to bottom of process grid loop if this case doesn't use my process
*
         IF ( MYROW .GE. NPROW .OR. MYCOL .GE. NPCOL ) GOTO 30
*
	 EPS = PDLAMCH( ICTXT, 'eps' )
*
         DO 20 I = 1, NMAT
*
            M = MVAL( I )
            N = NVAL( I )
*
*           Make sure matrix information is correct
*
            IERR(1) = 0
            IF( M.LT.1 ) THEN
                IF( IAM.EQ.0 ) WRITE(NOUT,1000) 'MATRIX', 'M', M
                IERR(1) = 1
            ELSE IF( N.LT.1 ) THEN
                IF( IAM.EQ.0 ) WRITE(NOUT,1000) 'MATRIX', 'N', N
                IERR(1) = 1
            END IF
*
*           Make sure no one had error
*
            CALL IGSUM2D( ICTXT, 'a', 'h', 1, 1, IERR, 1, -1, 0 )
*
            IF( IERR(1).GT.0 ) THEN
                IF( IAM.EQ.0 ) WRITE(NOUT,3000) 'matrix'
                KSKIP = KSKIP + 1
                GOTO 20
            END IF
*
*           Loop over different block sizes
*
            DO 10 II = 1, NBMAT
*
               MB = MBVAL( II )
               NB = NBVAL( II )
*
*              Make sure blocking sizes are legal
*
               IERR(1) = 0
               IF( MB.LT.1 ) THEN
                   IERR(1) = 1
                   IF ( IAM.EQ.0 ) WRITE(NOUT,1000) 'MB', 'MB', MB
               ELSE IF( NB.LT.1 ) THEN
                   IERR(1) = 1
                   IF ( IAM.EQ.0 ) WRITE(NOUT,1000) 'NB', 'NB', NB
               END IF
*
*              Make sure no one had error
*
               CALL IGSUM2D( ICTXT, 'a', 'h', 1, 1, IERR, 1, -1, 0 )
*
               IF( IERR(1).GT.0 ) THEN
                   IF( IAM.EQ.0 ) WRITE(NOUT,3000) 'NB'
                   KSKIP = KSKIP + 1
                   GOTO 10
               END IF
*
               MP = NUMROC( M, MB, MYROW, IMROW, NPROW )
               MQ = NUMROC( M, MB, MYCOL, IMCOL, NPCOL )
               NP = NUMROC( N, NB, MYROW, IMROW, NPROW )
               NQ = NUMROC( N, NB, MYCOL, IMCOL, NPCOL )
*
               MG = ICEIL( M, MB )
               NG = ICEIL( N, NB )
*
               MP0 = ICEIL( MG, NPROW ) * MB
               MQ0 = ICEIL( MG, NPCOL ) * MB
               NP0 = ICEIL( NG, NPROW ) * NB
               NQ0 = ICEIL( NG, NPCOL ) * NB
*
               LCM = ILCM( NPROW, NPCOL )
               IPC = 1
               IPA = IPC + NP0 * MQ0
               IPIW= MP0 * NQ0 + IPA
               IPW = IPIW + 
     $               ICEIL( 3*INTGSZ*MAX( NPCOL, NPROW ), DBLESZ )
               ISW = IPW + 2 * ICEIL( MG, LCM ) * MB * 
     $               ICEIL( NG, LCM ) * NB
*
*              Make sure have enough memory to handle problem
*
               IF( ISW.GT.MEMSIZ ) THEN
                   IF( IAM.EQ.0 ) WRITE(NOUT,4000) 'MULTI', ISW*DBLESZ
                   IERR(1) = 1
               END IF
*
*              Make sure no one had error
*
               CALL IGSUM2D( ICTXT, 'a', 'h', 1, 1, IERR, 1, -1, 0 )
*
               IF( IERR(1).GT.0 ) THEN
                   IF( IAM.EQ.0 ) WRITE(NOUT,3000) 'MEMORY'
                   KSKIP = KSKIP + 1
                   GOTO 10
               END IF
*
*              Generate matrix A
*
               LDA = MAX( 1, MP )
               CALL PDMATGEN( ICTXT, 'N', 'N', M, N, MB, NB,
     $                       MEM(IPA), LDA, IMROW, IMCOL, IASEED,
     $                       0, MP, 0, NQ, MYROW, MYCOL, NPROW,
     $                       NPCOL )
*
               CALL SLBOOT()
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 1 )
*
*              Perform the matrix transpose
*
               LDC = MAX( 1, NP )
               CALL PDTRANS( 'T', M, N, MB, NB, MEM(IPA), LDA, ZERO,
     $                      MEM(IPC), LDC, IMROW, IMCOL, MEM(IPW),
     $                      MEM(IPIW) )
*
               CALL SLTIMER( 1 )
*
               IF( THRESH.GT.0.0E+0 ) THEN
*
*                  Regenerate matrix A in transpose form (A')
*
		   LDA = MAX( 1, NP )
                   CALL PDMATGEN( ICTXT, 'T', 'N', N, M, NB, MB,
     $                            MEM(IPA), LDA, IMROW, IMCOL, IASEED,
     $                            0, NP, 0, MQ, MYROW, MYCOL, NPROW,
     $                            NPCOL )
*
*                  Compare A' to C
*
                   CALL PDMATCMP( ICTXT, NP, MQ, MEM(IPA), LDA,
     $                            MEM(IPC), LDC, RESID )
*
                   IF( (RESID.LE.THRESH).AND.
     $                 ((RESID-RESID).EQ.ZERO ) ) THEN
                       KPASS = KPASS + 1
                       PASSED = 'PASSED'
                   ELSE
                       KFAIL = KFAIL + 1
                       PASSED = 'FAILED'
                   END IF
               ELSE
*
*                  Don't perform the checking, only the timing operation
*
                   KPASS = KPASS + 1
                   RESID = RESID-RESID
                   PASSED = 'BYPASS'
               END IF
*
*              Gather maximum of all CPU and WALL clock timings
*
               CALL SLCOMBINE( ICTXT, 'All', '>', 'W', 1, 1, WTIME )
               CALL SLCOMBINE( ICTXT, 'All', '>', 'C', 1, 1, CTIME )
*
*              Print results
*
               IF( (MYROW.EQ.0).AND.(MYCOL.EQ.0) ) THEN
*
*                  Print WALL time if machine supports it
*
                   IF( WTIME( 1 ).GT.0.0D+0 )
     $                 WRITE(NOUT,7000) 'WALL', M, N, MB, NB, NPROW,
     $                           NPCOL, WTIME(1), PASSED, RESID
*
*                  Print CPU time if machine supports it
*
                   IF( CTIME( 1 ).GE.0.0D+0 )
     $                 WRITE(NOUT,7000) 'CPU ', M, N, MB, NB, NPROW,
     $                            NPCOL, CTIME(1), PASSED, RESID
               END IF
   10       CONTINUE
   20    CONTINUE
*
	 CALL BLACS_GRIDEXIT( ICTXT )
*
   30 CONTINUE
*
*     Print out ending messages and close output file
*
      IF( IAM.EQ.0 ) THEN
          KTESTS = KPASS + KFAIL + KSKIP
          WRITE(NOUT,14000) '    '
          WRITE(NOUT,10000) KTESTS
          IF( THRESH.GT.0.0E+0 ) THEN
              WRITE(NOUT,11000) KPASS
              WRITE(NOUT,12000) KFAIL
          ELSE
              WRITE(NOUT,15000) KPASS
          END IF
          WRITE(NOUT,13000) KSKIP
          WRITE(NOUT,14000) '    '
          WRITE(NOUT,14000) '    '
          WRITE(NOUT,14000) 'END OF TESTS.'
          IF( NOUT.NE.6 .AND. NOUT.NE.0 ) CLOSE( NOUT )
      END IF
 1000 FORMAT('ILLEGAL ',A6,': ',A5,' = ',I3,'; It should be at least 1')
 2000 FORMAT('ILLEGAL GRID: nprow*npcol = ',I4,'. It can be at most',I4)
 3000 FORMAT('Bad ',A6,' parameters: going on to next test case.')
 4000 FORMAT('Unable to perform ',A,': need TOTMEM of at least',I11)
 5000 FORMAT('TIME',1X,'  M  ',1X,'  N  ',1X,' MB',1X,' NB',1X,
     $       ' P ',1X,' Q ',1X,'  TIME  ',1X,'CHECK ',1X,'RESID')
 6000 FORMAT('---- ----- ----- --- --- --- --- -------- ------ -----')
 7000 FORMAT(A4,1X,I5,1X,I5,1X,I3,1X,I3,1X,
     $       I3,1X,I3,1X,F8.2,1X,A6,1X,F5.2)
10000 FORMAT('Finished',I4, ' tests, with the following results:')
11000 FORMAT(I5,' tests completed and passed residual checks.')
12000 FORMAT(I5,' tests completed and failed residual checks.')
13000 FORMAT(I5,' tests skipped because of illegal input values.')
14000 FORMAT(A)
15000 FORMAT(I5,' tests completed without checking' )
*
      CALL BLACS_EXIT( 0 )
*
      STOP
*
*
*     End of PDTRANSDRIVER
*
      END
