      SUBROUTINE PDLAFCHK( AFORM, DIAG, M, N, A, IA, JA, DESCA, IASEED,
     $                     ANORM, FRESID, WORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          AFORM, DIAG
      INTEGER            IA, IASEED, JA, M, N
      DOUBLE PRECISION   ANORM, FRESID
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLAFCHK computes the residual
*       || sub( A ) - sub( Ao ) || / (|| sub( Ao ) ||*eps*MAX(M,N)),
*  where Ao will be regenerated by the parallel random matrix generator,
*  sub( A ) = A( IA:IA+M-1, JA:JA+N-1 ) and ||.|| stands for the infini-
*  ty norm.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  AFORM   (global input) CHARACTER
*          sub( A ) is overwritten with:
*             - a symmetric matrix, if AFORM = 'S';
*             - a Hermitian matrix, if AFORM = 'H';
*             - the transpose of what would normally be generated,
*               if AFORM = 'T';
*             - the conjugate transpose of what would normally be
*               generated, if AFORM = 'C';
*             - otherwise a random matrix.
*
*  DIAG    (global input) CHARACTER
*          if DIAG = 'D' : sub( A ) is diagonally dominant.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on, i.e. the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on, i.e. the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A,LOCq(JA+N-1)).
*          On entry, this array contains the local pieces of the M-by-N
*          distributed matrix sub( A ) to be checked. On exit, this
*          array contains the local pieces of the difference
*          sub( A ) - sub( Ao ).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  IASEED  (global input) INTEGER
*          The seed number to generate the original matrix Ao.
*
*  ANORM   (global input) DOUBLE PRECISION
*          The Infinity norm of sub( A ).
*
*  FRESID  (global output) DOUBLE PRECISION
*          The maximum (worst) factorizational error.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (LWORK).
*          LWORK >= Mp0 * NB_A, where
*
*          IROFFA = MOD( IC-1, MB_C ),
*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ),
*          MpA0 = NUMROC( M+IROFFA, MB_A, MYROW, IAROW, NPROW ),
*
*          WORK is used to store a block of columns of sub( A ).
*          INDXG2P and NUMROC are ScaLAPACK tool functions; MYROW,
*          MYCOL, NPROW and NPCOL can be determined by calling the
*          subroutine BLACS_GRIDINFO.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE
      PARAMETER          ( ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            IACOL, IAROW, ICOFF, ICTXT, IIA, IOFFA, IROFF,
     $                   JB, JJ, JJA, JN, MP, MYCOL, MYROW, NPCOL,
     $                   NPROW, NQ
      DOUBLE PRECISION   EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DMATADD, INFOG2L, PDMATGEN
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH, PDLANGE
      EXTERNAL           ICEIL, NUMROC, PDLAMCH, PDLANGE
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      EPS = PDLAMCH( ICTXT, 'eps' )
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
*
*     Compute sub( A ) := sub( A ) - sub( Ao )
*
      IROFF = MOD( IA-1, DESCA( 3 ) )
      ICOFF = MOD( JA-1, DESCA( 4 ) )
      MP = NUMROC( M+IROFF, DESCA( 3 ), MYROW, IAROW, NPROW )
      NQ = NUMROC( N+ICOFF, DESCA( 4 ), MYCOL, IACOL, NPCOL )
      IF( MYROW.EQ.IAROW )
     $   MP = MP-IROFF
      IF( MYCOL.EQ.IACOL )
     $   NQ = NQ-ICOFF
      IOFFA = IIA + ( JJA - 1 ) * DESCA( 8 )
      JN = MIN( ICEIL( JA, DESCA( 4 ) ) * DESCA( 4 ), JA+N-1 )
*
*     Handle first block of columns separately
*
      IF( MYCOL.EQ.IACOL .AND. ICOFF.NE.0 ) THEN
         JB = JN-JA+1
         CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( 1 ), DESCA( 2 ),
     $                  DESCA( 3 ), DESCA( 4 ), WORK, MAX( 1, MP ),
     $                  DESCA( 5 ), DESCA( 6 ), IASEED, IIA-1, MP,
     $                  JJA-1, JB, MYROW, MYCOL, NPROW, NPCOL )
         CALL DMATADD( MP, JB, -ONE, WORK, MAX( 1, MP ), ONE,
     $                 A( IOFFA ), DESCA( 8 ) )
         NQ  = NQ - JB
         IOFFA = IOFFA + JB * DESCA( 8 )
      END IF
*
*     Handle the remaning blocks of columns
*
      DO 10 JJ = JJA, JJA+NQ-1, DESCA( 4 )
         JB = MIN( DESCA( 4 ), JJA+NQ-JJ )
         IOFFA = IIA + ( JJ - 1 ) * DESCA( 8 )
         CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( 1 ), DESCA( 2 ),
     $                  DESCA( 3 ), DESCA( 4 ), WORK, MAX( 1, MP ),
     $                  DESCA( 5 ), DESCA( 6 ), IASEED, IIA-1, MP,
     $                  JJ-1, JB, MYROW, MYCOL, NPROW, NPCOL )
         CALL DMATADD( MP, JB, -ONE, WORK, MAX( 1, MP ), ONE,
     $                 A( IOFFA ), DESCA( 8 ) )
   10 CONTINUE
*
*     Calculate factor residual
*
      FRESID = PDLANGE( 'I', M, N, A, IA, JA, DESCA, WORK ) /
     $                  ( MAX( M, N ) * EPS * ANORM )
*
      RETURN
*
*     End PDLAFCHK
*
      END
