      SUBROUTINE PDSUMMAINFO( SUMMRY, NOUT, TRANSA, TRANSB, NMAT, MVAL,
     $                        NVAL, KVAL, LDVAL, NBMAT, MBVAL, NBVAL,
     $                        KBVAL, LDNBVAL, NGRIDS, NPVAL, NQVAL,
     $                        LDPQVAL, ALPHA, BETA, IASEED, IBSEED,
     $                        ICSEED, IMROW, IMCOL, THRESH, WORK, IAM,
     $                        NPROCS )
*
*     .. Scalar Arguments ..
      CHARACTER*1        TRANSA, TRANSB
      CHARACTER*( * )    SUMMRY
      INTEGER            IAM, IASEED, IBSEED, ICSEED, IMCOL, IMROW
      INTEGER            LDNBVAL, LDPQVAL, LDVAL, NBMAT, NGRIDS, NMAT
      INTEGER            NPROCS, NOUT
      REAL               THRESH
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            KBVAL( LDNBVAL ), KVAL( LDVAL )
      INTEGER            MBVAL( LDNBVAL ), MVAL( LDVAL )
      INTEGER            NBVAL( LDNBVAL ), NPVAL( LDPQVAL )
      INTEGER            NQVAL( LDPQVAL ), NVAL( LDVAL )
      INTEGER            WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDSUMMAINFO gets needed startup info and transmits it to all processes.
*
*  Arguments
*  =========
*
*  SUMMRY  (output) CHARACTER*(*)
*          Name of output (summary) file (if any). Only defined for
*          process 0.
*
*  NOUT    (output) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr.  Only defined for process 0.
*
*  TRANSA  (output) CHARACTER*1
*          On entry, TRANSA specifies the form of op( A ) to be used
*          in the matrix multiplication as follows:
*             TRANSA = 'N',  op( A ) = A.
*             TRANSA = 'T',  op( A ) = A'.
*             TRANSA = 'C',  op( A ) = A'.
*
*  TRANSB  (output) CHARACTER*1
*          On entry, TRANSB specifies the form of op( B ) to be used
*          in the matrix multiplication as follows:
*             TRANSB = 'N',  op( B ) = B.
*             TRANSB = 'T',  op( B ) = B'.
*             TRANSB = 'C',  op( B ) = B'.
*
*  NMAT    (output) INTEGER
*          The number of different values that can be used for M, N
*          and K.
*
*  MVAL    (output) INTEGER
*          Array, dimension(LDVAL), the values of M to run code with.
*
*  NVAL    (output) INTEGER
*          Array, dimension(LDVAL), the values of N to run code with.
*
*  KVAL    (output) INTEGER
*          Array, dimension(LDVAL), the values of K to run code with.
*
*  LDVAL   (input) INTEGER
*          Leading dimension of the arrays MVAL, NVAL and KVAL,
*          LDVAL >= NMAT.
*
*  NBMAT   (output) INTEGER
*          The number of different values that can be used for MB, NB
*          and KB.
*
*  MBVAL   (output) INTEGER
*          Array, dimension(LDVAL), the values of MB to run code with.
*
*  NBVAL   (output) INTEGER
*          Array, dimension(LDVAL), the values of NB to run code with.
*
*  KBVAL   (output) INTEGER
*          Array, dimension(LDVAL), the values of KB to run code with.
*
*  LDNBVAL (input) INTEGER
*          Leading dimension of the arrays MBVAL, NBVAL and KBVAL,
*          LDNBVAL >= NMAT.
*
*  NGRIDS  (output) INTEGER
*          The number of different values that can be used for P & Q.
*
*  NPVAL   (output) INTEGER
*          Array, dimension(LDPQVAL), the values of P (number of process
*          rows) to run code with.
*
*  NQVAL   (output) INTEGER
*          Array, dimension(LDPQVAL), the values of Q (number of process
*          columns) to run code with.
*
*  LDPQVAL (input) INTEGER
*          The maximum number of different values that can be used for
*          P & Q, LDPQVAL >= NGRIDS.
*
*  ALPHA   (output) DOUBLE PRECISION
*          Scalar for the matrix multiply.
*
*  BETA    (output) DOUBLE PRECISION
*          Scalar for the matrix multiply.
*
*  IASEED  (output) INTEGER
*          Seed number to generate A
*
*  IBSEED  (output) INTEGER
*          Seed number to generate B
*
*  ICSEED  (output) INTEGER
*          Seed number to generate C
*
*  IMROW   (output) INTEGER
*          Starting row position of matrices A, B, and C
*
*  IMCOL   (output) INTEGER
*          Starting column position of matrices A, B, and C
*
*  THRESH  (output) DOUBLE PRECISION
*          Allowed threshold for the check.
*
*  WORK    (workspace) INTEGER
*          Array used to pack all input arrays.
*
*  IAM     (input) INTEGER
*          My process number.
*
*  NPROCS  (input/output) INTEGER
*          The total number of processes.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            NIN
      PARAMETER        ( NIN = 11 )
*     ..
*     .. Local Scalars ..
      CHARACTER*79       USRINFO 
      INTEGER            I, ICTXT, IPWRK
      DOUBLE PRECISION   EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINIT, BLACS_SETUP, DGEBR2D, DGEBS2D,
     $                   ICOPY, IGEBR2D, IGEBS2D, SGEBR2D, SGEBS2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CHAR, ICHAR, MIN, MAX
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           PDLAMCH
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Executable Statements ..
*
*     Process 0 reads the input data, broadcasts to other processes and
*     writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
*
*         Open file and skip data file header
*
          OPEN( UNIT=NIN, FILE='MATMUL.dat', STATUS='Old' )
          READ( NIN, FMT = * ) SUMMRY
          SUMMRY = ' '
*
*         Read in user-supplied info about machine type, compiler, etc.
*
          READ( NIN, FMT = 9999 ) USRINFO
*
*         Read name and unit number for summary output file
*
          READ( NIN,FMT = * ) SUMMRY
          READ( NIN,FMT = * ) NOUT
          IF( NOUT.NE.0 .AND. NOUT.NE.6 )
     $       OPEN( UNIT=NOUT, FILE=SUMMRY, STATUS='UNKNOWN' )
*
*         Get type of multiplication to perform
*
          READ( NIN, FMT = * ) TRANSA, TRANSB
*
*         Get values of M, N, K
*
          READ( NIN, FMT = * ) NMAT
          IF( NMAT.LT.1 .OR. NMAT.GT.LDVAL ) THEN
              WRITE( NOUT, FMT = 9997 ) 'M', LDVAL
              GO TO 30
          END IF
          READ( NIN, FMT = * ) ( MVAL(I), I = 1, NMAT )
          READ( NIN, FMT = * ) ( NVAL(I), I = 1, NMAT )
          READ( NIN, FMT = * ) ( KVAL(I), I = 1, NMAT )
*
*         Get values of MB, NB, KB
*
          READ( NIN, FMT = * ) NBMAT
          IF( NBMAT.LT.1 .OR. NBMAT.GT.LDNBVAL )THEN
              WRITE( NOUT, FMT = 9997 ) 'NB', LDNBVAL
              GO TO 30
          END IF
          READ( NIN, FMT = * ) ( MBVAL(I), I = 1, NBMAT )
          READ( NIN, FMT = * ) ( NBVAL(I), I = 1, NBMAT )
          READ( NIN, FMT = * ) ( KBVAL(I), I = 1, NBMAT )
*
*         Get Alpha, Beta
*
          READ( NIN, FMT = * ) ALPHA, BETA
*
*         Get IASEED, IBSEED, and ICSEED
*
          READ( NIN, FMT = * ) IASEED, IBSEED, ICSEED
*
*         Get IMROW and IMCOL >= (0,0)
*
          READ( NIN, FMT = * ) IMROW, IMCOL
          IF( IMROW.LT.0 )
     $       IMROW = 0
          IF( IMCOL.LT.0 )
     $       IMCOL = 0
*
*         Get values of P, Q
*
          READ( NIN, FMT = * ) NGRIDS
          IF( NGRIDS.LT.1 .OR. NGRIDS.GT.LDPQVAL )THEN
             WRITE( NOUT, FMT = 9997 ) 'Grids', LDPQVAL
             GO TO 30
          END IF
          READ( NIN, FMT = * ) ( NPVAL(I), I = 1, NGRIDS )
          READ( NIN, FMT = * ) ( NQVAL(I), I = 1, NGRIDS )
*
*         Make sure (IMROW, IMCOL) <= (NPVAL(*), NQVAL(*))
*
          DO 10 I = 1, NGRIDS
             IMROW = MIN( IMROW, NPVAL(I)-1 )
             IMCOL = MIN( IMCOL, NQVAL(I)-1 )
   10     CONTINUE
*
*         Get level of checking
*
          READ( NIN, FMT = * ) THRESH
*
          CLOSE( NIN )
*
*         Create "blacs_setup.dat" file for this executable
*
          OPEN(UNIT=NIN, FILE='blacs_setup.dat', STATUS='UNKNOWN')
          WRITE(NIN,*)'MATMUL_pvm'
          CLOSE( NIN )
*
*         For pvm only: if virtual machine not set up, allocate it and
*         spawn the correct number of processes.
*
          IF( NPROCS.LT.1 ) THEN
              NPROCS = 0
              DO 20 I = 1, NGRIDS
                 NPROCS = MAX( NPROCS, NPVAL( I )*NQVAL( I ) )
   20         CONTINUE
              CALL BLACS_SETUP( IAM, NPROCS )
          END IF
*
*         Temporarily define blacs grid to include all processes so
*         information can be broadcast to all processes
*
          CALL BLACS_GET( -1, 0, ICTXT )
          CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*         Compute machine epsilon
*
          EPS = PDLAMCH( ICTXT, 'eps' )
*
*         Pack information arrays and broadcast
*
          IPWRK = 1
          WORK( IPWRK ) = NMAT
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = NBMAT
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = NGRIDS
          IPWRK = IPWRK + 1
          CALL DGEBS2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1 )
          CALL DGEBS2D( ICTXT, 'All', ' ', 1, 1, BETA, 1 )
          CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1 )
          WORK( IPWRK ) = ICHAR( TRANSA )
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = ICHAR( TRANSB )
          IPWRK = IPWRK + 1
          CALL ICOPY( NMAT, MVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, NVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, KVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NBMAT, MBVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, NBVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, KBVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NBMAT
          WORK( IPWRK ) = IASEED
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = IBSEED
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = ICSEED
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = IMROW
          IPWRK = IPWRK + 1
          WORK( IPWRK ) = IMCOL
          IPWRK = IPWRK + 1
          CALL ICOPY( NGRIDS, NPVAL, 1, WORK( IPWRK ), 1 )
          IPWRK = IPWRK + NGRIDS
          CALL ICOPY( NGRIDS, NQVAL, 1, WORK( IPWRK ), 1)
          IPWRK = IPWRK + NGRIDS-1
          WORK( IPWRK+1 ) = IPWRK
          CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, WORK( IPWRK+1 ), 1 )
          CALL IGEBS2D( ICTXT, 'All', ' ', IPWRK, 1, WORK, IPWRK )
*
*         regurgitate input
*
          WRITE( NOUT, FMT = 9999 )
     $                'ScaLAPACK driver for full matrix multiply.'
          WRITE( NOUT, FMT = 9999 )
     $                USRINFO
          WRITE( NOUT, FMT = * )
          WRITE( NOUT, FMT = 9999 )
     $                'Running tests for C := alpha*op(A)*op(B) +'//
     $                ' beta*C.'
          WRITE( NOUT, FMT = 9999 )
     $                'The following scaled residual check will'//
     $                ' be computed:'
          WRITE( NOUT, FMT = 9999 )
     $                '  ||C-alpha*op(A)*op(B)-beta*C||/(||C||'//
     $                '*eps*N)'
          WRITE( NOUT, FMT = 9999 )
     $                'The matrix A, B and C are randomly '//
     $                'generated for each test.'
          WRITE( NOUT, FMT = * )
          WRITE( NOUT, FMT = 9999 )
     $                'An explanation of the input/output '//
     $                'parameters follows:'
          WRITE( NOUT, FMT = 9999 )
     $                'M      : The number of rows in '//
     $                'the matrices A and C.'
          WRITE( NOUT, FMT = 9999 )
     $                'N      : The number of columns in '//
     $                'the matrices B and C.'
          WRITE( NOUT, FMT = 9999 )
     $                'K      : The number of columns in '//
     $                'the matrices A and the number of rows in B.'
          WRITE( NOUT, FMT = 9999 )
     $                'MB     : The size of the row-blocks of A '//
     $                'and C.'
          WRITE( NOUT, FMT = 9999 )
     $                'NB     : The size of the col-blocks of B '//
     $                'and C.'
          WRITE( NOUT, FMT = 9999 )
     $                'KB     : The size of the col-blocks of A '//
     $                'and row-blocks of B.'
          WRITE( NOUT, FMT = 9999 )
     $                'P      : The number of process rows.'
          WRITE( NOUT, FMT = 9999 )
     $                'Q      : The number of process columns.'
          WRITE( NOUT, FMT = 9999 )
     $                'THRESH : If residual value is less than'//
     $                ' THRESH, CHECK is flagged as PASSED.'
          WRITE( NOUT, FMT = 9999 )
     $                'TIME   : Time in seconds to perform the '//
     $                'matrix multiplication'
          WRITE( NOUT, FMT = 9999 )
     $                'Mflops : Execution rate of computation.'
          WRITE( NOUT, FMT = 9999 )
     $                'RESID  : value of the scaled residual'
          WRITE( NOUT, FMT = * )
          WRITE( NOUT, FMT = 9999 )
     $                'The following parameter values will be used:'
          WRITE( NOUT, FMT = 9995 )
     $                'M    ',( MVAL(I), I = 1, MIN( NMAT, 10 ) )
          IF( NMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( MVAL(I), I = 11, NMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'N    ',( NVAL(I), I = 1, MIN( NMAT, 10 ) )
          IF( NMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( NVAL(I), I = 11, NMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'K    ',( KVAL(I), I = 1, MIN( NMAT, 10 ) )
          IF( NMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( KVAL(I), I = 11, NMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'MB   ',( MBVAL(I), I = 1, MIN( NBMAT, 10 ) )
          IF( NBMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( NBVAL(I), I = 11, NBMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'NB   ',( NBVAL(I), I = 1, MIN( NBMAT, 10 ) )
          IF( NBMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( NBVAL(I), I = 11, NBMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'KB   ',( KBVAL(I), I = 1, MIN( NBMAT, 10 ) )
          IF( NBMAT.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( NBVAL(I), I = 11, NBMAT )
          WRITE( NOUT, FMT = 9995 )
     $                'P    ',( NPVAL(I), I = 1, MIN( NGRIDS, 10 ) )
          IF( NGRIDS.GT.10 )
     $       WRITE( NOUT,FMT = 9995 ) ( NPVAL(I), I = 11, NGRIDS )
          WRITE( NOUT, FMT = 9995 )
     $                'Q    ',( NQVAL(I), I = 1, MIN( NGRIDS, 10 ) )
          IF( NGRIDS.GT.10 )
     $       WRITE( NOUT, FMT = 9995 ) ( NQVAL(I), I = 11, NGRIDS )
          WRITE( NOUT, FMT = 9993 ) 'ALPHA', ALPHA
          WRITE( NOUT, FMT = 9993 ) 'BETA ', BETA
          WRITE( NOUT, FMT = * )
          WRITE( NOUT, FMT = 9992 ) IMROW, IMCOL
          WRITE( NOUT, FMT = 9996 ) EPS
          WRITE( NOUT, FMT = 9991 ) THRESH
*
      ELSE
*
*         If in pvm, must participate setting up virtual machine
*
          IF( NPROCS.LT.1 )
     $       CALL BLACS_SETUP( IAM, NPROCS )
*
*         Temporarily define blacs grid to include all processes so
*         all processes have needed startup information
*
          CALL BLACS_GET( -1, 0, ICTXT )
          CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*         Compute machine epsilon
*
          EPS = PDLAMCH( ICTXT, 'eps' )
*
          CALL DGEBR2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1, 0, 0 )
          CALL DGEBR2D( ICTXT, 'All', ' ', 1, 1, BETA, 1, 0, 0 )
          CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1, 0, 0 )
          CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, WORK, 1, 0, 0 )
          IPWRK = WORK( 1 )
          CALL IGEBR2D( ICTXT, 'All', ' ', IPWRK, 1, WORK, IPWRK,
     $                  0, 0 )
*
*         Unpack received information
*
          IPWRK = 1
          NMAT = WORK( IPWRK )
          IPWRK = IPWRK + 1
          NBMAT = WORK( IPWRK )
          IPWRK = IPWRK + 1
          NGRIDS = WORK( IPWRK )
          IPWRK = IPWRK + 1
          TRANSA = CHAR( WORK( IPWRK ) )
          IPWRK = IPWRK + 1
          TRANSB = CHAR( WORK( IPWRK ) )
          IPWRK = IPWRK + 1
          CALL ICOPY( NMAT, WORK( IPWRK ), 1, MVAL, 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, WORK( IPWRK ), 1, NVAL, 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NMAT, WORK( IPWRK ), 1, KVAL, 1 )
          IPWRK = IPWRK + NMAT
          CALL ICOPY( NBMAT, WORK( IPWRK ), 1, MBVAL, 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, WORK( IPWRK ), 1, NBVAL, 1 )
          IPWRK = IPWRK + NBMAT
          CALL ICOPY( NBMAT, WORK( IPWRK ), 1, KBVAL, 1 )
          IPWRK = IPWRK + NBMAT
          IASEED = WORK( IPWRK )
          IPWRK = IPWRK + 1
          IBSEED = WORK( IPWRK )
          IPWRK = IPWRK + 1
          ICSEED = WORK( IPWRK )
          IPWRK = IPWRK + 1
          IMROW = WORK( IPWRK )
          IPWRK = IPWRK + 1
          IMCOL = WORK( IPWRK )
          IPWRK = IPWRK + 1
          CALL ICOPY( NGRIDS, WORK( IPWRK ), 1, NPVAL, 1 )
          IPWRK = IPWRK + NGRIDS
          CALL ICOPY( NGRIDS, WORK( IPWRK ), 1, NQVAL, 1 )
      END IF
*
      CALL BLACS_GRIDEXIT( ICTXT )
*
      RETURN
*
*     Prints error message if illegal input file
*
   30 WRITE( NOUT, FMT = 9998 )
      CLOSE( NIN )
      IF( IAM.EQ.0 .AND. NOUT.NE.6 .AND. NOUT.NE.0 )
     $   CLOSE( NOUT )
*
      CALL BLACS_ABORT( ICTXT, 1 )
      STOP
*
 9999 FORMAT( A )
 9998 FORMAT(' ILLEGAL INPUT IN FILE ',40A,'.  ABORTING RUN.')
 9997 FORMAT(' NUMBER OF VALUES OF ',5A, ' IS LESS THAN 1 OR GREATER ',
     $       'THAN ', I2 )
 9996 FORMAT('Relative machine precision (eps) is taken to be ',E18.6)
 9995 FORMAT(2X,A5,':        ',10I6)
 9994 FORMAT('              ',10I6)
 9993 FORMAT(2X,A5,':        ',F8.3)
 9992 FORMAT('The matrices start in process (',I4,',',I4,').')
 9991 FORMAT('Routines pass computational tests if scaled residual is',
     $       ' less than ',G14.7)
*
*     End of PDSUMMAINFO
*
      END
