      PROGRAM PDSUMMADRIVER
*
*  Purpose: Driver routine for testing the full matrix multiply.
*  =======
*
*    The user should modify TOTMEM to indicate the maximum amount of memory
*  in bytes his system has.  Remember to leave room in memory for operating
*  system, the buffer of the communication package, etc ...
*
*    The constants INTGSZ and DBLESZ indicate the length in bytes on the
*  given platform for an integer and a double precision real. For example,
*  on a system with 8 MB of memory, the parameters we use are
*  TOTMEM=6200000 (leaving 1.8 MB for OS, code, communication buffer, etc).
*  However, for PVM, we usually set TOTMEM = 2000000.
*  The length of a double precision real is 8, and an integer takes up 4 bytes.
*
*    Some playing around to discover what the maximum value you can set
*  TOTMEM to may be required. All arrays used by the factorization and
*  check are allocated out of the array called MEM. The integer IPA,
*  for example, indicates the element of MEM that the answer vector(s)
*  A begin(s) on.
*
*  Global variables
*  ================
*
*     .. Parameters ..
      INTEGER            TOTMEM, MEMSIZ, INTGSZ, DBLESZ, NTESTS
      DOUBLE PRECISION   ZERO
      INCLUDE 'TOTMEM.inc'
      PARAMETER          ( INTGSZ = 4, DBLESZ = 8,
     $                   MEMSIZ = TOTMEM / DBLESZ, NTESTS = 20,
     $                   ZERO = 0.0D+0 )
*     ..
*     .. Scalars ..
      LOGICAL            NOTA, NOTB
      CHARACTER*1        TRANSA, TRANSB
      INTEGER            I, IAM, IASEED, IBSEED, ICSEED, ICTXT, II,
     $                   IMCOL, IMROW, IPA, IPB, IPC, IPIW, IPW, ISW,
     $                   J, K, KB, KFAIL, KP, KPASS, KQ, KSKIP, KTESTS,
     $                   LCM, LDA, LDB, LDC, M, MB, MP, MQ, MYCOL,
     $                   MYROW, N, NB, NBMAT, NGRIDS, NMAT, NPCOL,
     $                   NPROCS, NPROW, NOUT, NP, NQ
      REAL               THRESH
      DOUBLE PRECISION   ALPHA, BETA, CNORM, EPS, NOPS, RESID, TMFLOPS
*     ..
*     .. Arrays ..
      CHARACTER*6        PASSED
      CHARACTER*80       OUTFILE
      INTEGER            IERR( 1 ), KBVAL( NTESTS ), KVAL( NTESTS ),
     $                   MBVAL( NTESTS ), MVAL( NTESTS ),
     $                   NBVAL( NTESTS ), NPVAL( NTESTS ),
     $                   NQVAL( NTESTS ), NVAL( NTESTS )
      DOUBLE PRECISION   CTIME(2), MEM( MEMSIZ ), WTIME(2)
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_BARRIER, BLACS_EXIT, BLACS_GET,
     $                   BLACS_GRIDEXIT, BLACS_GRIDINFO, BLACS_GRIDINIT,
     $                   BLACS_PINFO, IGSUM2D, SLBOOT, SLCOMBINE,
     $                   SLTIMER
      EXTERNAL           PDSUMMAINFO, PDMATGEN, PDSUMMA, PDSUMCHK
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ILCM, ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH
      DOUBLE PRECISION   PDLAINF
      EXTERNAL           ILCM, ICEIL, LSAME, NUMROC, PDLAMCH, PDLAINF
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Data Statements ..
      DATA               KTESTS, KPASS, KFAIL, KSKIP /4*0/
*
* ======================================================================
*
*     Get starting information
*
      CALL BLACS_PINFO( IAM, NPROCS )
*
      CALL PDSUMMAINFO( OUTFILE, NOUT, TRANSA, TRANSB, NMAT, MVAL, NVAL,
     $                  KVAL, NTESTS, NBMAT, MBVAL, NBVAL, KBVAL,
     $                  NTESTS, NGRIDS, NPVAL, NQVAL, NTESTS, ALPHA,
     $                  BETA, IASEED, IBSEED, ICSEED, IMROW, IMCOL,
     $                  THRESH, MEM, IAM, NPROCS )
*
*     Print headings
*
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9994 )
         WRITE( NOUT, FMT = 9993 )
         WRITE( NOUT, FMT = * )
      END IF
*
      NOTA = LSAME( TRANSA, 'N' )
      NOTB = LSAME( TRANSB, 'N' )
*
*     Loop over different process grids
*
      DO 30 J = 1, NGRIDS
*
         NPROW = NPVAL( J )
         NPCOL = NQVAL( J )
*
*        Make sure grid information is correct
*
         IERR(1) = 0
         IF( NPROW.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9998 ) 'GRID', 'nprow', NPROW
            IERR( 1 ) = 1
         ELSE IF( NPCOL.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9998 ) 'GRID', 'npcol', NPCOL
            IERR( 1 ) = 1
         ELSE IF( NPROW*NPCOL.GT.NPROCS ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )  NPROW*NPCOL, NPROCS
            IERR( 1 ) = 1
         END IF
*
         IF( IERR( 1 ).GT.0 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) 'grid'
            KSKIP = KSKIP + 1
            GO TO 30
         END IF
*
*        Define process grid
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*        Go to bottom of process grid loop if this case doesn't use my process
*
         IF( MYROW.GE.NPROW .OR. MYCOL.GE.NPCOL )
     $      GO TO 30
*
         EPS = PDLAMCH( ICTXT, 'eps' )
*
         DO 20 I = 1, NMAT
*
            M = MVAL( I )
            N = NVAL( I )
            K = KVAL( I )
*
*           Make sure matrix information is correct
*
            IERR( 1 ) = 0
            IF( M.LT.1 ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9998 ) 'MATRIX', 'M', M
               IERR( 1 ) = 1
            ELSE IF( N.LT.1 ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9998 ) 'MATRIX', 'N', N
               IERR( 1 ) = 1
            ELSE IF( K.LT.1 ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9998 ) 'MATRIX', 'K', K
               IERR( 1 ) = 1
            END IF
*
*           Make sure no one had error
*
            CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, 0 )
*
            IF( IERR( 1 ).GT.0 ) THEN
               IF( IAM.EQ.0 )
     $             WRITE( NOUT, FMT = 9996 ) 'matrix'
               KSKIP = KSKIP + 1
               GO TO 20
            END IF
*
*           Loop over different block sizes
*
            DO 10 II = 1, NBMAT
*
               MB = MBVAL( II )
               NB = NBVAL( II )
               KB = KBVAL( II )
*
*              Make sure blocking sizes are legal
*
               IERR( 1 ) = 0
               IF( MB.LT.1 ) THEN
                  IERR( 1 ) = 1
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT,FMT = 9998 ) 'MB', 'MB', MB
               ELSE IF( NB.LT.1 ) THEN
                  IERR( 1 ) = 1
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9998 ) 'NB', 'NB', NB
               ELSE IF( KB.LT.1 ) THEN
                  IERR( 1 ) = 1
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9998 ) 'KB', 'KB', KB
               END IF
*
*              Make sure no one had error
*
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, 0 )
*
               IF( IERR( 1 ).GT.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9996 ) 'NB'
                  KSKIP = KSKIP + 1
                  GO TO 10
               END IF
*
               MP = NUMROC( M, MB, MYROW, IMROW, NPROW )
               MQ = NUMROC( M, MB, MYCOL, IMCOL, NPCOL )
               NP = NUMROC( N, NB, MYROW, IMROW, NPROW )
               NQ = NUMROC( N, NB, MYCOL, IMCOL, NPCOL )
               KP = NUMROC( K, KB, MYROW, IMROW, NPROW )
               KQ = NUMROC( K, KB, MYCOL, IMCOL, NPCOL )
*
               LCM = ILCM( NPROW, NPCOL )
               LDC = MAX( 1, MP )
               IPC = 1
               IPA = IPC + MP * NQ
*
               IF( NOTB ) THEN
*
                  IF( NOTA ) THEN
*
                     LDA  = MAX( 1, MP )
                     LDB  = MAX( 1, KP )
                     IPB  = MP * KQ + IPA
                     IPIW = KP * NQ + IPB
                     IPW  = IPIW + 1
                     ISW  = IPW + KB * ( MP + NQ )
*
                  ELSE
*
                     LDA  = MAX( 1, KP )
                     LDB  = MAX( 1, KP )
                     IPB  = KP * MQ + IPA
                     IPIW = KP * NQ + IPB
                     IPW  = IPIW + 1
                     ISW  = IPW + MB * ( KP + NQ )
*
                  END IF
*
               ELSE
*
                  IF( NOTA ) THEN
*
                     LDA  = MAX( 1, MP )
                     LDB  = MAX( 1, NP )
                     IPB  = MP * KQ + IPA
                     IPIW = NP * KQ + IPB
                     IPW  = IPIW + 1
                     ISW  = IPW + NB * ( KQ + MP )
*
                  ELSE
*
                     LDA  = MAX( 1, KP )
                     LDB  = MAX( 1, NP )
                     IPB  = KP * MQ + IPA
                     IPIW = NP * KQ + IPB
                     IPW  = IPIW + ICEIL( INTGSZ*3*MAX( NPCOL, NPROW ),
     $                                    DBLESZ )
                     ISW  = IPW + NP * MQ + MAX( KB * ( MQ + NP ),
     $                      2*ICEIL( ICEIL(N,NB), LCM ) * NB * 
     $                      ICEIL( ICEIL(M,MB), LCM ) * MB )
*
                  END IF
*
               END IF
*
*              Check memory need
*
               IF( THRESH.GT.0.0E+0 ) THEN
                  ISW = MAX( IPA+MAX( MB*NQ, MB*KQ+KQ*NB+MB*NB ), ISW )
               END IF
*
*              Make sure have enough memory to handle problem
*
               IF( ISW.GT.MEMSIZ ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9995 ) 'MULTI', ISW*DBLESZ
                  IERR( 1 ) = 1
               END IF
*
*              Make sure no one had error
*
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, 0 )
*
               IF( IERR( 1 ).GT.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9996 ) 'MEMORY'
                  KSKIP = KSKIP + 1
                  GO TO 10
               END IF
*
*              Generate matrices A, B, C
*
               IF( NOTA ) THEN
                  CALL PDMATGEN( ICTXT, 'N', 'N', M, K, MB, KB,
     $                           MEM( IPA ), LDA, IMROW, IMCOL, IASEED,
     $                           0, MP, 0, KQ, MYROW, MYCOL, NPROW,
     $                           NPCOL )
               ELSE
                  CALL PDMATGEN( ICTXT, 'N', 'N', K, M, KB, MB,
     $                           MEM( IPA ), LDA, IMROW, IMCOL, IASEED,
     $                           0, KP, 0, MQ, MYROW, MYCOL, NPROW,
     $                           NPCOL )
               END IF
*
               IF( NOTB ) THEN
                  CALL PDMATGEN( ICTXT, 'N', 'N', K, N, KB, NB,
     $                           MEM( IPB ), LDB, IMROW, IMCOL, IBSEED,
     $                           0, KP, 0, NQ, MYROW, MYCOL, NPROW,
     $                           NPCOL )
               ELSE
                  CALL PDMATGEN( ICTXT, 'N', 'N', N, K, NB, KB,
     $                           MEM( IPB ), LDB, IMROW, IMCOL, IBSEED,
     $                           0, NP, 0, KQ, MYROW, MYCOL, NPROW,
     $                           NPCOL )
               END IF
*
               CALL PDMATGEN( ICTXT, 'N', 'N', M, N, MB, NB, MEM( IPC ),
     $                        LDC, IMROW, IMCOL, ICSEED, 0, MP, 0, NQ,
     $                        MYROW, MYCOL, NPROW, NPCOL )
*
               IF( THRESH.GT.0.0E+0 ) THEN
                  CNORM = PDLAINF( M, N, MB, NB, MEM( IPC ), LDC, IMROW,
     $                             IMCOL, MEM( IPW ) )
               END IF
*
               CALL SLBOOT()
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 1 )
*
*              Perform the matrix multiply
*
               CALL PDSUMMA( TRANSA, TRANSB, M, N, K, MB, NB, KB, ALPHA,
     $                       MEM( IPA ), LDA, MEM( IPB ), LDB, BETA,
     $                       MEM( IPC ), LDC, IMROW, IMCOL, MEM( IPW ),
     $                       MEM( IPIW ) )
*
               CALL SLTIMER( 1 )
*
               IF( THRESH.GT.0.0E+0 ) THEN
                  CALL PDSUMCHK( TRANSA, TRANSB, M, N, K, MB, NB,
     $                           KB, ALPHA, BETA, MEM( IPC ), LDC,
     $                           IASEED, IBSEED, ICSEED, IMROW,
     $                           IMCOL, MEM( IPA ), RESID )
                  IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 ) THEN
                     RESID = RESID / ( CNORM*EPS*DBLE( MAX( M, N ) ) )
                  ELSE
                     RESID = 0.0D+0
                  END IF
*
                  IF( ( RESID.LE.THRESH ).AND.
     $                ( ( RESID-RESID ).EQ.ZERO ) ) THEN
                     KPASS = KPASS + 1
                     PASSED = 'PASSED'
                  ELSE
                     KFAIL = KFAIL + 1
                     PASSED = 'FAILED'
                  END IF
               ELSE
*
*                 Don't perform the checking, only the timing operation
*
                  KPASS = KPASS + 1
                  RESID = RESID-RESID
                  PASSED = 'BYPASS'
               END IF
*
*              Gather maximum of all CPU and WALL clock timings
*
               CALL SLCOMBINE( ICTXT, 'All', '>', 'W', 1, 1, WTIME )
               CALL SLCOMBINE( ICTXT, 'All', '>', 'C', 1, 1, CTIME )
*
*              Print results
*
               IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 ) THEN
*
*                 Matrix multiply requires 2*M*N*K flops.
*
                  NOPS = 2.0D0*DBLE( M )*DBLE( N )*DBLE( K )
*
*                 Calculate total megaflops -- for WALL and
*                 CPU time, and print output.
*
*                 Print WALL time if machine supports it
*
                  IF( WTIME( 1 ).GT.0.0D+0 ) THEN
                     TMFLOPS = NOPS / ( WTIME( 1 ) * 1.0D+6 )
                  ELSE
                     TMFLOPS = 0.0D+0
                  END IF
*
                  IF( WTIME( 1 ).GE.0.0D+0 )
     $               WRITE( NOUT, FMT = 9992 ) 'WALL', TRANSA, TRANSB,
     $                      M, N, K, MB, NB, KB, NPROW, NPCOL,
     $                      WTIME( 1 ), TMFLOPS, PASSED, RESID
*
*                 Print CPU time if machine supports it
*
                  IF( CTIME( 1 ).GT.0.0D+0 ) THEN
                     TMFLOPS = NOPS / ( CTIME( 1 ) * 1.0D+6 )
                  ELSE
                     TMFLOPS = 0.0D+0
                  END IF
*
                  IF( CTIME( 1 ).GE.0.0D+0 )
     $               WRITE( NOUT, FMT = 9992 ) 'CPU ', TRANSA, TRANSB,
     $                      M, N, K, MB, NB, KB, NPROW, NPCOL,
     $                      CTIME( 1 ), TMFLOPS, PASSED, RESID
               END IF
   10       CONTINUE
   20    CONTINUE
*
         CALL BLACS_GRIDEXIT( ICTXT )
*
   30 CONTINUE
*
*     Print out ending messages and close output file
*
      IF( IAM.EQ.0 ) THEN
         KTESTS = KPASS + KFAIL + KSKIP
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9991 ) KTESTS
         IF( THRESH.GT.0.0E+0 ) THEN
            WRITE( NOUT, FMT = 9990 ) KPASS
            WRITE( NOUT, FMT = 9989 ) KFAIL
         ELSE
            WRITE( NOUT, FMT = 9987 ) KPASS
         END IF
         WRITE( NOUT, FMT = 9988 ) KSKIP
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9999 ) 'END OF TESTS.'
         IF( NOUT.NE.6 .AND. NOUT.NE.0 )
     $      CLOSE( NOUT )
      END IF
 9999 FORMAT( A )
 9998 FORMAT('ILLEGAL ',A6,': ',A5,' = ',I3,'; It should be at least 1')
 9997 FORMAT('ILLEGAL GRID: nprow*npcol = ',I4,'. It can be at most',I4)
 9996 FORMAT('Bad ',A6,' parameters: going on to next test case.')
 9995 FORMAT('Unable to perform ',A,': need TOTMEM of at least',I11)
 9994 FORMAT('TIME',1X,'TA',1X,'TB',1X,'   M ',1X,'   N ',1X,'   K ',1X,
     $       ' MB',1X,' NB',1X,' KB',1X,' P ',1X,' Q ',1X,'  TIME ',
     $       1X,'  Mflops  ',1X,'CHECK',1X,'RESID')
 9993 FORMAT('---- -- -- ----- ----- ----- --- --- --- --- --- ',
     $       '-------- -------- ------ -----')
 9992 FORMAT(A4,1X,A2,1X,A2,1X,I5,1X,I5,1X,I5,1X,I3,1X,I3,1X,I3,1X,
     $       I3,1X,I3,1X,F8.2,1X,F8.2,1X,A6,1X,F5.2)
 9991 FORMAT('Finished',I4, ' tests, with the following results:')
 9990 FORMAT(I5,' tests completed and passed residual checks.')
 9989 FORMAT(I5,' tests completed and failed residual checks.')
 9988 FORMAT(I5,' tests skipped because of illegal input values.')
 9987 FORMAT(I5,' tests completed without checking' )
*
      CALL BLACS_EXIT( 0 )
*
      STOP
*
*
*     End of PDSUMMADRIVER
*
      END
