      SUBROUTINE PDSUMCHK( TRANSA, TRANSB, M, N, K, MB, NB, KB, ALPHA,
     $                   BETA, C, LDC, IASEED, IBSEED, ICSEED, IMROW,
     $                   IMCOL, WORK, RESID )
*
*     .. Scalar Arguments ..
      CHARACTER*1        TRANSA, TRANSB
      INTEGER            IASEED, IBSEED, ICSEED, IMCOL, IMROW, K, KB
      INTEGER            LDC, M, MB, N, NB
      DOUBLE PRECISION   RESID
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   C( LDC, * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDSUMCHK computes ||C|| := ||C - alpha*op( A )*op( B ) - beta*C||
*  where  op( X ) is one of
*
*     op( X ) = X   or   op( X ) = X',
*
*  where alpha and beta are scalars, and A, B and C are matrices,
*  with op( A ) an M by K matrix (globally), op( B ) a K by N matrix
*  (globally) and C an M by N matrix (globally).
*
*  Arguments
*  =========
*
*  TRANSA - (input) CHARACTER*1
*           TRANSA specifies the form of op( A ) to be used in the
*           matrix multiplication as follows:
*
*              TRANSA = 'N',  op( A ) = A;
*              TRANSA = 'T',  op( A ) = A';
*              TRANSA = 'C',  op( A ) = conjg(A').
*
*  TRANSB - (input) CHARACTER*1
*           TRANSB specifies the form of op( B ) to be used in the
*           matrix multiplication as follows:
*
*              TRANSB = 'N',  op( B ) = B;
*              TRANSB = 'T',  op( B ) = B';
*              TRANSB = 'C',  op( B ) = conjg(B').
*
*  M        (input) INTEGER
*           M specifies the (global) number of rows of the matrix
*           op( A ) and of the matrix C.  M >= 0.
*
*  N        (input) INTEGER
*           N specifies the (global) number of columns of the matrix
*           op( B ) and the number of columns of the matrix C. N >= 0.
*
*  K        (input) INTEGER
*           K specifies the (global) number of columns of the matrix
*           op( A ) and the number of rows of the matrix op( B ).
*           K >= 0.
*
*  MB       (input) INTEGER
*           MB specifies the row block size of the matrix op( A ) and of
*           the matrix C.  MB >= 1.
*
*  NB       (input) INTEGER
*           NB specifies the column block size of the matrix op( B ) and
*           of the matrix C.  NB >= 1.
*
*  KB       (input) INTEGER
*           KB specifies the column block size of the matrix op( A ) and
*           the row block size of the matrix op( B ).  KB >= 1.
*
*  ALPHA    (input) DOUBLE PRECISION
*           ALPHA specifies the scalar alpha.
*
*  BETA     (input) DOUBLE PRECISION
*           BETA specifies the scalar beta.  When BETA is supplied as
*           zero then C need not be set on input.
*
*  C        (input/output) DOUBLE PRECISION array of dimension (LDC,Nq)
*           On entry, the leading Mp by Nq part of the array C must
*           contain the (local) resulting matrix C.
*           On exit, the array  C is overwritten by the Mp by Nq matrix
*           (C-alpha*op(A)*op(B)-beta*C ).
*
*  LDC      (input) INTEGER
*           The leading dimension of the (local) array C.
*           LDC >= max( 1, Mp ).
*
*  IASEED   (input) INTEGER
*           The seed for regeneration of A.
*
*  IBSEED   (input) INTEGER
*           The seed for regeneration of B.
*
*  ICSEED   (input) INTEGER
*           The seed for regeneration of C.
*
*  IMROW    (input) INTEGER
*           IMROW specifies a row of the process template, which holds
*           the first block of the matrices.  0 <= IMROW < NPROW.
*
*  IMCOL    (input) INTEGER
*           IMCOL specifies a column of the process template, which
*           holds the first block of the matrices.  0 <= IMCOL < NPCOL.
*
*  WORK     (workspace) DOUBLE PRECISION array of dimension
*           MB*KQ+KQ*NB+MB*NB, where KQ is the local number of columns
*           of op(A).
*
*  RESID    (output) DOUBLE PRECISION
*           On exit contains ||C||, and should be zero theoretically.
*
* ======================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE,           ZERO
      PARAMETER        ( ONE  = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IB, ICTXT, ICURCOL, ICURROW, II, IPA, IPB
      INTEGER            IPC, J, JB, JJ, KK, KQ, LL, MP, MYCOL, MYROW
      INTEGER            NPCOL, NPROW, NQ
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGEMM, PDMATGEN, DMATADD
      EXTERNAL           BLACS_GRIDINFO, DGEBR2D, DGEBS2D,
     $                   DGSUM2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC
      DOUBLE PRECISION   PDLAINF
      EXTERNAL           LSAME, NUMROC, PDLAINF
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Start the operations
*
      MP = NUMROC( M, MB, MYROW, IMROW, NPROW )
      KQ = NUMROC( K, KB, MYCOL, IMCOL, NPCOL )
      NQ = NUMROC( N, NB, MYCOL, IMCOL, NPCOL )
*
*     Computes C := C - beta*C
*
      II = 1
      ICURROW = IMROW
      DO 10 I = 1, M, MB
         IB = MIN( M-I+1, MB )
*
         IF( MYROW.EQ.ICURROW ) THEN
             CALL PDMATGEN( ICTXT, 'N', 'N', M, N, MB, NB, WORK,
     $                      MAX(1,MP), IMROW, IMCOL, ICSEED, II-1, IB,
     $                      0, NQ, MYROW, MYCOL, NPROW, NPCOL )
             CALL DMATADD( IB, NQ, -BETA, WORK, MAX(1,MP), ONE,
     $                     C(II,1), LDC )
             II = II + IB
         END IF
*
         ICURROW = MOD( ICURROW+1, NPROW )
*
   10 CONTINUE
*
*     Pointers for working array (MB*KQ + KQ*NB + MB*NB)
*
      IPA = 1
      IPB = MB*KQ + IPA
      IPC = KQ*NB + IPB
*
      IF( LSAME( TRANSB, 'N' ) ) THEN
*
          II = 1
          DO 60 I = 1, M, NPROW*MB
             IB = MIN( MP-II+1, MB )
*
*            regenerate NPROW*MB rows of A (or A').
*
             CALL PDMATGEN( ICTXT, TRANSA, 'N', M, K, MB, KB,
     $                      WORK(IPA), MB, IMROW, IMCOL, IASEED,
     $                      MIN(II-1,MP), IB, 0, KQ, MYROW, MYCOL,
     $                      NPROW, NPCOL )
*
             KK = 1
             JJ = 1
             ICURCOL = IMCOL
             ICURROW = IMROW
*
             DO 50 J = 1, N, NB
                JB = MIN( N-J+1, NB )
*
*               Regenerate NB (JB) columns of B (JB rows of B')
*
                IF( MYROW.EQ.ICURROW ) THEN
                    CALL PDMATGEN( ICTXT, 'T', 'N', N, K, NB, KB,
     $                             WORK(IPB), NB, IMROW, IMCOL,
     $                             IBSEED, KK-1, JB, 0, KQ,
     $                             MYROW, MYCOL, NPROW, NPCOL )
                    CALL DGEBS2D( ICTXT, 'col', '1-tree', JB, KQ,
     $                            WORK(IPB), NB )
                ELSE
                    CALL DGEBR2D( ICTXT, 'col', '1-tree', JB, KQ,
     $                            WORK(IPB), NB, ICURROW, MYCOL )
                END IF
*
*               Computes C := C - alpha*A*B or C := C - alpha*A'*B
*
                IF( KQ.GT.0 .AND. IB.GT.0 .AND. JB.GT.0 ) THEN
                    CALL DGEMM( 'N', 'T', IB, JB, KQ, ALPHA,
     $                          WORK(IPA), MB, WORK(IPB), NB,
     $                          ZERO, WORK( IPC ), MB )
                ELSE
                    DO 30 LL = 0, MB*JB-1
                       WORK( IPC + LL ) = ZERO
   30               CONTINUE
                END IF
*
                CALL DGSUM2D( ICTXT, 'row', '1-tree', IB, JB,
     $                        WORK( IPC ), MB, MYROW, ICURCOL )
*
                IF( II.LE.MP ) THEN
                    IF( MYCOL.EQ.ICURCOL ) THEN
                        CALL DMATADD( IB, JB, -ONE, WORK(IPC), MB,
     $                                ONE, C(II,JJ), LDC )
                    END IF
                END IF
*
                IF( MYROW.EQ.ICURROW ) KK = KK + JB
                IF( MYCOL.EQ.ICURCOL ) JJ = JJ + JB
                ICURCOL = MOD( ICURCOL+1, NPCOL )
                ICURROW = MOD( ICURROW+1, NPROW )
*
   50        CONTINUE
*
             II = II + IB
*
   60     CONTINUE
*
      ELSE
*
          II = 1
          DO 110 I = 1, M, NPROW*MB
             IB = MIN( MP-II+1, MB )
*
*            regenerate NPROW*MB rows of A or A'.
*
             CALL PDMATGEN( ICTXT, TRANSA, 'N', M, K, MB, KB,
     $                          WORK(IPA), MB, IMROW, IMCOL, IASEED,
     $                          MIN(II-1,MP), IB, 0, KQ, MYROW, MYCOL,
     $                          NPROW, NPCOL )
*
             KK = 1
             JJ = 1
             ICURCOL = IMCOL
             ICURROW = IMROW
*
             DO 100 J = 1, N, NB
                JB = MIN( N-J+1, NB )
*
*               Regenerate NB (JB) columns of B' (JB rows of B)
*
                IF( MYROW.EQ.ICURROW ) THEN
                    CALL PDMATGEN( ICTXT, 'N', 'N', N, K, NB, KB,
     $                             WORK(IPB), NB, IMROW, IMCOL,
     $                             IBSEED, KK-1, JB, 0, KQ,
     $                             MYROW, MYCOL, NPROW, NPCOL )
                    CALL DGEBS2D( ICTXT, 'col', '1-tree', JB, KQ,
     $                            WORK(IPB), NB )
                ELSE
                    CALL DGEBR2D( ICTXT, 'col', '1-tree', JB, KQ,
     $                            WORK(IPB), NB, ICURROW, MYCOL )
                END IF
*
*               Computes C := C - alpha*A*B' or C := C - alpha*A'*B'
*
                IF( KQ.GT.0 .AND. IB.GT.0 .AND. JB.GT.0 ) THEN
                    CALL DGEMM( 'N', TRANSB, IB, JB, KQ, ALPHA,
     $                          WORK(IPA), MB, WORK(IPB), NB,
     $                          ZERO, WORK( IPC ), MB )
                ELSE
                    DO 80 LL = 0, MB*JB-1
                       WORK( IPC + LL ) = ZERO
   80               CONTINUE
                END IF
*
                CALL DGSUM2D( ICTXT, 'row', '1-tree', IB, JB,
     $                        WORK( IPC ), MB, MYROW, ICURCOL )
*
                IF( II.LE.MP ) THEN
                    IF( MYCOL.EQ.ICURCOL ) THEN
                        CALL DMATADD( IB, JB, -ONE, WORK(IPC), MB,
     $                                ONE, C(II,JJ), LDC )
                    END IF
                END IF
*
                IF( MYROW.EQ.ICURROW ) KK = KK + JB
                IF( MYCOL.EQ.ICURCOL ) JJ = JJ + JB
                ICURCOL = MOD( ICURCOL+1, NPCOL )
                ICURROW = MOD( ICURROW+1, NPROW )
*
  100        CONTINUE
*
             II = II + IB
*
  110     CONTINUE
*
      END IF
*
      RESID = PDLAINF( M, N, MB, NB, C, LDC, IMROW, IMCOL, WORK )
*
      RETURN
*
*     End of PDSUMCHK
*
      END
*
      DOUBLE PRECISION FUNCTION PDLAINF( M, N, MB, NB, A, LDA, IMROW,
     $                                   IMCOL, WORK )
*
*  -- PUMMA Package routine (version 2.1) --
*     Jaeyoung Choi, Oak Ridge National Laboratory.
*     Jack Dongarra, Univ. of Tennessee, Oak Ridge National Laboratory.
*     David Walker,  Oak Ridge National Laboratory.
*     March 24, 1995.
*
*     .. Scalar Arguments ..
      INTEGER            IMCOL, IMROW, LDA, M, MB, N, NB
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  Compute the infinity-norm of a distributed matrix, where the matrix
*  is blocked into rectangular submatrices (MBxNB) that are distributed
*  across a 2-D process grid using torus mapping.
*
*  Arguments
*  =========
*
*  M         (input) INTEGER
*            Number of rows in global matrix.
*
*  N         (input) INTEGER
*            Number of columns in global matrix.
*
*  MB        (input) INTEGER
*            The row block size of the matrix A.
*
*  NB        (input) INTEGER
*            The column block size of the matrix A.
*
*  A         (input) DOUBLE PRECISION
*            Array of, dimension (LDA,N), the matrix whose norm you wish
*            to compute.
*
*  LDA       (input) INTEGER
*            Leading Dimension of A.
*
*  IMROW     (input) INTEGER
*            IMROW specifies a row of the process template, which holds
*            the first block of the matrices.  0 <= IMROW < NPROW.
*
*  IMCOL     (input) INTEGER
*            IMCOL specifies a column of the process template, which
*            holds the first block of the matrices.  0 <= IMCOL < NPCOL.
*
*  WORK      (temporary) DOUBLE PRECISION
*            Temporary work array of dimension MP used for summing rows.
*
*  Note Only the process (0,0) has the right answer at the end of
*  ==== this routine.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ZERO
      PARAMETER        ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, ICTXT, J, MP, MYCOL, MYROW, NPCOL, NPROW, NQ
      DOUBLE PRECISION   DMAX
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      INTEGER            IDAMAX, NUMROC
      DOUBLE PRECISION   DASUM
      EXTERNAL           IDAMAX, NUMROC, DASUM
*     ..
*     .. Common Blocks ..
      COMMON             / CONTEXT / ICTXT
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      MP = NUMROC( M, MB, MYROW, IMROW, NPROW )
      NQ = NUMROC( N, NB, MYCOL, IMCOL, NPCOL )
*
*     Add all local rows together
*
      IF( MP.GT.1 ) THEN
          IF( NQ.EQ.0 ) THEN
              DO 10 I = 1, MP
                 WORK( I ) = ZERO
   10         CONTINUE
          ELSE
              DO 20 I = 1, MP
                 WORK(I) = DASUM( NQ, A(I,1), LDA )
   20         CONTINUE
          END IF
      END IF
*
*     Find sum of global matrix rows and store on column 0 of process grid
*
      CALL DGSUM2D( ICTXT, 'Row', '1-Tree', 1, MP, WORK, 1, MYROW, 0 )
*
*     Find maximum sum of rows for supnorm
*
      IF( MYCOL.EQ.0 ) THEN
          IF( MP.GT.1 ) THEN
              DMAX = WORK( IDAMAX( MP, WORK, 1 ) )
          ELSE
              DMAX = ZERO
          END IF
          CALL DGAMX2D( ICTXT, 'Col', '1-Tree', 1, 1, DMAX, 1,
     $                  I, J, 1, 0, 0 )
      END IF
*
      PDLAINF = DMAX
*
      RETURN
*
*     End of PDLAINF
*
      END
