C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE TDVMOD(TL,PHIBAR,ITYPE,MOUNT,D,Z,H,U,V,DSC,ZSC,HSC,
     &                  DIV,ZETA,PHI,UCOS,VCOS,DIVSC,ZETASC,PHISC)
C
C If (ITYPE .EQ. -1) then this subroutine transforms the standard
C variables U, V, and H to the modified variables UCOS, VCOS, and PHI,
C and copies these fields and DIV, ZETA, DIVSC, ZETASC, and PHISC to
C the work arrays to be used in the next step of the computation.
C If (ITYPE .EQ. +1) then this subroutine transforms the modified
C variables UCOS, VCOS, and PHI to the standard variables U, V, 
C and H and copies these fields and DIV, ZETA, DIVSC, ZETASC, and PHISC
C from the work arrays.
C
C called by: PSTSWM
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C machine architecture information
#     include "machine.i"
C domain decomposition information
#     include "physical.i"
#     include "spectral.i"
C constants and timesteps
#     include "consts.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C time level offset into modified variables fields
      INTEGER TL
C global mean geopotential
      REAL PHIBAR
C type of transform desired 
C  -1 => forward transform standard -> modified
C  +1 => inverse transform modified -> standard
      INTEGER ITYPE
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C
C     Input/Output
C
C divergence field
      REAL D(NLLON_P,NLLAT_P)
C vorticity field
      REAL Z(NLLON_P,NLLAT_P)
C height field 
      REAL H(NLLON_P,NLLAT_P)
C eastward wind field 
      REAL U(NLLON_P,NLLAT_P)
C northward wind field 
      REAL V(NLLON_P,NLLAT_P)
C divergence field spectral coefficients
      COMPLEX DSC(MXLSPEC_S)
C vorticity field spectral coefficients
      COMPLEX ZSC(MXLSPEC_S)
C geopotential field spectral coefficients
      COMPLEX HSC(MXLSPEC_S)
C
C divergence field
      REAL DIV(MXLLON_P,NLVER_P,NLLAT_P,6)
C vorticity field
      REAL ZETA(MXLLON_P,NLVER_P,NLLAT_P,6)
C geopotential field
      REAL PHI(MXLLON_P,NLVER_P,NLLAT_P,6)
C eastward wind field (scaled by cos(theta))
      REAL UCOS(MXLLON_P,NLVER_P,NLLAT_P)
C northward wind field (scaled by cos(theta))
      REAL VCOS(MXLLON_P,NLVER_P,NLLAT_P)
C divergence field spectral coefficients
      COMPLEX DIVSC(MXLSPEC_S,NLVER_S)
C vorticity field spectral coefficients
      COMPLEX ZETASC(MXLSPEC_S,NLVER_S)
C geopotential field spectral coefficients
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)
C
C---- Local Variables --------------------------------------------------
C
C latitude
      REAL RLAT
C longitude, latitude, and vertical layer loop indices
      INTEGER I, J, JV
C
C---- Statement Function -----------------------------------------------
C
C grid latitude
      EXTERNAL GLAT_P
      REAL GLAT_P
C
C---- Executable Statements --------------------------------------------
C2
C     First, check for valid arguments; invalid arguments=>fatal error.
      IF ((ITYPE .NE. +1) .AND. (ITYPE .NE. -1)) THEN               
        IF (ME. EQ. 0) WRITE (0,900) ITYPE
  900   FORMAT(/,' PSTSWM: FATAL ERROR IN SUBROUTINE TDVMOD:',/,
     &           ' UNKNOWN TYPE OF TRANSFORM SPECIFIED',/, 
     &           ' ITYPE = ',I3)                                 
        STOP                                                   
      ENDIF                                                     
C                                                                  
      IF (ITYPE .EQ. -1) THEN                                      
C                                                                       
C       Forward transform from standard to modified variables.
        DO J=1,NLLAT_P
          RLAT = GLAT_P(J)
          DO I=1,NLLON_P
            DIV(I,1,J,TL)  = D(I,J)
            ZETA(I,1,J,TL) = Z(I,J)
            PHI(I,1,J,TL)  = GRAV*H(I,J) - PHIBAR
            UCOS(I,1,J)    = U(I,J)*COS(RLAT)
            VCOS(I,1,J)    = V(I,J)*COS(RLAT)
          ENDDO
        ENDDO
C
        IF (FTOPO) THEN
C         Compute modifications for topography.
          DO J=1,NLLAT_P
            DO I=1,NLLON_P
              PHI(I,1,J,TL) = PHI(I,1,J,TL) - GRAV*MOUNT(I,J)
            ENDDO
          ENDDO
        ENDIF
C
        DO I=1,NLSPEC_S(1)
          DIVSC(I,1)  = DSC(I)
          ZETASC(I,1) = ZSC(I)
          PHISC(I,1)  = HSC(I)
        ENDDO
C
C       Duplicate modified variables across other vertical levels.
        DO J=1,NLLAT_P
          DO JV=2,NLVER_P
            DO I=1,NLLON_P
              DIV(I,JV,J,TL)  = DIV(I,1,J,TL)
              ZETA(I,JV,J,TL) = ZETA(I,1,J,TL)
              PHI(I,JV,J,TL)  = PHI(I,1,J,TL)
              UCOS(I,JV,J)    = UCOS(I,1,J)
              VCOS(I,JV,J)    = VCOS(I,1,J)
            ENDDO
          ENDDO
        ENDDO
C
        DO JV=2,NLVER_S
          DO I=1,NLSPEC_S(1)
            DIVSC(I,JV)  = DIVSC(I,1)
            ZETASC(I,JV) = ZETASC(I,1)
            PHISC(I,JV)  = PHISC(I,1)
          ENDDO
        ENDDO
C
C     Transformation to modified variables complete.
C
      ELSE
C
C       Inverse transform from modified to standard variables.
        DO J=1,NLLAT_P
          RLAT = GLAT_P(J)
          DO I=1,NLLON_P
            D(I,J) = DIV(I,NLVER_P,J,TL)
            Z(I,J) = ZETA(I,NLVER_P,J,TL)
            H(I,J) = (PHI(I,NLVER_P,J,TL) + PHIBAR)/GRAV
            U(I,J) = UCOS(I,NLVER_P,J)/COS(RLAT)
            V(I,J) = VCOS(I,NLVER_P,J)/COS(RLAT)
          ENDDO
        ENDDO
C
        IF (FTOPO) THEN
C         Compute modifications for topography.
          DO J=1,NLLAT_P
            DO I=1,NLLON_P
              H(I,J) = H(I,J) + MOUNT(I,J)
            ENDDO
          ENDDO
        ENDIF
C
        IF (NLVER_S .GT. 0) THEN
          DO I=1,NLSPEC_S(1)
            DSC(I) = DIVSC(I,NLVER_S) 
            ZSC(I) = ZETASC(I,NLVER_S)
            HSC(I) = PHISC(I,NLVER_S) 
          ENDDO
        ELSE
          DO I=1,NLSPEC_S(1)
            DSC(I) = (0.0,0.0)
            ZSC(I) = (0.0,0.0)
            HSC(I) = (0.0,0.0)
          ENDDO
        ENDIF
C
C     Transformation to standard variables complete.
C
      ENDIF
C
      RETURN
      END
