C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE SPEED(MOUNT, H, U, V, WSA, WSB, MAXV, PHIBAR, COUR)
C
C This procedure computes the maximum wind speed, the global mean
C geopotential, and the Courant number. For explicit timestepping,
C fastest waves are determined by gravity waves of speed SQRT(PHIBAR).
C For semi-implicit timestepping, fastest waves are determined by Rossby
C waves of speed MAXV. These formulae are correct only for spectral
C transform codes. (The Courant number should be less than 1 at all
C times.)
C
C called by: PSTSWM
C calls: GLOBALMAX, PGRIDSUM, WEIGHT_P
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
#     include "problem.i"
C domain decomposition definition variables
#     include "physical.i"
C constants  
#     include "consts.i"
C initial conditions
#     include "finit.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C height on grid
      REAL H(NLLON_P,NLLAT_P)
C eastward wind velocity on grid
      REAL U(NLLON_P,NLLAT_P)
C northward wind velocity on grid
      REAL V(NLLON_P,NLLAT_P)
C
C     Work Space
C
C work arrays
      REAL WSA(NLLON_P,NLLAT_P)
      REAL WSB(NLLON_P)
C
C     Output
C
C global mean geopotential
      REAL PHIBAR
C maximum wind speed
      REAL MAXV
C Courant number
      REAL COUR
C
C---- Local Variables --------------------------------------------------
C
C gridpoint weight
      REAL GWTS
C loop indices
      INTEGER I,J
C length of velocity vector
      REAL VLEN
C
C---- External Functions -----------------------------------------------
C
C grid latitude and weights
      EXTERNAL WEIGHT_P
      REAL WEIGHT_P
C
C---- Executable Statements --------------------------------------------
C
C     compute MAXV and PHIBAR
      PHIBAR = 0.0
      MAXV = 0.0
      DO J=1,NLLAT_P
C
C       weight independent of longitude
        GWTS = WEIGHT_P(1,J)
c
        DO I=1,NLLON_P
          VLEN  = SQRT(U(I,J)*U(I,J)+V(I,J)*V(I,J))
          IF (VLEN .GT. MAXV) THEN
            MAXV = VLEN
          ENDIF
          IF (FTOPO) THEN
            WSA(I,J) = GRAV*(H(I,J) - MOUNT(I,J))*GWTS
          ELSE
            WSA(I,J) = GRAV*H(I,J)*GWTS
          ENDIF
        ENDDO
      ENDDO
C
C     Finish calculation of MAXV with a global combine (and rebroadcast).
      CALL GLOBALMAX(1,MAXV)
C
C     Finish calculation of PHIBAR by summing all of the contributions
C     (using a processor-independent ordering).
      CALL PGRIDSUM(1, 1, NLLON_P, NLLAT_P, WSA, WSB, PHIBAR)
C
C     Compute COUR.
      IF (SITS) THEN
        COUR = MAXV*DT*KK/A
      ELSE
        COUR = SQRT(PHIBAR)*DT*KK/A
      ENDIF
C
      RETURN
      END



