C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C pvm.F                                                                C
C                                                                      C
C The following routines are used to initialize the PVM TIDS array and C
C datatype description variables, and to be compatible with            C
C initialization routines needed by other native implementations of    C
C sendrecv.F and swap.F.                                               C 
C                                                                      C
C COMMINIT - used to initialize any data structures used by native     C
C            implementations of sendrecv and swap.                     C
C COMMEXIT - used to clean up after use of native commands in PSTSWM   C
C                                                               (NOP)  C
C DATADESC - used to return PVM datatype and data length parameters.   C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE COMMINIT(SYSMSGS, SYSVOL, COMBUF, BUFSIZ)
C
C This subroutine initializes the data structures used to support the
C native communication commands as used in swap.F and sendrecv.F.
C In the PVM implementation, it calls GETTID to initialize the TIDS
C array.
C
C called by: PSTSWM
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C picl/pvm interface variables
#     include "picl.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C number of blocking asynchronous send requests that the system needs 
C to be able to handle 
      INTEGER SYSMSGS
C size (in bytes) of blocking asynchronous send requests that the system needs 
C to be able to handle 
      INTEGER SYSVOL
C size of user buffer space
      INTEGER BUFSIZ
C User space to use for communication buffering 
C (not used in VERTEX implementation)
      REAL COMBUF(BUFSIZ)
C
C---- Local Variables --------------------------------------------------
C
C "Boolean" indicating whether TIDS array has been filled yet.
      INTEGER FIRST
      SAVE FIRST
      DATA FIRST /1/
C
C---- Executable Statements --------------------------------------------
C
      IF (FIRST .EQ. 1) THEN
        CALL GETTIDS(TIDS)
        FIRST = 0
      ENDIF
C
      RETURN
C
      END
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE COMMEXIT
C
C This subroutine does any clean up needed after using native commands
C commands in PSTSWM. In the VERTEX implementation, it does nothing.
C
C called by: PSTSWM
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Executable Statements --------------------------------------------
C
      RETURN
C
      END
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE DATADESC(DATATYPE, DATALTH)
C
C This subroutine returns the current PVM datatype and data length
C to be used in interprocessor communication.
C
C called by: SWAP and SENDRECV routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
C pvm implementation-specific parameters
#     include "fpvm3.h"
C pstswm-specific parameters
#     include "params.i"
C
C---- Arguments --------------------------------------------------------
C
C     Output
C
C PVM datatype
      INTEGER DATATYPE
C Length (in bytes) of PVM datatype
      INTEGER DATALTH
C
C---- Local Variables --------------------------------------------------
C
C Current PICL datatype
      CHARACTER*1 PICLTYPE(4)
C
C---- Executable Statements --------------------------------------------
C
      CALL GETDATA0F(PICLTYPE)
      IF ((PICLTYPE(1) .EQ. 'I') .OR. (PICLTYPE(1) .EQ. 'i')) THEN
        DATATYPE = PVMINTEGER
        DATALTH  = IBYTES
      ELSEIF ((PICLTYPE(1) .EQ. 'R') .OR. (PICLTYPE(1) .EQ. 'r') .OR.
     &        (PICLTYPE(1) .EQ. 'F') .OR. (PICLTYPE(1) .EQ. 'f')) THEN
        DATATYPE = PVMREAL
        DATALTH  = RBYTES
      ELSEIF ((PICLTYPE(1) .EQ. 'D') .OR. (PICLTYPE(1) .EQ. 'd')) THEN
        DATATYPE = PVMDOUBLE
        DATALTH  = DBYTES
      ELSEIF ((PICLTYPE(1) .EQ. 'C') .OR. (PICLTYPE(1) .EQ. 'c')) THEN
        DATATYPE = BYTE1
        DATALTH  = 1
      ENDIF
C
      RETURN
C
      END
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
