C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'precision.i'                                          *
C***********************************************************************
C* The following preprocessor definitions are used to define the       #
C* precision to be used in the computation.                            #
C***********************************************************************
#if (I_SIZE-4)
#     define PVMINTEGER INTEGER8
#else
#     define PVMINTEGER INTEGER4
#endif
#if (R_SIZE-4)
#     define REAL real*8
#     define COMPLEX complex*16
#     define PVMREAL REAL8
#     define MPIREAL MPI_REAL8
#else
#     define REAL real*4
#     define COMPLEX complex*8
#     define PVMREAL REAL4
#     define MPIREAL MPI_REAL4
#endif
#if (D_SIZE-8)
#     define PVMDOUBLE REAL16
#else
#     define PVMDOUBLE REAL8
#endif
C (Note: if (D_SIZE .eq. R_SIZE) then Real is being promoted to
C  Double Precision. There is no support for promoting both Real
C  and Double, since Double Double is not supported in PICL (or 
C  on many machines).)
#if (D_SIZE-R_SIZE)
#     define CMPLX cmplx
#     define DATAREAL 'real'
#else
#     define CMPLX dcmplx
#     define DATAREAL 'double'
#endif
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
