C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* INCLUDE FILE 'perf.i'                                               *
C***********************************************************************
C* Common Block /PERF/ contains the variables used to record the       *
C* performance of PSTSWM and the PICL tracing parameters.              *
C*                                                                     *
C*    PRFINPUT  - name of file containing performance measurement      *
C*                parameters                                           *
C*                                                                     *
C*    TIMING    - enable timing logic?                                 *
C*    TIMEFILE  - name of file where timing data should be saved       *
C*    TBEGIN    - time at which timing began                           *
C*    TMIN      - minimum elapsed time to calculate a timestep         *
C*    TMAX      - maximum elapsed time to calculate a timestep         *
C*    TIN       - time current timestep calculation started            *
C*    TOVER     - measure of some of the time spent in subroutine call *
C*                overhead incurred when choosing between parallel     *
C*                algorithm options                                    *
C*    TTOTAL    - elapsed time between start and finish of model       *
C*                simulation                                           *
C*                                                                     *
C*    TRACING   - enable tracing logic?                                *
C*    TRSIZE    - size of buffer used to hold trace information        *
C*    TRSTART   - number of timestep when detailed tracing should start*
C*    TRSTOP    - number of timestep when detailed tracing should stop *
C*    TL1       - collect detailed PICL event trace?                   *
C*    TL2       - collect detailed user event trace?                   *
C*    TL3       - collect detailed tracing event trace?                *
C*                                                                     *
C*    TRACEFILE - open a trace file?                                   *
C*    VERBOSE   - save trace data in verbose or compact form           *
C*    TMPNAME   - name of temporary file used for saving flushed data  *
C*    PERMNAME  - name of file where trace data is to be (permanently) *
C*                saved                                                *
C***********************************************************************
      real*8 TBEGIN, TMIN, TMAX, TIN, TOVER, TTOTAL
      COMMON  / PERF / 
     &        TBEGIN, TMIN, TMAX, TIN, TOVER, TTOTAL
C*                                                                     *
      INTEGER TRSIZE, TRSTART, TRSTOP, TL1, TL2, TL3, VERBOSE
      COMMON  / PERF / 
     &        TRSIZE, TRSTART, TRSTOP, TL1, TL2, TL3, VERBOSE
C*                                                                     *
      CHARACTER*32 PRFINPUT, TIMEFILE, TMPNAME, PERMNAME
      COMMON  / PERF / 
     &        PRFINPUT, TIMEFILE, TMPNAME, PERMNAME
C*                                                                     *
      LOGICAL TIMING, TRACING, TRACEFILE
      COMMON  / PERF / 
     &        TIMING, TRACING, TRACEFILE
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
