C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'params.i'                                             *
C***********************************************************************
C* The following parameter values are upper bounds on problem and      *
C* machine parameter sizes, and are used to dimension arrays for which *
C* contiguous storage is not important for computational efficiency    *
C*                                                                     *
C*    MMX    - bounds on spectral truncation parameters MM, NN, KK,    *
C*    NNX      described in problem.i                                  *
C*    KKX                                                              *
C*    NLATX - bound on NLAT, the number of gaussian latitudes.         *
C*    NLONX - bound on NLON, the number of longitudes                  *
C*    NVERX - bound on NVER, the number of (simulated) vertical layers *
C*    NFCX  - bound on NFC, the number of Fourier coefficients         *
C*    LMNX  - a temporary used to define NALPX                         *
C*    NALPX - bound on NALP, the number of Associated Legendre         *
C*            Polynomials values used in the spectral transform        *
C*    LRMX  - bound on LRM, the length of the Belousov recurrence      *
C*            coefficient matrices                                     *
C*    NPROCSX - bound on NPROCS, the number of processors being        *
C*              utilized                                               *
C*    LGPROCSX- bound on log_2(NPROCS)                                 *
C*    NGRPHSX - bound on the number of entries used to define the      *
C*              energetics graphs                                      *
C***********************************************************************
      INTEGER MMX, NNX, KKX, NLATX, NLONX, NVERX
      PARAMETER 
     &       (MMX=340, 
     &        NNX=340, 
     &        KKX=340, 
     &        NLATX=512, 
     &        NLONX=1024, 
     &        NVERX=72)
C*                                                                     *
      INTEGER NFCX, LMNX, LRMX, NALPX
      PARAMETER 
     &       (NFCX=(NLONX+2)/2, 
     &        LMNX=MMX+NNX-KKX,
     &        NALPX=(MMX+1)*(NNX+1)-(LMNX**2+LMNX)/2,
     &        LRMX=(MMX+1)*(KKX+1)-(MMX*MMX+MMX)/2-1)
C*                                                                     *
      INTEGER NPROCSX, LGPROCSX, NGRPHSX
      PARAMETER 
     &       (NPROCSX=1024,
     &        LGPROCSX=10,
     &        NGRPHSX=100)
C*                                                                     *
C***********************************************************************
C* The parameter value COMPSZ specifies the size (in REAL values) of   *
C* the heap used for allocating work space, both temporary and         *
C* permanent. (See the routine INPUT for the allocation specification.)*
C* COMPSZ is the major determiner of the size of the node executable.  *
C* Smaller COMPSZ will allow PSTSWM to fit into smaller node memories; *
C* Larger COMPSZ will allow larger problem sizes (or smaller numbers of*
C* processors for a fixed problem size) to be used.                    *
C***********************************************************************
      INTEGER COMPSZ
#if defined(WORK_SPACE)
      PARAMETER (COMPSZ = WORK_SPACE)
#else
      PARAMETER (COMPSZ = 500000)
#endif
C*                                                                     *
C***********************************************************************
C* The following parameters specify variable lengths in bytes on the   *
C* target machine, and are used to calculate message lengths           *
C*                                                                     *
C*    IBYTES - number of bytes in an INTEGER variable                  *
C*    RBYTES - number of bytes in a REAL variable                      *
C*    DBYTES - number of bytes in a DOUBLE PRECISION variable          *
C*    CBYTES - number of bytes in a COMPLEX variable                   *
C*    PICLREAL - integer indicating datatype of REAL variables to PICL *
C*             GMAX0F and GMIN0F routines                              *
C***********************************************************************
      INTEGER IBYTES, RBYTES, DBYTES, CBYTES, PICLREAL
#if (R_SIZE-4)
      PARAMETER (RBYTES=8,
     &           CBYTES=16,
     &           PICLREAL=5)
#else
      PARAMETER (RBYTES=4,
     &           CBYTES=8,
     &           PICLREAL=4)
#endif
#if (D_SIZE-8)
      PARAMETER (DBYTES=16)
#else
      PARAMETER (DBYTES=8)
#endif
#if (I_SIZE-4)
      PARAMETER (IBYTES=8)
#else
      PARAMETER (IBYTES=4)
#endif
C*                                                                     *
C***********************************************************************
C* The parameter value ALIGN specifies the alignment (in number of     *
C* REALs values) to use in defining arrays and communication buffers.  *
C* For example, ALIGN=2 means that all arrays and buffers will begin   *
C* on double REAL boundaries. Specifying alignment > 1 can be necessary*
C* for correct and/or efficient execution on some machines.            *
C* NOTE: ALIGN MUST BE .EQ. 1 OR A MULTIPLE OF 2 !!                    *
C***********************************************************************
      INTEGER ALIGN
#if defined(ALIGNMENT)
      PARAMETER (ALIGN = ALIGNMENT)
#else
      PARAMETER (ALIGN = 2)
#endif
C*                                                                     *
C***********************************************************************
C* The parameter value MSGOVH specifies the space in bytes required    *
C* to send a message, including message headers and table space        *
C* This is generally communication library or library implementation   *
C* specific.                                                           *
C***********************************************************************
      INTEGER MSGOVH
#if defined(MSGOVERHEAD)
      PARAMETER (MSGOVH = MSGOVERHEAD)
#else
      PARAMETER (MSGOVH = 100)
#endif
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
