C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE DIFFUSE(DTA, A2NNP1, TOPOSC, WS, DIVSC, ZETASC, PHISC)
C
C This routine applies a linear diffusion operator in the spectral space
C (time lagged as in CCM).
C
C called by: EXPLIC, SIMPLIC
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
#     include "problem.i"
C constants and timesteps
#     include "consts.i"
C domain decomposition information
#     include "spectral.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C timestep
      REAL DTA
C (N*(N+1))/A**2
      REAL A2NNP1(0:KK)
C spectral coefficients of mountains
      COMPLEX TOPOSC(MXLSPEC_S)
C
C     Work Space
C
C work array
      REAL WS(0:KK,3)
C
C     Input/Output
C
C divergence spectral coefficients
      COMPLEX DIVSC(MXLSPEC_S,NLVER_S)
C vorticity spectral coefficients
      COMPLEX ZETASC(MXLSPEC_S,NLVER_S)                        
C geopotential spectral coefficients
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C---- Local Variables --------------------------------------------------
C
C precalculated coefficients
      REAL FAC1, FAC2
C polynomial degree, polynomial degree index, and polynomial degree
C transition index
      INTEGER N, JN, JNTRNS
C vertical layer, wavenumber, and spectral coefficient indices
      INTEGER JV, JM, L
C true wavenumber
      INTEGER M
C
C---- Executable Statements --------------------------------------------
C
C     Calculate diffusion operator:
C     1) special handling for (N .EQ. 0) case
      WS(0,1) = 1.0
      WS(0,2) = 1.0
C
C     2) (N .GT. 0) case
      FAC2   = DTA*HDC
      FAC1   = (DTA*HDC)*4.0/(A**4)
      DO N=1,KK
        WS(N,1) = 1.0/((1.0 + FAC2*A2NNP1(N)*A2NNP1(N))-FAC1)
        WS(N,2) = 1.0/(1.0 + FAC2*A2NNP1(N)*A2NNP1(N))
      ENDDO
C
C     Apply diffusion operator to local spectral coefficients.
      JNTRNS = 1-JMB_S(1)
      DO JV=1,NLVER_S
        L = 1
C
        DO JM=JMB_S(1),JME_S(1)
          M = MTRUE_S(JM)
          L = L - JNB_S(JNTRNS+JM)
C
          DO JN=JNB_S(JNTRNS+JM),JNE_S(JNTRNS+JM)
C           N = M + JN - 1
            ZETASC(L+JN,JV) = ZETASC(L+JN,JV)*WS(M+JN-1,1)
            DIVSC (L+JN,JV) = DIVSC (L+JN,JV)*WS(M+JN-1,1)
          ENDDO
C
C         Update local spectral coefficient offset index.
          L = L + JNE_S(JNTRNS+JM) + 1
C
        ENDDO
C
      ENDDO
C
      JNTRNS = 1-JMB_S(1)
      DO JV=1,NLVER_S
        L = 1
C
        DO JM=JMB_S(1),JME_S(1)
          M = MTRUE_S(JM)
          L = L - JNB_S(JNTRNS+JM)
C
          DO JN=JNB_S(JNTRNS+JM),JNE_S(JNTRNS+JM)
C           N = M + JN - 1
            PHISC (L+JN,JV) = PHISC (L+JN,JV)*WS(M+JN-1,2)
          ENDDO
C
C         Update local spectral coefficient offset index.
          L = L + JNE_S(JNTRNS+JM) + 1
C
        ENDDO
C
      ENDDO
C
      IF (FTOPO) THEN
C       modifications for topography
C
C       Calculate diffusion operator.
        DO N=0,KK
          WS(N,3) = 1.0 - WS(N,2)
        ENDDO
C
C       Apply diffusion operator to local spectral coefficients.
C       JNTRNS = 1-JMB_S(1)
        DO JV=1,NLVER_S
          L = 1
C
          DO JM=JMB_S(1),JME_S(1)
            M = MTRUE_S(JM)
            L = L - JNB_S(JNTRNS+JM)
C
            DO JN=JNB_S(JNTRNS+JM),JNE_S(JNTRNS+JM)
C             N = M + JN - 1
              PHISC(L+JN,JV) = PHISC(L+JN,JV) 
     &                       - TOPOSC(L+JN)*WS(M+JN-1,3)
            ENDDO
C
C           Update local spectral coefficient offset index.
            L = L + JNE_S(JNTRNS+JM) + 1
C
          ENDDO
C
        ENDDO
C
      ENDIF
C
      RETURN
      END



