C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      INTEGER FUNCTION PRFINP()
C                                                                              
C This subroutine inputs or determines performance measurement
C parameters.
C                                                                              
C called by: INPUT
C calls: PICL routines
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C     
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C     
C---- Common Blocks ----------------------------------------------------
C     
C machine architecture information
#     include "machine.i"
C performance parameters
#     include "perf.i"
C
C---- Local Variables --------------------------------------------------
C
C flag indicating existence of input file
      LOGICAL PRFTEST
C base for message types used in broadcasting problem parameters
      INTEGER BASE
C communication buffers
      INTEGER IBUF(10)
      CHARACTER CBUF*96
C
C---- External Functions ----------------------------------------------
C
C base for message types
      EXTERNAL MSGBASE
      INTEGER MSGBASE
C                                                                            
C---- Executable Statements --------------------------------------------
C
      BASE = MSGBASE()
      IF (ME .EQ. 0) THEN
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C       Initialize timing and tracing parameters.
C       See common block /PERF/ (in perf.i) for definitions.
C
        TIMING    = .FALSE.
        TRACING   = .FALSE.
        TRACEFILE = .FALSE.
C
        VERBOSE   = 0
        TRSIZE    = 0
        TRSTART   = -1
        TRSTOP    = -1
        TL1       = -1
        TL2       = -1
        TL3       = -1
        TIMEFILE  = 'timings.mpi'
        TMPNAME   = '/tmp/trace'
        PERMNAME  = 'tracefile'
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                              
C       Read algorithm input data.
        PRFTEST = .FALSE.
        OPEN(8, ERR=999, FILE=PRFINPUT, STATUS='OLD')
        PRFTEST = .TRUE.
  999   IF (PRFTEST) THEN
C
          WRITE(6,*) 'READING PERFORMANCE MEASUREMENT PARAMETERS FROM', 
     &               ' FILE ',PRFINPUT,':'
C
C         tracing parameters
          READ(8,*) TIMING
          READ(8,*) TRACING
          READ(8,*) TRACEFILE
          READ(8, *, END=1000) VERBOSE
          READ(8, *, END=1000) TRSIZE
          READ(8, *, END=1000) TRSTART
          READ(8,*) TRSTOP
          READ(8, *, END=1000) TL1
          READ(8,*) TL2
          READ(8,*) TL3
          READ(8, *, END=1000) TIMEFILE
          READ(8,*) TMPNAME
          READ(8,*) PERMNAME
C
C         Close input file.
 1000     CLOSE(8)
C
        ELSE
C
          WRITE(6,*) 'USING DEFAULT PERFORMANCE MEASUREMENT PARAMETERS'
C
        ENDIF
C
C       Send input parameters to other processors.
        IF (NPROCS .GT. 1) THEN
C
          IF (TIMING) THEN
            IBUF(1) = 1
          ELSE
            IBUF(1) = 0
          ENDIF            
          IF (TRACING) THEN
            IBUF(2) = 1
          ELSE
            IBUF(2) = 0
          ENDIF            
          IF (TRACEFILE) THEN
            IBUF(3) = 1
          ELSE
            IBUF(3) = 0
          ENDIF            
          IBUF(4) = VERBOSE
          IBUF(5) = TRSIZE
          IBUF(6) = TRSTART
          IBUF(7) = TRSTOP
          IBUF(8) = TL1
          IBUF(9) = TL2
          IBUF(10) = TL3
          CALL SETDATA0F('INTEGER')
          CALL BCAST0F(IBUF, IBYTES*10, BASE, 0)
C
          CBUF(1:32)  = TIMEFILE
          CBUF(33:64) = TMPNAME
          CBUF(65:96) = PERMNAME
          CALL SETDATA0F('CHARACTER')
          CALL BCAST0F(CBUF, 96, BASE+1, 0)
C
        ENDIF
C
      ELSE
C
C       Get input parameters from node 0.
        CALL SETDATA0F('INTEGER')
        CALL BCAST0F(IBUF, IBYTES*10, BASE, 0)
        IF (IBUF(1) .EQ. 1) THEN
           TIMING = .TRUE.
        ELSE
           TIMING = .FALSE.
        ENDIF
        IF (IBUF(2) .EQ. 1) THEN
          TRACING = .TRUE.
        ELSE
          TRACING = .FALSE.
        ENDIF
        IF (IBUF(3) .EQ. 1) THEN
          TRACEFILE = .TRUE.
        ELSE
          TRACEFILE = .FALSE.
        ENDIF
        VERBOSE = IBUF(4)
        TRSIZE  = IBUF(5)
        TRSTART = IBUF(6)
        TRSTOP  = IBUF(7)
        TL1     = IBUF(8)
        TL2     = IBUF(9)
        TL3     = IBUF(10)
C
        CALL SETDATA0F('CHARACTER')
        CALL BCAST0F(CBUF, 96, BASE+1, 0)
        TIMEFILE = CBUF(1:32)
        TMPNAME  = CBUF(33:64)
        PERMNAME = CBUF(65:96)
C
      ENDIF
C
      PRFINP = 0
C
      RETURN
      END
